# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 cpu_core_count: pulumi.Input[int],
                 deployment_type: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 is_auto_scaling_enabled: pulumi.Input[bool],
                 license_model: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_backup_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 load_balancer_subnet_id: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLockArgs']]]] = None,
                 maintenance_configuration: Optional[pulumi.Input['DeploymentMaintenanceConfigurationArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['DeploymentMaintenanceWindowArgs']] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ogg_data: Optional[pulumi.Input['DeploymentOggDataArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The Minimum number of OCPUs to be made available for this Deployment.
        :param pulumi.Input[str] deployment_type: The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        :param pulumi.Input[str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[bool] is_auto_scaling_enabled: (Updatable) Indicates if auto scaling is enabled for the Deployment's CPU core count.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to a Deployment.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet of the deployment's private endpoint. The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025, after which the private subnet will be enforced.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        :param pulumi.Input[str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[str] fqdn: (Updatable) A three-label Fully Qualified Domain Name (FQDN) for a resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_public: (Updatable) True if this object is publicly available.
        :param pulumi.Input[str] load_balancer_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a public subnet in the customer tenancy. Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy. For backward compatiblity this is an optional property for now, but it will become mandatory (for public deployments only) after October 1, 2024.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input['DeploymentMaintenanceConfigurationArgs'] maintenance_configuration: (Updatable) Defines the maintenance configuration for create operation.
        :param pulumi.Input['DeploymentMaintenanceWindowArgs'] maintenance_window: (Updatable) Defines the maintenance window for create operation, when automatic actions can be performed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param pulumi.Input['DeploymentOggDataArgs'] ogg_data: (Updatable) Deployment Data for creating an OggDeployment
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        pulumi.set(__self__, "license_model", license_model)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_backup_id is not None:
            pulumi.set(__self__, "deployment_backup_id", deployment_backup_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if load_balancer_subnet_id is not None:
            pulumi.set(__self__, "load_balancer_subnet_id", load_balancer_subnet_id)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if maintenance_configuration is not None:
            pulumi.set(__self__, "maintenance_configuration", maintenance_configuration)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ogg_data is not None:
            pulumi.set(__self__, "ogg_data", ogg_data)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The Minimum number of OCPUs to be made available for this Deployment.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Deployment's CPU core count.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_auto_scaling_enabled", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Input[str]:
        """
        (Updatable) The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: pulumi.Input[str]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet of the deployment's private endpoint. The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025, after which the private subnet will be enforced.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deploymentBackupId")
    def deployment_backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        """
        return pulumi.get(self, "deployment_backup_id")

    @deployment_backup_id.setter
    def deployment_backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_backup_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A three-label Fully Qualified Domain Name (FQDN) for a resource.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True if this object is publicly available.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_public", value)

    @property
    @pulumi.getter(name="loadBalancerSubnetId")
    def load_balancer_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a public subnet in the customer tenancy. Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy. For backward compatiblity this is an optional property for now, but it will become mandatory (for public deployments only) after October 1, 2024.
        """
        return pulumi.get(self, "load_balancer_subnet_id")

    @load_balancer_subnet_id.setter
    def load_balancer_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_subnet_id", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="maintenanceConfiguration")
    def maintenance_configuration(self) -> Optional[pulumi.Input['DeploymentMaintenanceConfigurationArgs']]:
        """
        (Updatable) Defines the maintenance configuration for create operation.
        """
        return pulumi.get(self, "maintenance_configuration")

    @maintenance_configuration.setter
    def maintenance_configuration(self, value: Optional[pulumi.Input['DeploymentMaintenanceConfigurationArgs']]):
        pulumi.set(self, "maintenance_configuration", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['DeploymentMaintenanceWindowArgs']]:
        """
        (Updatable) Defines the maintenance window for create operation, when automatic actions can be performed.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['DeploymentMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="oggData")
    def ogg_data(self) -> Optional[pulumi.Input['DeploymentOggDataArgs']]:
        """
        (Updatable) Deployment Data for creating an OggDeployment
        """
        return pulumi.get(self, "ogg_data")

    @ogg_data.setter
    def ogg_data(self, value: Optional[pulumi.Input['DeploymentOggDataArgs']]):
        pulumi.set(self, "ogg_data", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_backup_id: Optional[pulumi.Input[str]] = None,
                 deployment_diagnostic_datas: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeploymentDiagnosticDataArgs']]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 deployment_url: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ingress_ips: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentIngressIpArgs']]]] = None,
                 is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
                 is_healthy: Optional[pulumi.Input[bool]] = None,
                 is_latest_version: Optional[pulumi.Input[bool]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 is_storage_utilization_limit_exceeded: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 lifecycle_sub_state: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_subnet_id: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLockArgs']]]] = None,
                 maintenance_configuration: Optional[pulumi.Input['DeploymentMaintenanceConfigurationArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['DeploymentMaintenanceWindowArgs']] = None,
                 next_maintenance_action_type: Optional[pulumi.Input[str]] = None,
                 next_maintenance_description: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ogg_data: Optional[pulumi.Input['DeploymentOggDataArgs']] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_utilization_in_bytes: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_of_next_maintenance: Optional[pulumi.Input[str]] = None,
                 time_ogg_version_supported_until: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 time_upgrade_required: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The Minimum number of OCPUs to be made available for this Deployment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentDeploymentDiagnosticDataArgs']]] deployment_diagnostic_datas: Information regarding the deployment diagnostic collection
        :param pulumi.Input[str] deployment_type: The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        :param pulumi.Input[str] deployment_url: The URL of a resource.
        :param pulumi.Input[str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[str] fqdn: (Updatable) A three-label Fully Qualified Domain Name (FQDN) for a resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentIngressIpArgs']]] ingress_ips: List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        :param pulumi.Input[bool] is_auto_scaling_enabled: (Updatable) Indicates if auto scaling is enabled for the Deployment's CPU core count.
        :param pulumi.Input[bool] is_healthy: True if all of the aggregate resources are working correctly.
        :param pulumi.Input[bool] is_latest_version: Indicates if the resource is the the latest available version.
        :param pulumi.Input[bool] is_public: (Updatable) True if this object is publicly available.
        :param pulumi.Input[bool] is_storage_utilization_limit_exceeded: Indicator will be true if the amount of storage being utilized exceeds the allowable storage utilization limit.  Exceeding the limit may be an indication of a misconfiguration of the deployment's GoldenGate service.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to a Deployment.
        :param pulumi.Input[str] lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[str] lifecycle_sub_state: Possible GGS lifecycle sub-states.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the loadbalancer in the customer's subnet. The loadbalancer of the public deployment created in the customer subnet.
        :param pulumi.Input[str] load_balancer_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a public subnet in the customer tenancy. Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy. For backward compatiblity this is an optional property for now, but it will become mandatory (for public deployments only) after October 1, 2024.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input['DeploymentMaintenanceConfigurationArgs'] maintenance_configuration: (Updatable) Defines the maintenance configuration for create operation.
        :param pulumi.Input['DeploymentMaintenanceWindowArgs'] maintenance_window: (Updatable) Defines the maintenance window for create operation, when automatic actions can be performed.
        :param pulumi.Input[str] next_maintenance_action_type: Type of the next maintenance.
        :param pulumi.Input[str] next_maintenance_description: Description of the next maintenance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param pulumi.Input['DeploymentOggDataArgs'] ogg_data: (Updatable) Deployment Data for creating an OggDeployment
        :param pulumi.Input[str] private_ip_address: The private IP address in the customer's VCN representing the access point for the associated endpoint service in the GoldenGate service VCN.
        :param pulumi.Input[str] public_ip_address: The public IP address representing the access point for the Deployment.
        :param pulumi.Input[str] storage_utilization_in_bytes: The amount of storage being utilized (in bytes)
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet of the deployment's private endpoint. The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025, after which the private subnet will be enforced.
        :param pulumi.Input[Mapping[str, Any]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_of_next_maintenance: The time of next maintenance schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_ogg_version_supported_until: The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_upgrade_required: Note: Deprecated: Use timeOfNextMaintenance instead, or related upgrade records  to check, when deployment will be forced to upgrade to a newer version. Old description: The date the existing version in use will no longer be considered as usable and an upgrade will be required.  This date is typically 6 months after the version was released for use by GGS.  The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_backup_id is not None:
            pulumi.set(__self__, "deployment_backup_id", deployment_backup_id)
        if deployment_diagnostic_datas is not None:
            pulumi.set(__self__, "deployment_diagnostic_datas", deployment_diagnostic_datas)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if deployment_url is not None:
            pulumi.set(__self__, "deployment_url", deployment_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ingress_ips is not None:
            pulumi.set(__self__, "ingress_ips", ingress_ips)
        if is_auto_scaling_enabled is not None:
            pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if is_healthy is not None:
            pulumi.set(__self__, "is_healthy", is_healthy)
        if is_latest_version is not None:
            pulumi.set(__self__, "is_latest_version", is_latest_version)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if is_storage_utilization_limit_exceeded is not None:
            pulumi.set(__self__, "is_storage_utilization_limit_exceeded", is_storage_utilization_limit_exceeded)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_sub_state is not None:
            pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if load_balancer_subnet_id is not None:
            pulumi.set(__self__, "load_balancer_subnet_id", load_balancer_subnet_id)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if maintenance_configuration is not None:
            pulumi.set(__self__, "maintenance_configuration", maintenance_configuration)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if next_maintenance_action_type is not None:
            pulumi.set(__self__, "next_maintenance_action_type", next_maintenance_action_type)
        if next_maintenance_description is not None:
            pulumi.set(__self__, "next_maintenance_description", next_maintenance_description)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ogg_data is not None:
            pulumi.set(__self__, "ogg_data", ogg_data)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_utilization_in_bytes is not None:
            pulumi.set(__self__, "storage_utilization_in_bytes", storage_utilization_in_bytes)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_next_maintenance is not None:
            pulumi.set(__self__, "time_of_next_maintenance", time_of_next_maintenance)
        if time_ogg_version_supported_until is not None:
            pulumi.set(__self__, "time_ogg_version_supported_until", time_ogg_version_supported_until)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if time_upgrade_required is not None:
            pulumi.set(__self__, "time_upgrade_required", time_upgrade_required)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The Minimum number of OCPUs to be made available for this Deployment.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deploymentBackupId")
    def deployment_backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        """
        return pulumi.get(self, "deployment_backup_id")

    @deployment_backup_id.setter
    def deployment_backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_backup_id", value)

    @property
    @pulumi.getter(name="deploymentDiagnosticDatas")
    def deployment_diagnostic_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeploymentDiagnosticDataArgs']]]]:
        """
        Information regarding the deployment diagnostic collection
        """
        return pulumi.get(self, "deployment_diagnostic_datas")

    @deployment_diagnostic_datas.setter
    def deployment_diagnostic_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeploymentDiagnosticDataArgs']]]]):
        pulumi.set(self, "deployment_diagnostic_datas", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="deploymentUrl")
    def deployment_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of a resource.
        """
        return pulumi.get(self, "deployment_url")

    @deployment_url.setter
    def deployment_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A three-label Fully Qualified Domain Name (FQDN) for a resource.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentIngressIpArgs']]]]:
        """
        List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        """
        return pulumi.get(self, "ingress_ips")

    @ingress_ips.setter
    def ingress_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentIngressIpArgs']]]]):
        pulumi.set(self, "ingress_ips", value)

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Deployment's CPU core count.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_scaling_enabled", value)

    @property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> Optional[pulumi.Input[bool]]:
        """
        True if all of the aggregate resources are working correctly.
        """
        return pulumi.get(self, "is_healthy")

    @is_healthy.setter
    def is_healthy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_healthy", value)

    @property
    @pulumi.getter(name="isLatestVersion")
    def is_latest_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the resource is the the latest available version.
        """
        return pulumi.get(self, "is_latest_version")

    @is_latest_version.setter
    def is_latest_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_latest_version", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True if this object is publicly available.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_public", value)

    @property
    @pulumi.getter(name="isStorageUtilizationLimitExceeded")
    def is_storage_utilization_limit_exceeded(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator will be true if the amount of storage being utilized exceeds the allowable storage utilization limit.  Exceeding the limit may be an indication of a misconfiguration of the deployment's GoldenGate service.
        """
        return pulumi.get(self, "is_storage_utilization_limit_exceeded")

    @is_storage_utilization_limit_exceeded.setter
    def is_storage_utilization_limit_exceeded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_storage_utilization_limit_exceeded", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> Optional[pulumi.Input[str]]:
        """
        Possible GGS lifecycle sub-states.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @lifecycle_sub_state.setter
    def lifecycle_sub_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_sub_state", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the loadbalancer in the customer's subnet. The loadbalancer of the public deployment created in the customer subnet.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="loadBalancerSubnetId")
    def load_balancer_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a public subnet in the customer tenancy. Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy. For backward compatiblity this is an optional property for now, but it will become mandatory (for public deployments only) after October 1, 2024.
        """
        return pulumi.get(self, "load_balancer_subnet_id")

    @load_balancer_subnet_id.setter
    def load_balancer_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_subnet_id", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="maintenanceConfiguration")
    def maintenance_configuration(self) -> Optional[pulumi.Input['DeploymentMaintenanceConfigurationArgs']]:
        """
        (Updatable) Defines the maintenance configuration for create operation.
        """
        return pulumi.get(self, "maintenance_configuration")

    @maintenance_configuration.setter
    def maintenance_configuration(self, value: Optional[pulumi.Input['DeploymentMaintenanceConfigurationArgs']]):
        pulumi.set(self, "maintenance_configuration", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['DeploymentMaintenanceWindowArgs']]:
        """
        (Updatable) Defines the maintenance window for create operation, when automatic actions can be performed.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['DeploymentMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="nextMaintenanceActionType")
    def next_maintenance_action_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the next maintenance.
        """
        return pulumi.get(self, "next_maintenance_action_type")

    @next_maintenance_action_type.setter
    def next_maintenance_action_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_maintenance_action_type", value)

    @property
    @pulumi.getter(name="nextMaintenanceDescription")
    def next_maintenance_description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the next maintenance.
        """
        return pulumi.get(self, "next_maintenance_description")

    @next_maintenance_description.setter
    def next_maintenance_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_maintenance_description", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="oggData")
    def ogg_data(self) -> Optional[pulumi.Input['DeploymentOggDataArgs']]:
        """
        (Updatable) Deployment Data for creating an OggDeployment
        """
        return pulumi.get(self, "ogg_data")

    @ogg_data.setter
    def ogg_data(self, value: Optional[pulumi.Input['DeploymentOggDataArgs']]):
        pulumi.set(self, "ogg_data", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address in the customer's VCN representing the access point for the associated endpoint service in the GoldenGate service VCN.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The public IP address representing the access point for the Deployment.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageUtilizationInBytes")
    def storage_utilization_in_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of storage being utilized (in bytes)
        """
        return pulumi.get(self, "storage_utilization_in_bytes")

    @storage_utilization_in_bytes.setter
    def storage_utilization_in_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_utilization_in_bytes", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet of the deployment's private endpoint. The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025, after which the private subnet will be enforced.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeOfNextMaintenance")
    def time_of_next_maintenance(self) -> Optional[pulumi.Input[str]]:
        """
        The time of next maintenance schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_of_next_maintenance")

    @time_of_next_maintenance.setter
    def time_of_next_maintenance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_next_maintenance", value)

    @property
    @pulumi.getter(name="timeOggVersionSupportedUntil")
    def time_ogg_version_supported_until(self) -> Optional[pulumi.Input[str]]:
        """
        The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_ogg_version_supported_until")

    @time_ogg_version_supported_until.setter
    def time_ogg_version_supported_until(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ogg_version_supported_until", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="timeUpgradeRequired")
    def time_upgrade_required(self) -> Optional[pulumi.Input[str]]:
        """
        Note: Deprecated: Use timeOfNextMaintenance instead, or related upgrade records  to check, when deployment will be forced to upgrade to a newer version. Old description: The date the existing version in use will no longer be considered as usable and an upgrade will be required.  This date is typically 6 months after the version was released for use by GGS.  The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_upgrade_required")

    @time_upgrade_required.setter
    def time_upgrade_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_upgrade_required", value)


class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_backup_id: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 load_balancer_subnet_id: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentLockArgs', 'DeploymentLockArgsDict']]]]] = None,
                 maintenance_configuration: Optional[pulumi.Input[Union['DeploymentMaintenanceConfigurationArgs', 'DeploymentMaintenanceConfigurationArgsDict']]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['DeploymentMaintenanceWindowArgs', 'DeploymentMaintenanceWindowArgsDict']]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ogg_data: Optional[pulumi.Input[Union['DeploymentOggDataArgs', 'DeploymentOggDataArgsDict']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Deployment resource in Oracle Cloud Infrastructure Golden Gate service.

        Creates a new Deployment.

        ## Import

        Deployments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GoldenGate/deployment:Deployment test_deployment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The Minimum number of OCPUs to be made available for this Deployment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        :param pulumi.Input[str] deployment_type: The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        :param pulumi.Input[str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[str] fqdn: (Updatable) A three-label Fully Qualified Domain Name (FQDN) for a resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_auto_scaling_enabled: (Updatable) Indicates if auto scaling is enabled for the Deployment's CPU core count.
        :param pulumi.Input[bool] is_public: (Updatable) True if this object is publicly available.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to a Deployment.
        :param pulumi.Input[str] load_balancer_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a public subnet in the customer tenancy. Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy. For backward compatiblity this is an optional property for now, but it will become mandatory (for public deployments only) after October 1, 2024.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentLockArgs', 'DeploymentLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[Union['DeploymentMaintenanceConfigurationArgs', 'DeploymentMaintenanceConfigurationArgsDict']] maintenance_configuration: (Updatable) Defines the maintenance configuration for create operation.
        :param pulumi.Input[Union['DeploymentMaintenanceWindowArgs', 'DeploymentMaintenanceWindowArgsDict']] maintenance_window: (Updatable) Defines the maintenance window for create operation, when automatic actions can be performed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param pulumi.Input[Union['DeploymentOggDataArgs', 'DeploymentOggDataArgsDict']] ogg_data: (Updatable) Deployment Data for creating an OggDeployment
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet of the deployment's private endpoint. The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025, after which the private subnet will be enforced.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Deployment resource in Oracle Cloud Infrastructure Golden Gate service.

        Creates a new Deployment.

        ## Import

        Deployments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GoldenGate/deployment:Deployment test_deployment "id"
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_backup_id: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 load_balancer_subnet_id: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentLockArgs', 'DeploymentLockArgsDict']]]]] = None,
                 maintenance_configuration: Optional[pulumi.Input[Union['DeploymentMaintenanceConfigurationArgs', 'DeploymentMaintenanceConfigurationArgsDict']]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['DeploymentMaintenanceWindowArgs', 'DeploymentMaintenanceWindowArgsDict']]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ogg_data: Optional[pulumi.Input[Union['DeploymentOggDataArgs', 'DeploymentOggDataArgsDict']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if cpu_core_count is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_core_count'")
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deployment_backup_id"] = deployment_backup_id
            if deployment_type is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_type'")
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["fqdn"] = fqdn
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_auto_scaling_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_auto_scaling_enabled'")
            __props__.__dict__["is_auto_scaling_enabled"] = is_auto_scaling_enabled
            __props__.__dict__["is_lock_override"] = is_lock_override
            __props__.__dict__["is_public"] = is_public
            if license_model is None and not opts.urn:
                raise TypeError("Missing required property 'license_model'")
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["load_balancer_subnet_id"] = load_balancer_subnet_id
            __props__.__dict__["locks"] = locks
            __props__.__dict__["maintenance_configuration"] = maintenance_configuration
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["ogg_data"] = ogg_data
            __props__.__dict__["state"] = state
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["deployment_diagnostic_datas"] = None
            __props__.__dict__["deployment_url"] = None
            __props__.__dict__["ingress_ips"] = None
            __props__.__dict__["is_healthy"] = None
            __props__.__dict__["is_latest_version"] = None
            __props__.__dict__["is_storage_utilization_limit_exceeded"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lifecycle_sub_state"] = None
            __props__.__dict__["load_balancer_id"] = None
            __props__.__dict__["next_maintenance_action_type"] = None
            __props__.__dict__["next_maintenance_description"] = None
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["storage_utilization_in_bytes"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_next_maintenance"] = None
            __props__.__dict__["time_ogg_version_supported_until"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["time_upgrade_required"] = None
        super(Deployment, __self__).__init__(
            'oci:GoldenGate/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            cpu_core_count: Optional[pulumi.Input[int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            deployment_backup_id: Optional[pulumi.Input[str]] = None,
            deployment_diagnostic_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentDeploymentDiagnosticDataArgs', 'DeploymentDeploymentDiagnosticDataArgsDict']]]]] = None,
            deployment_type: Optional[pulumi.Input[str]] = None,
            deployment_url: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            fqdn: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            ingress_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentIngressIpArgs', 'DeploymentIngressIpArgsDict']]]]] = None,
            is_auto_scaling_enabled: Optional[pulumi.Input[bool]] = None,
            is_healthy: Optional[pulumi.Input[bool]] = None,
            is_latest_version: Optional[pulumi.Input[bool]] = None,
            is_lock_override: Optional[pulumi.Input[bool]] = None,
            is_public: Optional[pulumi.Input[bool]] = None,
            is_storage_utilization_limit_exceeded: Optional[pulumi.Input[bool]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            lifecycle_sub_state: Optional[pulumi.Input[str]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            load_balancer_subnet_id: Optional[pulumi.Input[str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentLockArgs', 'DeploymentLockArgsDict']]]]] = None,
            maintenance_configuration: Optional[pulumi.Input[Union['DeploymentMaintenanceConfigurationArgs', 'DeploymentMaintenanceConfigurationArgsDict']]] = None,
            maintenance_window: Optional[pulumi.Input[Union['DeploymentMaintenanceWindowArgs', 'DeploymentMaintenanceWindowArgsDict']]] = None,
            next_maintenance_action_type: Optional[pulumi.Input[str]] = None,
            next_maintenance_description: Optional[pulumi.Input[str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ogg_data: Optional[pulumi.Input[Union['DeploymentOggDataArgs', 'DeploymentOggDataArgsDict']]] = None,
            private_ip_address: Optional[pulumi.Input[str]] = None,
            public_ip_address: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_utilization_in_bytes: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_of_next_maintenance: Optional[pulumi.Input[str]] = None,
            time_ogg_version_supported_until: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            time_upgrade_required: Optional[pulumi.Input[str]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[int] cpu_core_count: (Updatable) The Minimum number of OCPUs to be made available for this Deployment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentDeploymentDiagnosticDataArgs', 'DeploymentDeploymentDiagnosticDataArgsDict']]]] deployment_diagnostic_datas: Information regarding the deployment diagnostic collection
        :param pulumi.Input[str] deployment_type: The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        :param pulumi.Input[str] deployment_url: The URL of a resource.
        :param pulumi.Input[str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[str] fqdn: (Updatable) A three-label Fully Qualified Domain Name (FQDN) for a resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentIngressIpArgs', 'DeploymentIngressIpArgsDict']]]] ingress_ips: List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        :param pulumi.Input[bool] is_auto_scaling_enabled: (Updatable) Indicates if auto scaling is enabled for the Deployment's CPU core count.
        :param pulumi.Input[bool] is_healthy: True if all of the aggregate resources are working correctly.
        :param pulumi.Input[bool] is_latest_version: Indicates if the resource is the the latest available version.
        :param pulumi.Input[bool] is_public: (Updatable) True if this object is publicly available.
        :param pulumi.Input[bool] is_storage_utilization_limit_exceeded: Indicator will be true if the amount of storage being utilized exceeds the allowable storage utilization limit.  Exceeding the limit may be an indication of a misconfiguration of the deployment's GoldenGate service.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to a Deployment.
        :param pulumi.Input[str] lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[str] lifecycle_sub_state: Possible GGS lifecycle sub-states.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the loadbalancer in the customer's subnet. The loadbalancer of the public deployment created in the customer subnet.
        :param pulumi.Input[str] load_balancer_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a public subnet in the customer tenancy. Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy. For backward compatiblity this is an optional property for now, but it will become mandatory (for public deployments only) after October 1, 2024.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentLockArgs', 'DeploymentLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[Union['DeploymentMaintenanceConfigurationArgs', 'DeploymentMaintenanceConfigurationArgsDict']] maintenance_configuration: (Updatable) Defines the maintenance configuration for create operation.
        :param pulumi.Input[Union['DeploymentMaintenanceWindowArgs', 'DeploymentMaintenanceWindowArgsDict']] maintenance_window: (Updatable) Defines the maintenance window for create operation, when automatic actions can be performed.
        :param pulumi.Input[str] next_maintenance_action_type: Type of the next maintenance.
        :param pulumi.Input[str] next_maintenance_description: Description of the next maintenance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param pulumi.Input[Union['DeploymentOggDataArgs', 'DeploymentOggDataArgsDict']] ogg_data: (Updatable) Deployment Data for creating an OggDeployment
        :param pulumi.Input[str] private_ip_address: The private IP address in the customer's VCN representing the access point for the associated endpoint service in the GoldenGate service VCN.
        :param pulumi.Input[str] public_ip_address: The public IP address representing the access point for the Deployment.
        :param pulumi.Input[str] storage_utilization_in_bytes: The amount of storage being utilized (in bytes)
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet of the deployment's private endpoint. The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025, after which the private subnet will be enforced.
        :param pulumi.Input[Mapping[str, Any]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_of_next_maintenance: The time of next maintenance schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_ogg_version_supported_until: The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_upgrade_required: Note: Deprecated: Use timeOfNextMaintenance instead, or related upgrade records  to check, when deployment will be forced to upgrade to a newer version. Old description: The date the existing version in use will no longer be considered as usable and an upgrade will be required.  This date is typically 6 months after the version was released for use by GGS.  The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deployment_backup_id"] = deployment_backup_id
        __props__.__dict__["deployment_diagnostic_datas"] = deployment_diagnostic_datas
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["deployment_url"] = deployment_url
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ingress_ips"] = ingress_ips
        __props__.__dict__["is_auto_scaling_enabled"] = is_auto_scaling_enabled
        __props__.__dict__["is_healthy"] = is_healthy
        __props__.__dict__["is_latest_version"] = is_latest_version
        __props__.__dict__["is_lock_override"] = is_lock_override
        __props__.__dict__["is_public"] = is_public
        __props__.__dict__["is_storage_utilization_limit_exceeded"] = is_storage_utilization_limit_exceeded
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lifecycle_sub_state"] = lifecycle_sub_state
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["load_balancer_subnet_id"] = load_balancer_subnet_id
        __props__.__dict__["locks"] = locks
        __props__.__dict__["maintenance_configuration"] = maintenance_configuration
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["next_maintenance_action_type"] = next_maintenance_action_type
        __props__.__dict__["next_maintenance_description"] = next_maintenance_description
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["ogg_data"] = ogg_data
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_utilization_in_bytes"] = storage_utilization_in_bytes
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_next_maintenance"] = time_of_next_maintenance
        __props__.__dict__["time_ogg_version_supported_until"] = time_ogg_version_supported_until
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["time_upgrade_required"] = time_upgrade_required
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The Minimum number of OCPUs to be made available for this Deployment.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentBackupId")
    def deployment_backup_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        """
        return pulumi.get(self, "deployment_backup_id")

    @property
    @pulumi.getter(name="deploymentDiagnosticDatas")
    def deployment_diagnostic_datas(self) -> pulumi.Output[Sequence['outputs.DeploymentDeploymentDiagnosticData']]:
        """
        Information regarding the deployment diagnostic collection
        """
        return pulumi.get(self, "deployment_diagnostic_datas")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[str]:
        """
        The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="deploymentUrl")
    def deployment_url(self) -> pulumi.Output[str]:
        """
        The URL of a resource.
        """
        return pulumi.get(self, "deployment_url")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[str]:
        """
        (Updatable) A three-label Fully Qualified Domain Name (FQDN) for a resource.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> pulumi.Output[Sequence['outputs.DeploymentIngressIp']]:
        """
        List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        """
        return pulumi.get(self, "ingress_ips")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if auto scaling is enabled for the Deployment's CPU core count.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> pulumi.Output[bool]:
        """
        True if all of the aggregate resources are working correctly.
        """
        return pulumi.get(self, "is_healthy")

    @property
    @pulumi.getter(name="isLatestVersion")
    def is_latest_version(self) -> pulumi.Output[bool]:
        """
        Indicates if the resource is the the latest available version.
        """
        return pulumi.get(self, "is_latest_version")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[bool]:
        """
        (Updatable) True if this object is publicly available.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter(name="isStorageUtilizationLimitExceeded")
    def is_storage_utilization_limit_exceeded(self) -> pulumi.Output[bool]:
        """
        Indicator will be true if the amount of storage being utilized exceeds the allowable storage utilization limit.  Exceeding the limit may be an indication of a misconfiguration of the deployment's GoldenGate service.
        """
        return pulumi.get(self, "is_storage_utilization_limit_exceeded")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> pulumi.Output[str]:
        """
        Possible GGS lifecycle sub-states.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the loadbalancer in the customer's subnet. The loadbalancer of the public deployment created in the customer subnet.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="loadBalancerSubnetId")
    def load_balancer_subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a public subnet in the customer tenancy. Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy. For backward compatiblity this is an optional property for now, but it will become mandatory (for public deployments only) after October 1, 2024.
        """
        return pulumi.get(self, "load_balancer_subnet_id")

    @property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Sequence['outputs.DeploymentLock']]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="maintenanceConfiguration")
    def maintenance_configuration(self) -> pulumi.Output['outputs.DeploymentMaintenanceConfiguration']:
        """
        (Updatable) Defines the maintenance configuration for create operation.
        """
        return pulumi.get(self, "maintenance_configuration")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.DeploymentMaintenanceWindow']:
        """
        (Updatable) Defines the maintenance window for create operation, when automatic actions can be performed.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="nextMaintenanceActionType")
    def next_maintenance_action_type(self) -> pulumi.Output[str]:
        """
        Type of the next maintenance.
        """
        return pulumi.get(self, "next_maintenance_action_type")

    @property
    @pulumi.getter(name="nextMaintenanceDescription")
    def next_maintenance_description(self) -> pulumi.Output[str]:
        """
        Description of the next maintenance.
        """
        return pulumi.get(self, "next_maintenance_description")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="oggData")
    def ogg_data(self) -> pulumi.Output['outputs.DeploymentOggData']:
        """
        (Updatable) Deployment Data for creating an OggDeployment
        """
        return pulumi.get(self, "ogg_data")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[str]:
        """
        The private IP address in the customer's VCN representing the access point for the associated endpoint service in the GoldenGate service VCN.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[str]:
        """
        The public IP address representing the access point for the Deployment.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageUtilizationInBytes")
    def storage_utilization_in_bytes(self) -> pulumi.Output[str]:
        """
        The amount of storage being utilized (in bytes)
        """
        return pulumi.get(self, "storage_utilization_in_bytes")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet of the deployment's private endpoint. The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025, after which the private subnet will be enforced.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfNextMaintenance")
    def time_of_next_maintenance(self) -> pulumi.Output[str]:
        """
        The time of next maintenance schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_of_next_maintenance")

    @property
    @pulumi.getter(name="timeOggVersionSupportedUntil")
    def time_ogg_version_supported_until(self) -> pulumi.Output[str]:
        """
        The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_ogg_version_supported_until")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeUpgradeRequired")
    def time_upgrade_required(self) -> pulumi.Output[str]:
        """
        Note: Deprecated: Use timeOfNextMaintenance instead, or related upgrade records  to check, when deployment will be forced to upgrade to a newer version. Old description: The date the existing version in use will no longer be considered as usable and an upgrade will be required.  This date is typically 6 months after the version was released for use by GGS.  The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_upgrade_required")

