# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetVaultUsageResult',
    'AwaitableGetVaultUsageResult',
    'get_vault_usage',
    'get_vault_usage_output',
]

@pulumi.output_type
class GetVaultUsageResult:
    """
    A collection of values returned by getVaultUsage.
    """
    def __init__(__self__, id=None, key_count=None, key_version_count=None, software_key_count=None, software_key_version_count=None, vault_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_count and not isinstance(key_count, int):
            raise TypeError("Expected argument 'key_count' to be a int")
        pulumi.set(__self__, "key_count", key_count)
        if key_version_count and not isinstance(key_version_count, int):
            raise TypeError("Expected argument 'key_version_count' to be a int")
        pulumi.set(__self__, "key_version_count", key_version_count)
        if software_key_count and not isinstance(software_key_count, int):
            raise TypeError("Expected argument 'software_key_count' to be a int")
        pulumi.set(__self__, "software_key_count", software_key_count)
        if software_key_version_count and not isinstance(software_key_version_count, int):
            raise TypeError("Expected argument 'software_key_version_count' to be a int")
        pulumi.set(__self__, "software_key_version_count", software_key_version_count)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyCount")
    def key_count(self) -> int:
        """
        The number of keys in this vault, across all compartments, excluding keys in a `DELETED` state.
        """
        return pulumi.get(self, "key_count")

    @property
    @pulumi.getter(name="keyVersionCount")
    def key_version_count(self) -> int:
        """
        The number of key versions in this vault, across all compartments, excluding key versions in a `DELETED` state.
        """
        return pulumi.get(self, "key_version_count")

    @property
    @pulumi.getter(name="softwareKeyCount")
    def software_key_count(self) -> int:
        """
        The number of keys in this vault that persist on the server, across all compartments, excluding keys in a `DELETED` state.
        """
        return pulumi.get(self, "software_key_count")

    @property
    @pulumi.getter(name="softwareKeyVersionCount")
    def software_key_version_count(self) -> int:
        """
        The number of key versions in this vault that persist on the server, across all compartments, excluding key versions in a `DELETED` state.
        """
        return pulumi.get(self, "software_key_version_count")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        return pulumi.get(self, "vault_id")


class AwaitableGetVaultUsageResult(GetVaultUsageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVaultUsageResult(
            id=self.id,
            key_count=self.key_count,
            key_version_count=self.key_version_count,
            software_key_count=self.software_key_count,
            software_key_version_count=self.software_key_version_count,
            vault_id=self.vault_id)


def get_vault_usage(vault_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVaultUsageResult:
    """
    This data source provides details about a specific Vault Usage resource in Oracle Cloud Infrastructure Kms service.

    Gets the count of keys and key versions in the specified vault to calculate usage against service limits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vault_usage = oci.Kms.get_vault_usage(vault_id=test_vault["id"])
    ```


    :param str vault_id: The OCID of the vault.
    """
    __args__ = dict()
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getVaultUsage:getVaultUsage', __args__, opts=opts, typ=GetVaultUsageResult).value

    return AwaitableGetVaultUsageResult(
        id=pulumi.get(__ret__, 'id'),
        key_count=pulumi.get(__ret__, 'key_count'),
        key_version_count=pulumi.get(__ret__, 'key_version_count'),
        software_key_count=pulumi.get(__ret__, 'software_key_count'),
        software_key_version_count=pulumi.get(__ret__, 'software_key_version_count'),
        vault_id=pulumi.get(__ret__, 'vault_id'))


@_utilities.lift_output_func(get_vault_usage)
def get_vault_usage_output(vault_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVaultUsageResult]:
    """
    This data source provides details about a specific Vault Usage resource in Oracle Cloud Infrastructure Kms service.

    Gets the count of keys and key versions in the specified vault to calculate usage against service limits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vault_usage = oci.Kms.get_vault_usage(vault_id=test_vault["id"])
    ```


    :param str vault_id: The OCID of the vault.
    """
    ...
