# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkFirewallPolicyDecryptionRuleResult',
    'AwaitableGetNetworkFirewallPolicyDecryptionRuleResult',
    'get_network_firewall_policy_decryption_rule',
    'get_network_firewall_policy_decryption_rule_output',
]

@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRuleResult:
    """
    A collection of values returned by getNetworkFirewallPolicyDecryptionRule.
    """
    def __init__(__self__, action=None, conditions=None, decryption_profile=None, id=None, name=None, network_firewall_policy_id=None, parent_resource_id=None, positions=None, priority_order=None, secret=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if decryption_profile and not isinstance(decryption_profile, str):
            raise TypeError("Expected argument 'decryption_profile' to be a str")
        pulumi.set(__self__, "decryption_profile", decryption_profile)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_firewall_policy_id and not isinstance(network_firewall_policy_id, str):
            raise TypeError("Expected argument 'network_firewall_policy_id' to be a str")
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id and not isinstance(parent_resource_id, str):
            raise TypeError("Expected argument 'parent_resource_id' to be a str")
        pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if positions and not isinstance(positions, list):
            raise TypeError("Expected argument 'positions' to be a list")
        pulumi.set(__self__, "positions", positions)
        if priority_order and not isinstance(priority_order, str):
            raise TypeError("Expected argument 'priority_order' to be a str")
        pulumi.set(__self__, "priority_order", priority_order)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action:
        * NO_DECRYPT - Matching traffic is not decrypted.
        * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetNetworkFirewallPolicyDecryptionRuleConditionResult']:
        """
        Match criteria used in Decryption Rule used on the firewall policy rules.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="decryptionProfile")
    def decryption_profile(self) -> str:
        """
        The name of the decryption profile to use.
        """
        return pulumi.get(self, "decryption_profile")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the decryption rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> str:
        """
        OCID of the Network Firewall Policy this decryption rule belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def positions(self) -> Sequence['outputs.GetNetworkFirewallPolicyDecryptionRulePositionResult']:
        """
        An object which defines the position of the rule.
        """
        return pulumi.get(self, "positions")

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> str:
        return pulumi.get(self, "priority_order")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        return pulumi.get(self, "secret")


class AwaitableGetNetworkFirewallPolicyDecryptionRuleResult(GetNetworkFirewallPolicyDecryptionRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkFirewallPolicyDecryptionRuleResult(
            action=self.action,
            conditions=self.conditions,
            decryption_profile=self.decryption_profile,
            id=self.id,
            name=self.name,
            network_firewall_policy_id=self.network_firewall_policy_id,
            parent_resource_id=self.parent_resource_id,
            positions=self.positions,
            priority_order=self.priority_order,
            secret=self.secret)


def get_network_firewall_policy_decryption_rule(name: Optional[str] = None,
                                                network_firewall_policy_id: Optional[str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkFirewallPolicyDecryptionRuleResult:
    """
    This data source provides details about a specific Network Firewall Policy Decryption Rule resource in Oracle Cloud Infrastructure Network Firewall service.

    Get Decryption Rule by the given name in the context of network firewall policy.


    :param str name: Name for the decryption rule, must be unique within the policy.
    :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkFirewall/getNetworkFirewallPolicyDecryptionRule:getNetworkFirewallPolicyDecryptionRule', __args__, opts=opts, typ=GetNetworkFirewallPolicyDecryptionRuleResult).value

    return AwaitableGetNetworkFirewallPolicyDecryptionRuleResult(
        action=pulumi.get(__ret__, 'action'),
        conditions=pulumi.get(__ret__, 'conditions'),
        decryption_profile=pulumi.get(__ret__, 'decryption_profile'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_firewall_policy_id=pulumi.get(__ret__, 'network_firewall_policy_id'),
        parent_resource_id=pulumi.get(__ret__, 'parent_resource_id'),
        positions=pulumi.get(__ret__, 'positions'),
        priority_order=pulumi.get(__ret__, 'priority_order'),
        secret=pulumi.get(__ret__, 'secret'))


@_utilities.lift_output_func(get_network_firewall_policy_decryption_rule)
def get_network_firewall_policy_decryption_rule_output(name: Optional[pulumi.Input[str]] = None,
                                                       network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkFirewallPolicyDecryptionRuleResult]:
    """
    This data source provides details about a specific Network Firewall Policy Decryption Rule resource in Oracle Cloud Infrastructure Network Firewall service.

    Get Decryption Rule by the given name in the context of network firewall policy.


    :param str name: Name for the decryption rule, must be unique within the policy.
    :param str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    ...
