# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetNotificationTopicResult',
    'AwaitableGetNotificationTopicResult',
    'get_notification_topic',
    'get_notification_topic_output',
]

@pulumi.output_type
class GetNotificationTopicResult:
    """
    A collection of values returned by getNotificationTopic.
    """
    def __init__(__self__, api_endpoint=None, compartment_id=None, defined_tags=None, description=None, etag=None, freeform_tags=None, id=None, name=None, short_topic_id=None, state=None, time_created=None, topic_id=None):
        if api_endpoint and not isinstance(api_endpoint, str):
            raise TypeError("Expected argument 'api_endpoint' to be a str")
        pulumi.set(__self__, "api_endpoint", api_endpoint)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if short_topic_id and not isinstance(short_topic_id, str):
            raise TypeError("Expected argument 'short_topic_id' to be a str")
        pulumi.set(__self__, "short_topic_id", short_topic_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if topic_id and not isinstance(topic_id, str):
            raise TypeError("Expected argument 'topic_id' to be a str")
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> str:
        """
        The endpoint for managing subscriptions or publishing messages to the topic.
        """
        return pulumi.get(self, "api_endpoint")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the topic.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the topic.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        For optimistic concurrency control. See `if-match`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="shortTopicId")
    def short_topic_id(self) -> str:
        """
        A unique short topic Id. This is used only for SMS subscriptions.
        """
        return pulumi.get(self, "short_topic_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the topic.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the topic was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic.
        """
        return pulumi.get(self, "topic_id")


class AwaitableGetNotificationTopicResult(GetNotificationTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotificationTopicResult(
            api_endpoint=self.api_endpoint,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            etag=self.etag,
            freeform_tags=self.freeform_tags,
            id=self.id,
            name=self.name,
            short_topic_id=self.short_topic_id,
            state=self.state,
            time_created=self.time_created,
            topic_id=self.topic_id)


def get_notification_topic(topic_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotificationTopicResult:
    """
    This data source provides details about a specific Notification Topic resource in Oracle Cloud Infrastructure Notifications service.

    Gets the specified topic's configuration information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_notification_topic = oci.Ons.get_notification_topic(topic_id=test_notification_topic_oci_ons_notification_topic["id"])
    ```


    :param str topic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to retrieve.
           
           Transactions Per Minute (TPM) per-tenancy limit for this operation: 120.
    """
    __args__ = dict()
    __args__['topicId'] = topic_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ons/getNotificationTopic:getNotificationTopic', __args__, opts=opts, typ=GetNotificationTopicResult).value

    return AwaitableGetNotificationTopicResult(
        api_endpoint=pulumi.get(__ret__, 'api_endpoint'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        etag=pulumi.get(__ret__, 'etag'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        short_topic_id=pulumi.get(__ret__, 'short_topic_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        topic_id=pulumi.get(__ret__, 'topic_id'))


@_utilities.lift_output_func(get_notification_topic)
def get_notification_topic_output(topic_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNotificationTopicResult]:
    """
    This data source provides details about a specific Notification Topic resource in Oracle Cloud Infrastructure Notifications service.

    Gets the specified topic's configuration information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_notification_topic = oci.Ons.get_notification_topic(topic_id=test_notification_topic_oci_ons_notification_topic["id"])
    ```


    :param str topic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to retrieve.
           
           Transactions Per Minute (TPM) per-tenancy limit for this operation: 120.
    """
    ...
