# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetControlAssignmentResult',
    'AwaitableGetControlAssignmentResult',
    'get_control_assignment',
    'get_control_assignment_output',
]

@pulumi.output_type
class GetControlAssignmentResult:
    """
    A collection of values returned by getControlAssignment.
    """
    def __init__(__self__, assigner_id=None, comment=None, compartment_id=None, defined_tags=None, detachment_description=None, error_code=None, error_message=None, freeform_tags=None, id=None, is_auto_approve_during_maintenance=None, is_default_assignment=None, is_enforced_always=None, is_hypervisor_log_forwarded=None, is_log_forwarded=None, lifecycle_details=None, op_control_name=None, operator_control_assignment_id=None, operator_control_id=None, remote_syslog_server_address=None, remote_syslog_server_ca_cert=None, remote_syslog_server_port=None, resource_compartment_id=None, resource_id=None, resource_name=None, resource_type=None, state=None, time_assignment_from=None, time_assignment_to=None, time_of_assignment=None, time_of_deletion=None, unassigner_id=None, validate_assignment_trigger=None):
        if assigner_id and not isinstance(assigner_id, str):
            raise TypeError("Expected argument 'assigner_id' to be a str")
        pulumi.set(__self__, "assigner_id", assigner_id)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if detachment_description and not isinstance(detachment_description, str):
            raise TypeError("Expected argument 'detachment_description' to be a str")
        pulumi.set(__self__, "detachment_description", detachment_description)
        if error_code and not isinstance(error_code, int):
            raise TypeError("Expected argument 'error_code' to be a int")
        pulumi.set(__self__, "error_code", error_code)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_approve_during_maintenance and not isinstance(is_auto_approve_during_maintenance, bool):
            raise TypeError("Expected argument 'is_auto_approve_during_maintenance' to be a bool")
        pulumi.set(__self__, "is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        if is_default_assignment and not isinstance(is_default_assignment, bool):
            raise TypeError("Expected argument 'is_default_assignment' to be a bool")
        pulumi.set(__self__, "is_default_assignment", is_default_assignment)
        if is_enforced_always and not isinstance(is_enforced_always, bool):
            raise TypeError("Expected argument 'is_enforced_always' to be a bool")
        pulumi.set(__self__, "is_enforced_always", is_enforced_always)
        if is_hypervisor_log_forwarded and not isinstance(is_hypervisor_log_forwarded, bool):
            raise TypeError("Expected argument 'is_hypervisor_log_forwarded' to be a bool")
        pulumi.set(__self__, "is_hypervisor_log_forwarded", is_hypervisor_log_forwarded)
        if is_log_forwarded and not isinstance(is_log_forwarded, bool):
            raise TypeError("Expected argument 'is_log_forwarded' to be a bool")
        pulumi.set(__self__, "is_log_forwarded", is_log_forwarded)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if op_control_name and not isinstance(op_control_name, str):
            raise TypeError("Expected argument 'op_control_name' to be a str")
        pulumi.set(__self__, "op_control_name", op_control_name)
        if operator_control_assignment_id and not isinstance(operator_control_assignment_id, str):
            raise TypeError("Expected argument 'operator_control_assignment_id' to be a str")
        pulumi.set(__self__, "operator_control_assignment_id", operator_control_assignment_id)
        if operator_control_id and not isinstance(operator_control_id, str):
            raise TypeError("Expected argument 'operator_control_id' to be a str")
        pulumi.set(__self__, "operator_control_id", operator_control_id)
        if remote_syslog_server_address and not isinstance(remote_syslog_server_address, str):
            raise TypeError("Expected argument 'remote_syslog_server_address' to be a str")
        pulumi.set(__self__, "remote_syslog_server_address", remote_syslog_server_address)
        if remote_syslog_server_ca_cert and not isinstance(remote_syslog_server_ca_cert, str):
            raise TypeError("Expected argument 'remote_syslog_server_ca_cert' to be a str")
        pulumi.set(__self__, "remote_syslog_server_ca_cert", remote_syslog_server_ca_cert)
        if remote_syslog_server_port and not isinstance(remote_syslog_server_port, int):
            raise TypeError("Expected argument 'remote_syslog_server_port' to be a int")
        pulumi.set(__self__, "remote_syslog_server_port", remote_syslog_server_port)
        if resource_compartment_id and not isinstance(resource_compartment_id, str):
            raise TypeError("Expected argument 'resource_compartment_id' to be a str")
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_assignment_from and not isinstance(time_assignment_from, str):
            raise TypeError("Expected argument 'time_assignment_from' to be a str")
        pulumi.set(__self__, "time_assignment_from", time_assignment_from)
        if time_assignment_to and not isinstance(time_assignment_to, str):
            raise TypeError("Expected argument 'time_assignment_to' to be a str")
        pulumi.set(__self__, "time_assignment_to", time_assignment_to)
        if time_of_assignment and not isinstance(time_of_assignment, str):
            raise TypeError("Expected argument 'time_of_assignment' to be a str")
        pulumi.set(__self__, "time_of_assignment", time_of_assignment)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if unassigner_id and not isinstance(unassigner_id, str):
            raise TypeError("Expected argument 'unassigner_id' to be a str")
        pulumi.set(__self__, "unassigner_id", unassigner_id)
        if validate_assignment_trigger and not isinstance(validate_assignment_trigger, int):
            raise TypeError("Expected argument 'validate_assignment_trigger' to be a int")
        pulumi.set(__self__, "validate_assignment_trigger", validate_assignment_trigger)

    @property
    @pulumi.getter(name="assignerId")
    def assigner_id(self) -> str:
        """
        The OCID of the user who created this operator control assignment.
        """
        return pulumi.get(self, "assigner_id")

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        Comment about the assignment of the operator control to this target resource.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the comparment that contains the operator control assignment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="detachmentDescription")
    def detachment_description(self) -> str:
        """
        description containing reason for releasing of OperatorControl.
        """
        return pulumi.get(self, "detachment_description")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        """
        The code identifying the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The message describing the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the operator control assignment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> bool:
        """
        The boolean if true would autoApprove during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @property
    @pulumi.getter(name="isDefaultAssignment")
    def is_default_assignment(self) -> bool:
        """
        Whether the assignment is a default assignment.
        """
        return pulumi.get(self, "is_default_assignment")

    @property
    @pulumi.getter(name="isEnforcedAlways")
    def is_enforced_always(self) -> bool:
        """
        If set, then the target resource is always governed by the operator control.
        """
        return pulumi.get(self, "is_enforced_always")

    @property
    @pulumi.getter(name="isHypervisorLogForwarded")
    def is_hypervisor_log_forwarded(self) -> bool:
        """
        If set, then the hypervisor audit logs will be forwarded to the relevant remote syslog server
        """
        return pulumi.get(self, "is_hypervisor_log_forwarded")

    @property
    @pulumi.getter(name="isLogForwarded")
    def is_log_forwarded(self) -> bool:
        """
        If set indicates that the audit logs are being forwarded to the relevant remote logging server
        """
        return pulumi.get(self, "is_log_forwarded")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        More in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="opControlName")
    def op_control_name(self) -> str:
        """
        Name of the operator control name associated.
        """
        return pulumi.get(self, "op_control_name")

    @property
    @pulumi.getter(name="operatorControlAssignmentId")
    def operator_control_assignment_id(self) -> str:
        return pulumi.get(self, "operator_control_assignment_id")

    @property
    @pulumi.getter(name="operatorControlId")
    def operator_control_id(self) -> str:
        """
        The OCID of the operator control.
        """
        return pulumi.get(self, "operator_control_id")

    @property
    @pulumi.getter(name="remoteSyslogServerAddress")
    def remote_syslog_server_address(self) -> str:
        """
        The address of the remote syslog server where the audit logs are being forwarded to. Address in host or IP format.
        """
        return pulumi.get(self, "remote_syslog_server_address")

    @property
    @pulumi.getter(name="remoteSyslogServerCaCert")
    def remote_syslog_server_ca_cert(self) -> str:
        """
        The CA certificate of the remote syslog server.
        """
        return pulumi.get(self, "remote_syslog_server_ca_cert")

    @property
    @pulumi.getter(name="remoteSyslogServerPort")
    def remote_syslog_server_port(self) -> int:
        """
        The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        """
        return pulumi.get(self, "remote_syslog_server_port")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the target resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The OCID of the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        Name of the target resource.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        resourceType for which the OperatorControlAssignment is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifcycle state of the OperatorControl.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAssignmentFrom")
    def time_assignment_from(self) -> str:
        """
        The time at which the target resource will be brought under the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_from")

    @property
    @pulumi.getter(name="timeAssignmentTo")
    def time_assignment_to(self) -> str:
        """
        The time at which the target resource will leave the governance of the operator control expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_to")

    @property
    @pulumi.getter(name="timeOfAssignment")
    def time_of_assignment(self) -> str:
        """
        Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_assignment")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="unassignerId")
    def unassigner_id(self) -> str:
        """
        User id who released the operatorControl.
        """
        return pulumi.get(self, "unassigner_id")

    @property
    @pulumi.getter(name="validateAssignmentTrigger")
    def validate_assignment_trigger(self) -> int:
        return pulumi.get(self, "validate_assignment_trigger")


class AwaitableGetControlAssignmentResult(GetControlAssignmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetControlAssignmentResult(
            assigner_id=self.assigner_id,
            comment=self.comment,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            detachment_description=self.detachment_description,
            error_code=self.error_code,
            error_message=self.error_message,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_auto_approve_during_maintenance=self.is_auto_approve_during_maintenance,
            is_default_assignment=self.is_default_assignment,
            is_enforced_always=self.is_enforced_always,
            is_hypervisor_log_forwarded=self.is_hypervisor_log_forwarded,
            is_log_forwarded=self.is_log_forwarded,
            lifecycle_details=self.lifecycle_details,
            op_control_name=self.op_control_name,
            operator_control_assignment_id=self.operator_control_assignment_id,
            operator_control_id=self.operator_control_id,
            remote_syslog_server_address=self.remote_syslog_server_address,
            remote_syslog_server_ca_cert=self.remote_syslog_server_ca_cert,
            remote_syslog_server_port=self.remote_syslog_server_port,
            resource_compartment_id=self.resource_compartment_id,
            resource_id=self.resource_id,
            resource_name=self.resource_name,
            resource_type=self.resource_type,
            state=self.state,
            time_assignment_from=self.time_assignment_from,
            time_assignment_to=self.time_assignment_to,
            time_of_assignment=self.time_of_assignment,
            time_of_deletion=self.time_of_deletion,
            unassigner_id=self.unassigner_id,
            validate_assignment_trigger=self.validate_assignment_trigger)


def get_control_assignment(operator_control_assignment_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetControlAssignmentResult:
    """
    This data source provides details about a specific Operator Control Assignment resource in Oracle Cloud Infrastructure Operator Access Control service.

    Gets the details of an Operator Control Assignment of the specified ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operator_control_assignment = oci.OperatorAccessControl.get_control_assignment(operator_control_assignment_id=test_operator_control_assignment_oci_operator_access_control_operator_control_assignment["id"])
    ```


    :param str operator_control_assignment_id: unique OperatorControl identifier
    """
    __args__ = dict()
    __args__['operatorControlAssignmentId'] = operator_control_assignment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getControlAssignment:getControlAssignment', __args__, opts=opts, typ=GetControlAssignmentResult).value

    return AwaitableGetControlAssignmentResult(
        assigner_id=pulumi.get(__ret__, 'assigner_id'),
        comment=pulumi.get(__ret__, 'comment'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        detachment_description=pulumi.get(__ret__, 'detachment_description'),
        error_code=pulumi.get(__ret__, 'error_code'),
        error_message=pulumi.get(__ret__, 'error_message'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_approve_during_maintenance=pulumi.get(__ret__, 'is_auto_approve_during_maintenance'),
        is_default_assignment=pulumi.get(__ret__, 'is_default_assignment'),
        is_enforced_always=pulumi.get(__ret__, 'is_enforced_always'),
        is_hypervisor_log_forwarded=pulumi.get(__ret__, 'is_hypervisor_log_forwarded'),
        is_log_forwarded=pulumi.get(__ret__, 'is_log_forwarded'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        op_control_name=pulumi.get(__ret__, 'op_control_name'),
        operator_control_assignment_id=pulumi.get(__ret__, 'operator_control_assignment_id'),
        operator_control_id=pulumi.get(__ret__, 'operator_control_id'),
        remote_syslog_server_address=pulumi.get(__ret__, 'remote_syslog_server_address'),
        remote_syslog_server_ca_cert=pulumi.get(__ret__, 'remote_syslog_server_ca_cert'),
        remote_syslog_server_port=pulumi.get(__ret__, 'remote_syslog_server_port'),
        resource_compartment_id=pulumi.get(__ret__, 'resource_compartment_id'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        time_assignment_from=pulumi.get(__ret__, 'time_assignment_from'),
        time_assignment_to=pulumi.get(__ret__, 'time_assignment_to'),
        time_of_assignment=pulumi.get(__ret__, 'time_of_assignment'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'),
        unassigner_id=pulumi.get(__ret__, 'unassigner_id'),
        validate_assignment_trigger=pulumi.get(__ret__, 'validate_assignment_trigger'))


@_utilities.lift_output_func(get_control_assignment)
def get_control_assignment_output(operator_control_assignment_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetControlAssignmentResult]:
    """
    This data source provides details about a specific Operator Control Assignment resource in Oracle Cloud Infrastructure Operator Access Control service.

    Gets the details of an Operator Control Assignment of the specified ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operator_control_assignment = oci.OperatorAccessControl.get_control_assignment(operator_control_assignment_id=test_operator_control_assignment_oci_operator_access_control_operator_control_assignment["id"])
    ```


    :param str operator_control_assignment_id: unique OperatorControl identifier
    """
    ...
