# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OpsiConfigurationArgs', 'OpsiConfiguration']

@pulumi.input_type
class OpsiConfigurationArgs:
    def __init__(__self__, *,
                 opsi_config_type: pulumi.Input[str],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_item_custom_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_item_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_items: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemArgs']]]] = None,
                 config_items_applicable_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 opsi_config_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a OpsiConfiguration resource.
        :param pulumi.Input[str] opsi_config_type: (Updatable) OPSI configuration type.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_item_custom_statuses: Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_item_fields: Specifies the fields to return in a config item summary.
        :param pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemArgs']]] config_items: (Updatable) Array of configuration items with custom values. All and only configuration items requiring custom values should be part of this array.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_items_applicable_contexts: Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description of OPSI configuration.
        :param pulumi.Input[str] display_name: (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] opsi_config_fields: Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "opsi_config_type", opsi_config_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_item_custom_statuses is not None:
            pulumi.set(__self__, "config_item_custom_statuses", config_item_custom_statuses)
        if config_item_fields is not None:
            pulumi.set(__self__, "config_item_fields", config_item_fields)
        if config_items is not None:
            pulumi.set(__self__, "config_items", config_items)
        if config_items_applicable_contexts is not None:
            pulumi.set(__self__, "config_items_applicable_contexts", config_items_applicable_contexts)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if opsi_config_fields is not None:
            pulumi.set(__self__, "opsi_config_fields", opsi_config_fields)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @property
    @pulumi.getter(name="opsiConfigType")
    def opsi_config_type(self) -> pulumi.Input[str]:
        """
        (Updatable) OPSI configuration type.
        """
        return pulumi.get(self, "opsi_config_type")

    @opsi_config_type.setter
    def opsi_config_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "opsi_config_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configItemCustomStatuses")
    def config_item_custom_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
        """
        return pulumi.get(self, "config_item_custom_statuses")

    @config_item_custom_statuses.setter
    def config_item_custom_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_item_custom_statuses", value)

    @property
    @pulumi.getter(name="configItemFields")
    def config_item_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the fields to return in a config item summary.
        """
        return pulumi.get(self, "config_item_fields")

    @config_item_fields.setter
    def config_item_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_item_fields", value)

    @property
    @pulumi.getter(name="configItems")
    def config_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemArgs']]]]:
        """
        (Updatable) Array of configuration items with custom values. All and only configuration items requiring custom values should be part of this array.
        """
        return pulumi.get(self, "config_items")

    @config_items.setter
    def config_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemArgs']]]]):
        pulumi.set(self, "config_items", value)

    @property
    @pulumi.getter(name="configItemsApplicableContexts")
    def config_items_applicable_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
        """
        return pulumi.get(self, "config_items_applicable_contexts")

    @config_items_applicable_contexts.setter
    def config_items_applicable_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_items_applicable_contexts", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of OPSI configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="opsiConfigFields")
    def opsi_config_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
        """
        return pulumi.get(self, "opsi_config_fields")

    @opsi_config_fields.setter
    def opsi_config_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "opsi_config_fields", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _OpsiConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_item_custom_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_item_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_items: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemArgs']]]] = None,
                 config_items_applicable_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 opsi_config_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 opsi_config_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OpsiConfiguration resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_item_custom_statuses: Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_item_fields: Specifies the fields to return in a config item summary.
        :param pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemArgs']]] config_items: (Updatable) Array of configuration items with custom values. All and only configuration items requiring custom values should be part of this array.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_items_applicable_contexts: Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description of OPSI configuration.
        :param pulumi.Input[str] display_name: (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] opsi_config_fields: Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
        :param pulumi.Input[str] opsi_config_type: (Updatable) OPSI configuration type.
        :param pulumi.Input[str] state: OPSI configuration resource lifecycle state.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time at which the resource was first created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_item_custom_statuses is not None:
            pulumi.set(__self__, "config_item_custom_statuses", config_item_custom_statuses)
        if config_item_fields is not None:
            pulumi.set(__self__, "config_item_fields", config_item_fields)
        if config_items is not None:
            pulumi.set(__self__, "config_items", config_items)
        if config_items_applicable_contexts is not None:
            pulumi.set(__self__, "config_items_applicable_contexts", config_items_applicable_contexts)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if opsi_config_fields is not None:
            pulumi.set(__self__, "opsi_config_fields", opsi_config_fields)
        if opsi_config_type is not None:
            pulumi.set(__self__, "opsi_config_type", opsi_config_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configItemCustomStatuses")
    def config_item_custom_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
        """
        return pulumi.get(self, "config_item_custom_statuses")

    @config_item_custom_statuses.setter
    def config_item_custom_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_item_custom_statuses", value)

    @property
    @pulumi.getter(name="configItemFields")
    def config_item_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the fields to return in a config item summary.
        """
        return pulumi.get(self, "config_item_fields")

    @config_item_fields.setter
    def config_item_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_item_fields", value)

    @property
    @pulumi.getter(name="configItems")
    def config_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemArgs']]]]:
        """
        (Updatable) Array of configuration items with custom values. All and only configuration items requiring custom values should be part of this array.
        """
        return pulumi.get(self, "config_items")

    @config_items.setter
    def config_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemArgs']]]]):
        pulumi.set(self, "config_items", value)

    @property
    @pulumi.getter(name="configItemsApplicableContexts")
    def config_items_applicable_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
        """
        return pulumi.get(self, "config_items_applicable_contexts")

    @config_items_applicable_contexts.setter
    def config_items_applicable_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_items_applicable_contexts", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of OPSI configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="opsiConfigFields")
    def opsi_config_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
        """
        return pulumi.get(self, "opsi_config_fields")

    @opsi_config_fields.setter
    def opsi_config_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "opsi_config_fields", value)

    @property
    @pulumi.getter(name="opsiConfigType")
    def opsi_config_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OPSI configuration type.
        """
        return pulumi.get(self, "opsi_config_type")

    @opsi_config_type.setter
    def opsi_config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opsi_config_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        OPSI configuration resource lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class OpsiConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_item_custom_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_item_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpsiConfigurationConfigItemArgs', 'OpsiConfigurationConfigItemArgsDict']]]]] = None,
                 config_items_applicable_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 opsi_config_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 opsi_config_type: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        This resource provides the Opsi Configuration resource in Oracle Cloud Infrastructure Opsi service.

        Create an OPSI configuration resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_opsi_configuration = oci.opsi.OpsiConfiguration("test_opsi_configuration",
            opsi_config_type=opsi_configuration_opsi_config_type,
            compartment_id=compartment_id,
            config_item_custom_statuses=opsi_configuration_config_item_custom_status,
            config_item_fields=opsi_configuration_config_item_field,
            config_items=[{
                "config_item_type": opsi_configuration_config_items_config_item_type,
                "name": opsi_configuration_config_items_name,
                "value": opsi_configuration_config_items_value,
            }],
            config_items_applicable_contexts=opsi_configuration_config_items_applicable_context,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=opsi_configuration_description,
            display_name=opsi_configuration_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            opsi_config_fields=opsi_configuration_opsi_config_field,
            system_tags=opsi_configuration_system_tags)
        ```

        ## Import

        OpsiConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/opsiConfiguration:OpsiConfiguration test_opsi_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_item_custom_statuses: Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_item_fields: Specifies the fields to return in a config item summary.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OpsiConfigurationConfigItemArgs', 'OpsiConfigurationConfigItemArgsDict']]]] config_items: (Updatable) Array of configuration items with custom values. All and only configuration items requiring custom values should be part of this array.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_items_applicable_contexts: Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description of OPSI configuration.
        :param pulumi.Input[str] display_name: (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] opsi_config_fields: Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
        :param pulumi.Input[str] opsi_config_type: (Updatable) OPSI configuration type.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OpsiConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Opsi Configuration resource in Oracle Cloud Infrastructure Opsi service.

        Create an OPSI configuration resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_opsi_configuration = oci.opsi.OpsiConfiguration("test_opsi_configuration",
            opsi_config_type=opsi_configuration_opsi_config_type,
            compartment_id=compartment_id,
            config_item_custom_statuses=opsi_configuration_config_item_custom_status,
            config_item_fields=opsi_configuration_config_item_field,
            config_items=[{
                "config_item_type": opsi_configuration_config_items_config_item_type,
                "name": opsi_configuration_config_items_name,
                "value": opsi_configuration_config_items_value,
            }],
            config_items_applicable_contexts=opsi_configuration_config_items_applicable_context,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=opsi_configuration_description,
            display_name=opsi_configuration_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            opsi_config_fields=opsi_configuration_opsi_config_field,
            system_tags=opsi_configuration_system_tags)
        ```

        ## Import

        OpsiConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/opsiConfiguration:OpsiConfiguration test_opsi_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param OpsiConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OpsiConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_item_custom_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_item_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpsiConfigurationConfigItemArgs', 'OpsiConfigurationConfigItemArgsDict']]]]] = None,
                 config_items_applicable_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 opsi_config_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 opsi_config_type: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OpsiConfigurationArgs.__new__(OpsiConfigurationArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["config_item_custom_statuses"] = config_item_custom_statuses
            __props__.__dict__["config_item_fields"] = config_item_fields
            __props__.__dict__["config_items"] = config_items
            __props__.__dict__["config_items_applicable_contexts"] = config_items_applicable_contexts
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["opsi_config_fields"] = opsi_config_fields
            if opsi_config_type is None and not opts.urn:
                raise TypeError("Missing required property 'opsi_config_type'")
            __props__.__dict__["opsi_config_type"] = opsi_config_type
            __props__.__dict__["system_tags"] = system_tags
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(OpsiConfiguration, __self__).__init__(
            'oci:Opsi/opsiConfiguration:OpsiConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            config_item_custom_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            config_item_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            config_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpsiConfigurationConfigItemArgs', 'OpsiConfigurationConfigItemArgsDict']]]]] = None,
            config_items_applicable_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            opsi_config_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            opsi_config_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'OpsiConfiguration':
        """
        Get an existing OpsiConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_item_custom_statuses: Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_item_fields: Specifies the fields to return in a config item summary.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OpsiConfigurationConfigItemArgs', 'OpsiConfigurationConfigItemArgsDict']]]] config_items: (Updatable) Array of configuration items with custom values. All and only configuration items requiring custom values should be part of this array.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_items_applicable_contexts: Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description of OPSI configuration.
        :param pulumi.Input[str] display_name: (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] opsi_config_fields: Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
        :param pulumi.Input[str] opsi_config_type: (Updatable) OPSI configuration type.
        :param pulumi.Input[str] state: OPSI configuration resource lifecycle state.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time at which the resource was first created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OpsiConfigurationState.__new__(_OpsiConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_item_custom_statuses"] = config_item_custom_statuses
        __props__.__dict__["config_item_fields"] = config_item_fields
        __props__.__dict__["config_items"] = config_items
        __props__.__dict__["config_items_applicable_contexts"] = config_items_applicable_contexts
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["opsi_config_fields"] = opsi_config_fields
        __props__.__dict__["opsi_config_type"] = opsi_config_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return OpsiConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configItemCustomStatuses")
    def config_item_custom_statuses(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
        """
        return pulumi.get(self, "config_item_custom_statuses")

    @property
    @pulumi.getter(name="configItemFields")
    def config_item_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the fields to return in a config item summary.
        """
        return pulumi.get(self, "config_item_fields")

    @property
    @pulumi.getter(name="configItems")
    def config_items(self) -> pulumi.Output[Sequence['outputs.OpsiConfigurationConfigItem']]:
        """
        (Updatable) Array of configuration items with custom values. All and only configuration items requiring custom values should be part of this array.
        """
        return pulumi.get(self, "config_items")

    @property
    @pulumi.getter(name="configItemsApplicableContexts")
    def config_items_applicable_contexts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
        """
        return pulumi.get(self, "config_items_applicable_contexts")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description of OPSI configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="opsiConfigFields")
    def opsi_config_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
        """
        return pulumi.get(self, "opsi_config_fields")

    @property
    @pulumi.getter(name="opsiConfigType")
    def opsi_config_type(self) -> pulumi.Output[str]:
        """
        (Updatable) OPSI configuration type.
        """
        return pulumi.get(self, "opsi_config_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        OPSI configuration resource lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

