# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLifecycleStageResult',
    'AwaitableGetLifecycleStageResult',
    'get_lifecycle_stage',
    'get_lifecycle_stage_output',
]

@pulumi.output_type
class GetLifecycleStageResult:
    """
    A collection of values returned by getLifecycleStage.
    """
    def __init__(__self__, arch_type=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_environment_id=None, lifecycle_stage_id=None, location=None, managed_instance_ids=None, os_family=None, rank=None, software_source_ids=None, state=None, system_tags=None, time_created=None, time_modified=None, vendor_name=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_environment_id and not isinstance(lifecycle_environment_id, str):
            raise TypeError("Expected argument 'lifecycle_environment_id' to be a str")
        pulumi.set(__self__, "lifecycle_environment_id", lifecycle_environment_id)
        if lifecycle_stage_id and not isinstance(lifecycle_stage_id, str):
            raise TypeError("Expected argument 'lifecycle_stage_id' to be a str")
        pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if managed_instance_ids and not isinstance(managed_instance_ids, list):
            raise TypeError("Expected argument 'managed_instance_ids' to be a list")
        pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if rank and not isinstance(rank, int):
            raise TypeError("Expected argument 'rank' to be a int")
        pulumi.set(__self__, "rank", rank)
        if software_source_ids and not isinstance(software_source_ids, list):
            raise TypeError("Expected argument 'software_source_ids' to be a list")
        pulumi.set(__self__, "software_source_ids", software_source_ids)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_modified and not isinstance(time_modified, str):
            raise TypeError("Expected argument 'time_modified' to be a str")
        pulumi.set(__self__, "time_modified", time_modified)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> str:
        """
        The CPU architecture of the managed instances in the lifecycle stage.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the lifecycle stage.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Software source name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleEnvironmentId")
    def lifecycle_environment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle environment that contains the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_environment_id")

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> str:
        return pulumi.get(self, "lifecycle_stage_id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of managed instances associated with the lifecycle stage.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Sequence['outputs.GetLifecycleStageManagedInstanceIdResult']:
        """
        The list of managed instances associated with the lifecycle stage.
        """
        return pulumi.get(self, "managed_instance_ids")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> str:
        """
        The operating system of the managed instances in the lifecycle stage.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter
    def rank(self) -> int:
        """
        User-specified rank for the lifecycle stage. Rank determines the hierarchy of the lifecycle stages within the lifecycle environment.
        """
        return pulumi.get(self, "rank")

    @property
    @pulumi.getter(name="softwareSourceIds")
    def software_source_ids(self) -> Sequence['outputs.GetLifecycleStageSoftwareSourceIdResult']:
        """
        Provides identifying information for the specified software source.
        """
        return pulumi.get(self, "software_source_ids")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the lifecycle stage.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the lifecycle stage was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> str:
        """
        The time the lifecycle stage was last modified (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> str:
        """
        The vendor of the operating system used by the managed instances in the lifecycle stage.
        """
        return pulumi.get(self, "vendor_name")


class AwaitableGetLifecycleStageResult(GetLifecycleStageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLifecycleStageResult(
            arch_type=self.arch_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_environment_id=self.lifecycle_environment_id,
            lifecycle_stage_id=self.lifecycle_stage_id,
            location=self.location,
            managed_instance_ids=self.managed_instance_ids,
            os_family=self.os_family,
            rank=self.rank,
            software_source_ids=self.software_source_ids,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_modified=self.time_modified,
            vendor_name=self.vendor_name)


def get_lifecycle_stage(lifecycle_stage_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLifecycleStageResult:
    """
    This data source provides details about a specific Lifecycle Stage resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified lifecycle stage.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lifecycle_stage = oci.OsManagementHub.get_lifecycle_stage(lifecycle_stage_id=test_lifecycle_stage_oci_os_management_hub_lifecycle_stage["id"])
    ```


    :param str lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
    """
    __args__ = dict()
    __args__['lifecycleStageId'] = lifecycle_stage_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getLifecycleStage:getLifecycleStage', __args__, opts=opts, typ=GetLifecycleStageResult).value

    return AwaitableGetLifecycleStageResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_environment_id=pulumi.get(__ret__, 'lifecycle_environment_id'),
        lifecycle_stage_id=pulumi.get(__ret__, 'lifecycle_stage_id'),
        location=pulumi.get(__ret__, 'location'),
        managed_instance_ids=pulumi.get(__ret__, 'managed_instance_ids'),
        os_family=pulumi.get(__ret__, 'os_family'),
        rank=pulumi.get(__ret__, 'rank'),
        software_source_ids=pulumi.get(__ret__, 'software_source_ids'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_modified=pulumi.get(__ret__, 'time_modified'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'))


@_utilities.lift_output_func(get_lifecycle_stage)
def get_lifecycle_stage_output(lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLifecycleStageResult]:
    """
    This data source provides details about a specific Lifecycle Stage resource in Oracle Cloud Infrastructure Os Management Hub service.

    Returns information about the specified lifecycle stage.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lifecycle_stage = oci.OsManagementHub.get_lifecycle_stage(lifecycle_stage_id=test_lifecycle_stage_oci_os_management_hub_lifecycle_stage["id"])
    ```


    :param str lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
    """
    ...
