# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetWlpAgentResult',
    'AwaitableGetWlpAgentResult',
    'get_wlp_agent',
    'get_wlp_agent_output',
]

@pulumi.output_type
class GetWlpAgentResult:
    """
    A collection of values returned by getWlpAgent.
    """
    def __init__(__self__, agent_version=None, certificate_id=None, certificate_signed_request=None, compartment_id=None, defined_tags=None, freeform_tags=None, host_id=None, id=None, os_info=None, system_tags=None, tenant_id=None, time_created=None, time_updated=None, wlp_agent_id=None):
        if agent_version and not isinstance(agent_version, str):
            raise TypeError("Expected argument 'agent_version' to be a str")
        pulumi.set(__self__, "agent_version", agent_version)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_signed_request and not isinstance(certificate_signed_request, str):
            raise TypeError("Expected argument 'certificate_signed_request' to be a str")
        pulumi.set(__self__, "certificate_signed_request", certificate_signed_request)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_id and not isinstance(host_id, str):
            raise TypeError("Expected argument 'host_id' to be a str")
        pulumi.set(__self__, "host_id", host_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if os_info and not isinstance(os_info, str):
            raise TypeError("Expected argument 'os_info' to be a str")
        pulumi.set(__self__, "os_info", os_info)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if wlp_agent_id and not isinstance(wlp_agent_id, str):
            raise TypeError("Expected argument 'wlp_agent_id' to be a str")
        pulumi.set(__self__, "wlp_agent_id", wlp_agent_id)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> str:
        """
        The version of the agent
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        """
        The certificate ID returned by Oracle Cloud Infrastructure certificates service
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateSignedRequest")
    def certificate_signed_request(self) -> str:
        """
        The updated certificate signing request
        """
        return pulumi.get(self, "certificate_signed_request")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID of WlpAgent.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> str:
        """
        OCID for instance in which WlpAgent is installed
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID for WlpAgent
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="osInfo")
    def os_info(self) -> str:
        return pulumi.get(self, "os_info")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        TenantId of the host
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the WlpAgent was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the WlpAgent was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="wlpAgentId")
    def wlp_agent_id(self) -> str:
        return pulumi.get(self, "wlp_agent_id")


class AwaitableGetWlpAgentResult(GetWlpAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlpAgentResult(
            agent_version=self.agent_version,
            certificate_id=self.certificate_id,
            certificate_signed_request=self.certificate_signed_request,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            host_id=self.host_id,
            id=self.id,
            os_info=self.os_info,
            system_tags=self.system_tags,
            tenant_id=self.tenant_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            wlp_agent_id=self.wlp_agent_id)


def get_wlp_agent(wlp_agent_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlpAgentResult:
    """
    This data source provides details about a specific Wlp Agent resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a WlpAgent resource for an on-premise resource identified by wlpAgentId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wlp_agent = oci.CloudGuard.get_wlp_agent(wlp_agent_id=test_wlp_agent_oci_cloud_guard_wlp_agent["id"])
    ```


    :param str wlp_agent_id: WLP agent OCID.
    """
    __args__ = dict()
    __args__['wlpAgentId'] = wlp_agent_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getWlpAgent:getWlpAgent', __args__, opts=opts, typ=GetWlpAgentResult).value

    return AwaitableGetWlpAgentResult(
        agent_version=pulumi.get(__ret__, 'agent_version'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        certificate_signed_request=pulumi.get(__ret__, 'certificate_signed_request'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        host_id=pulumi.get(__ret__, 'host_id'),
        id=pulumi.get(__ret__, 'id'),
        os_info=pulumi.get(__ret__, 'os_info'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        wlp_agent_id=pulumi.get(__ret__, 'wlp_agent_id'))


@_utilities.lift_output_func(get_wlp_agent)
def get_wlp_agent_output(wlp_agent_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWlpAgentResult]:
    """
    This data source provides details about a specific Wlp Agent resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a WlpAgent resource for an on-premise resource identified by wlpAgentId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wlp_agent = oci.CloudGuard.get_wlp_agent(wlp_agent_id=test_wlp_agent_oci_cloud_guard_wlp_agent["id"])
    ```


    :param str wlp_agent_id: WLP agent OCID.
    """
    ...
