# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpsecConnectionsResult',
    'AwaitableGetIpsecConnectionsResult',
    'get_ipsec_connections',
    'get_ipsec_connections_output',
]

@pulumi.output_type
class GetIpsecConnectionsResult:
    """
    A collection of values returned by getIpsecConnections.
    """
    def __init__(__self__, compartment_id=None, connections=None, cpe_id=None, drg_id=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connections and not isinstance(connections, list):
            raise TypeError("Expected argument 'connections' to be a list")
        pulumi.set(__self__, "connections", connections)
        if cpe_id and not isinstance(cpe_id, str):
            raise TypeError("Expected argument 'cpe_id' to be a str")
        pulumi.set(__self__, "cpe_id", cpe_id)
        if drg_id and not isinstance(drg_id, str):
            raise TypeError("Expected argument 'drg_id' to be a str")
        pulumi.set(__self__, "drg_id", drg_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the IPSec connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetIpsecConnectionsConnectionResult']:
        """
        The list of connections.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="cpeId")
    def cpe_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.
        """
        return pulumi.get(self, "cpe_id")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIpsecConnectionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetIpsecConnectionsResult(GetIpsecConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsecConnectionsResult(
            compartment_id=self.compartment_id,
            connections=self.connections,
            cpe_id=self.cpe_id,
            drg_id=self.drg_id,
            filters=self.filters,
            id=self.id)


def get_ipsec_connections(compartment_id: Optional[str] = None,
                          cpe_id: Optional[str] = None,
                          drg_id: Optional[str] = None,
                          filters: Optional[Sequence[Union['GetIpsecConnectionsFilterArgs', 'GetIpsecConnectionsFilterArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsecConnectionsResult:
    """
    This data source provides the list of Ip Sec Connections in Oracle Cloud Infrastructure Core service.

    Lists the IPSec connections for the specified compartment. You can filter the
    results by DRG or CPE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connections = oci.Core.get_ipsec_connections(compartment_id=compartment_id,
        cpe_id=test_cpe["id"],
        drg_id=test_drg["id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str cpe_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CPE.
    :param str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['cpeId'] = cpe_id
    __args__['drgId'] = drg_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getIpsecConnections:getIpsecConnections', __args__, opts=opts, typ=GetIpsecConnectionsResult).value

    return AwaitableGetIpsecConnectionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connections=pulumi.get(__ret__, 'connections'),
        cpe_id=pulumi.get(__ret__, 'cpe_id'),
        drg_id=pulumi.get(__ret__, 'drg_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_ipsec_connections)
def get_ipsec_connections_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 cpe_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 drg_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetIpsecConnectionsFilterArgs', 'GetIpsecConnectionsFilterArgsDict']]]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpsecConnectionsResult]:
    """
    This data source provides the list of Ip Sec Connections in Oracle Cloud Infrastructure Core service.

    Lists the IPSec connections for the specified compartment. You can filter the
    results by DRG or CPE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connections = oci.Core.get_ipsec_connections(compartment_id=compartment_id,
        cpe_id=test_cpe["id"],
        drg_id=test_drg["id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str cpe_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CPE.
    :param str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    """
    ...
