# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MigrationArgs', 'Migration']

@pulumi.input_type
class MigrationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 database_combination: pulumi.Input[str],
                 source_database_connection_id: pulumi.Input[str],
                 target_database_connection_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 advanced_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationAdvancedParameterArgs']]]] = None,
                 advisor_settings: Optional[pulumi.Input['MigrationAdvisorSettingsArgs']] = None,
                 bulk_include_exclude_data: Optional[pulumi.Input[str]] = None,
                 data_transfer_medium_details: Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ggs_details: Optional[pulumi.Input['MigrationGgsDetailsArgs']] = None,
                 hub_details: Optional[pulumi.Input['MigrationHubDetailsArgs']] = None,
                 include_objects: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]] = None,
                 initial_load_settings: Optional[pulumi.Input['MigrationInitialLoadSettingsArgs']] = None,
                 source_container_database_connection_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Migration resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] database_combination: (Updatable) The combination of source and target databases participating in a migration. Example: ORACLE means the migration is meant for migrating Oracle source and target databases.
        :param pulumi.Input[str] source_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] target_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] type: (Updatable) The type of the migration to be performed. Example: ONLINE if no downtime is preferred for a migration. This method uses Oracle GoldenGate for replication.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['MigrationAdvancedParameterArgs']]] advanced_parameters: (Updatable) List of Migration Parameter objects.
        :param pulumi.Input['MigrationAdvisorSettingsArgs'] advisor_settings: (Updatable) Optional Pre-Migration advisor settings.
        :param pulumi.Input[str] bulk_include_exclude_data: Specifies the database objects to be excluded from the migration in bulk. The definition accepts input in a CSV format, newline separated for each entry. More details can be found in the documentation.
        :param pulumi.Input['MigrationDataTransferMediumDetailsArgs'] data_transfer_medium_details: (Updatable) Optional additional properties for data transfer.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]] exclude_objects: Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input['MigrationGgsDetailsArgs'] ggs_details: (Updatable) Optional settings for Oracle GoldenGate processes
        :param pulumi.Input['MigrationHubDetailsArgs'] hub_details: (Updatable) Details about Oracle GoldenGate Microservices.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]] include_objects: Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        :param pulumi.Input['MigrationInitialLoadSettingsArgs'] initial_load_settings: (Updatable) Optional settings for Data Pump Export and Import jobs
        :param pulumi.Input[str] source_container_database_connection_id: (Updatable) The OCID of the resource being referenced.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "database_combination", database_combination)
        pulumi.set(__self__, "source_database_connection_id", source_database_connection_id)
        pulumi.set(__self__, "target_database_connection_id", target_database_connection_id)
        pulumi.set(__self__, "type", type)
        if advanced_parameters is not None:
            pulumi.set(__self__, "advanced_parameters", advanced_parameters)
        if advisor_settings is not None:
            pulumi.set(__self__, "advisor_settings", advisor_settings)
        if bulk_include_exclude_data is not None:
            pulumi.set(__self__, "bulk_include_exclude_data", bulk_include_exclude_data)
        if data_transfer_medium_details is not None:
            pulumi.set(__self__, "data_transfer_medium_details", data_transfer_medium_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ggs_details is not None:
            pulumi.set(__self__, "ggs_details", ggs_details)
        if hub_details is not None:
            pulumi.set(__self__, "hub_details", hub_details)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if initial_load_settings is not None:
            pulumi.set(__self__, "initial_load_settings", initial_load_settings)
        if source_container_database_connection_id is not None:
            pulumi.set(__self__, "source_container_database_connection_id", source_container_database_connection_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseCombination")
    def database_combination(self) -> pulumi.Input[str]:
        """
        (Updatable) The combination of source and target databases participating in a migration. Example: ORACLE means the migration is meant for migrating Oracle source and target databases.
        """
        return pulumi.get(self, "database_combination")

    @database_combination.setter
    def database_combination(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_combination", value)

    @property
    @pulumi.getter(name="sourceDatabaseConnectionId")
    def source_database_connection_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "source_database_connection_id")

    @source_database_connection_id.setter
    def source_database_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_database_connection_id", value)

    @property
    @pulumi.getter(name="targetDatabaseConnectionId")
    def target_database_connection_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "target_database_connection_id")

    @target_database_connection_id.setter
    def target_database_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_database_connection_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the migration to be performed. Example: ONLINE if no downtime is preferred for a migration. This method uses Oracle GoldenGate for replication.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="advancedParameters")
    def advanced_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationAdvancedParameterArgs']]]]:
        """
        (Updatable) List of Migration Parameter objects.
        """
        return pulumi.get(self, "advanced_parameters")

    @advanced_parameters.setter
    def advanced_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationAdvancedParameterArgs']]]]):
        pulumi.set(self, "advanced_parameters", value)

    @property
    @pulumi.getter(name="advisorSettings")
    def advisor_settings(self) -> Optional[pulumi.Input['MigrationAdvisorSettingsArgs']]:
        """
        (Updatable) Optional Pre-Migration advisor settings.
        """
        return pulumi.get(self, "advisor_settings")

    @advisor_settings.setter
    def advisor_settings(self, value: Optional[pulumi.Input['MigrationAdvisorSettingsArgs']]):
        pulumi.set(self, "advisor_settings", value)

    @property
    @pulumi.getter(name="bulkIncludeExcludeData")
    def bulk_include_exclude_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database objects to be excluded from the migration in bulk. The definition accepts input in a CSV format, newline separated for each entry. More details can be found in the documentation.
        """
        return pulumi.get(self, "bulk_include_exclude_data")

    @bulk_include_exclude_data.setter
    def bulk_include_exclude_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bulk_include_exclude_data", value)

    @property
    @pulumi.getter(name="dataTransferMediumDetails")
    def data_transfer_medium_details(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']]:
        """
        (Updatable) Optional additional properties for data transfer.
        """
        return pulumi.get(self, "data_transfer_medium_details")

    @data_transfer_medium_details.setter
    def data_transfer_medium_details(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']]):
        pulumi.set(self, "data_transfer_medium_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]]:
        """
        Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        """
        return pulumi.get(self, "exclude_objects")

    @exclude_objects.setter
    def exclude_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]]):
        pulumi.set(self, "exclude_objects", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ggsDetails")
    def ggs_details(self) -> Optional[pulumi.Input['MigrationGgsDetailsArgs']]:
        """
        (Updatable) Optional settings for Oracle GoldenGate processes
        """
        return pulumi.get(self, "ggs_details")

    @ggs_details.setter
    def ggs_details(self, value: Optional[pulumi.Input['MigrationGgsDetailsArgs']]):
        pulumi.set(self, "ggs_details", value)

    @property
    @pulumi.getter(name="hubDetails")
    def hub_details(self) -> Optional[pulumi.Input['MigrationHubDetailsArgs']]:
        """
        (Updatable) Details about Oracle GoldenGate Microservices.
        """
        return pulumi.get(self, "hub_details")

    @hub_details.setter
    def hub_details(self, value: Optional[pulumi.Input['MigrationHubDetailsArgs']]):
        pulumi.set(self, "hub_details", value)

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]]:
        """
        Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        """
        return pulumi.get(self, "include_objects")

    @include_objects.setter
    def include_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]]):
        pulumi.set(self, "include_objects", value)

    @property
    @pulumi.getter(name="initialLoadSettings")
    def initial_load_settings(self) -> Optional[pulumi.Input['MigrationInitialLoadSettingsArgs']]:
        """
        (Updatable) Optional settings for Data Pump Export and Import jobs
        """
        return pulumi.get(self, "initial_load_settings")

    @initial_load_settings.setter
    def initial_load_settings(self, value: Optional[pulumi.Input['MigrationInitialLoadSettingsArgs']]):
        pulumi.set(self, "initial_load_settings", value)

    @property
    @pulumi.getter(name="sourceContainerDatabaseConnectionId")
    def source_container_database_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "source_container_database_connection_id")

    @source_container_database_connection_id.setter
    def source_container_database_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_container_database_connection_id", value)


@pulumi.input_type
class _MigrationState:
    def __init__(__self__, *,
                 advanced_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationAdvancedParameterArgs']]]] = None,
                 advisor_settings: Optional[pulumi.Input['MigrationAdvisorSettingsArgs']] = None,
                 bulk_include_exclude_data: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_transfer_medium_details: Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']] = None,
                 database_combination: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]] = None,
                 executing_job_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ggs_details: Optional[pulumi.Input['MigrationGgsDetailsArgs']] = None,
                 hub_details: Optional[pulumi.Input['MigrationHubDetailsArgs']] = None,
                 include_objects: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]] = None,
                 initial_load_settings: Optional[pulumi.Input['MigrationInitialLoadSettingsArgs']] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
                 source_database_connection_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_database_connection_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_migration: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 wait_after: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Migration resources.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationAdvancedParameterArgs']]] advanced_parameters: (Updatable) List of Migration Parameter objects.
        :param pulumi.Input['MigrationAdvisorSettingsArgs'] advisor_settings: (Updatable) Optional Pre-Migration advisor settings.
        :param pulumi.Input[str] bulk_include_exclude_data: Specifies the database objects to be excluded from the migration in bulk. The definition accepts input in a CSV format, newline separated for each entry. More details can be found in the documentation.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input['MigrationDataTransferMediumDetailsArgs'] data_transfer_medium_details: (Updatable) Optional additional properties for data transfer.
        :param pulumi.Input[str] database_combination: (Updatable) The combination of source and target databases participating in a migration. Example: ORACLE means the migration is meant for migrating Oracle source and target databases.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]] exclude_objects: Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        :param pulumi.Input[str] executing_job_id: The OCID of the resource being referenced.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input['MigrationGgsDetailsArgs'] ggs_details: (Updatable) Optional settings for Oracle GoldenGate processes
        :param pulumi.Input['MigrationHubDetailsArgs'] hub_details: (Updatable) Details about Oracle GoldenGate Microservices.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]] include_objects: Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        :param pulumi.Input['MigrationInitialLoadSettingsArgs'] initial_load_settings: (Updatable) Optional settings for Data Pump Export and Import jobs
        :param pulumi.Input[str] lifecycle_details: Additional status related to the execution and current state of the Migration.
        :param pulumi.Input[str] source_container_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] source_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] state: The current state of the Migration resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] time_created: An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_last_migration: An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_updated: An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] type: (Updatable) The type of the migration to be performed. Example: ONLINE if no downtime is preferred for a migration. This method uses Oracle GoldenGate for replication.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] wait_after: You can optionally pause a migration after a job phase. This property allows you to optionally specify the phase after which you can pause the migration.
        """
        if advanced_parameters is not None:
            pulumi.set(__self__, "advanced_parameters", advanced_parameters)
        if advisor_settings is not None:
            pulumi.set(__self__, "advisor_settings", advisor_settings)
        if bulk_include_exclude_data is not None:
            pulumi.set(__self__, "bulk_include_exclude_data", bulk_include_exclude_data)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if data_transfer_medium_details is not None:
            pulumi.set(__self__, "data_transfer_medium_details", data_transfer_medium_details)
        if database_combination is not None:
            pulumi.set(__self__, "database_combination", database_combination)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if executing_job_id is not None:
            pulumi.set(__self__, "executing_job_id", executing_job_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ggs_details is not None:
            pulumi.set(__self__, "ggs_details", ggs_details)
        if hub_details is not None:
            pulumi.set(__self__, "hub_details", hub_details)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if initial_load_settings is not None:
            pulumi.set(__self__, "initial_load_settings", initial_load_settings)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if source_container_database_connection_id is not None:
            pulumi.set(__self__, "source_container_database_connection_id", source_container_database_connection_id)
        if source_database_connection_id is not None:
            pulumi.set(__self__, "source_database_connection_id", source_database_connection_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_database_connection_id is not None:
            pulumi.set(__self__, "target_database_connection_id", target_database_connection_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_migration is not None:
            pulumi.set(__self__, "time_last_migration", time_last_migration)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if wait_after is not None:
            pulumi.set(__self__, "wait_after", wait_after)

    @property
    @pulumi.getter(name="advancedParameters")
    def advanced_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationAdvancedParameterArgs']]]]:
        """
        (Updatable) List of Migration Parameter objects.
        """
        return pulumi.get(self, "advanced_parameters")

    @advanced_parameters.setter
    def advanced_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationAdvancedParameterArgs']]]]):
        pulumi.set(self, "advanced_parameters", value)

    @property
    @pulumi.getter(name="advisorSettings")
    def advisor_settings(self) -> Optional[pulumi.Input['MigrationAdvisorSettingsArgs']]:
        """
        (Updatable) Optional Pre-Migration advisor settings.
        """
        return pulumi.get(self, "advisor_settings")

    @advisor_settings.setter
    def advisor_settings(self, value: Optional[pulumi.Input['MigrationAdvisorSettingsArgs']]):
        pulumi.set(self, "advisor_settings", value)

    @property
    @pulumi.getter(name="bulkIncludeExcludeData")
    def bulk_include_exclude_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database objects to be excluded from the migration in bulk. The definition accepts input in a CSV format, newline separated for each entry. More details can be found in the documentation.
        """
        return pulumi.get(self, "bulk_include_exclude_data")

    @bulk_include_exclude_data.setter
    def bulk_include_exclude_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bulk_include_exclude_data", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataTransferMediumDetails")
    def data_transfer_medium_details(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']]:
        """
        (Updatable) Optional additional properties for data transfer.
        """
        return pulumi.get(self, "data_transfer_medium_details")

    @data_transfer_medium_details.setter
    def data_transfer_medium_details(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsArgs']]):
        pulumi.set(self, "data_transfer_medium_details", value)

    @property
    @pulumi.getter(name="databaseCombination")
    def database_combination(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The combination of source and target databases participating in a migration. Example: ORACLE means the migration is meant for migrating Oracle source and target databases.
        """
        return pulumi.get(self, "database_combination")

    @database_combination.setter
    def database_combination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_combination", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]]:
        """
        Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        """
        return pulumi.get(self, "exclude_objects")

    @exclude_objects.setter
    def exclude_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationExcludeObjectArgs']]]]):
        pulumi.set(self, "exclude_objects", value)

    @property
    @pulumi.getter(name="executingJobId")
    def executing_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "executing_job_id")

    @executing_job_id.setter
    def executing_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executing_job_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ggsDetails")
    def ggs_details(self) -> Optional[pulumi.Input['MigrationGgsDetailsArgs']]:
        """
        (Updatable) Optional settings for Oracle GoldenGate processes
        """
        return pulumi.get(self, "ggs_details")

    @ggs_details.setter
    def ggs_details(self, value: Optional[pulumi.Input['MigrationGgsDetailsArgs']]):
        pulumi.set(self, "ggs_details", value)

    @property
    @pulumi.getter(name="hubDetails")
    def hub_details(self) -> Optional[pulumi.Input['MigrationHubDetailsArgs']]:
        """
        (Updatable) Details about Oracle GoldenGate Microservices.
        """
        return pulumi.get(self, "hub_details")

    @hub_details.setter
    def hub_details(self, value: Optional[pulumi.Input['MigrationHubDetailsArgs']]):
        pulumi.set(self, "hub_details", value)

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]]:
        """
        Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        """
        return pulumi.get(self, "include_objects")

    @include_objects.setter
    def include_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationIncludeObjectArgs']]]]):
        pulumi.set(self, "include_objects", value)

    @property
    @pulumi.getter(name="initialLoadSettings")
    def initial_load_settings(self) -> Optional[pulumi.Input['MigrationInitialLoadSettingsArgs']]:
        """
        (Updatable) Optional settings for Data Pump Export and Import jobs
        """
        return pulumi.get(self, "initial_load_settings")

    @initial_load_settings.setter
    def initial_load_settings(self, value: Optional[pulumi.Input['MigrationInitialLoadSettingsArgs']]):
        pulumi.set(self, "initial_load_settings", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional status related to the execution and current state of the Migration.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="sourceContainerDatabaseConnectionId")
    def source_container_database_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "source_container_database_connection_id")

    @source_container_database_connection_id.setter
    def source_container_database_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_container_database_connection_id", value)

    @property
    @pulumi.getter(name="sourceDatabaseConnectionId")
    def source_database_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "source_database_connection_id")

    @source_database_connection_id.setter
    def source_database_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_database_connection_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Migration resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetDatabaseConnectionId")
    def target_database_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "target_database_connection_id")

    @target_database_connection_id.setter
    def target_database_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_connection_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastMigration")
    def time_last_migration(self) -> Optional[pulumi.Input[str]]:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_migration")

    @time_last_migration.setter
    def time_last_migration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_migration", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the migration to be performed. Example: ONLINE if no downtime is preferred for a migration. This method uses Oracle GoldenGate for replication.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="waitAfter")
    def wait_after(self) -> Optional[pulumi.Input[str]]:
        """
        You can optionally pause a migration after a job phase. This property allows you to optionally specify the phase after which you can pause the migration.
        """
        return pulumi.get(self, "wait_after")

    @wait_after.setter
    def wait_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_after", value)


class Migration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationAdvancedParameterArgs', 'MigrationAdvancedParameterArgsDict']]]]] = None,
                 advisor_settings: Optional[pulumi.Input[Union['MigrationAdvisorSettingsArgs', 'MigrationAdvisorSettingsArgsDict']]] = None,
                 bulk_include_exclude_data: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_transfer_medium_details: Optional[pulumi.Input[Union['MigrationDataTransferMediumDetailsArgs', 'MigrationDataTransferMediumDetailsArgsDict']]] = None,
                 database_combination: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationExcludeObjectArgs', 'MigrationExcludeObjectArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ggs_details: Optional[pulumi.Input[Union['MigrationGgsDetailsArgs', 'MigrationGgsDetailsArgsDict']]] = None,
                 hub_details: Optional[pulumi.Input[Union['MigrationHubDetailsArgs', 'MigrationHubDetailsArgsDict']]] = None,
                 include_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationIncludeObjectArgs', 'MigrationIncludeObjectArgsDict']]]]] = None,
                 initial_load_settings: Optional[pulumi.Input[Union['MigrationInitialLoadSettingsArgs', 'MigrationInitialLoadSettingsArgsDict']]] = None,
                 source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
                 source_database_connection_id: Optional[pulumi.Input[str]] = None,
                 target_database_connection_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_migration = oci.database_migration.Migration("test_migration",
            compartment_id=compartment_id,
            database_combination=migration_database_combination,
            source_database_connection_id=test_connection["id"],
            target_database_connection_id=test_connection["id"],
            type=migration_type,
            advanced_parameters=[{
                "data_type": migration_advanced_parameters_data_type,
                "name": migration_advanced_parameters_name,
                "value": migration_advanced_parameters_value,
            }],
            advisor_settings={
                "is_ignore_errors": migration_advisor_settings_is_ignore_errors,
                "is_skip_advisor": migration_advisor_settings_is_skip_advisor,
            },
            bulk_include_exclude_data=migration_bulk_include_exclude_data,
            data_transfer_medium_details={
                "type": migration_data_transfer_medium_details_type,
                "access_key_id": test_key["id"],
                "name": migration_data_transfer_medium_details_name,
                "object_storage_bucket": {
                    "bucket": migration_data_transfer_medium_details_object_storage_bucket_bucket,
                    "namespace": migration_data_transfer_medium_details_object_storage_bucket_namespace,
                },
                "region": migration_data_transfer_medium_details_region,
                "secret_access_key": migration_data_transfer_medium_details_secret_access_key,
                "shared_storage_mount_target_id": test_mount_target["id"],
                "source": {
                    "kind": migration_data_transfer_medium_details_source_kind,
                    "oci_home": migration_data_transfer_medium_details_source_oci_home,
                    "wallet_location": migration_data_transfer_medium_details_source_wallet_location,
                },
                "target": {
                    "kind": migration_data_transfer_medium_details_target_kind,
                    "oci_home": migration_data_transfer_medium_details_target_oci_home,
                    "wallet_location": migration_data_transfer_medium_details_target_wallet_location,
                },
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=migration_description,
            display_name=migration_display_name,
            exclude_objects=[{
                "object": migration_exclude_objects_object,
                "is_omit_excluded_table_from_replication": migration_exclude_objects_is_omit_excluded_table_from_replication,
                "owner": migration_exclude_objects_owner,
                "schema": migration_exclude_objects_schema,
                "type": migration_exclude_objects_type,
            }],
            freeform_tags=migration_freeform_tags,
            ggs_details={
                "acceptable_lag": migration_ggs_details_acceptable_lag,
                "extract": {
                    "long_trans_duration": migration_ggs_details_extract_long_trans_duration,
                    "performance_profile": migration_ggs_details_extract_performance_profile,
                },
                "replicat": {
                    "performance_profile": migration_ggs_details_replicat_performance_profile,
                },
            },
            hub_details={
                "key_id": test_key["id"],
                "rest_admin_credentials": {
                    "password": migration_hub_details_rest_admin_credentials_password,
                    "username": migration_hub_details_rest_admin_credentials_username,
                },
                "url": migration_hub_details_url,
                "vault_id": test_vault["id"],
                "acceptable_lag": migration_hub_details_acceptable_lag,
                "compute_id": test_compute["id"],
                "extract": {
                    "long_trans_duration": migration_hub_details_extract_long_trans_duration,
                    "performance_profile": migration_hub_details_extract_performance_profile,
                },
                "replicat": {
                    "performance_profile": migration_hub_details_replicat_performance_profile,
                },
            },
            include_objects=[{
                "object": migration_include_objects_object,
                "is_omit_excluded_table_from_replication": migration_include_objects_is_omit_excluded_table_from_replication,
                "owner": migration_include_objects_owner,
                "schema": migration_include_objects_schema,
                "type": migration_include_objects_type,
            }],
            initial_load_settings={
                "job_mode": migration_initial_load_settings_job_mode,
                "compatibilities": migration_initial_load_settings_compatibility,
                "data_pump_parameters": {
                    "estimate": migration_initial_load_settings_data_pump_parameters_estimate,
                    "exclude_parameters": migration_initial_load_settings_data_pump_parameters_exclude_parameters,
                    "export_parallelism_degree": migration_initial_load_settings_data_pump_parameters_export_parallelism_degree,
                    "import_parallelism_degree": migration_initial_load_settings_data_pump_parameters_import_parallelism_degree,
                    "is_cluster": migration_initial_load_settings_data_pump_parameters_is_cluster,
                    "table_exists_action": migration_initial_load_settings_data_pump_parameters_table_exists_action,
                },
                "export_directory_object": {
                    "name": migration_initial_load_settings_export_directory_object_name,
                    "path": migration_initial_load_settings_export_directory_object_path,
                },
                "handle_grant_errors": migration_initial_load_settings_handle_grant_errors,
                "import_directory_object": {
                    "name": migration_initial_load_settings_import_directory_object_name,
                    "path": migration_initial_load_settings_import_directory_object_path,
                },
                "is_consistent": migration_initial_load_settings_is_consistent,
                "is_ignore_existing_objects": migration_initial_load_settings_is_ignore_existing_objects,
                "is_tz_utc": migration_initial_load_settings_is_tz_utc,
                "metadata_remaps": [{
                    "new_value": migration_initial_load_settings_metadata_remaps_new_value,
                    "old_value": migration_initial_load_settings_metadata_remaps_old_value,
                    "type": migration_initial_load_settings_metadata_remaps_type,
                }],
                "primary_key_compatibility": migration_initial_load_settings_primary_key_compatibility,
                "tablespace_details": {
                    "target_type": migration_initial_load_settings_tablespace_details_target_type,
                    "block_size_in_kbs": migration_initial_load_settings_tablespace_details_block_size_in_kbs,
                    "extend_size_in_mbs": migration_initial_load_settings_tablespace_details_extend_size_in_mbs,
                    "is_auto_create": migration_initial_load_settings_tablespace_details_is_auto_create,
                    "is_big_file": migration_initial_load_settings_tablespace_details_is_big_file,
                    "remap_target": migration_initial_load_settings_tablespace_details_remap_target,
                },
            },
            source_container_database_connection_id=test_connection["id"])
        ```

        ## Import

        Migrations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseMigration/migration:Migration test_migration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MigrationAdvancedParameterArgs', 'MigrationAdvancedParameterArgsDict']]]] advanced_parameters: (Updatable) List of Migration Parameter objects.
        :param pulumi.Input[Union['MigrationAdvisorSettingsArgs', 'MigrationAdvisorSettingsArgsDict']] advisor_settings: (Updatable) Optional Pre-Migration advisor settings.
        :param pulumi.Input[str] bulk_include_exclude_data: Specifies the database objects to be excluded from the migration in bulk. The definition accepts input in a CSV format, newline separated for each entry. More details can be found in the documentation.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[Union['MigrationDataTransferMediumDetailsArgs', 'MigrationDataTransferMediumDetailsArgsDict']] data_transfer_medium_details: (Updatable) Optional additional properties for data transfer.
        :param pulumi.Input[str] database_combination: (Updatable) The combination of source and target databases participating in a migration. Example: ORACLE means the migration is meant for migrating Oracle source and target databases.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MigrationExcludeObjectArgs', 'MigrationExcludeObjectArgsDict']]]] exclude_objects: Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[Union['MigrationGgsDetailsArgs', 'MigrationGgsDetailsArgsDict']] ggs_details: (Updatable) Optional settings for Oracle GoldenGate processes
        :param pulumi.Input[Union['MigrationHubDetailsArgs', 'MigrationHubDetailsArgsDict']] hub_details: (Updatable) Details about Oracle GoldenGate Microservices.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MigrationIncludeObjectArgs', 'MigrationIncludeObjectArgsDict']]]] include_objects: Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        :param pulumi.Input[Union['MigrationInitialLoadSettingsArgs', 'MigrationInitialLoadSettingsArgsDict']] initial_load_settings: (Updatable) Optional settings for Data Pump Export and Import jobs
        :param pulumi.Input[str] source_container_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] source_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] target_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] type: (Updatable) The type of the migration to be performed. Example: ONLINE if no downtime is preferred for a migration. This method uses Oracle GoldenGate for replication.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_migration = oci.database_migration.Migration("test_migration",
            compartment_id=compartment_id,
            database_combination=migration_database_combination,
            source_database_connection_id=test_connection["id"],
            target_database_connection_id=test_connection["id"],
            type=migration_type,
            advanced_parameters=[{
                "data_type": migration_advanced_parameters_data_type,
                "name": migration_advanced_parameters_name,
                "value": migration_advanced_parameters_value,
            }],
            advisor_settings={
                "is_ignore_errors": migration_advisor_settings_is_ignore_errors,
                "is_skip_advisor": migration_advisor_settings_is_skip_advisor,
            },
            bulk_include_exclude_data=migration_bulk_include_exclude_data,
            data_transfer_medium_details={
                "type": migration_data_transfer_medium_details_type,
                "access_key_id": test_key["id"],
                "name": migration_data_transfer_medium_details_name,
                "object_storage_bucket": {
                    "bucket": migration_data_transfer_medium_details_object_storage_bucket_bucket,
                    "namespace": migration_data_transfer_medium_details_object_storage_bucket_namespace,
                },
                "region": migration_data_transfer_medium_details_region,
                "secret_access_key": migration_data_transfer_medium_details_secret_access_key,
                "shared_storage_mount_target_id": test_mount_target["id"],
                "source": {
                    "kind": migration_data_transfer_medium_details_source_kind,
                    "oci_home": migration_data_transfer_medium_details_source_oci_home,
                    "wallet_location": migration_data_transfer_medium_details_source_wallet_location,
                },
                "target": {
                    "kind": migration_data_transfer_medium_details_target_kind,
                    "oci_home": migration_data_transfer_medium_details_target_oci_home,
                    "wallet_location": migration_data_transfer_medium_details_target_wallet_location,
                },
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=migration_description,
            display_name=migration_display_name,
            exclude_objects=[{
                "object": migration_exclude_objects_object,
                "is_omit_excluded_table_from_replication": migration_exclude_objects_is_omit_excluded_table_from_replication,
                "owner": migration_exclude_objects_owner,
                "schema": migration_exclude_objects_schema,
                "type": migration_exclude_objects_type,
            }],
            freeform_tags=migration_freeform_tags,
            ggs_details={
                "acceptable_lag": migration_ggs_details_acceptable_lag,
                "extract": {
                    "long_trans_duration": migration_ggs_details_extract_long_trans_duration,
                    "performance_profile": migration_ggs_details_extract_performance_profile,
                },
                "replicat": {
                    "performance_profile": migration_ggs_details_replicat_performance_profile,
                },
            },
            hub_details={
                "key_id": test_key["id"],
                "rest_admin_credentials": {
                    "password": migration_hub_details_rest_admin_credentials_password,
                    "username": migration_hub_details_rest_admin_credentials_username,
                },
                "url": migration_hub_details_url,
                "vault_id": test_vault["id"],
                "acceptable_lag": migration_hub_details_acceptable_lag,
                "compute_id": test_compute["id"],
                "extract": {
                    "long_trans_duration": migration_hub_details_extract_long_trans_duration,
                    "performance_profile": migration_hub_details_extract_performance_profile,
                },
                "replicat": {
                    "performance_profile": migration_hub_details_replicat_performance_profile,
                },
            },
            include_objects=[{
                "object": migration_include_objects_object,
                "is_omit_excluded_table_from_replication": migration_include_objects_is_omit_excluded_table_from_replication,
                "owner": migration_include_objects_owner,
                "schema": migration_include_objects_schema,
                "type": migration_include_objects_type,
            }],
            initial_load_settings={
                "job_mode": migration_initial_load_settings_job_mode,
                "compatibilities": migration_initial_load_settings_compatibility,
                "data_pump_parameters": {
                    "estimate": migration_initial_load_settings_data_pump_parameters_estimate,
                    "exclude_parameters": migration_initial_load_settings_data_pump_parameters_exclude_parameters,
                    "export_parallelism_degree": migration_initial_load_settings_data_pump_parameters_export_parallelism_degree,
                    "import_parallelism_degree": migration_initial_load_settings_data_pump_parameters_import_parallelism_degree,
                    "is_cluster": migration_initial_load_settings_data_pump_parameters_is_cluster,
                    "table_exists_action": migration_initial_load_settings_data_pump_parameters_table_exists_action,
                },
                "export_directory_object": {
                    "name": migration_initial_load_settings_export_directory_object_name,
                    "path": migration_initial_load_settings_export_directory_object_path,
                },
                "handle_grant_errors": migration_initial_load_settings_handle_grant_errors,
                "import_directory_object": {
                    "name": migration_initial_load_settings_import_directory_object_name,
                    "path": migration_initial_load_settings_import_directory_object_path,
                },
                "is_consistent": migration_initial_load_settings_is_consistent,
                "is_ignore_existing_objects": migration_initial_load_settings_is_ignore_existing_objects,
                "is_tz_utc": migration_initial_load_settings_is_tz_utc,
                "metadata_remaps": [{
                    "new_value": migration_initial_load_settings_metadata_remaps_new_value,
                    "old_value": migration_initial_load_settings_metadata_remaps_old_value,
                    "type": migration_initial_load_settings_metadata_remaps_type,
                }],
                "primary_key_compatibility": migration_initial_load_settings_primary_key_compatibility,
                "tablespace_details": {
                    "target_type": migration_initial_load_settings_tablespace_details_target_type,
                    "block_size_in_kbs": migration_initial_load_settings_tablespace_details_block_size_in_kbs,
                    "extend_size_in_mbs": migration_initial_load_settings_tablespace_details_extend_size_in_mbs,
                    "is_auto_create": migration_initial_load_settings_tablespace_details_is_auto_create,
                    "is_big_file": migration_initial_load_settings_tablespace_details_is_big_file,
                    "remap_target": migration_initial_load_settings_tablespace_details_remap_target,
                },
            },
            source_container_database_connection_id=test_connection["id"])
        ```

        ## Import

        Migrations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseMigration/migration:Migration test_migration "id"
        ```

        :param str resource_name: The name of the resource.
        :param MigrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationAdvancedParameterArgs', 'MigrationAdvancedParameterArgsDict']]]]] = None,
                 advisor_settings: Optional[pulumi.Input[Union['MigrationAdvisorSettingsArgs', 'MigrationAdvisorSettingsArgsDict']]] = None,
                 bulk_include_exclude_data: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_transfer_medium_details: Optional[pulumi.Input[Union['MigrationDataTransferMediumDetailsArgs', 'MigrationDataTransferMediumDetailsArgsDict']]] = None,
                 database_combination: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationExcludeObjectArgs', 'MigrationExcludeObjectArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ggs_details: Optional[pulumi.Input[Union['MigrationGgsDetailsArgs', 'MigrationGgsDetailsArgsDict']]] = None,
                 hub_details: Optional[pulumi.Input[Union['MigrationHubDetailsArgs', 'MigrationHubDetailsArgsDict']]] = None,
                 include_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationIncludeObjectArgs', 'MigrationIncludeObjectArgsDict']]]]] = None,
                 initial_load_settings: Optional[pulumi.Input[Union['MigrationInitialLoadSettingsArgs', 'MigrationInitialLoadSettingsArgsDict']]] = None,
                 source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
                 source_database_connection_id: Optional[pulumi.Input[str]] = None,
                 target_database_connection_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationArgs.__new__(MigrationArgs)

            __props__.__dict__["advanced_parameters"] = advanced_parameters
            __props__.__dict__["advisor_settings"] = advisor_settings
            __props__.__dict__["bulk_include_exclude_data"] = bulk_include_exclude_data
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["data_transfer_medium_details"] = data_transfer_medium_details
            if database_combination is None and not opts.urn:
                raise TypeError("Missing required property 'database_combination'")
            __props__.__dict__["database_combination"] = database_combination
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["exclude_objects"] = exclude_objects
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["ggs_details"] = ggs_details
            __props__.__dict__["hub_details"] = hub_details
            __props__.__dict__["include_objects"] = include_objects
            __props__.__dict__["initial_load_settings"] = initial_load_settings
            __props__.__dict__["source_container_database_connection_id"] = source_container_database_connection_id
            if source_database_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_database_connection_id'")
            __props__.__dict__["source_database_connection_id"] = source_database_connection_id
            if target_database_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_database_connection_id'")
            __props__.__dict__["target_database_connection_id"] = target_database_connection_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["executing_job_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_migration"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["wait_after"] = None
        super(Migration, __self__).__init__(
            'oci:DatabaseMigration/migration:Migration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationAdvancedParameterArgs', 'MigrationAdvancedParameterArgsDict']]]]] = None,
            advisor_settings: Optional[pulumi.Input[Union['MigrationAdvisorSettingsArgs', 'MigrationAdvisorSettingsArgsDict']]] = None,
            bulk_include_exclude_data: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            data_transfer_medium_details: Optional[pulumi.Input[Union['MigrationDataTransferMediumDetailsArgs', 'MigrationDataTransferMediumDetailsArgsDict']]] = None,
            database_combination: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            exclude_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationExcludeObjectArgs', 'MigrationExcludeObjectArgsDict']]]]] = None,
            executing_job_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            ggs_details: Optional[pulumi.Input[Union['MigrationGgsDetailsArgs', 'MigrationGgsDetailsArgsDict']]] = None,
            hub_details: Optional[pulumi.Input[Union['MigrationHubDetailsArgs', 'MigrationHubDetailsArgsDict']]] = None,
            include_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationIncludeObjectArgs', 'MigrationIncludeObjectArgsDict']]]]] = None,
            initial_load_settings: Optional[pulumi.Input[Union['MigrationInitialLoadSettingsArgs', 'MigrationInitialLoadSettingsArgsDict']]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            source_container_database_connection_id: Optional[pulumi.Input[str]] = None,
            source_database_connection_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_database_connection_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_migration: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            wait_after: Optional[pulumi.Input[str]] = None) -> 'Migration':
        """
        Get an existing Migration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MigrationAdvancedParameterArgs', 'MigrationAdvancedParameterArgsDict']]]] advanced_parameters: (Updatable) List of Migration Parameter objects.
        :param pulumi.Input[Union['MigrationAdvisorSettingsArgs', 'MigrationAdvisorSettingsArgsDict']] advisor_settings: (Updatable) Optional Pre-Migration advisor settings.
        :param pulumi.Input[str] bulk_include_exclude_data: Specifies the database objects to be excluded from the migration in bulk. The definition accepts input in a CSV format, newline separated for each entry. More details can be found in the documentation.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[Union['MigrationDataTransferMediumDetailsArgs', 'MigrationDataTransferMediumDetailsArgsDict']] data_transfer_medium_details: (Updatable) Optional additional properties for data transfer.
        :param pulumi.Input[str] database_combination: (Updatable) The combination of source and target databases participating in a migration. Example: ORACLE means the migration is meant for migrating Oracle source and target databases.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MigrationExcludeObjectArgs', 'MigrationExcludeObjectArgsDict']]]] exclude_objects: Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        :param pulumi.Input[str] executing_job_id: The OCID of the resource being referenced.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[Union['MigrationGgsDetailsArgs', 'MigrationGgsDetailsArgsDict']] ggs_details: (Updatable) Optional settings for Oracle GoldenGate processes
        :param pulumi.Input[Union['MigrationHubDetailsArgs', 'MigrationHubDetailsArgsDict']] hub_details: (Updatable) Details about Oracle GoldenGate Microservices.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MigrationIncludeObjectArgs', 'MigrationIncludeObjectArgsDict']]]] include_objects: Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        :param pulumi.Input[Union['MigrationInitialLoadSettingsArgs', 'MigrationInitialLoadSettingsArgsDict']] initial_load_settings: (Updatable) Optional settings for Data Pump Export and Import jobs
        :param pulumi.Input[str] lifecycle_details: Additional status related to the execution and current state of the Migration.
        :param pulumi.Input[str] source_container_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] source_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] state: The current state of the Migration resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_database_connection_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[str] time_created: An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_last_migration: An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_updated: An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] type: (Updatable) The type of the migration to be performed. Example: ONLINE if no downtime is preferred for a migration. This method uses Oracle GoldenGate for replication.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] wait_after: You can optionally pause a migration after a job phase. This property allows you to optionally specify the phase after which you can pause the migration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MigrationState.__new__(_MigrationState)

        __props__.__dict__["advanced_parameters"] = advanced_parameters
        __props__.__dict__["advisor_settings"] = advisor_settings
        __props__.__dict__["bulk_include_exclude_data"] = bulk_include_exclude_data
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_transfer_medium_details"] = data_transfer_medium_details
        __props__.__dict__["database_combination"] = database_combination
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["exclude_objects"] = exclude_objects
        __props__.__dict__["executing_job_id"] = executing_job_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ggs_details"] = ggs_details
        __props__.__dict__["hub_details"] = hub_details
        __props__.__dict__["include_objects"] = include_objects
        __props__.__dict__["initial_load_settings"] = initial_load_settings
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["source_container_database_connection_id"] = source_container_database_connection_id
        __props__.__dict__["source_database_connection_id"] = source_database_connection_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_database_connection_id"] = target_database_connection_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_migration"] = time_last_migration
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["wait_after"] = wait_after
        return Migration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedParameters")
    def advanced_parameters(self) -> pulumi.Output[Sequence['outputs.MigrationAdvancedParameter']]:
        """
        (Updatable) List of Migration Parameter objects.
        """
        return pulumi.get(self, "advanced_parameters")

    @property
    @pulumi.getter(name="advisorSettings")
    def advisor_settings(self) -> pulumi.Output['outputs.MigrationAdvisorSettings']:
        """
        (Updatable) Optional Pre-Migration advisor settings.
        """
        return pulumi.get(self, "advisor_settings")

    @property
    @pulumi.getter(name="bulkIncludeExcludeData")
    def bulk_include_exclude_data(self) -> pulumi.Output[str]:
        """
        Specifies the database objects to be excluded from the migration in bulk. The definition accepts input in a CSV format, newline separated for each entry. More details can be found in the documentation.
        """
        return pulumi.get(self, "bulk_include_exclude_data")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataTransferMediumDetails")
    def data_transfer_medium_details(self) -> pulumi.Output['outputs.MigrationDataTransferMediumDetails']:
        """
        (Updatable) Optional additional properties for data transfer.
        """
        return pulumi.get(self, "data_transfer_medium_details")

    @property
    @pulumi.getter(name="databaseCombination")
    def database_combination(self) -> pulumi.Output[str]:
        """
        (Updatable) The combination of source and target databases participating in a migration. Example: ORACLE means the migration is meant for migrating Oracle source and target databases.
        """
        return pulumi.get(self, "database_combination")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> pulumi.Output[Sequence['outputs.MigrationExcludeObject']]:
        """
        Database objects to exclude from migration, cannot be specified alongside 'includeObjects'
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="executingJobId")
    def executing_job_id(self) -> pulumi.Output[str]:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "executing_job_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ggsDetails")
    def ggs_details(self) -> pulumi.Output['outputs.MigrationGgsDetails']:
        """
        (Updatable) Optional settings for Oracle GoldenGate processes
        """
        return pulumi.get(self, "ggs_details")

    @property
    @pulumi.getter(name="hubDetails")
    def hub_details(self) -> pulumi.Output['outputs.MigrationHubDetails']:
        """
        (Updatable) Details about Oracle GoldenGate Microservices.
        """
        return pulumi.get(self, "hub_details")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> pulumi.Output[Sequence['outputs.MigrationIncludeObject']]:
        """
        Database objects to include from migration, cannot be specified alongside 'excludeObjects'
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="initialLoadSettings")
    def initial_load_settings(self) -> pulumi.Output['outputs.MigrationInitialLoadSettings']:
        """
        (Updatable) Optional settings for Data Pump Export and Import jobs
        """
        return pulumi.get(self, "initial_load_settings")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional status related to the execution and current state of the Migration.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="sourceContainerDatabaseConnectionId")
    def source_container_database_connection_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "source_container_database_connection_id")

    @property
    @pulumi.getter(name="sourceDatabaseConnectionId")
    def source_database_connection_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "source_database_connection_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Migration resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetDatabaseConnectionId")
    def target_database_connection_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "target_database_connection_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastMigration")
    def time_last_migration(self) -> pulumi.Output[str]:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_migration")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of the migration to be performed. Example: ONLINE if no downtime is preferred for a migration. This method uses Oracle GoldenGate for replication.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="waitAfter")
    def wait_after(self) -> pulumi.Output[str]:
        """
        You can optionally pause a migration after a job phase. This property allows you to optionally specify the phase after which you can pause the migration.
        """
        return pulumi.get(self, "wait_after")

