# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApiKeysResult',
    'AwaitableGetApiKeysResult',
    'get_api_keys',
    'get_api_keys_output',
]

@pulumi.output_type
class GetApiKeysResult:
    """
    A collection of values returned by getApiKeys.
    """
    def __init__(__self__, api_keys=None, filters=None, id=None, user_id=None):
        if api_keys and not isinstance(api_keys, list):
            raise TypeError("Expected argument 'api_keys' to be a list")
        pulumi.set(__self__, "api_keys", api_keys)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="apiKeys")
    def api_keys(self) -> Sequence['outputs.GetApiKeysApiKeyResult']:
        """
        The list of api_keys.
        """
        return pulumi.get(self, "api_keys")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApiKeysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The OCID of the user the key belongs to.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetApiKeysResult(GetApiKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiKeysResult(
            api_keys=self.api_keys,
            filters=self.filters,
            id=self.id,
            user_id=self.user_id)


def get_api_keys(filters: Optional[Sequence[Union['GetApiKeysFilterArgs', 'GetApiKeysFilterArgsDict']]] = None,
                 user_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiKeysResult:
    """
    This data source provides the list of Api Keys in Oracle Cloud Infrastructure Identity service.

    Lists the API signing keys for the specified user. A user can have a maximum of three keys.

    Every user has permission to use this API call for *their own user ID*.  An administrator in your
    organization does not need to write a policy to give users this ability.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_keys = oci.Identity.get_api_keys(user_id=test_user["id"])
    ```


    :param str user_id: The OCID of the user.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getApiKeys:getApiKeys', __args__, opts=opts, typ=GetApiKeysResult).value

    return AwaitableGetApiKeysResult(
        api_keys=pulumi.get(__ret__, 'api_keys'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        user_id=pulumi.get(__ret__, 'user_id'))


@_utilities.lift_output_func(get_api_keys)
def get_api_keys_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetApiKeysFilterArgs', 'GetApiKeysFilterArgsDict']]]]] = None,
                        user_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApiKeysResult]:
    """
    This data source provides the list of Api Keys in Oracle Cloud Infrastructure Identity service.

    Lists the API signing keys for the specified user. A user can have a maximum of three keys.

    Every user has permission to use this API call for *their own user ID*.  An administrator in your
    organization does not need to write a policy to give users this ability.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_keys = oci.Identity.get_api_keys(user_id=test_user["id"])
    ```


    :param str user_id: The OCID of the user.
    """
    ...
