# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ManagementAgentDataSourceList',
    'ManagementAgentDataSourceListMetricDimension',
    'ManagementAgentDataSourceMetricDimension',
    'ManagementAgentDataSourceSummaryList',
    'ManagementAgentManagementAgentProperty',
    'ManagementAgentPluginList',
    'GetManagementAgentAvailableHistoriesAvailabilityHistoryResult',
    'GetManagementAgentAvailableHistoriesFilterResult',
    'GetManagementAgentCountItemResult',
    'GetManagementAgentCountItemDimensionResult',
    'GetManagementAgentDataSourceListResult',
    'GetManagementAgentDataSourceListMetricDimensionResult',
    'GetManagementAgentDataSourceMetricDimensionResult',
    'GetManagementAgentDataSourceSummaryListResult',
    'GetManagementAgentDataSourcesDataSourceResult',
    'GetManagementAgentDataSourcesFilterResult',
    'GetManagementAgentImagesFilterResult',
    'GetManagementAgentImagesManagementAgentImageResult',
    'GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailResult',
    'GetManagementAgentInstallKeysFilterResult',
    'GetManagementAgentInstallKeysManagementAgentInstallKeyResult',
    'GetManagementAgentManagementAgentPropertyResult',
    'GetManagementAgentPluginCountItemResult',
    'GetManagementAgentPluginCountItemDimensionResult',
    'GetManagementAgentPluginListResult',
    'GetManagementAgentPluginsFilterResult',
    'GetManagementAgentPluginsManagementAgentPluginResult',
    'GetManagementAgentsFilterResult',
    'GetManagementAgentsManagementAgentResult',
    'GetManagementAgentsManagementAgentDataSourceListResult',
    'GetManagementAgentsManagementAgentDataSourceListMetricDimensionResult',
    'GetManagementAgentsManagementAgentDataSourceSummaryListResult',
    'GetManagementAgentsManagementAgentManagementAgentPropertyResult',
    'GetManagementAgentsManagementAgentPluginListResult',
]

@pulumi.output_type
class ManagementAgentDataSourceList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMetrics":
            suggest = "allow_metrics"
        elif key == "compartmentId":
            suggest = "compartment_id"
        elif key == "connectionTimeout":
            suggest = "connection_timeout"
        elif key == "isDaemonSet":
            suggest = "is_daemon_set"
        elif key == "metricDimensions":
            suggest = "metric_dimensions"
        elif key == "proxyUrl":
            suggest = "proxy_url"
        elif key == "readDataLimit":
            suggest = "read_data_limit"
        elif key == "readTimeout":
            suggest = "read_timeout"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "scheduleMins":
            suggest = "schedule_mins"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementAgentDataSourceList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementAgentDataSourceList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementAgentDataSourceList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_metrics: Optional[str] = None,
                 compartment_id: Optional[str] = None,
                 connection_timeout: Optional[int] = None,
                 is_daemon_set: Optional[bool] = None,
                 key: Optional[str] = None,
                 metric_dimensions: Optional[Sequence['outputs.ManagementAgentDataSourceListMetricDimension']] = None,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 proxy_url: Optional[str] = None,
                 read_data_limit: Optional[int] = None,
                 read_timeout: Optional[int] = None,
                 resource_group: Optional[str] = None,
                 schedule_mins: Optional[int] = None,
                 state: Optional[str] = None,
                 time_created: Optional[str] = None,
                 time_updated: Optional[str] = None,
                 type: Optional[str] = None,
                 url: Optional[str] = None):
        """
        :param str name: Name of the property
        :param int read_data_limit: Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param int read_timeout: Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        :param str resource_group: Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        :param int schedule_mins: Number in minutes. The scraping occurs at the specified interval.
        :param str state: The current state of managementAgent
        :param str time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param str type: The type of the DataSource.
        :param str url: The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        if allow_metrics is not None:
            pulumi.set(__self__, "allow_metrics", allow_metrics)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if is_daemon_set is not None:
            pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if proxy_url is not None:
            pulumi.set(__self__, "proxy_url", proxy_url)
        if read_data_limit is not None:
            pulumi.set(__self__, "read_data_limit", read_data_limit)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if schedule_mins is not None:
            pulumi.set(__self__, "schedule_mins", schedule_mins)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> Optional[str]:
        return pulumi.get(self, "allow_metrics")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[int]:
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> Optional[bool]:
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[Sequence['outputs.ManagementAgentDataSourceListMetricDimension']]:
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> Optional[str]:
        return pulumi.get(self, "proxy_url")

    @property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> Optional[int]:
        """
        Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[int]:
        """
        Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> Optional[int]:
        """
        Number in minutes. The scraping occurs at the specified interval.
        """
        return pulumi.get(self, "schedule_mins")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[str]:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ManagementAgentDataSourceListMetricDimension(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: Name of the property
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ManagementAgentDataSourceMetricDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: (Updatable) Name of the metric dimension
        :param str value: (Updatable) Value of the metric dimension
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Name of the metric dimension
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        (Updatable) Value of the metric dimension
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ManagementAgentDataSourceSummaryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDaemonSet":
            suggest = "is_daemon_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementAgentDataSourceSummaryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementAgentDataSourceSummaryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementAgentDataSourceSummaryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_daemon_set: Optional[bool] = None,
                 key: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: Name of the property
        :param str type: The type of the DataSource.
        """
        if is_daemon_set is not None:
            pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> Optional[bool]:
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagementAgentManagementAgentProperty(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 units: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str name: Name of the property
        :param str units: Unit for the property
        :param Sequence[str] values: Values of the property
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if units is not None:
            pulumi.set(__self__, "units", units)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def units(self) -> Optional[str]:
        """
        Unit for the property
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        Values of the property
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ManagementAgentPluginList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "pluginDisplayName":
            suggest = "plugin_display_name"
        elif key == "pluginId":
            suggest = "plugin_id"
        elif key == "pluginName":
            suggest = "plugin_name"
        elif key == "pluginStatus":
            suggest = "plugin_status"
        elif key == "pluginStatusMessage":
            suggest = "plugin_status_message"
        elif key == "pluginVersion":
            suggest = "plugin_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementAgentPluginList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementAgentPluginList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementAgentPluginList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None,
                 plugin_display_name: Optional[str] = None,
                 plugin_id: Optional[str] = None,
                 plugin_name: Optional[str] = None,
                 plugin_status: Optional[str] = None,
                 plugin_status_message: Optional[str] = None,
                 plugin_version: Optional[str] = None):
        """
        :param bool is_enabled: flag indicating whether the plugin is in enabled mode or disabled mode.
        :param str plugin_display_name: Management Agent Plugin Identifier, can be renamed
        :param str plugin_id: Plugin Id
        :param str plugin_name: Management Agent Plugin Name
        :param str plugin_status: Plugin Status
        :param str plugin_status_message: Status message of the Plugin
        :param str plugin_version: Plugin Version
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if plugin_display_name is not None:
            pulumi.set(__self__, "plugin_display_name", plugin_display_name)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if plugin_name is not None:
            pulumi.set(__self__, "plugin_name", plugin_name)
        if plugin_status is not None:
            pulumi.set(__self__, "plugin_status", plugin_status)
        if plugin_status_message is not None:
            pulumi.set(__self__, "plugin_status_message", plugin_status_message)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        flag indicating whether the plugin is in enabled mode or disabled mode.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="pluginDisplayName")
    def plugin_display_name(self) -> Optional[str]:
        """
        Management Agent Plugin Identifier, can be renamed
        """
        return pulumi.get(self, "plugin_display_name")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[str]:
        """
        Plugin Id
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> Optional[str]:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter(name="pluginStatus")
    def plugin_status(self) -> Optional[str]:
        """
        Plugin Status
        """
        return pulumi.get(self, "plugin_status")

    @property
    @pulumi.getter(name="pluginStatusMessage")
    def plugin_status_message(self) -> Optional[str]:
        """
        Status message of the Plugin
        """
        return pulumi.get(self, "plugin_status_message")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[str]:
        """
        Plugin Version
        """
        return pulumi.get(self, "plugin_version")


@pulumi.output_type
class GetManagementAgentAvailableHistoriesAvailabilityHistoryResult(dict):
    def __init__(__self__, *,
                 availability_status: str,
                 management_agent_id: str,
                 time_availability_status_ended: str,
                 time_availability_status_started: str):
        """
        :param str availability_status: The availability status of managementAgent
        :param str management_agent_id: Unique Management Agent identifier
        :param str time_availability_status_ended: The time till which the Management Agent was known to be in the availability status. An RFC3339 formatted datetime string
        :param str time_availability_status_started: The time at which the Management Agent moved to the availability status. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "availability_status", availability_status)
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        pulumi.set(__self__, "time_availability_status_ended", time_availability_status_ended)
        pulumi.set(__self__, "time_availability_status_started", time_availability_status_started)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> str:
        """
        The availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> str:
        """
        Unique Management Agent identifier
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter(name="timeAvailabilityStatusEnded")
    def time_availability_status_ended(self) -> str:
        """
        The time till which the Management Agent was known to be in the availability status. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_availability_status_ended")

    @property
    @pulumi.getter(name="timeAvailabilityStatusStarted")
    def time_availability_status_started(self) -> str:
        """
        The time at which the Management Agent moved to the availability status. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_availability_status_started")


@pulumi.output_type
class GetManagementAgentAvailableHistoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentCountItemResult(dict):
    def __init__(__self__, *,
                 count: int,
                 dimensions: Sequence['outputs.GetManagementAgentCountItemDimensionResult']):
        """
        :param int count: The number of Management Agents in this group
        :param Sequence['GetManagementAgentCountItemDimensionArgs'] dimensions: The Aggregation of Management Agent Dimensions
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of Management Agents in this group
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetManagementAgentCountItemDimensionResult']:
        """
        The Aggregation of Management Agent Dimensions
        """
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class GetManagementAgentCountItemDimensionResult(dict):
    def __init__(__self__, *,
                 availability_status: str,
                 has_plugins: bool,
                 install_type: str,
                 platform_type: str,
                 version: str):
        """
        :param str availability_status: The availability status of managementAgent
        :param bool has_plugins: When set to true then agents that have at least one plugin deployed will be returned. When set to false only agents that have no plugins deployed will be returned.
        :param str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
        :param str platform_type: Platform Type
        :param str version: Agent image version
        """
        pulumi.set(__self__, "availability_status", availability_status)
        pulumi.set(__self__, "has_plugins", has_plugins)
        pulumi.set(__self__, "install_type", install_type)
        pulumi.set(__self__, "platform_type", platform_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> str:
        """
        The availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="hasPlugins")
    def has_plugins(self) -> bool:
        """
        When set to true then agents that have at least one plugin deployed will be returned. When set to false only agents that have no plugins deployed will be returned.
        """
        return pulumi.get(self, "has_plugins")

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> str:
        """
        A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
        """
        return pulumi.get(self, "install_type")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> str:
        """
        Platform Type
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Agent image version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagementAgentDataSourceListResult(dict):
    def __init__(__self__, *,
                 allow_metrics: str,
                 compartment_id: str,
                 connection_timeout: int,
                 is_daemon_set: bool,
                 key: str,
                 metric_dimensions: Sequence['outputs.GetManagementAgentDataSourceListMetricDimensionResult'],
                 name: str,
                 namespace: str,
                 proxy_url: str,
                 read_data_limit: int,
                 read_timeout: int,
                 resource_group: str,
                 schedule_mins: int,
                 state: str,
                 time_created: str,
                 time_updated: str,
                 type: str,
                 url: str):
        """
        :param str allow_metrics: Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        :param str compartment_id: Compartment owning this DataSource.
        :param int connection_timeout: Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        :param bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param Sequence['GetManagementAgentDataSourceListMetricDimensionArgs'] metric_dimensions: The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        :param str name: Name of the property
        :param str namespace: The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        :param str proxy_url: The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        :param int read_data_limit: Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param int read_timeout: Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        :param str resource_group: Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        :param int schedule_mins: Number in minutes. The scraping occurs at the specified interval.
        :param str state: The current state of managementAgent
        :param str time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param str type: The type of the DataSource.
        :param str url: The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        pulumi.set(__self__, "allow_metrics", allow_metrics)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connection_timeout", connection_timeout)
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "proxy_url", proxy_url)
        pulumi.set(__self__, "read_data_limit", read_data_limit)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "schedule_mins", schedule_mins)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> str:
        """
        Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        """
        return pulumi.get(self, "allow_metrics")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> int:
        """
        Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Sequence['outputs.GetManagementAgentDataSourceListMetricDimensionResult']:
        """
        The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        """
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> str:
        """
        The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        """
        return pulumi.get(self, "proxy_url")

    @property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> int:
        """
        Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> int:
        """
        Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> int:
        """
        Number in minutes. The scraping occurs at the specified interval.
        """
        return pulumi.get(self, "schedule_mins")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetManagementAgentDataSourceListMetricDimensionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the property
        :param str value: Value of the metric dimension
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the metric dimension
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetManagementAgentDataSourceMetricDimensionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Unique name of the DataSource.
        :param str value: Value of the metric dimension
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name of the DataSource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the metric dimension
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetManagementAgentDataSourceSummaryListResult(dict):
    def __init__(__self__, *,
                 is_daemon_set: bool,
                 key: str,
                 name: str,
                 type: str):
        """
        :param bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param str name: Name of the property
        :param str type: The type of the DataSource.
        """
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetManagementAgentDataSourcesDataSourceResult(dict):
    def __init__(__self__, *,
                 data_source_key: str,
                 type: str,
                 name: Optional[str] = None):
        """
        :param str data_source_key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param str type: The type of the DataSource.
        :param str name: Unique name of the dataSource.
        """
        pulumi.set(__self__, "data_source_key", data_source_key)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataSourceKey")
    def data_source_key(self) -> str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "data_source_key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Unique name of the dataSource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetManagementAgentDataSourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Unique name of the dataSource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name of the dataSource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentImagesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire platform name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire platform name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentImagesManagementAgentImageResult(dict):
    def __init__(__self__, *,
                 checksum: str,
                 id: str,
                 image_object_storage_details: Sequence['outputs.GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailResult'],
                 object_url: str,
                 package_architecture_type: str,
                 package_type: str,
                 platform_name: str,
                 platform_type: str,
                 size: float,
                 state: str,
                 version: str):
        """
        :param str checksum: Object content SHA256 Hash
        :param str id: Agent image resource id
        :param Sequence['GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailArgs'] image_object_storage_details: Details of the Objectstorage object
        :param str object_url: Object storage URL for download
        :param str package_architecture_type: The installation package target architecture type
        :param str package_type: The installation package type
        :param str platform_name: Agent image platform display name
        :param str platform_type: Agent image platform type
        :param float size: Agent image size in bytes
        :param str state: Filter to return only Management Agents in the particular lifecycle state.
        :param str version: Agent image version
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_object_storage_details", image_object_storage_details)
        pulumi.set(__self__, "object_url", object_url)
        pulumi.set(__self__, "package_architecture_type", package_architecture_type)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "platform_name", platform_name)
        pulumi.set(__self__, "platform_type", platform_type)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Object content SHA256 Hash
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Agent image resource id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageObjectStorageDetails")
    def image_object_storage_details(self) -> Sequence['outputs.GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailResult']:
        """
        Details of the Objectstorage object
        """
        return pulumi.get(self, "image_object_storage_details")

    @property
    @pulumi.getter(name="objectUrl")
    def object_url(self) -> str:
        """
        Object storage URL for download
        """
        return pulumi.get(self, "object_url")

    @property
    @pulumi.getter(name="packageArchitectureType")
    def package_architecture_type(self) -> str:
        """
        The installation package target architecture type
        """
        return pulumi.get(self, "package_architecture_type")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The installation package type
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> str:
        """
        Agent image platform display name
        """
        return pulumi.get(self, "platform_name")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> str:
        """
        Agent image platform type
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter
    def size(self) -> float:
        """
        Agent image size in bytes
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Agent image version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagementAgentImagesManagementAgentImageImageObjectStorageDetailResult(dict):
    def __init__(__self__, *,
                 checksum: str,
                 object: str,
                 object_bucket: str,
                 object_namespace: str,
                 object_url: str):
        """
        :param str checksum: Object content SHA256 Hash
        :param str object: Objectstorage object name reference providing the original location of this object
        :param str object_bucket: Objectstorage bucket reference providing the original location of this object
        :param str object_namespace: Objectstorage namespace reference providing the original location of this object
        :param str object_url: Object storage URL for download
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "object_bucket", object_bucket)
        pulumi.set(__self__, "object_namespace", object_namespace)
        pulumi.set(__self__, "object_url", object_url)

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Object content SHA256 Hash
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Objectstorage object name reference providing the original location of this object
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="objectBucket")
    def object_bucket(self) -> str:
        """
        Objectstorage bucket reference providing the original location of this object
        """
        return pulumi.get(self, "object_bucket")

    @property
    @pulumi.getter(name="objectNamespace")
    def object_namespace(self) -> str:
        """
        Objectstorage namespace reference providing the original location of this object
        """
        return pulumi.get(self, "object_namespace")

    @property
    @pulumi.getter(name="objectUrl")
    def object_url(self) -> str:
        """
        Object storage URL for download
        """
        return pulumi.get(self, "object_url")


@pulumi.output_type
class GetManagementAgentInstallKeysFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentInstallKeysManagementAgentInstallKeyResult(dict):
    def __init__(__self__, *,
                 allowed_key_install_count: int,
                 compartment_id: str,
                 created_by_principal_id: str,
                 current_key_install_count: int,
                 display_name: str,
                 id: str,
                 is_unlimited: bool,
                 key: str,
                 lifecycle_details: str,
                 state: str,
                 time_created: str,
                 time_expires: str,
                 time_updated: str):
        """
        :param int allowed_key_install_count: Total number of install for this keys
        :param str compartment_id: The OCID of the compartment to which a request will be scoped.
        :param str created_by_principal_id: Principal id of user who created the Agent Install key
        :param int current_key_install_count: Total number of install for this keys
        :param str display_name: The display name for which the Key needs to be listed.
        :param str id: Agent install Key identifier
        :param bool is_unlimited: If set to true, the install key has no expiration date or usage limit. Properties allowedKeyInstallCount and timeExpires are ignored if set to true. Defaults to false.
        :param str key: Management Agent Install Key
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str state: Filter to return only Management Agents in the particular lifecycle state.
        :param str time_created: The time when Management Agent install Key was created. An RFC3339 formatted date time string
        :param str time_expires: date after which key would expire after creation
        :param str time_updated: The time when Management Agent install Key was updated. An RFC3339 formatted date time string
        """
        pulumi.set(__self__, "allowed_key_install_count", allowed_key_install_count)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by_principal_id", created_by_principal_id)
        pulumi.set(__self__, "current_key_install_count", current_key_install_count)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_unlimited", is_unlimited)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_expires", time_expires)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="allowedKeyInstallCount")
    def allowed_key_install_count(self) -> int:
        """
        Total number of install for this keys
        """
        return pulumi.get(self, "allowed_key_install_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment to which a request will be scoped.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdByPrincipalId")
    def created_by_principal_id(self) -> str:
        """
        Principal id of user who created the Agent Install key
        """
        return pulumi.get(self, "created_by_principal_id")

    @property
    @pulumi.getter(name="currentKeyInstallCount")
    def current_key_install_count(self) -> int:
        """
        Total number of install for this keys
        """
        return pulumi.get(self, "current_key_install_count")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name for which the Key needs to be listed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Agent install Key identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> bool:
        """
        If set to true, the install key has no expiration date or usage limit. Properties allowedKeyInstallCount and timeExpires are ignored if set to true. Defaults to false.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Management Agent Install Key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when Management Agent install Key was created. An RFC3339 formatted date time string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> str:
        """
        date after which key would expire after creation
        """
        return pulumi.get(self, "time_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when Management Agent install Key was updated. An RFC3339 formatted date time string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetManagementAgentManagementAgentPropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 units: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the property
        :param str units: Unit for the property
        :param Sequence[str] values: Values of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "units", units)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        Unit for the property
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Values of the property
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetManagementAgentPluginCountItemResult(dict):
    def __init__(__self__, *,
                 count: int,
                 dimensions: Sequence['outputs.GetManagementAgentPluginCountItemDimensionResult']):
        """
        :param int count: The number of Management Agent Plugins in this group
        :param Sequence['GetManagementAgentPluginCountItemDimensionArgs'] dimensions: The Aggregation of Management Agent Plugin Dimensions
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of Management Agent Plugins in this group
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetManagementAgentPluginCountItemDimensionResult']:
        """
        The Aggregation of Management Agent Plugin Dimensions
        """
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class GetManagementAgentPluginCountItemDimensionResult(dict):
    def __init__(__self__, *,
                 plugin_display_name: str,
                 plugin_name: str):
        """
        :param str plugin_display_name: Management Agent Plugin Display Name
        :param str plugin_name: Management Agent Plugin Name
        """
        pulumi.set(__self__, "plugin_display_name", plugin_display_name)
        pulumi.set(__self__, "plugin_name", plugin_name)

    @property
    @pulumi.getter(name="pluginDisplayName")
    def plugin_display_name(self) -> str:
        """
        Management Agent Plugin Display Name
        """
        return pulumi.get(self, "plugin_display_name")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> str:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "plugin_name")


@pulumi.output_type
class GetManagementAgentPluginListResult(dict):
    def __init__(__self__, *,
                 is_enabled: bool,
                 plugin_display_name: str,
                 plugin_id: str,
                 plugin_name: str,
                 plugin_status: str,
                 plugin_status_message: str,
                 plugin_version: str):
        """
        :param bool is_enabled: flag indicating whether the plugin is in enabled mode or disabled mode.
        :param str plugin_display_name: Management Agent Plugin Identifier, can be renamed
        :param str plugin_id: Plugin Id
        :param str plugin_name: Management Agent Plugin Name
        :param str plugin_status: Plugin Status
        :param str plugin_status_message: Status message of the Plugin
        :param str plugin_version: Plugin Version
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "plugin_display_name", plugin_display_name)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "plugin_status", plugin_status)
        pulumi.set(__self__, "plugin_status_message", plugin_status_message)
        pulumi.set(__self__, "plugin_version", plugin_version)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        flag indicating whether the plugin is in enabled mode or disabled mode.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="pluginDisplayName")
    def plugin_display_name(self) -> str:
        """
        Management Agent Plugin Identifier, can be renamed
        """
        return pulumi.get(self, "plugin_display_name")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> str:
        """
        Plugin Id
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> str:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter(name="pluginStatus")
    def plugin_status(self) -> str:
        """
        Plugin Status
        """
        return pulumi.get(self, "plugin_status")

    @property
    @pulumi.getter(name="pluginStatusMessage")
    def plugin_status_message(self) -> str:
        """
        Status message of the Plugin
        """
        return pulumi.get(self, "plugin_status_message")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> str:
        """
        Plugin Version
        """
        return pulumi.get(self, "plugin_version")


@pulumi.output_type
class GetManagementAgentPluginsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Management Agent Plugin Name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentPluginsManagementAgentPluginResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 id: str,
                 is_console_deployable: bool,
                 name: str,
                 state: str,
                 supported_platform_types: Sequence[str],
                 version: int):
        """
        :param str description: Management Agent Plugin description
        :param str display_name: Filter to return only Management Agent Plugins having the particular display name.
        :param str id: Management Agent Plugin Id
        :param bool is_console_deployable: A flag to indicate whether a given plugin can be deployed from Agent Console UI or not.
        :param str name: Management Agent Plugin Name
        :param str state: Filter to return only Management Agents in the particular lifecycle state.
        :param Sequence[str] supported_platform_types: Supported Platform Types
        :param int version: Management Agent Plugin Version
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_console_deployable", is_console_deployable)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "supported_platform_types", supported_platform_types)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Management Agent Plugin description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Filter to return only Management Agent Plugins having the particular display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Management Agent Plugin Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isConsoleDeployable")
    def is_console_deployable(self) -> bool:
        """
        A flag to indicate whether a given plugin can be deployed from Agent Console UI or not.
        """
        return pulumi.get(self, "is_console_deployable")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportedPlatformTypes")
    def supported_platform_types(self) -> Sequence[str]:
        """
        Supported Platform Types
        """
        return pulumi.get(self, "supported_platform_types")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        Management Agent Plugin Version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagementAgentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the property
        :param Sequence[str] values: Values of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Values of the property
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetManagementAgentsManagementAgentResult(dict):
    def __init__(__self__, *,
                 availability_status: str,
                 compartment_id: str,
                 data_source_lists: Sequence['outputs.GetManagementAgentsManagementAgentDataSourceListResult'],
                 data_source_summary_lists: Sequence['outputs.GetManagementAgentsManagementAgentDataSourceSummaryListResult'],
                 defined_tags: Mapping[str, Any],
                 deploy_plugins_ids: Sequence[str],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 host: str,
                 host_id: str,
                 id: str,
                 install_key_id: str,
                 install_path: str,
                 install_type: str,
                 is_agent_auto_upgradable: bool,
                 is_customer_deployed: bool,
                 lifecycle_details: str,
                 managed_agent_id: str,
                 management_agent_properties: Sequence['outputs.GetManagementAgentsManagementAgentManagementAgentPropertyResult'],
                 platform_name: str,
                 platform_type: str,
                 platform_version: str,
                 plugin_lists: Sequence['outputs.GetManagementAgentsManagementAgentPluginListResult'],
                 resource_artifact_version: str,
                 state: str,
                 time_created: str,
                 time_last_heartbeat: str,
                 time_updated: str,
                 version: str):
        """
        :param str availability_status: Filter to return only Management Agents in the particular availability status.
        :param str compartment_id: The OCID of the compartment to which a request will be scoped.
        :param Sequence['GetManagementAgentsManagementAgentDataSourceSummaryListArgs'] data_source_summary_lists: list of dataSources associated with the agent
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: Filter to return only Management Agents having the particular display name.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str host: Management Agent host machine name
        :param str host_id: Filter to return only Management Agents having the particular agent host id.
        :param str id: agent identifier
        :param str install_key_id: agent install key identifier
        :param str install_path: Path where Management Agent is installed
        :param str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
        :param bool is_agent_auto_upgradable: true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        :param bool is_customer_deployed: true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetManagementAgentsManagementAgentManagementAgentPropertyArgs'] management_agent_properties: Additional properties for this Management Agent
        :param str platform_name: Platform Name
        :param str platform_type: Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
        :param str platform_version: Platform Version
        :param Sequence['GetManagementAgentsManagementAgentPluginListArgs'] plugin_lists: list of managementAgentPlugins associated with the agent
        :param str resource_artifact_version: Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        :param str state: Filter to return only Management Agents in the particular lifecycle state.
        :param str time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param str time_last_heartbeat: The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        :param str time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param str version: Array of versions to return only Management Agents having the particular agent versions. Example: ["202020.0101","210201.0513"]
        """
        pulumi.set(__self__, "availability_status", availability_status)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_source_lists", data_source_lists)
        pulumi.set(__self__, "data_source_summary_lists", data_source_summary_lists)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "deploy_plugins_ids", deploy_plugins_ids)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "host_id", host_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "install_key_id", install_key_id)
        pulumi.set(__self__, "install_path", install_path)
        pulumi.set(__self__, "install_type", install_type)
        pulumi.set(__self__, "is_agent_auto_upgradable", is_agent_auto_upgradable)
        pulumi.set(__self__, "is_customer_deployed", is_customer_deployed)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "managed_agent_id", managed_agent_id)
        pulumi.set(__self__, "management_agent_properties", management_agent_properties)
        pulumi.set(__self__, "platform_name", platform_name)
        pulumi.set(__self__, "platform_type", platform_type)
        pulumi.set(__self__, "platform_version", platform_version)
        pulumi.set(__self__, "plugin_lists", plugin_lists)
        pulumi.set(__self__, "resource_artifact_version", resource_artifact_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_heartbeat", time_last_heartbeat)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> str:
        """
        Filter to return only Management Agents in the particular availability status.
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment to which a request will be scoped.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSourceLists")
    def data_source_lists(self) -> Sequence['outputs.GetManagementAgentsManagementAgentDataSourceListResult']:
        return pulumi.get(self, "data_source_lists")

    @property
    @pulumi.getter(name="dataSourceSummaryLists")
    def data_source_summary_lists(self) -> Sequence['outputs.GetManagementAgentsManagementAgentDataSourceSummaryListResult']:
        """
        list of dataSources associated with the agent
        """
        return pulumi.get(self, "data_source_summary_lists")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deployPluginsIds")
    def deploy_plugins_ids(self) -> Sequence[str]:
        return pulumi.get(self, "deploy_plugins_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Filter to return only Management Agents having the particular display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Management Agent host machine name
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> str:
        """
        Filter to return only Management Agents having the particular agent host id.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        agent identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installKeyId")
    def install_key_id(self) -> str:
        """
        agent install key identifier
        """
        return pulumi.get(self, "install_key_id")

    @property
    @pulumi.getter(name="installPath")
    def install_path(self) -> str:
        """
        Path where Management Agent is installed
        """
        return pulumi.get(self, "install_path")

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> str:
        """
        A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
        """
        return pulumi.get(self, "install_type")

    @property
    @pulumi.getter(name="isAgentAutoUpgradable")
    def is_agent_auto_upgradable(self) -> bool:
        """
        true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        """
        return pulumi.get(self, "is_agent_auto_upgradable")

    @property
    @pulumi.getter(name="isCustomerDeployed")
    def is_customer_deployed(self) -> bool:
        """
        true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        """
        return pulumi.get(self, "is_customer_deployed")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managedAgentId")
    def managed_agent_id(self) -> str:
        return pulumi.get(self, "managed_agent_id")

    @property
    @pulumi.getter(name="managementAgentProperties")
    def management_agent_properties(self) -> Sequence['outputs.GetManagementAgentsManagementAgentManagementAgentPropertyResult']:
        """
        Additional properties for this Management Agent
        """
        return pulumi.get(self, "management_agent_properties")

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> str:
        """
        Platform Name
        """
        return pulumi.get(self, "platform_name")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> str:
        """
        Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> str:
        """
        Platform Version
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> Sequence['outputs.GetManagementAgentsManagementAgentPluginListResult']:
        """
        list of managementAgentPlugins associated with the agent
        """
        return pulumi.get(self, "plugin_lists")

    @property
    @pulumi.getter(name="resourceArtifactVersion")
    def resource_artifact_version(self) -> str:
        """
        Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        """
        return pulumi.get(self, "resource_artifact_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastHeartbeat")
    def time_last_heartbeat(self) -> str:
        """
        The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_heartbeat")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Array of versions to return only Management Agents having the particular agent versions. Example: ["202020.0101","210201.0513"]
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetManagementAgentsManagementAgentDataSourceListResult(dict):
    def __init__(__self__, *,
                 allow_metrics: str,
                 compartment_id: str,
                 connection_timeout: int,
                 is_daemon_set: bool,
                 key: str,
                 metric_dimensions: Sequence['outputs.GetManagementAgentsManagementAgentDataSourceListMetricDimensionResult'],
                 name: str,
                 namespace: str,
                 proxy_url: str,
                 read_data_limit: int,
                 read_timeout: int,
                 resource_group: str,
                 schedule_mins: int,
                 state: str,
                 time_created: str,
                 time_updated: str,
                 type: str,
                 url: str):
        """
        :param str compartment_id: The OCID of the compartment to which a request will be scoped.
        :param bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param str name: Name of the property
        :param str state: Filter to return only Management Agents in the particular lifecycle state.
        :param str time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param str type: The type of the DataSource.
        """
        pulumi.set(__self__, "allow_metrics", allow_metrics)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connection_timeout", connection_timeout)
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "proxy_url", proxy_url)
        pulumi.set(__self__, "read_data_limit", read_data_limit)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "schedule_mins", schedule_mins)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> str:
        return pulumi.get(self, "allow_metrics")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment to which a request will be scoped.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> int:
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Sequence['outputs.GetManagementAgentsManagementAgentDataSourceListMetricDimensionResult']:
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> str:
        return pulumi.get(self, "proxy_url")

    @property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> int:
        return pulumi.get(self, "read_data_limit")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> int:
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> int:
        return pulumi.get(self, "schedule_mins")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Filter to return only Management Agents in the particular lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")


@pulumi.output_type
class GetManagementAgentsManagementAgentDataSourceListMetricDimensionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetManagementAgentsManagementAgentDataSourceSummaryListResult(dict):
    def __init__(__self__, *,
                 is_daemon_set: bool,
                 key: str,
                 name: str,
                 type: str):
        """
        :param bool is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param str key: Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        :param str name: Name of the property
        :param str type: The type of the DataSource.
        """
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetManagementAgentsManagementAgentManagementAgentPropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 units: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the property
        :param str units: Unit for the property
        :param Sequence[str] values: Values of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "units", units)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        Unit for the property
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Values of the property
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetManagementAgentsManagementAgentPluginListResult(dict):
    def __init__(__self__, *,
                 is_enabled: bool,
                 plugin_display_name: str,
                 plugin_id: str,
                 plugin_name: str,
                 plugin_status: str,
                 plugin_status_message: str,
                 plugin_version: str):
        """
        :param bool is_enabled: flag indicating whether the plugin is in enabled mode or disabled mode.
        :param str plugin_display_name: Management Agent Plugin Identifier, can be renamed
        :param str plugin_id: Plugin Id
        :param str plugin_name: Array of pluginName to return only Management Agents having the particular Plugins installed. A special pluginName of 'None' can be provided and this will return only Management Agents having no plugin installed. Example: ["PluginA"]
        :param str plugin_status: Plugin Status
        :param str plugin_status_message: Status message of the Plugin
        :param str plugin_version: Plugin Version
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "plugin_display_name", plugin_display_name)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "plugin_status", plugin_status)
        pulumi.set(__self__, "plugin_status_message", plugin_status_message)
        pulumi.set(__self__, "plugin_version", plugin_version)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        flag indicating whether the plugin is in enabled mode or disabled mode.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="pluginDisplayName")
    def plugin_display_name(self) -> str:
        """
        Management Agent Plugin Identifier, can be renamed
        """
        return pulumi.get(self, "plugin_display_name")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> str:
        """
        Plugin Id
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> str:
        """
        Array of pluginName to return only Management Agents having the particular Plugins installed. A special pluginName of 'None' can be provided and this will return only Management Agents having no plugin installed. Example: ["PluginA"]
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter(name="pluginStatus")
    def plugin_status(self) -> str:
        """
        Plugin Status
        """
        return pulumi.get(self, "plugin_status")

    @property
    @pulumi.getter(name="pluginStatusMessage")
    def plugin_status_message(self) -> str:
        """
        Status message of the Plugin
        """
        return pulumi.get(self, "plugin_status_message")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> str:
        """
        Plugin Version
        """
        return pulumi.get(self, "plugin_version")


