# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 data_node_count: pulumi.Input[int],
                 data_node_host_memory_gb: pulumi.Input[int],
                 data_node_host_ocpu_count: pulumi.Input[int],
                 data_node_host_type: pulumi.Input[str],
                 data_node_storage_gb: pulumi.Input[int],
                 display_name: pulumi.Input[str],
                 master_node_count: pulumi.Input[int],
                 master_node_host_memory_gb: pulumi.Input[int],
                 master_node_host_ocpu_count: pulumi.Input[int],
                 master_node_host_type: pulumi.Input[str],
                 opendashboard_node_count: pulumi.Input[int],
                 opendashboard_node_host_memory_gb: pulumi.Input[int],
                 opendashboard_node_host_ocpu_count: pulumi.Input[int],
                 software_version: pulumi.Input[str],
                 subnet_compartment_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vcn_compartment_id: pulumi.Input[str],
                 vcn_id: pulumi.Input[str],
                 data_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
                 security_master_user_name: Optional[pulumi.Input[str]] = None,
                 security_master_user_password_hash: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment to create the cluster in.
        :param pulumi.Input[int] data_node_count: (Updatable) The number of data nodes to configure for the cluster.
        :param pulumi.Input[int] data_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[int] data_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        :param pulumi.Input[str] data_node_host_type: TThe instance type for the cluster's data nodes.
        :param pulumi.Input[int] data_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[str] display_name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[int] master_node_count: (Updatable) The number of master nodes to configure for the cluster.
        :param pulumi.Input[int] master_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        :param pulumi.Input[int] master_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        :param pulumi.Input[str] master_node_host_type: The instance type for the cluster's master nodes.
        :param pulumi.Input[int] opendashboard_node_count: (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        :param pulumi.Input[int] opendashboard_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[int] opendashboard_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[str] software_version: (Updatable) The version of the software the cluster is running.
        :param pulumi.Input[str] subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param pulumi.Input[str] subnet_id: The OCID of the cluster's subnet.
        :param pulumi.Input[str] vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param pulumi.Input[str] vcn_id: The OCID of the cluster's VCN.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param pulumi.Input[str] security_master_user_name: (Updatable) The name of the master user that are used to manage security config
        :param pulumi.Input[str] security_master_user_password_hash: (Updatable) The password hash of the master user that are used to manage security config
        :param pulumi.Input[str] security_mode: (Updatable) The security mode of the cluster.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_node_count", data_node_count)
        pulumi.set(__self__, "data_node_host_memory_gb", data_node_host_memory_gb)
        pulumi.set(__self__, "data_node_host_ocpu_count", data_node_host_ocpu_count)
        pulumi.set(__self__, "data_node_host_type", data_node_host_type)
        pulumi.set(__self__, "data_node_storage_gb", data_node_storage_gb)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "master_node_count", master_node_count)
        pulumi.set(__self__, "master_node_host_memory_gb", master_node_host_memory_gb)
        pulumi.set(__self__, "master_node_host_ocpu_count", master_node_host_ocpu_count)
        pulumi.set(__self__, "master_node_host_type", master_node_host_type)
        pulumi.set(__self__, "opendashboard_node_count", opendashboard_node_count)
        pulumi.set(__self__, "opendashboard_node_host_memory_gb", opendashboard_node_host_memory_gb)
        pulumi.set(__self__, "opendashboard_node_host_ocpu_count", opendashboard_node_host_ocpu_count)
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        if data_node_host_bare_metal_shape is not None:
            pulumi.set(__self__, "data_node_host_bare_metal_shape", data_node_host_bare_metal_shape)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if master_node_host_bare_metal_shape is not None:
            pulumi.set(__self__, "master_node_host_bare_metal_shape", master_node_host_bare_metal_shape)
        if security_master_user_name is not None:
            pulumi.set(__self__, "security_master_user_name", security_master_user_name)
        if security_master_user_password_hash is not None:
            pulumi.set(__self__, "security_master_user_password_hash", security_master_user_password_hash)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment to create the cluster in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataNodeCount")
    def data_node_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of data nodes to configure for the cluster.
        """
        return pulumi.get(self, "data_node_count")

    @data_node_count.setter
    def data_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_node_count", value)

    @property
    @pulumi.getter(name="dataNodeHostMemoryGb")
    def data_node_host_memory_gb(self) -> pulumi.Input[int]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_memory_gb")

    @data_node_host_memory_gb.setter
    def data_node_host_memory_gb(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_node_host_memory_gb", value)

    @property
    @pulumi.getter(name="dataNodeHostOcpuCount")
    def data_node_host_ocpu_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_ocpu_count")

    @data_node_host_ocpu_count.setter
    def data_node_host_ocpu_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_node_host_ocpu_count", value)

    @property
    @pulumi.getter(name="dataNodeHostType")
    def data_node_host_type(self) -> pulumi.Input[str]:
        """
        TThe instance type for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_type")

    @data_node_host_type.setter
    def data_node_host_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_node_host_type", value)

    @property
    @pulumi.getter(name="dataNodeStorageGb")
    def data_node_storage_gb(self) -> pulumi.Input[int]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_storage_gb")

    @data_node_storage_gb.setter
    def data_node_storage_gb(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_node_storage_gb", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="masterNodeCount")
    def master_node_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of master nodes to configure for the cluster.
        """
        return pulumi.get(self, "master_node_count")

    @master_node_count.setter
    def master_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "master_node_count", value)

    @property
    @pulumi.getter(name="masterNodeHostMemoryGb")
    def master_node_host_memory_gb(self) -> pulumi.Input[int]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_memory_gb")

    @master_node_host_memory_gb.setter
    def master_node_host_memory_gb(self, value: pulumi.Input[int]):
        pulumi.set(self, "master_node_host_memory_gb", value)

    @property
    @pulumi.getter(name="masterNodeHostOcpuCount")
    def master_node_host_ocpu_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        """
        return pulumi.get(self, "master_node_host_ocpu_count")

    @master_node_host_ocpu_count.setter
    def master_node_host_ocpu_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "master_node_host_ocpu_count", value)

    @property
    @pulumi.getter(name="masterNodeHostType")
    def master_node_host_type(self) -> pulumi.Input[str]:
        """
        The instance type for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_type")

    @master_node_host_type.setter
    def master_node_host_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_node_host_type", value)

    @property
    @pulumi.getter(name="opendashboardNodeCount")
    def opendashboard_node_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        """
        return pulumi.get(self, "opendashboard_node_count")

    @opendashboard_node_count.setter
    def opendashboard_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "opendashboard_node_count", value)

    @property
    @pulumi.getter(name="opendashboardNodeHostMemoryGb")
    def opendashboard_node_host_memory_gb(self) -> pulumi.Input[int]:
        """
        (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_memory_gb")

    @opendashboard_node_host_memory_gb.setter
    def opendashboard_node_host_memory_gb(self, value: pulumi.Input[int]):
        pulumi.set(self, "opendashboard_node_host_memory_gb", value)

    @property
    @pulumi.getter(name="opendashboardNodeHostOcpuCount")
    def opendashboard_node_host_ocpu_count(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_ocpu_count")

    @opendashboard_node_host_ocpu_count.setter
    def opendashboard_node_host_ocpu_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "opendashboard_node_host_ocpu_count", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Input[str]:
        """
        (Updatable) The version of the software the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID for the compartment where the cluster's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @subnet_compartment_id.setter
    def subnet_compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_compartment_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The OCID of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID for the compartment where the cluster's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @vcn_compartment_id.setter
    def vcn_compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcn_compartment_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[str]:
        """
        The OCID of the cluster's VCN.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcn_id", value)

    @property
    @pulumi.getter(name="dataNodeHostBareMetalShape")
    def data_node_host_bare_metal_shape(self) -> Optional[pulumi.Input[str]]:
        """
        The bare metal shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_bare_metal_shape")

    @data_node_host_bare_metal_shape.setter
    def data_node_host_bare_metal_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_node_host_bare_metal_shape", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="masterNodeHostBareMetalShape")
    def master_node_host_bare_metal_shape(self) -> Optional[pulumi.Input[str]]:
        """
        The bare metal shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_bare_metal_shape")

    @master_node_host_bare_metal_shape.setter
    def master_node_host_bare_metal_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_node_host_bare_metal_shape", value)

    @property
    @pulumi.getter(name="securityMasterUserName")
    def security_master_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_name")

    @security_master_user_name.setter
    def security_master_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_master_user_name", value)

    @property
    @pulumi.getter(name="securityMasterUserPasswordHash")
    def security_master_user_password_hash(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password hash of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_password_hash")

    @security_master_user_password_hash.setter
    def security_master_user_password_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_master_user_password_hash", value)

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The security mode of the cluster.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_mode", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 availability_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_node_count: Optional[pulumi.Input[int]] = None,
                 data_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
                 data_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 data_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 data_node_host_type: Optional[pulumi.Input[str]] = None,
                 data_node_storage_gb: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 master_node_count: Optional[pulumi.Input[int]] = None,
                 master_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
                 master_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 master_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 master_node_host_type: Optional[pulumi.Input[str]] = None,
                 opendashboard_fqdn: Optional[pulumi.Input[str]] = None,
                 opendashboard_node_count: Optional[pulumi.Input[int]] = None,
                 opendashboard_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 opendashboard_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 opendashboard_private_ip: Optional[pulumi.Input[str]] = None,
                 opensearch_fqdn: Optional[pulumi.Input[str]] = None,
                 opensearch_private_ip: Optional[pulumi.Input[str]] = None,
                 security_master_user_name: Optional[pulumi.Input[str]] = None,
                 security_master_user_password_hash: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[str]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_deleted: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 total_storage_gb: Optional[pulumi.Input[int]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_domains: The availability domains to distribute the cluser nodes across.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment to create the cluster in.
        :param pulumi.Input[int] data_node_count: (Updatable) The number of data nodes to configure for the cluster.
        :param pulumi.Input[str] data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param pulumi.Input[int] data_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[int] data_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        :param pulumi.Input[str] data_node_host_type: TThe instance type for the cluster's data nodes.
        :param pulumi.Input[int] data_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[str] fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state of the cluster.
        :param pulumi.Input[int] master_node_count: (Updatable) The number of master nodes to configure for the cluster.
        :param pulumi.Input[str] master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param pulumi.Input[int] master_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        :param pulumi.Input[int] master_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        :param pulumi.Input[str] master_node_host_type: The instance type for the cluster's master nodes.
        :param pulumi.Input[str] opendashboard_fqdn: The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        :param pulumi.Input[int] opendashboard_node_count: (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        :param pulumi.Input[int] opendashboard_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[int] opendashboard_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[str] opendashboard_private_ip: The private IP address for the cluster's OpenSearch Dashboard.
        :param pulumi.Input[str] opensearch_fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[str] opensearch_private_ip: The cluster's private IP address.
        :param pulumi.Input[str] security_master_user_name: (Updatable) The name of the master user that are used to manage security config
        :param pulumi.Input[str] security_master_user_password_hash: (Updatable) The password hash of the master user that are used to manage security config
        :param pulumi.Input[str] security_mode: (Updatable) The security mode of the cluster.
        :param pulumi.Input[str] software_version: (Updatable) The version of the software the cluster is running.
        :param pulumi.Input[str] state: The current state of the cluster.
        :param pulumi.Input[str] subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param pulumi.Input[str] subnet_id: The OCID of the cluster's subnet.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The amount of time in milliseconds since the cluster was created.
        :param pulumi.Input[str] time_deleted: The amount of time in milliseconds since the cluster was updated.
        :param pulumi.Input[str] time_updated: The amount of time in milliseconds since the cluster was updated.
        :param pulumi.Input[int] total_storage_gb: The size in GB of the cluster's total storage.
        :param pulumi.Input[str] vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param pulumi.Input[str] vcn_id: The OCID of the cluster's VCN.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if availability_domains is not None:
            pulumi.set(__self__, "availability_domains", availability_domains)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if data_node_count is not None:
            pulumi.set(__self__, "data_node_count", data_node_count)
        if data_node_host_bare_metal_shape is not None:
            pulumi.set(__self__, "data_node_host_bare_metal_shape", data_node_host_bare_metal_shape)
        if data_node_host_memory_gb is not None:
            pulumi.set(__self__, "data_node_host_memory_gb", data_node_host_memory_gb)
        if data_node_host_ocpu_count is not None:
            pulumi.set(__self__, "data_node_host_ocpu_count", data_node_host_ocpu_count)
        if data_node_host_type is not None:
            pulumi.set(__self__, "data_node_host_type", data_node_host_type)
        if data_node_storage_gb is not None:
            pulumi.set(__self__, "data_node_storage_gb", data_node_storage_gb)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if master_node_count is not None:
            pulumi.set(__self__, "master_node_count", master_node_count)
        if master_node_host_bare_metal_shape is not None:
            pulumi.set(__self__, "master_node_host_bare_metal_shape", master_node_host_bare_metal_shape)
        if master_node_host_memory_gb is not None:
            pulumi.set(__self__, "master_node_host_memory_gb", master_node_host_memory_gb)
        if master_node_host_ocpu_count is not None:
            pulumi.set(__self__, "master_node_host_ocpu_count", master_node_host_ocpu_count)
        if master_node_host_type is not None:
            pulumi.set(__self__, "master_node_host_type", master_node_host_type)
        if opendashboard_fqdn is not None:
            pulumi.set(__self__, "opendashboard_fqdn", opendashboard_fqdn)
        if opendashboard_node_count is not None:
            pulumi.set(__self__, "opendashboard_node_count", opendashboard_node_count)
        if opendashboard_node_host_memory_gb is not None:
            pulumi.set(__self__, "opendashboard_node_host_memory_gb", opendashboard_node_host_memory_gb)
        if opendashboard_node_host_ocpu_count is not None:
            pulumi.set(__self__, "opendashboard_node_host_ocpu_count", opendashboard_node_host_ocpu_count)
        if opendashboard_private_ip is not None:
            pulumi.set(__self__, "opendashboard_private_ip", opendashboard_private_ip)
        if opensearch_fqdn is not None:
            pulumi.set(__self__, "opensearch_fqdn", opensearch_fqdn)
        if opensearch_private_ip is not None:
            pulumi.set(__self__, "opensearch_private_ip", opensearch_private_ip)
        if security_master_user_name is not None:
            pulumi.set(__self__, "security_master_user_name", security_master_user_name)
        if security_master_user_password_hash is not None:
            pulumi.set(__self__, "security_master_user_password_hash", security_master_user_password_hash)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_compartment_id is not None:
            pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_deleted is not None:
            pulumi.set(__self__, "time_deleted", time_deleted)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_storage_gb is not None:
            pulumi.set(__self__, "total_storage_gb", total_storage_gb)
        if vcn_compartment_id is not None:
            pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="availabilityDomains")
    def availability_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The availability domains to distribute the cluser nodes across.
        """
        return pulumi.get(self, "availability_domains")

    @availability_domains.setter
    def availability_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_domains", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment to create the cluster in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataNodeCount")
    def data_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of data nodes to configure for the cluster.
        """
        return pulumi.get(self, "data_node_count")

    @data_node_count.setter
    def data_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_node_count", value)

    @property
    @pulumi.getter(name="dataNodeHostBareMetalShape")
    def data_node_host_bare_metal_shape(self) -> Optional[pulumi.Input[str]]:
        """
        The bare metal shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_bare_metal_shape")

    @data_node_host_bare_metal_shape.setter
    def data_node_host_bare_metal_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_node_host_bare_metal_shape", value)

    @property
    @pulumi.getter(name="dataNodeHostMemoryGb")
    def data_node_host_memory_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_memory_gb")

    @data_node_host_memory_gb.setter
    def data_node_host_memory_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_node_host_memory_gb", value)

    @property
    @pulumi.getter(name="dataNodeHostOcpuCount")
    def data_node_host_ocpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_ocpu_count")

    @data_node_host_ocpu_count.setter
    def data_node_host_ocpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_node_host_ocpu_count", value)

    @property
    @pulumi.getter(name="dataNodeHostType")
    def data_node_host_type(self) -> Optional[pulumi.Input[str]]:
        """
        TThe instance type for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_type")

    @data_node_host_type.setter
    def data_node_host_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_node_host_type", value)

    @property
    @pulumi.getter(name="dataNodeStorageGb")
    def data_node_storage_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_storage_gb")

    @data_node_storage_gb.setter
    def data_node_storage_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_node_storage_gb", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state of the cluster.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="masterNodeCount")
    def master_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of master nodes to configure for the cluster.
        """
        return pulumi.get(self, "master_node_count")

    @master_node_count.setter
    def master_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_node_count", value)

    @property
    @pulumi.getter(name="masterNodeHostBareMetalShape")
    def master_node_host_bare_metal_shape(self) -> Optional[pulumi.Input[str]]:
        """
        The bare metal shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_bare_metal_shape")

    @master_node_host_bare_metal_shape.setter
    def master_node_host_bare_metal_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_node_host_bare_metal_shape", value)

    @property
    @pulumi.getter(name="masterNodeHostMemoryGb")
    def master_node_host_memory_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_memory_gb")

    @master_node_host_memory_gb.setter
    def master_node_host_memory_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_node_host_memory_gb", value)

    @property
    @pulumi.getter(name="masterNodeHostOcpuCount")
    def master_node_host_ocpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        """
        return pulumi.get(self, "master_node_host_ocpu_count")

    @master_node_host_ocpu_count.setter
    def master_node_host_ocpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_node_host_ocpu_count", value)

    @property
    @pulumi.getter(name="masterNodeHostType")
    def master_node_host_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_type")

    @master_node_host_type.setter
    def master_node_host_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_node_host_type", value)

    @property
    @pulumi.getter(name="opendashboardFqdn")
    def opendashboard_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        """
        return pulumi.get(self, "opendashboard_fqdn")

    @opendashboard_fqdn.setter
    def opendashboard_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opendashboard_fqdn", value)

    @property
    @pulumi.getter(name="opendashboardNodeCount")
    def opendashboard_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        """
        return pulumi.get(self, "opendashboard_node_count")

    @opendashboard_node_count.setter
    def opendashboard_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "opendashboard_node_count", value)

    @property
    @pulumi.getter(name="opendashboardNodeHostMemoryGb")
    def opendashboard_node_host_memory_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_memory_gb")

    @opendashboard_node_host_memory_gb.setter
    def opendashboard_node_host_memory_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "opendashboard_node_host_memory_gb", value)

    @property
    @pulumi.getter(name="opendashboardNodeHostOcpuCount")
    def opendashboard_node_host_ocpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_ocpu_count")

    @opendashboard_node_host_ocpu_count.setter
    def opendashboard_node_host_ocpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "opendashboard_node_host_ocpu_count", value)

    @property
    @pulumi.getter(name="opendashboardPrivateIp")
    def opendashboard_private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address for the cluster's OpenSearch Dashboard.
        """
        return pulumi.get(self, "opendashboard_private_ip")

    @opendashboard_private_ip.setter
    def opendashboard_private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opendashboard_private_ip", value)

    @property
    @pulumi.getter(name="opensearchFqdn")
    def opensearch_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_fqdn")

    @opensearch_fqdn.setter
    def opensearch_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opensearch_fqdn", value)

    @property
    @pulumi.getter(name="opensearchPrivateIp")
    def opensearch_private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster's private IP address.
        """
        return pulumi.get(self, "opensearch_private_ip")

    @opensearch_private_ip.setter
    def opensearch_private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opensearch_private_ip", value)

    @property
    @pulumi.getter(name="securityMasterUserName")
    def security_master_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_name")

    @security_master_user_name.setter
    def security_master_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_master_user_name", value)

    @property
    @pulumi.getter(name="securityMasterUserPasswordHash")
    def security_master_user_password_hash(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password hash of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_password_hash")

    @security_master_user_password_hash.setter
    def security_master_user_password_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_master_user_password_hash", value)

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The security mode of the cluster.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_mode", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of the software the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID for the compartment where the cluster's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @subnet_compartment_id.setter
    def subnet_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_compartment_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time in milliseconds since the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_deleted")

    @time_deleted.setter
    def time_deleted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_deleted", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalStorageGb")
    def total_storage_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size in GB of the cluster's total storage.
        """
        return pulumi.get(self, "total_storage_gb")

    @total_storage_gb.setter
    def total_storage_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_storage_gb", value)

    @property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID for the compartment where the cluster's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @vcn_compartment_id.setter
    def vcn_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_compartment_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the cluster's VCN.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_id", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_node_count: Optional[pulumi.Input[int]] = None,
                 data_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
                 data_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 data_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 data_node_host_type: Optional[pulumi.Input[str]] = None,
                 data_node_storage_gb: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_node_count: Optional[pulumi.Input[int]] = None,
                 master_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
                 master_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 master_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 master_node_host_type: Optional[pulumi.Input[str]] = None,
                 opendashboard_node_count: Optional[pulumi.Input[int]] = None,
                 opendashboard_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 opendashboard_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 security_master_user_name: Optional[pulumi.Input[str]] = None,
                 security_master_user_password_hash: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[str]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Opensearch Cluster resource in Oracle Cloud Infrastructure Opensearch service.

        Creates a new OpensearchCluster.

        ## Prerequisites

        The below policies must be created in compartment before creating OpensearchCluster

        ##### {Compartment-Name} - Name of  your compartment

        For latest documentation on OpenSearch use please refer to https://docs.oracle.com/en-us/iaas/Content/search-opensearch/home.htm\\
        Required permissions: https://docs.oracle.com/en-us/iaas/Content/search-opensearch/Concepts/ocisearchpermissions.htm

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_opensearch_cluster = oci.opensearch.Cluster("test_opensearch_cluster",
            compartment_id=compartment_id,
            data_node_count=opensearch_cluster_data_node_count,
            data_node_host_memory_gb=opensearch_cluster_data_node_host_memory_gb,
            data_node_host_ocpu_count=opensearch_cluster_data_node_host_ocpu_count,
            data_node_host_type=opensearch_cluster_data_node_host_type,
            data_node_storage_gb=opensearch_cluster_data_node_storage_gb,
            display_name=opensearch_cluster_display_name,
            master_node_count=opensearch_cluster_master_node_count,
            master_node_host_memory_gb=opensearch_cluster_master_node_host_memory_gb,
            master_node_host_ocpu_count=opensearch_cluster_master_node_host_ocpu_count,
            master_node_host_type=opensearch_cluster_master_node_host_type,
            opendashboard_node_count=opensearch_cluster_opendashboard_node_count,
            opendashboard_node_host_memory_gb=opensearch_cluster_opendashboard_node_host_memory_gb,
            opendashboard_node_host_ocpu_count=opensearch_cluster_opendashboard_node_host_ocpu_count,
            software_version=opensearch_cluster_software_version,
            subnet_compartment_id=test_compartment["id"],
            subnet_id=test_subnet["id"],
            vcn_compartment_id=test_compartment["id"],
            vcn_id=test_vcn["id"],
            data_node_host_bare_metal_shape=opensearch_cluster_data_node_host_bare_metal_shape,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            master_node_host_bare_metal_shape=opensearch_cluster_master_node_host_bare_metal_shape,
            security_master_user_name=test_user["name"],
            security_master_user_password_hash=opensearch_cluster_security_master_user_password_hash,
            security_mode=opensearch_cluster_security_mode,
            system_tags=opensearch_cluster_system_tags)
        ```

        ## Import

        OpensearchClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opensearch/cluster:Cluster test_opensearch_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment to create the cluster in.
        :param pulumi.Input[int] data_node_count: (Updatable) The number of data nodes to configure for the cluster.
        :param pulumi.Input[str] data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param pulumi.Input[int] data_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[int] data_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        :param pulumi.Input[str] data_node_host_type: TThe instance type for the cluster's data nodes.
        :param pulumi.Input[int] data_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] master_node_count: (Updatable) The number of master nodes to configure for the cluster.
        :param pulumi.Input[str] master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param pulumi.Input[int] master_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        :param pulumi.Input[int] master_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        :param pulumi.Input[str] master_node_host_type: The instance type for the cluster's master nodes.
        :param pulumi.Input[int] opendashboard_node_count: (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        :param pulumi.Input[int] opendashboard_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[int] opendashboard_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[str] security_master_user_name: (Updatable) The name of the master user that are used to manage security config
        :param pulumi.Input[str] security_master_user_password_hash: (Updatable) The password hash of the master user that are used to manage security config
        :param pulumi.Input[str] security_mode: (Updatable) The security mode of the cluster.
        :param pulumi.Input[str] software_version: (Updatable) The version of the software the cluster is running.
        :param pulumi.Input[str] subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param pulumi.Input[str] subnet_id: The OCID of the cluster's subnet.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param pulumi.Input[str] vcn_id: The OCID of the cluster's VCN.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Opensearch Cluster resource in Oracle Cloud Infrastructure Opensearch service.

        Creates a new OpensearchCluster.

        ## Prerequisites

        The below policies must be created in compartment before creating OpensearchCluster

        ##### {Compartment-Name} - Name of  your compartment

        For latest documentation on OpenSearch use please refer to https://docs.oracle.com/en-us/iaas/Content/search-opensearch/home.htm\\
        Required permissions: https://docs.oracle.com/en-us/iaas/Content/search-opensearch/Concepts/ocisearchpermissions.htm

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_opensearch_cluster = oci.opensearch.Cluster("test_opensearch_cluster",
            compartment_id=compartment_id,
            data_node_count=opensearch_cluster_data_node_count,
            data_node_host_memory_gb=opensearch_cluster_data_node_host_memory_gb,
            data_node_host_ocpu_count=opensearch_cluster_data_node_host_ocpu_count,
            data_node_host_type=opensearch_cluster_data_node_host_type,
            data_node_storage_gb=opensearch_cluster_data_node_storage_gb,
            display_name=opensearch_cluster_display_name,
            master_node_count=opensearch_cluster_master_node_count,
            master_node_host_memory_gb=opensearch_cluster_master_node_host_memory_gb,
            master_node_host_ocpu_count=opensearch_cluster_master_node_host_ocpu_count,
            master_node_host_type=opensearch_cluster_master_node_host_type,
            opendashboard_node_count=opensearch_cluster_opendashboard_node_count,
            opendashboard_node_host_memory_gb=opensearch_cluster_opendashboard_node_host_memory_gb,
            opendashboard_node_host_ocpu_count=opensearch_cluster_opendashboard_node_host_ocpu_count,
            software_version=opensearch_cluster_software_version,
            subnet_compartment_id=test_compartment["id"],
            subnet_id=test_subnet["id"],
            vcn_compartment_id=test_compartment["id"],
            vcn_id=test_vcn["id"],
            data_node_host_bare_metal_shape=opensearch_cluster_data_node_host_bare_metal_shape,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            master_node_host_bare_metal_shape=opensearch_cluster_master_node_host_bare_metal_shape,
            security_master_user_name=test_user["name"],
            security_master_user_password_hash=opensearch_cluster_security_master_user_password_hash,
            security_mode=opensearch_cluster_security_mode,
            system_tags=opensearch_cluster_system_tags)
        ```

        ## Import

        OpensearchClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opensearch/cluster:Cluster test_opensearch_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_node_count: Optional[pulumi.Input[int]] = None,
                 data_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
                 data_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 data_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 data_node_host_type: Optional[pulumi.Input[str]] = None,
                 data_node_storage_gb: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_node_count: Optional[pulumi.Input[int]] = None,
                 master_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
                 master_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 master_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 master_node_host_type: Optional[pulumi.Input[str]] = None,
                 opendashboard_node_count: Optional[pulumi.Input[int]] = None,
                 opendashboard_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
                 opendashboard_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
                 security_master_user_name: Optional[pulumi.Input[str]] = None,
                 security_master_user_password_hash: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[str]] = None,
                 software_version: Optional[pulumi.Input[str]] = None,
                 subnet_compartment_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vcn_compartment_id: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if data_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_count'")
            __props__.__dict__["data_node_count"] = data_node_count
            __props__.__dict__["data_node_host_bare_metal_shape"] = data_node_host_bare_metal_shape
            if data_node_host_memory_gb is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_host_memory_gb'")
            __props__.__dict__["data_node_host_memory_gb"] = data_node_host_memory_gb
            if data_node_host_ocpu_count is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_host_ocpu_count'")
            __props__.__dict__["data_node_host_ocpu_count"] = data_node_host_ocpu_count
            if data_node_host_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_host_type'")
            __props__.__dict__["data_node_host_type"] = data_node_host_type
            if data_node_storage_gb is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_storage_gb'")
            __props__.__dict__["data_node_storage_gb"] = data_node_storage_gb
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if master_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_count'")
            __props__.__dict__["master_node_count"] = master_node_count
            __props__.__dict__["master_node_host_bare_metal_shape"] = master_node_host_bare_metal_shape
            if master_node_host_memory_gb is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_host_memory_gb'")
            __props__.__dict__["master_node_host_memory_gb"] = master_node_host_memory_gb
            if master_node_host_ocpu_count is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_host_ocpu_count'")
            __props__.__dict__["master_node_host_ocpu_count"] = master_node_host_ocpu_count
            if master_node_host_type is None and not opts.urn:
                raise TypeError("Missing required property 'master_node_host_type'")
            __props__.__dict__["master_node_host_type"] = master_node_host_type
            if opendashboard_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'opendashboard_node_count'")
            __props__.__dict__["opendashboard_node_count"] = opendashboard_node_count
            if opendashboard_node_host_memory_gb is None and not opts.urn:
                raise TypeError("Missing required property 'opendashboard_node_host_memory_gb'")
            __props__.__dict__["opendashboard_node_host_memory_gb"] = opendashboard_node_host_memory_gb
            if opendashboard_node_host_ocpu_count is None and not opts.urn:
                raise TypeError("Missing required property 'opendashboard_node_host_ocpu_count'")
            __props__.__dict__["opendashboard_node_host_ocpu_count"] = opendashboard_node_host_ocpu_count
            __props__.__dict__["security_master_user_name"] = security_master_user_name
            __props__.__dict__["security_master_user_password_hash"] = None if security_master_user_password_hash is None else pulumi.Output.secret(security_master_user_password_hash)
            __props__.__dict__["security_mode"] = security_mode
            if software_version is None and not opts.urn:
                raise TypeError("Missing required property 'software_version'")
            __props__.__dict__["software_version"] = software_version
            if subnet_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_compartment_id'")
            __props__.__dict__["subnet_compartment_id"] = subnet_compartment_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["system_tags"] = system_tags
            if vcn_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_compartment_id'")
            __props__.__dict__["vcn_compartment_id"] = vcn_compartment_id
            if vcn_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_id'")
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["availability_domains"] = None
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["opendashboard_fqdn"] = None
            __props__.__dict__["opendashboard_private_ip"] = None
            __props__.__dict__["opensearch_fqdn"] = None
            __props__.__dict__["opensearch_private_ip"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_deleted"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["total_storage_gb"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["securityMasterUserPasswordHash"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'oci:Opensearch/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            data_node_count: Optional[pulumi.Input[int]] = None,
            data_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
            data_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
            data_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
            data_node_host_type: Optional[pulumi.Input[str]] = None,
            data_node_storage_gb: Optional[pulumi.Input[int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            fqdn: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            master_node_count: Optional[pulumi.Input[int]] = None,
            master_node_host_bare_metal_shape: Optional[pulumi.Input[str]] = None,
            master_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
            master_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
            master_node_host_type: Optional[pulumi.Input[str]] = None,
            opendashboard_fqdn: Optional[pulumi.Input[str]] = None,
            opendashboard_node_count: Optional[pulumi.Input[int]] = None,
            opendashboard_node_host_memory_gb: Optional[pulumi.Input[int]] = None,
            opendashboard_node_host_ocpu_count: Optional[pulumi.Input[int]] = None,
            opendashboard_private_ip: Optional[pulumi.Input[str]] = None,
            opensearch_fqdn: Optional[pulumi.Input[str]] = None,
            opensearch_private_ip: Optional[pulumi.Input[str]] = None,
            security_master_user_name: Optional[pulumi.Input[str]] = None,
            security_master_user_password_hash: Optional[pulumi.Input[str]] = None,
            security_mode: Optional[pulumi.Input[str]] = None,
            software_version: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_compartment_id: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_deleted: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            total_storage_gb: Optional[pulumi.Input[int]] = None,
            vcn_compartment_id: Optional[pulumi.Input[str]] = None,
            vcn_id: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_domains: The availability domains to distribute the cluser nodes across.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment to create the cluster in.
        :param pulumi.Input[int] data_node_count: (Updatable) The number of data nodes to configure for the cluster.
        :param pulumi.Input[str] data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param pulumi.Input[int] data_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[int] data_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        :param pulumi.Input[str] data_node_host_type: TThe instance type for the cluster's data nodes.
        :param pulumi.Input[int] data_node_storage_gb: (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[str] fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state of the cluster.
        :param pulumi.Input[int] master_node_count: (Updatable) The number of master nodes to configure for the cluster.
        :param pulumi.Input[str] master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param pulumi.Input[int] master_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        :param pulumi.Input[int] master_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        :param pulumi.Input[str] master_node_host_type: The instance type for the cluster's master nodes.
        :param pulumi.Input[str] opendashboard_fqdn: The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        :param pulumi.Input[int] opendashboard_node_count: (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        :param pulumi.Input[int] opendashboard_node_host_memory_gb: (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[int] opendashboard_node_host_ocpu_count: (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        :param pulumi.Input[str] opendashboard_private_ip: The private IP address for the cluster's OpenSearch Dashboard.
        :param pulumi.Input[str] opensearch_fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param pulumi.Input[str] opensearch_private_ip: The cluster's private IP address.
        :param pulumi.Input[str] security_master_user_name: (Updatable) The name of the master user that are used to manage security config
        :param pulumi.Input[str] security_master_user_password_hash: (Updatable) The password hash of the master user that are used to manage security config
        :param pulumi.Input[str] security_mode: (Updatable) The security mode of the cluster.
        :param pulumi.Input[str] software_version: (Updatable) The version of the software the cluster is running.
        :param pulumi.Input[str] state: The current state of the cluster.
        :param pulumi.Input[str] subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param pulumi.Input[str] subnet_id: The OCID of the cluster's subnet.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The amount of time in milliseconds since the cluster was created.
        :param pulumi.Input[str] time_deleted: The amount of time in milliseconds since the cluster was updated.
        :param pulumi.Input[str] time_updated: The amount of time in milliseconds since the cluster was updated.
        :param pulumi.Input[int] total_storage_gb: The size in GB of the cluster's total storage.
        :param pulumi.Input[str] vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param pulumi.Input[str] vcn_id: The OCID of the cluster's VCN.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["availability_domains"] = availability_domains
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_node_count"] = data_node_count
        __props__.__dict__["data_node_host_bare_metal_shape"] = data_node_host_bare_metal_shape
        __props__.__dict__["data_node_host_memory_gb"] = data_node_host_memory_gb
        __props__.__dict__["data_node_host_ocpu_count"] = data_node_host_ocpu_count
        __props__.__dict__["data_node_host_type"] = data_node_host_type
        __props__.__dict__["data_node_storage_gb"] = data_node_storage_gb
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["master_node_count"] = master_node_count
        __props__.__dict__["master_node_host_bare_metal_shape"] = master_node_host_bare_metal_shape
        __props__.__dict__["master_node_host_memory_gb"] = master_node_host_memory_gb
        __props__.__dict__["master_node_host_ocpu_count"] = master_node_host_ocpu_count
        __props__.__dict__["master_node_host_type"] = master_node_host_type
        __props__.__dict__["opendashboard_fqdn"] = opendashboard_fqdn
        __props__.__dict__["opendashboard_node_count"] = opendashboard_node_count
        __props__.__dict__["opendashboard_node_host_memory_gb"] = opendashboard_node_host_memory_gb
        __props__.__dict__["opendashboard_node_host_ocpu_count"] = opendashboard_node_host_ocpu_count
        __props__.__dict__["opendashboard_private_ip"] = opendashboard_private_ip
        __props__.__dict__["opensearch_fqdn"] = opensearch_fqdn
        __props__.__dict__["opensearch_private_ip"] = opensearch_private_ip
        __props__.__dict__["security_master_user_name"] = security_master_user_name
        __props__.__dict__["security_master_user_password_hash"] = security_master_user_password_hash
        __props__.__dict__["security_mode"] = security_mode
        __props__.__dict__["software_version"] = software_version
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_compartment_id"] = subnet_compartment_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_deleted"] = time_deleted
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_storage_gb"] = total_storage_gb
        __props__.__dict__["vcn_compartment_id"] = vcn_compartment_id
        __props__.__dict__["vcn_id"] = vcn_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomains")
    def availability_domains(self) -> pulumi.Output[Sequence[str]]:
        """
        The availability domains to distribute the cluser nodes across.
        """
        return pulumi.get(self, "availability_domains")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment to create the cluster in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataNodeCount")
    def data_node_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of data nodes to configure for the cluster.
        """
        return pulumi.get(self, "data_node_count")

    @property
    @pulumi.getter(name="dataNodeHostBareMetalShape")
    def data_node_host_bare_metal_shape(self) -> pulumi.Output[str]:
        """
        The bare metal shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_bare_metal_shape")

    @property
    @pulumi.getter(name="dataNodeHostMemoryGb")
    def data_node_host_memory_gb(self) -> pulumi.Output[int]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_memory_gb")

    @property
    @pulumi.getter(name="dataNodeHostOcpuCount")
    def data_node_host_ocpu_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_ocpu_count")

    @property
    @pulumi.getter(name="dataNodeHostType")
    def data_node_host_type(self) -> pulumi.Output[str]:
        """
        TThe instance type for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_type")

    @property
    @pulumi.getter(name="dataNodeStorageGb")
    def data_node_storage_gb(self) -> pulumi.Output[int]:
        """
        (Updatable) The amount of storage in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_storage_gb")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state of the cluster.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="masterNodeCount")
    def master_node_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of master nodes to configure for the cluster.
        """
        return pulumi.get(self, "master_node_count")

    @property
    @pulumi.getter(name="masterNodeHostBareMetalShape")
    def master_node_host_bare_metal_shape(self) -> pulumi.Output[str]:
        """
        The bare metal shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_bare_metal_shape")

    @property
    @pulumi.getter(name="masterNodeHostMemoryGb")
    def master_node_host_memory_gb(self) -> pulumi.Output[int]:
        """
        (Updatable) The amount of memory in GB, to configure per node for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_memory_gb")

    @property
    @pulumi.getter(name="masterNodeHostOcpuCount")
    def master_node_host_ocpu_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of OCPUs to configure for the cluser's master nodes.
        """
        return pulumi.get(self, "master_node_host_ocpu_count")

    @property
    @pulumi.getter(name="masterNodeHostType")
    def master_node_host_type(self) -> pulumi.Output[str]:
        """
        The instance type for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_type")

    @property
    @pulumi.getter(name="opendashboardFqdn")
    def opendashboard_fqdn(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        """
        return pulumi.get(self, "opendashboard_fqdn")

    @property
    @pulumi.getter(name="opendashboardNodeCount")
    def opendashboard_node_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of OpenSearch Dashboard nodes to configure for the cluster.
        """
        return pulumi.get(self, "opendashboard_node_count")

    @property
    @pulumi.getter(name="opendashboardNodeHostMemoryGb")
    def opendashboard_node_host_memory_gb(self) -> pulumi.Output[int]:
        """
        (Updatable) The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_memory_gb")

    @property
    @pulumi.getter(name="opendashboardNodeHostOcpuCount")
    def opendashboard_node_host_ocpu_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_ocpu_count")

    @property
    @pulumi.getter(name="opendashboardPrivateIp")
    def opendashboard_private_ip(self) -> pulumi.Output[str]:
        """
        The private IP address for the cluster's OpenSearch Dashboard.
        """
        return pulumi.get(self, "opendashboard_private_ip")

    @property
    @pulumi.getter(name="opensearchFqdn")
    def opensearch_fqdn(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_fqdn")

    @property
    @pulumi.getter(name="opensearchPrivateIp")
    def opensearch_private_ip(self) -> pulumi.Output[str]:
        """
        The cluster's private IP address.
        """
        return pulumi.get(self, "opensearch_private_ip")

    @property
    @pulumi.getter(name="securityMasterUserName")
    def security_master_user_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_name")

    @property
    @pulumi.getter(name="securityMasterUserPasswordHash")
    def security_master_user_password_hash(self) -> pulumi.Output[str]:
        """
        (Updatable) The password hash of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_password_hash")

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) The security mode of the cluster.
        """
        return pulumi.get(self, "security_mode")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The version of the software the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID for the compartment where the cluster's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The OCID of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The amount of time in milliseconds since the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> pulumi.Output[str]:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalStorageGb")
    def total_storage_gb(self) -> pulumi.Output[int]:
        """
        The size in GB of the cluster's total storage.
        """
        return pulumi.get(self, "total_storage_gb")

    @property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID for the compartment where the cluster's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[str]:
        """
        The OCID of the cluster's VCN.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

