# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceActionArgs', 'ResourceAction']

@pulumi.input_type
class ResourceActionArgs:
    def __init__(__self__, *,
                 resource_action_id: pulumi.Input[str],
                 status: pulumi.Input[str],
                 time_status_end: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ResourceAction resource.
        :param pulumi.Input[str] resource_action_id: The unique OCID associated with the resource action.
        :param pulumi.Input[str] status: (Updatable) The status of the resource action.
        :param pulumi.Input[str] time_status_end: (Updatable) The date and time the current status will change. The format is defined by RFC3339.
               
               For example, "The current `postponed` status of the resource action will end and change to `pending` on this date and time."
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "resource_action_id", resource_action_id)
        pulumi.set(__self__, "status", status)
        if time_status_end is not None:
            pulumi.set(__self__, "time_status_end", time_status_end)

    @property
    @pulumi.getter(name="resourceActionId")
    def resource_action_id(self) -> pulumi.Input[str]:
        """
        The unique OCID associated with the resource action.
        """
        return pulumi.get(self, "resource_action_id")

    @resource_action_id.setter
    def resource_action_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_action_id", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        (Updatable) The status of the resource action.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date and time the current status will change. The format is defined by RFC3339.

        For example, "The current `postponed` status of the resource action will end and change to `pending` on this date and time."


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_status_end")

    @time_status_end.setter
    def time_status_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_status_end", value)


@pulumi.input_type
class _ResourceActionState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceActionActionArgs']]]] = None,
                 category_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compartment_name: Optional[pulumi.Input[str]] = None,
                 estimated_cost_saving: Optional[pulumi.Input[float]] = None,
                 extended_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recommendation_id: Optional[pulumi.Input[str]] = None,
                 resource_action_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_status_begin: Optional[pulumi.Input[str]] = None,
                 time_status_end: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ResourceAction resources.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceActionActionArgs']]] actions: Details about the recommended action.
        :param pulumi.Input[str] category_id: The unique OCID associated with the category.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] compartment_name: The name associated with the compartment.
        :param pulumi.Input[float] estimated_cost_saving: The estimated cost savings, in dollars, for the resource action.
        :param pulumi.Input[Mapping[str, Any]] extended_metadata: Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        :param pulumi.Input[Mapping[str, Any]] metadata: Custom metadata key/value pairs for the resource action.
        :param pulumi.Input[str] name: The name assigned to the resource.
        :param pulumi.Input[str] recommendation_id: The unique OCID associated with the recommendation.
        :param pulumi.Input[str] resource_action_id: The unique OCID associated with the resource action.
        :param pulumi.Input[str] resource_id: The unique OCID associated with the resource.
        :param pulumi.Input[str] resource_type: The kind of resource.
        :param pulumi.Input[str] state: The resource action's current state.
        :param pulumi.Input[str] status: (Updatable) The status of the resource action.
        :param pulumi.Input[str] time_created: The date and time the resource action details were created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_status_begin: The date and time that the resource action entered its current status. The format is defined by RFC3339.
        :param pulumi.Input[str] time_status_end: (Updatable) The date and time the current status will change. The format is defined by RFC3339.
               
               For example, "The current `postponed` status of the resource action will end and change to `pending` on this date and time."
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_updated: The date and time the resource action details were last updated, in the format defined by RFC3339.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if category_id is not None:
            pulumi.set(__self__, "category_id", category_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_name is not None:
            pulumi.set(__self__, "compartment_name", compartment_name)
        if estimated_cost_saving is not None:
            pulumi.set(__self__, "estimated_cost_saving", estimated_cost_saving)
        if extended_metadata is not None:
            pulumi.set(__self__, "extended_metadata", extended_metadata)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recommendation_id is not None:
            pulumi.set(__self__, "recommendation_id", recommendation_id)
        if resource_action_id is not None:
            pulumi.set(__self__, "resource_action_id", resource_action_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_status_begin is not None:
            pulumi.set(__self__, "time_status_begin", time_status_begin)
        if time_status_end is not None:
            pulumi.set(__self__, "time_status_end", time_status_end)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceActionActionArgs']]]]:
        """
        Details about the recommended action.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceActionActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @category_id.setter
    def category_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name associated with the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @compartment_name.setter
    def compartment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_name", value)

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> Optional[pulumi.Input[float]]:
        """
        The estimated cost savings, in dollars, for the resource action.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @estimated_cost_saving.setter
    def estimated_cost_saving(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "estimated_cost_saving", value)

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        """
        return pulumi.get(self, "extended_metadata")

    @extended_metadata.setter
    def extended_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "extended_metadata", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom metadata key/value pairs for the resource action.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name assigned to the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @recommendation_id.setter
    def recommendation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recommendation_id", value)

    @property
    @pulumi.getter(name="resourceActionId")
    def resource_action_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique OCID associated with the resource action.
        """
        return pulumi.get(self, "resource_action_id")

    @resource_action_id.setter
    def resource_action_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_action_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique OCID associated with the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The resource action's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The status of the resource action.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource action details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the resource action entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @time_status_begin.setter
    def time_status_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_status_begin", value)

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The date and time the current status will change. The format is defined by RFC3339.

        For example, "The current `postponed` status of the resource action will end and change to `pending` on this date and time."


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_status_end")

    @time_status_end.setter
    def time_status_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_status_end", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource action details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class ResourceAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_action_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_status_end: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Resource Action resource in Oracle Cloud Infrastructure Optimizer service.

        Updates the resource action that corresponds to the specified OCID.
        Use this operation to implement the following actions:

          * Postpone resource action
          * Ignore resource action
          * Reactivate resource action

        ## Import

        ResourceActions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Optimizer/resourceAction:ResourceAction test_resource_action "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] resource_action_id: The unique OCID associated with the resource action.
        :param pulumi.Input[str] status: (Updatable) The status of the resource action.
        :param pulumi.Input[str] time_status_end: (Updatable) The date and time the current status will change. The format is defined by RFC3339.
               
               For example, "The current `postponed` status of the resource action will end and change to `pending` on this date and time."
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Resource Action resource in Oracle Cloud Infrastructure Optimizer service.

        Updates the resource action that corresponds to the specified OCID.
        Use this operation to implement the following actions:

          * Postpone resource action
          * Ignore resource action
          * Reactivate resource action

        ## Import

        ResourceActions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Optimizer/resourceAction:ResourceAction test_resource_action "id"
        ```

        :param str resource_name: The name of the resource.
        :param ResourceActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_action_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_status_end: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceActionArgs.__new__(ResourceActionArgs)

            if resource_action_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_action_id'")
            __props__.__dict__["resource_action_id"] = resource_action_id
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["time_status_end"] = time_status_end
            __props__.__dict__["actions"] = None
            __props__.__dict__["category_id"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compartment_name"] = None
            __props__.__dict__["estimated_cost_saving"] = None
            __props__.__dict__["extended_metadata"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["recommendation_id"] = None
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_status_begin"] = None
            __props__.__dict__["time_updated"] = None
        super(ResourceAction, __self__).__init__(
            'oci:Optimizer/resourceAction:ResourceAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceActionActionArgs', 'ResourceActionActionArgsDict']]]]] = None,
            category_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compartment_name: Optional[pulumi.Input[str]] = None,
            estimated_cost_saving: Optional[pulumi.Input[float]] = None,
            extended_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            recommendation_id: Optional[pulumi.Input[str]] = None,
            resource_action_id: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            resource_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_status_begin: Optional[pulumi.Input[str]] = None,
            time_status_end: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'ResourceAction':
        """
        Get an existing ResourceAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceActionActionArgs', 'ResourceActionActionArgsDict']]]] actions: Details about the recommended action.
        :param pulumi.Input[str] category_id: The unique OCID associated with the category.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] compartment_name: The name associated with the compartment.
        :param pulumi.Input[float] estimated_cost_saving: The estimated cost savings, in dollars, for the resource action.
        :param pulumi.Input[Mapping[str, Any]] extended_metadata: Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        :param pulumi.Input[Mapping[str, Any]] metadata: Custom metadata key/value pairs for the resource action.
        :param pulumi.Input[str] name: The name assigned to the resource.
        :param pulumi.Input[str] recommendation_id: The unique OCID associated with the recommendation.
        :param pulumi.Input[str] resource_action_id: The unique OCID associated with the resource action.
        :param pulumi.Input[str] resource_id: The unique OCID associated with the resource.
        :param pulumi.Input[str] resource_type: The kind of resource.
        :param pulumi.Input[str] state: The resource action's current state.
        :param pulumi.Input[str] status: (Updatable) The status of the resource action.
        :param pulumi.Input[str] time_created: The date and time the resource action details were created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_status_begin: The date and time that the resource action entered its current status. The format is defined by RFC3339.
        :param pulumi.Input[str] time_status_end: (Updatable) The date and time the current status will change. The format is defined by RFC3339.
               
               For example, "The current `postponed` status of the resource action will end and change to `pending` on this date and time."
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_updated: The date and time the resource action details were last updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceActionState.__new__(_ResourceActionState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["category_id"] = category_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compartment_name"] = compartment_name
        __props__.__dict__["estimated_cost_saving"] = estimated_cost_saving
        __props__.__dict__["extended_metadata"] = extended_metadata
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["recommendation_id"] = recommendation_id
        __props__.__dict__["resource_action_id"] = resource_action_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_status_begin"] = time_status_begin
        __props__.__dict__["time_status_end"] = time_status_end
        __props__.__dict__["time_updated"] = time_updated
        return ResourceAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.ResourceActionAction']]:
        """
        Details about the recommended action.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> pulumi.Output[str]:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> pulumi.Output[str]:
        """
        The name associated with the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> pulumi.Output[float]:
        """
        The estimated cost savings, in dollars, for the resource action.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        """
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Custom metadata key/value pairs for the resource action.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name assigned to the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> pulumi.Output[str]:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @property
    @pulumi.getter(name="resourceActionId")
    def resource_action_id(self) -> pulumi.Output[str]:
        """
        The unique OCID associated with the resource action.
        """
        return pulumi.get(self, "resource_action_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The unique OCID associated with the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[str]:
        """
        The kind of resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The resource action's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) The status of the resource action.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource action details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> pulumi.Output[str]:
        """
        The date and time that the resource action entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> pulumi.Output[str]:
        """
        (Updatable) The date and time the current status will change. The format is defined by RFC3339.

        For example, "The current `postponed` status of the resource action will end and change to `pending` on this date and time."


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_status_end")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the resource action details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

