# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-05-19 04:00
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import mezzanine.core.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('forms', '0005_auto_20151026_1600'),
        ('shop', '0007_auto_20150921_2323'),
    ]

    operations = [
        migrations.CreateModel(
            name='Acquisition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('download_count', models.IntegerField(default=0, editable=False, verbose_name='Download Count')),
                ('download_limit', models.IntegerField(default=5, verbose_name='Download Limit')),
            ],
        ),
        migrations.CreateModel(
            name='Download',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', mezzanine.core.fields.FileField(max_length=255)),
                ('slug', models.SlugField(editable=False, unique=True)),
                ('forms', models.ManyToManyField(related_name='downloads', to='forms.Form')),
                ('products', models.ManyToManyField(related_name='downloads', to='shop.Product')),
            ],
        ),
        migrations.CreateModel(
            name='Promotion',
            fields=[
                ('acquisition_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cartridge_downloads.Acquisition')),
                ('formentry', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, to='forms.FormEntry')),
            ],
            bases=('cartridge_downloads.acquisition',),
        ),
        migrations.CreateModel(
            name='Purchase',
            fields=[
                ('acquisition_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cartridge_downloads.Acquisition')),
                ('order', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, to='shop.Order')),
                ('product', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, to='shop.Product')),
            ],
            bases=('cartridge_downloads.acquisition',),
        ),
    ]
