"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListBalanceTransactionsRequestTypedDict(TypedDict):
    balance_id: str
    r"""Provide the ID of the related balance."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListBalanceTransactionsRequest(BaseModel):
    balance_id: Annotated[
        str,
        pydantic.Field(alias="balanceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related balance."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListBalanceTransactionsBalancesResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListBalanceTransactionsBalancesResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListBalanceTransactionsBalancesResponseLinksTypedDict(TypedDict):
    documentation: ListBalanceTransactionsBalancesResponseDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListBalanceTransactionsBalancesResponseLinks(BaseModel):
    documentation: ListBalanceTransactionsBalancesResponseDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListBalanceTransactionsBalancesResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListBalanceTransactionsBalancesResponseLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class ListBalanceTransactionsBalancesResponseResponseBody(Exception):
    r"""An error response object."""

    data: ListBalanceTransactionsBalancesResponseResponseBodyData

    def __init__(self, data: ListBalanceTransactionsBalancesResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ListBalanceTransactionsBalancesResponseResponseBodyData
        )


class ListBalanceTransactionsBalancesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListBalanceTransactionsBalancesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListBalanceTransactionsBalancesLinksTypedDict(TypedDict):
    documentation: ListBalanceTransactionsBalancesDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListBalanceTransactionsBalancesLinks(BaseModel):
    documentation: ListBalanceTransactionsBalancesDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListBalanceTransactionsBalancesResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListBalanceTransactionsBalancesLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class ListBalanceTransactionsBalancesResponseBody(Exception):
    r"""An error response object."""

    data: ListBalanceTransactionsBalancesResponseBodyData

    def __init__(self, data: ListBalanceTransactionsBalancesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ListBalanceTransactionsBalancesResponseBodyData
        )


class ResultAmountTypedDict(TypedDict):
    r"""The final amount that was moved to or from the balance. If the transaction moves funds away from the balance, for example when it concerns a refund, the amount will be negative."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ResultAmount(BaseModel):
    r"""The final amount that was moved to or from the balance. If the transaction moves funds away from the balance, for example when it concerns a refund, the amount will be negative."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class InitialAmountTypedDict(TypedDict):
    r"""The amount that was to be moved to or from the balance, excluding deductions. If the transaction moves funds away from the balance, for example when it concerns a refund, the amount will be negative."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class InitialAmount(BaseModel):
    r"""The amount that was to be moved to or from the balance, excluding deductions. If the transaction moves funds away from the balance, for example when it concerns a refund, the amount will be negative."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class DeductionsTypedDict(TypedDict):
    r"""The total amount of deductions withheld from the movement. For example, if we charge a €0.29 fee on a €10 payment, the deductions amount will be `{\"currency\":\"EUR\", \"value\":\"-0.29\"}`.

    When moving funds to a balance, we always round the deduction to a 'real' amount. Any differences between these real-time rounded amounts and the final invoice will be compensated when the invoice is generated.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class Deductions(BaseModel):
    r"""The total amount of deductions withheld from the movement. For example, if we charge a €0.29 fee on a €10 payment, the deductions amount will be `{\"currency\":\"EUR\", \"value\":\"-0.29\"}`.

    When moving funds to a balance, we always round the deduction to a 'real' amount. Any differences between these real-time rounded amounts and the final invoice will be compensated when the invoice is generated.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CaptureTypedDict(TypedDict):
    payment_id: NotRequired[str]
    capture_id: NotRequired[str]


class Capture(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    capture_id: Annotated[Optional[str], pydantic.Field(alias="captureId")] = None


class ReturnedRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    refund_id: NotRequired[str]


class ReturnedRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None


class ChargebackTypedDict(TypedDict):
    payment_id: NotRequired[str]
    chargeback_id: NotRequired[str]


class Chargeback(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None


class OutgoingTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class OutgoingTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class CanceledOutgoingTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class CanceledOutgoingTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class ReturnedTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class ReturnedTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class PlatformPaymentRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    refund_id: NotRequired[str]


class PlatformPaymentRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None


class PlatformPaymentChargebackTypedDict(TypedDict):
    payment_id: NotRequired[str]
    chargeback_id: NotRequired[str]


class PlatformPaymentChargeback(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None


class ContextTypedDict(TypedDict):
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that triggered it. For example, the context object for a payment transaction will look like `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`
    * Type `capture`: `paymentId` `captureId`
    * Type `unauthorized-direct-debit`: `paymentId`
    * Type `failed-payment`: `paymentId`
    * Type `refund`: `paymentId` `refundId`
    * Type `returned-refund`: `paymentId` `refundId`
    * Type `chargeback`: `paymentId` `chargebackId`
    * Type `chargeback-reversal`: `paymentId`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`
    * Type `split-payment`: `paymentId`
    * Type `platform-payment-refund`: `paymentId` `refundId`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`
    """

    payment: NotRequired[Nullable[str]]
    capture: NotRequired[Nullable[CaptureTypedDict]]
    unauthorized_direct_debit: NotRequired[Nullable[str]]
    failed_payment: NotRequired[Nullable[str]]
    refund: NotRequired[Nullable[str]]
    returned_refund: NotRequired[Nullable[ReturnedRefundTypedDict]]
    chargeback: NotRequired[Nullable[ChargebackTypedDict]]
    chargeback_reversal: NotRequired[Nullable[str]]
    outgoing_transfer: NotRequired[Nullable[OutgoingTransferTypedDict]]
    canceled_outgoing_transfer: NotRequired[Nullable[CanceledOutgoingTransferTypedDict]]
    returned_transfer: NotRequired[Nullable[ReturnedTransferTypedDict]]
    invoice_compensation: NotRequired[Nullable[str]]
    application_fee: NotRequired[Nullable[str]]
    split_payment: NotRequired[Nullable[str]]
    platform_payment_refund: NotRequired[Nullable[PlatformPaymentRefundTypedDict]]
    platform_payment_chargeback: NotRequired[
        Nullable[PlatformPaymentChargebackTypedDict]
    ]


class Context(BaseModel):
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that triggered it. For example, the context object for a payment transaction will look like `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`
    * Type `capture`: `paymentId` `captureId`
    * Type `unauthorized-direct-debit`: `paymentId`
    * Type `failed-payment`: `paymentId`
    * Type `refund`: `paymentId` `refundId`
    * Type `returned-refund`: `paymentId` `refundId`
    * Type `chargeback`: `paymentId` `chargebackId`
    * Type `chargeback-reversal`: `paymentId`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`
    * Type `split-payment`: `paymentId`
    * Type `platform-payment-refund`: `paymentId` `refundId`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`
    """

    payment: OptionalNullable[str] = UNSET

    capture: OptionalNullable[Capture] = UNSET

    unauthorized_direct_debit: Annotated[
        OptionalNullable[str], pydantic.Field(alias="unauthorized-direct-debit")
    ] = UNSET

    failed_payment: Annotated[
        OptionalNullable[str], pydantic.Field(alias="failed-payment")
    ] = UNSET

    refund: OptionalNullable[str] = UNSET

    returned_refund: Annotated[
        OptionalNullable[ReturnedRefund], pydantic.Field(alias="returned-refund")
    ] = UNSET

    chargeback: OptionalNullable[Chargeback] = UNSET

    chargeback_reversal: Annotated[
        OptionalNullable[str], pydantic.Field(alias="chargeback-reversal")
    ] = UNSET

    outgoing_transfer: Annotated[
        OptionalNullable[OutgoingTransfer], pydantic.Field(alias="outgoing-transfer")
    ] = UNSET

    canceled_outgoing_transfer: Annotated[
        OptionalNullable[CanceledOutgoingTransfer],
        pydantic.Field(alias="canceled-outgoing-transfer"),
    ] = UNSET

    returned_transfer: Annotated[
        OptionalNullable[ReturnedTransfer], pydantic.Field(alias="returned-transfer")
    ] = UNSET

    invoice_compensation: Annotated[
        OptionalNullable[str], pydantic.Field(alias="invoice-compensation")
    ] = UNSET

    application_fee: Annotated[
        OptionalNullable[str], pydantic.Field(alias="application-fee")
    ] = UNSET

    split_payment: Annotated[
        OptionalNullable[str], pydantic.Field(alias="split-payment")
    ] = UNSET

    platform_payment_refund: Annotated[
        OptionalNullable[PlatformPaymentRefund],
        pydantic.Field(alias="platform-payment-refund"),
    ] = UNSET

    platform_payment_chargeback: Annotated[
        OptionalNullable[PlatformPaymentChargeback],
        pydantic.Field(alias="platform-payment-chargeback"),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "payment",
            "capture",
            "unauthorized-direct-debit",
            "failed-payment",
            "refund",
            "returned-refund",
            "chargeback",
            "chargeback-reversal",
            "outgoing-transfer",
            "canceled-outgoing-transfer",
            "returned-transfer",
            "invoice-compensation",
            "application-fee",
            "split-payment",
            "platform-payment-refund",
            "platform-payment-chargeback",
        ]
        nullable_fields = [
            "payment",
            "capture",
            "unauthorized-direct-debit",
            "failed-payment",
            "refund",
            "returned-refund",
            "chargeback",
            "chargeback-reversal",
            "outgoing-transfer",
            "canceled-outgoing-transfer",
            "returned-transfer",
            "invoice-compensation",
            "application-fee",
            "split-payment",
            "platform-payment-refund",
            "platform-payment-chargeback",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BalanceTransactionsTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a balance transaction object. Will always contain the string `balance_transaction` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this balance transaction."""
    type: NotRequired[str]
    r"""The type of transaction, for example `payment` or `refund`. Values include the below examples, although this list is not definitive.

    * Regular payment processing: `payment` `capture` `unauthorized-direct-debit` `failed-payment`
    * Refunds and chargebacks: `refund` `returned-refund` `chargeback` `chargeback-reversal`
    * Settlements: `outgoing-transfer` `canceled-outgoing-transfer` `returned-transfer`
    * Invoicing: `invoice-compensation` `balance-correction`
    * Mollie Connect: `application-fee` `split-payment` `platform-payment-refund` `platform-payment-chargeback`

    Possible values: `application-fee` `capture` `chargeback` `chargeback-reversal` `failed-payment-fee` `failed-payment` `invoice-compensation` `payment` `payment-fee` `payment-commission` `refund` `returned-refund` `returned-transfer` `split-payment` `outgoing-transfer` `capture-commission` `canceled-outgoing-transfer` `incoming-transfer` `api-payment-rolling-reserve-release` `capture-rolling-reserve-release` `reimbursement-fee` `balance-correction` `unauthorized-direct-debit` `bank-charged-failure-fee` `platform-payment-refund` `refund-compensation` `returned-refund-compensation` `returned-platform-payment-refund` `platform-payment-chargeback` `chargeback-compensation` `reversed-platform-payment-chargeback` `reversed-chargeback-compensation` `failed-split-payment-platform` `failed-split-payment-compensation` `cash-advance-repayment` `cash-advance-loan` `platform-connected-organizations-fee` `split-transaction` `managed-fee` `returned-managed-fee` `topup` `balance-reserve` `balance-reserve-return` `movement` `post-payment-split-payment` `cash-collateral-issuance` `cash-collateral-release`
    """
    result_amount: NotRequired[ResultAmountTypedDict]
    r"""The final amount that was moved to or from the balance. If the transaction moves funds away from the balance, for example when it concerns a refund, the amount will be negative."""
    initial_amount: NotRequired[InitialAmountTypedDict]
    r"""The amount that was to be moved to or from the balance, excluding deductions. If the transaction moves funds away from the balance, for example when it concerns a refund, the amount will be negative."""
    deductions: NotRequired[Nullable[DeductionsTypedDict]]
    r"""The total amount of deductions withheld from the movement. For example, if we charge a €0.29 fee on a €10 payment, the deductions amount will be `{\"currency\":\"EUR\", \"value\":\"-0.29\"}`.

    When moving funds to a balance, we always round the deduction to a 'real' amount. Any differences between these real-time rounded amounts and the final invoice will be compensated when the invoice is generated.
    """
    context: NotRequired[ContextTypedDict]
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that triggered it. For example, the context object for a payment transaction will look like `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`
    * Type `capture`: `paymentId` `captureId`
    * Type `unauthorized-direct-debit`: `paymentId`
    * Type `failed-payment`: `paymentId`
    * Type `refund`: `paymentId` `refundId`
    * Type `returned-refund`: `paymentId` `refundId`
    * Type `chargeback`: `paymentId` `chargebackId`
    * Type `chargeback-reversal`: `paymentId`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`
    * Type `split-payment`: `paymentId`
    * Type `platform-payment-refund`: `paymentId` `refundId`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""


class BalanceTransactions(BaseModel):
    resource: Optional[str] = "balance_transaction"
    r"""Indicates the response contains a balance transaction object. Will always contain the string `balance_transaction` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this balance transaction."""

    type: Optional[str] = None
    r"""The type of transaction, for example `payment` or `refund`. Values include the below examples, although this list is not definitive.

    * Regular payment processing: `payment` `capture` `unauthorized-direct-debit` `failed-payment`
    * Refunds and chargebacks: `refund` `returned-refund` `chargeback` `chargeback-reversal`
    * Settlements: `outgoing-transfer` `canceled-outgoing-transfer` `returned-transfer`
    * Invoicing: `invoice-compensation` `balance-correction`
    * Mollie Connect: `application-fee` `split-payment` `platform-payment-refund` `platform-payment-chargeback`

    Possible values: `application-fee` `capture` `chargeback` `chargeback-reversal` `failed-payment-fee` `failed-payment` `invoice-compensation` `payment` `payment-fee` `payment-commission` `refund` `returned-refund` `returned-transfer` `split-payment` `outgoing-transfer` `capture-commission` `canceled-outgoing-transfer` `incoming-transfer` `api-payment-rolling-reserve-release` `capture-rolling-reserve-release` `reimbursement-fee` `balance-correction` `unauthorized-direct-debit` `bank-charged-failure-fee` `platform-payment-refund` `refund-compensation` `returned-refund-compensation` `returned-platform-payment-refund` `platform-payment-chargeback` `chargeback-compensation` `reversed-platform-payment-chargeback` `reversed-chargeback-compensation` `failed-split-payment-platform` `failed-split-payment-compensation` `cash-advance-repayment` `cash-advance-loan` `platform-connected-organizations-fee` `split-transaction` `managed-fee` `returned-managed-fee` `topup` `balance-reserve` `balance-reserve-return` `movement` `post-payment-split-payment` `cash-collateral-issuance` `cash-collateral-release`
    """

    result_amount: Annotated[
        Optional[ResultAmount], pydantic.Field(alias="resultAmount")
    ] = None
    r"""The final amount that was moved to or from the balance. If the transaction moves funds away from the balance, for example when it concerns a refund, the amount will be negative."""

    initial_amount: Annotated[
        Optional[InitialAmount], pydantic.Field(alias="initialAmount")
    ] = None
    r"""The amount that was to be moved to or from the balance, excluding deductions. If the transaction moves funds away from the balance, for example when it concerns a refund, the amount will be negative."""

    deductions: OptionalNullable[Deductions] = UNSET
    r"""The total amount of deductions withheld from the movement. For example, if we charge a €0.29 fee on a €10 payment, the deductions amount will be `{\"currency\":\"EUR\", \"value\":\"-0.29\"}`.

    When moving funds to a balance, we always round the deduction to a 'real' amount. Any differences between these real-time rounded amounts and the final invoice will be compensated when the invoice is generated.
    """

    context: Optional[Context] = None
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that triggered it. For example, the context object for a payment transaction will look like `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`
    * Type `capture`: `paymentId` `captureId`
    * Type `unauthorized-direct-debit`: `paymentId`
    * Type `failed-payment`: `paymentId`
    * Type `refund`: `paymentId` `refundId`
    * Type `returned-refund`: `paymentId` `refundId`
    * Type `chargeback`: `paymentId` `chargebackId`
    * Type `chargeback-reversal`: `paymentId`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`
    * Type `split-payment`: `paymentId`
    * Type `platform-payment-refund`: `paymentId` `refundId`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "type",
            "resultAmount",
            "initialAmount",
            "deductions",
            "context",
            "createdAt",
        ]
        nullable_fields = ["deductions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListBalanceTransactionsEmbeddedTypedDict(TypedDict):
    balance_transactions: NotRequired[List[BalanceTransactionsTypedDict]]
    r"""An array of balance transaction objects."""


class ListBalanceTransactionsEmbedded(BaseModel):
    balance_transactions: Optional[List[BalanceTransactions]] = None
    r"""An array of balance transaction objects."""


class ListBalanceTransactionsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListBalanceTransactionsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListBalanceTransactionsSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListBalanceTransactionsPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListBalanceTransactionsNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListBalanceTransactionsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListBalanceTransactionsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListBalanceTransactionsSelf], pydantic.Field(alias="self")
    ] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListBalanceTransactionsPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListBalanceTransactionsNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListBalanceTransactionsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListBalanceTransactionsResponseBodyTypedDict(TypedDict):
    r"""A list of balance transaction objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListBalanceTransactionsEmbeddedTypedDict]
    links: NotRequired[ListBalanceTransactionsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListBalanceTransactionsResponseBody(BaseModel):
    r"""A list of balance transaction objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListBalanceTransactionsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListBalanceTransactionsLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
