"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class QueryParamAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class QueryParamAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: Annotated[str, FieldMetadata(query=True)]
    r"""A three-character ISO 4217 currency code."""

    value: Annotated[str, FieldMetadata(query=True)]
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsQueryParamInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    ISSUERS = "issuers"


class ListMethodsRequestTypedDict(TypedDict):
    sequence_type: NotRequired[str]
    r"""Set this parameter to `first` to only return the enabled methods that can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """
    locale: NotRequired[str]
    r"""Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language."""
    amount: NotRequired[QueryParamAmountTypedDict]
    r"""If supplied, only payment methods that support the amount and currency are returned.

    Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
    """
    resource: NotRequired[str]
    r"""**⚠️ We no longer recommend using the Orders API. Please refer to the [Payments API](payments-api) instead.**

    Indicate if you will use the result for the [Create order](create-order) or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods that are only available for payments created via the Orders API.

    Possible values: `payments` `orders` (default: `payments`)
    """
    billing_country: NotRequired[str]
    r"""The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used to check whether your customer is eligible for certain payment methods, for example for Klarna.

    Example: `/v2/methods?resource=orders&billingCountry=DE`
    """
    include_wallets: NotRequired[str]
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code to check if they are available on the shoppers device, hence the need to indicate your support.

    Possible values: `applepay`
    """
    order_line_categories: NotRequired[str]
    r"""A comma-separated list of the line categories you support in your checkout.

    Example: `/v2/methods?orderLineCategories=eco,meal`

    Possible values: `eco` `gift` `meal` `sport_culture` `additional` `consume`
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve the payment methods for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    include: NotRequired[Nullable[ListMethodsQueryParamInclude]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListMethodsRequest(BaseModel):
    sequence_type: Annotated[
        Optional[str],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set this parameter to `first` to only return the enabled methods that can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """

    locale: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language."""

    amount: Annotated[
        Optional[QueryParamAmount],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If supplied, only payment methods that support the amount and currency are returned.

    Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
    """

    resource: Annotated[
        Optional[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""**⚠️ We no longer recommend using the Orders API. Please refer to the [Payments API](payments-api) instead.**

    Indicate if you will use the result for the [Create order](create-order) or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods that are only available for payments created via the Orders API.

    Possible values: `payments` `orders` (default: `payments`)
    """

    billing_country: Annotated[
        Optional[str],
        pydantic.Field(alias="billingCountry"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used to check whether your customer is eligible for certain payment methods, for example for Klarna.

    Example: `/v2/methods?resource=orders&billingCountry=DE`
    """

    include_wallets: Annotated[
        Optional[str],
        pydantic.Field(alias="includeWallets"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code to check if they are available on the shoppers device, hence the need to indicate your support.

    Possible values: `applepay`
    """

    order_line_categories: Annotated[
        Optional[str],
        pydantic.Field(alias="orderLineCategories"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A comma-separated list of the line categories you support in your checkout.

    Example: `/v2/methods?orderLineCategories=eco,meal`

    Possible values: `eco` `gift` `meal` `sport_culture` `additional` `consume`
    """

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve the payment methods for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    include: Annotated[
        OptionalNullable[ListMethodsQueryParamInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sequenceType",
            "locale",
            "amount",
            "resource",
            "billingCountry",
            "includeWallets",
            "orderLineCategories",
            "profileId",
            "include",
            "testmode",
        ]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMethodsMethodsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListMethodsMethodsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListMethodsMethodsLinksTypedDict(TypedDict):
    documentation: ListMethodsMethodsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListMethodsMethodsLinks(BaseModel):
    documentation: ListMethodsMethodsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListMethodsMethodsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListMethodsMethodsLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class ListMethodsMethodsResponseBody(Exception):
    r"""An error response object."""

    data: ListMethodsMethodsResponseBodyData

    def __init__(self, data: ListMethodsMethodsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListMethodsMethodsResponseBodyData)


class ListMethodsMinimumAmountTypedDict(TypedDict):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsMinimumAmount(BaseModel):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsMaximumAmountTypedDict(TypedDict):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsMaximumAmount(BaseModel):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class ListMethodsImage(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class ListMethodsMethodsImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class ListMethodsMethodsImage(BaseModel):
    r"""URLs of images representing the issuer."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class ListMethodsIssuersTypedDict(TypedDict):
    resource: NotRequired[str]
    id: NotRequired[str]
    name: NotRequired[str]
    r"""The full name of the issuer."""
    image: NotRequired[ListMethodsMethodsImageTypedDict]
    r"""URLs of images representing the issuer."""


class ListMethodsIssuers(BaseModel):
    resource: Optional[str] = "issuer"

    id: Optional[str] = None

    name: Optional[str] = None
    r"""The full name of the issuer."""

    image: Optional[ListMethodsMethodsImage] = None
    r"""URLs of images representing the issuer."""


class ListMethodsMethodsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsMethodsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsMethodsResponseDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsMethodsResponseDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsMethodsResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListMethodsMethodsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListMethodsMethodsResponseDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsMethodsResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListMethodsMethodsSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListMethodsMethodsResponseDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsMethodsTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this endpoint."""
    id: NotRequired[str]
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment method selection screen will be skipped.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `swish` `trustly` `twint` `voucher`
    """
    description: NotRequired[str]
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: NotRequired[ListMethodsMinimumAmountTypedDict]
    r"""The minimum payment amount required to use this payment method."""
    maximum_amount: NotRequired[Nullable[ListMethodsMaximumAmountTypedDict]]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""
    image: NotRequired[ListMethodsImageTypedDict]
    r"""URLs of images representing the payment method."""
    status: NotRequired[Nullable[str]]
    r"""The payment method's activation status for this profile.

    Possible values: `activated` `pending-boarding` `pending-review` `pending-external` `rejected`
    """
    issuers: NotRequired[List[ListMethodsIssuersTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant for iDEAL, KBC/CBC, gift cards, and vouchers."""
    links: NotRequired[ListMethodsMethodsResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListMethodsMethods(BaseModel):
    resource: Optional[str] = "method"
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this endpoint."""

    id: Optional[str] = None
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment method selection screen will be skipped.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `swish` `trustly` `twint` `voucher`
    """

    description: Optional[str] = None
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[
        Optional[ListMethodsMinimumAmount], pydantic.Field(alias="minimumAmount")
    ] = None
    r"""The minimum payment amount required to use this payment method."""

    maximum_amount: Annotated[
        OptionalNullable[ListMethodsMaximumAmount],
        pydantic.Field(alias="maximumAmount"),
    ] = UNSET
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    image: Optional[ListMethodsImage] = None
    r"""URLs of images representing the payment method."""

    status: OptionalNullable[str] = UNSET
    r"""The payment method's activation status for this profile.

    Possible values: `activated` `pending-boarding` `pending-review` `pending-external` `rejected`
    """

    issuers: Optional[List[ListMethodsIssuers]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant for iDEAL, KBC/CBC, gift cards, and vouchers."""

    links: Annotated[
        Optional[ListMethodsMethodsResponseLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "description",
            "minimumAmount",
            "maximumAmount",
            "image",
            "status",
            "issuers",
            "_links",
        ]
        nullable_fields = ["maximumAmount", "status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmbeddedTypedDict(TypedDict):
    methods: NotRequired[List[ListMethodsMethodsTypedDict]]
    r"""An array of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""


class Embedded(BaseModel):
    methods: Optional[List[ListMethodsMethods]] = None
    r"""An array of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""


class ListMethodsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsLinksTypedDict(TypedDict):
    self_: NotRequired[ListMethodsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListMethodsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsLinks(BaseModel):
    self_: Annotated[Optional[ListMethodsSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListMethodsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsResponseBodyTypedDict(TypedDict):
    r"""A list of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""

    count: NotRequired[int]
    r"""The number of payment method objects in this result set. Results are **not** paginated."""
    embedded: NotRequired[EmbeddedTypedDict]
    links: NotRequired[ListMethodsLinksTypedDict]


class ListMethodsResponseBody(BaseModel):
    r"""A list of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""

    count: Optional[int] = None
    r"""The number of payment method objects in this result set. Results are **not** paginated."""

    embedded: Annotated[Optional[Embedded], pydantic.Field(alias="_embedded")] = None

    links: Annotated[Optional[ListMethodsLinks], pydantic.Field(alias="_links")] = None
