from divinegift import cipher


class Templator:
    def __init__(self):
        # cipher key
        self.cipher_key = b'rKKvXPL7OefUAfscsduYOWdtHHC1V0Mo0n5VgLR19tE='
        # file body
        self.console_template = b'gAAAAABdEY65GbQ2K-5huohanMzfZQG1Ir_eA-2O7WL1IOdco8GwkkDNteB3H-mgcTJ2QD20t7rGZDNWJcCHnb8d4-I63g2rHkwJNeiaRUP6k16e_f2sTq0elh0dzuiWFMYSsoOVAxhpd-4ezfds7-wUaw1_F6Ip08-pe0WnXJSFbHUtgK3j3j0P82kJ6iRBXwI-ap4J-GAIEppS5IvkiO1EePmgf_tQvrcpQRaA-lq6TeSBNDXkO_JzaTqD8Fj-GZTQvJqh8k_VY-Q54ShUq36vr23EKR5IzGeePQnh4OQ9G0S_eucj3vmAWbCcF0wfA2C33dive7fljZpe5b0D7mZwjwTl2TPB3sh_SEBnFB2_Py5ZMFdaVo51gaJfmCdw0KBn3BJN4q1ca4Z6O25GEQMDYQKnZcMVZhtnTfDhphnTx8OV_FaDFPhK8_iY7XNGdGz7eS4_bCsYUkuA1ItBwMWg0cbIqDeBI0VrLGR9O-K3SZ_lXehVru_iOLRTE_GIITddwskEpSH0kExB3jvrF6R6F1x6Fjy34pbkmskYrk5XbeFqpepZvGWKA4F-uyRzwkegAdM2bEtwNSKmsHWfCa2tArfR6xDox0--MMI8TM0R-FN1pldKrcVPyYMdxtDgxAxdLcqBkMr_Rra79smIxqERYVag1tPtd5amP1F89E0Z43Wj1k-LcQwi__BgWBiBktubH7zZRDRPyGrqoiQ5PXjLUZH7csy9aubkJsCmu1R0BKcxmIUX0A0rZgpfSGPta9HohvfouND4Ecz9U8Yx3KI-kHdvTNoHaKQuBQRwdQmFcvtNDGVwpclNxBuqqyJFw8j0zO2Nb-mkqGgpi2kiN9w5eUN9uOrgyv4b4PuOagzrQ1iPc-AfVDc5NPbaDVWXI9HwJGQ9Q_kjqqVtsduMxZs3f-l4RAkhtza-7sKu9-7r0dSKbjqR_wepNyf_-1NsJze5YmufZRccvyNIbtI2KyZAW2v2ewYRQ5GbW8Vp9KV-UnQ6Zp4mqQEuLUm2MVv-bqCuGDK2aLbb4We2WM0ndbqrhdVplcggOsCJNRHx4eouRuTACCADrASIrVU4o_2QJaw33Tp5wftb-xrQQYhyzkYppqJXp08TjP6iNdX2cJ4Oo0ybmZZhKekP8N2jfPu7vxeM90Cmg_YP0e6EdgSexT4jmavuYJKL3zZUbt5_dlSGqQBOC5j_ZHi3DZHVRmbTmbudGHP7D46WUqYj-EHpS8Zam7KJRMqLOZzI-UnOvIiuKsSHLYKAV0KQxpyeyhLPOhJfcpfnRJO3-qPKQxQwt2Mqd9KT0WKCDYi0cSrbPAa-yLCoY-FgkCIuTpWF4VD7OjrKmjVrl5pp4cZyGNu5Pu0IevWpx8KcXv1LWSVR5UEFpy7za2cpwI7EwBnM7Ldh8_pOKhMHWJka81RZvvTJlz-42sddLBgCBuwux1VrLh7XmoTT7G3-7ob32i9KP38oP6ybKolTRrE8NdGsFZHYS5WdMhsfO5hxe_f4KlbH1FWLj54i42w73Y4RU2S2-NFO7PVEwrYuQcwqdh-EG0sJkClYX9arT4v84xAn4KIqWZgBN7iJIv7LndPdGw9O5k4c56ler-H_CJS0e5t9W90vnF7ha1ik_N1ZSFK4YCIBlHcjaEuBCmGa2STWR8mX45Ils_saEQ08tIws402BoPVg1UqIcI5emgWcJYg4Y5Q8HkUs5vGBXwAF3bhferTTJI1izl3dWQuat1FECUvRsnHtL3bgLX3HkZRXEkL2MqlDJ2ws6NTodmeWJdMGR4zl-lLLeVTUBqTyB-8Crl_ztjZrBcs0jPr6S2ONixy_Spt5vrXiF5OUOyg9VKu3xOuZYmfTi8lHkyQnaqtfK-7qQ4IBaNV7DB92aH6oC69zWegf76YHnr6lcJst59X_2T3mAHHSuYq2DflKJN46ZOFIDISGywSWJLSuNYVSHwolfOeQqb1W_1EOYwFbTr9Fe11jSXXv0j6SGyUv3N7uw0JnwTfbN0euAf6dk2CQ7gD104MvqtVv_G_6Xa9vAPGJEqHQhyi8m8CNVIMxnk9VtNfylenolFdp943OnaEU55Ab7jhT2VSnnGKQh1jjIF6uI-D6uHjjnVJupOWR2YQn7wjuNJlsYb9wabmykVAUjohaNO1Tg5oBa7BGAbfjuJAwSs_tk9qDwZLOUgLHgebzIs-0ATcndR7A_C6cUKckMP3i3Aows3UTS5N-m3FGsl7lJqyb6ntnBrvvs4tk5s-IZNTR39zPzLjtcBXRvgCeCn8vOqEpo5_lsIc-_56s7LUHB6VSyOJUFDDFidbfe4ODew32CVxEifV4k49Xf2T-GGRq1vyaBNhI4eXrbgAOouUJsSul9dzMCtIoItNkjlLlrJQfw7KPqL-M6q2Ps3EXOB5IlQWRQ8T_nxjXahhYqh0kuWtJg1vY9loyZNsG7jabviVLw03-AwISrDv0dcDRBR7nEcOATEpEp94G6qKbz2Ck3W2xWTqB7qvvMRWiTzMJOcijwNywlFtPoN9MRg7BTIbqOF6h274BnWJ0I0N5KMSURJKChtmnENt_F80Pkp_gnEz3FH159q3rntxBE5vZ_mpBSyAplqXXdz4rAJqBiJxXww3FegQfkIFwWSfRWkwpN3JSe3-rfuFiPxfX4Wbca-bsowTu4-WEmBo3BjgsypOWzXzACa9kd-ptkhFmFjHOOJhr1ncIbV-PmVLspvSHuFm93vDoUOcnr5AZNPfIhggmGOzIHGAeqxpoYo8506XNnAkFVypJlQqF0cMfGPZj-_-2jQ4TXS6rzlOQStqfnrrDQaSliokayvxB3l98YwB797fHhurkgoKmcri7MkBRlY6uAc47lpU1AqmpegyJ1Ll4Y1OTJrA4hicm3zQPyHh4UfiASZgHCRz7NPo6u-KoDDmcKnlJfTGag6EySb568rE7QyGuSAU3AKGhbM2OPjQVQ1yUclz09pt7RHC5kG0TU5t5PN9XdYXVrGvFF_yn4OflMgcA9HLzaiPhn7jBYbcpWM_23ldUX1GS7_IA6YiPPLv2wvAVyEHn7P9iPq0BUJPzMIUk4cD12yk_7AgOzAFwuij7kCXRENot7qnmSXT-sbb8NfVFNG91dOqyFEOPp0nd6X5jL4R32XylFbDvUL2R7ZHyg1Ubq8gAmP5B0aKucMbzxQAx4CcY7udPgp6oPlt09UuUWwDY7Vk4Mjpg125gddAylycGUuQAoWXaclFVTCPxVdX8uG0nS-BCy2lvfuTxnMZ5Abjoyf6sSWurwqI7YNu4omII1lFlxMXOxGBTOXEXBP6hoNQ3TyZbQBXtY6w='
        self.gui_template = b'gAAAAABcc7gmma_Yb6WFUpFArh0PIh_Kgkk-VGDURE7HRlIp81CwZZVBvozjzyFilBJfSM97lu9f3Ouxs1K06BH710g-W3O-HwehrTvTVGvdPloYKqGsI8wWkvdx7vBP0e-KL1dy1Ld_RuXcR0nrxb57dMIKbgc5EWkLHV82Zal1zapjPdwO0nJYKsmRzIomeDR6JrGvZ3ZOZuD7mxXAWxs9QOSfu7ovDYXpd4Zg1AB9MUrWxVLIn0DmYYb0NrCifS122HgGjyPEqMsPzI2X8bxCp0eD-JCczponz3z1_IT8j7jROLVsSFnFhYjwZmOd7bqoUhZ2_hgRpGFouQlLfgjxvFe62OClMNbkp3mkIiaQNhuTR9lWYyNjOQxtdF6hi8pBix5AvjuH5as4lyzlhHke7nsCrQDba8JGowKNeQxgoqWwDlXwWdHkKyCDSFCUbuFnzLUuq8HnV0t_MoHMtAesIE2lB7kOWdmpMhqwAZYfCX49QOyGm0tSPG1EZAoL3p3ozIlboxKd4aP3pVFJQoi4YIcEWImRQ1dfksYmoE87qvQzSwL6tT2hw_lQ03gOqIKAEP58SiYzTJlMoau5M1qXY1wlgLkmsyP_ql7lOn6PlbkJKcAuSm4XHFdlt5vdUjBipIdJfR0o9OxboIzdnp8QKp_zBmKjrp5hq3Maia-pUZLomnzPxo9_R3waP9ARZNT5kSD4hHM6MkM61cqfEn8ev9hPKsikmjDRdGjPnVVVunHmtMj9P6M5TsXD5-sO7ymFaT_pxul3GuxKZGKSrVGF1ceNWmZtUezvlpjUxYx6-TdjbMgHBWWlpNWi9Ffb2_7L8UwBxBs91BiESBnsYvh9WhnD4czwu8DWoNlPRyEVJuaOWVyZjergqywZTbooXXnLIb_PKwtLfyaaQRxBTiDPuIKWnqZgGaZlXlVNwuo5eYBxuZP059cNBRQxe2oJRzCZ94vIvCBhevwuN7Cdgay8ZviU91cByvPFu8OIQ-Ht2QH9MWc0Zdx8uXh9N9KGUKf_9FaAGSlfNiJBxhh4TmhgnhE9lbLBlSG5u7NyB67AHLzIk6b_EH7KcJjvQT7ZQ2DxLT8sRI7BomDanAbRY7lfZCtC1eC0EMJLMe8troNj4T0C37_PPRLl88QmF7BZwezHi-MeVxnqvTxUJQ2Fa0lmQqwM4DqUr8g9rjQ9WBIJ5mOvLbRPxn_M3xaBaGhH7UKLRSW5hStxZ5eBH1tiD2Xbge_iG_bFPS7O8Onfj5S88XwAHhQOSxBMcbKbIRtgXA9p8GROghvlZClnH0WAWr5YkJ9JJEo_BWofG7dxkdl6Rf_-cuygMFY0dCfSF6HWi6kS4iCgqIjsnUxqax-wS07HV3G6U9Lanq6KVsioaNZvD8OtIHDF42fpjpmHSdH1qu1wRZEYASkZsfe8GtqcW6WvPrMOHVtwTlswF9m64Ua4I22Qch-2UuGXqTL5GZYG53FzLrnziQ24nAmHsmNEpNB-0nXElRDzGfqwHbRDeuM0VatWWQDfJ5KHY_U6_i86XrQspTsz_5W6ozMvjxSs4FrodL8EJ1P7GE2tYLW-bRpmF4w1uFBhHWaRSbuY-blXLVqEzpHRw5JQ_iMF7BSymstldLW18P9e4huOoO9fGNpUwyT38c3LJh6Ffq4NcoIwQK-8RuSEzlGCIi3n84rBSR4M9k-Bvxc9FlPchx8Ya-va-4dHy_EarIIT8i3qnmlAs-Y7OL5SX7q59mixDBOgRjCEWuTQNW8YC4bP29gXFyLbhb76vQs-Oi2o9NyLsKmm5HOPuVtxEDzthBEE4_w9K3GmelDsfEliAG2E4F2uw8S4SprEuxeZRN3sPcX9NiqkdFH5i0lnLpXXx5N3Cqnt5kBk6LWmquRTgVV2DpOUJSU2jzSe21Ez-WhrsNqJeOeqK1HIxYrANSynlOUmmwhOHDii1PsoTTWhMvkn1cLL9PadbB0KjS_RudAIMPCbScWviPRoSMnQnRnYlcYi0FbxDymArj3EN394SHEd0eYHrzVvCYTQ5AtqyTmfQW8z0jNIUiFwARxoBNTkxR5Nn26-22ZL615umNIEA0yKXFRYYj39SGaspuZ_toHu1-kKj0P9-Eh_w9gqI2DZymraD3ADFvFP7rO7e7YMqNHQxVIq_jiRiMiUCBOVfptx_lllEKXCObsk0fx8zj6NCwvf5JGCiwXi5tUTClcMPb9gjcSyLF2wFId7yFb5F5VBz3pD_J3M_LS9m3h_NvMOEbBXHwYPgjyxLHSxTe92v9U2Cbyz5YdFrU0ad1RtVR9S2Tnyw3WX-O4abqBm1wd3tZRPqPHiHCke7Fd07BgpBdiY7LTBl-8lIZNTlAIhca1qVVtI93Y1aTg3nkUBasj9HBj3r60d8GKwZaMCDs05pLlU30jqhVVXhlqPGE87lY1T7ONAl2vDfQDyTRevUD1bB52TMgs_1y5c_v95ODRgZ90VAYQyYPJ9lSAmS2YsW8WatH-T07pbskqgFUvSgOJLKtzSh3ZTL3izeztgZv6fZZKcP1CgW8Fh5sJgX8YcQI91wVE23NSFMbPgtD6I36YFi6a8wX91Of_R7K1165om32djMZvq3rIu4rbr6O8tktVbVJTLAcRTbSNLnkIksrVUlXl4F1A0vkSPLrvuBTZ_yHClcOK3ytYSZbONlgbDXBJwVIw-MKBCXABDSC0oKgvDNCvC5KbTnmslpTA0vZjgI_RgoSRwsb5mY4FlCcccmXY57xzak3_ZpjtjLGtquamIC0Zvd_bHIaYsPtVUnHo4fpnrKJDDsUsJKSPcDipNoUdObXhwfKb3Br8mMSozBzJS1noj0huVRzQiRQaMYyTWPJ6qxO7_5gAnujzrpFxmWCieA4lR_u90Va642RFdFBH-2qlIDdSN9l4cfz7sR-NI2f8kL52xCjhEYPe2Nl00VWwUuLly_CTOWtut3qTukVJSTs-h07UeQHAyE5Hnnndefo_g3XzGLAhjblPK2NERSC5zeXIHnMfXoDYuEHr_V2qdyd9k8p1NZxfjPYVu8aTgPq9NmFXWHj_-EWrync460hDCpreBmZ6rcrCGnZrNzBMSRDqLbAvbl58dcWJLNiwfz7LWg5l0BkAIhLga0INdEP32rIOARNZVQOCNCE963CDKVOd0ewYLO1hHPukLJrruqASFhWkfYobzktOtTLSSZBtYRU2sDZ4oqcq8QUSertAtdl44VchQpo_sy0AfZ9MPg9VVvuObWKc6-lq04LGOYwh7fl0jAaOr_fWEuZh_i7kzFNFsMRXOi7Zvw0hLkJ30mQ5gnpZKp2Txl2qYj7CoH02GKkbeoaH6JQkDz1X_YT0z8y6qrWsYQcWWPCt4zYIXSOK0Yv28PuNfOWrnXMb0SWExBHKK5eCPwRi1fR_HpMu7udPvajCs9IfJE6bm8mYlaX8OGxVSAFfzoi0bTvhY7gup8P_pa5buEUE9AP477shoyg-bhx3zVHMGV7Rr3SJn1L0cBcGci5-GGXSAUSgXVLdq11mu5Tfeplm6LSb3LZNVv87OnaVU9ZFUpI-2ePsH0_-6UeNWE1Z79YCA_vuCg5TIMnip7O71rykxU5NdONqPpVybvWoa98vMcRLzwafbKYzX9t9Bj63TRPrIlkQ8jp09BObL_ZHbtkREjmw0R4V4uPxHAtB7nY9SwA-sF3pdrLr9MoLPlFkIkghjhK-ZqaW8Rn-TvTiab0ygserx5hqAgxMzVT008DnXKAEYXjMixLwWdCOpJgq8cQMQYH1DB7rFMFvuypLNjPG56wo6L-yL8tFGBB0CmzH5nfisvBioGQ=='
        self.config_template = b'gAAAAABdEE7GpP955jsV8csOCa1UMWtBV13p_BjWOlDQ5RzvouIwbWNaSNw8elw4QJzPQPQk7T2sfsQnLawASKPNlHY37xAEqkcqRXZ4UwKTc1--Rte10_UYd8xEyM7Gn5J1PNn5Q29-OZQNqm6Hz9l24cSIDe0IYhl0hhuykAsRbK0RhOYrg3kwsBglPiRqWBO7wAbO9AwyTGnsrcAFadVnFXlCHYeQFkGCq2OWMmG3LqfRJTnQTIT0vz6XqToTL_zHSvZLjLLXsDkEtpn86U8iQxPm2-Tpv59s1wiDEd4ONzk5OzB9dTVA1sMWamQPn6cg46pDWQLz0OMgCGA82nuDyi3yjgrnyFOUhAZHrQ1YelKJiIBZGTu21qVRGYFiDxub4kcmbBY5ZC6_KOiIF9osUBVuAcVbl3PYKU9ORtD1wGmcniILd7c='
        self.email_config_template = b'gAAAAABdEE7kHD-yJ5TK6F8y_eSy2t34s4La0lqL0EvSejeZM-5kNtquX1OOJ5AJwp1lNAtmS5FXpkxwVaKqPOUSuh53aVLoC9n_HPagn86ka1uWcsT9sziVI7VZfNFnT1hcyEEJTIQbH-2BED3oz_H1fKyyZyq0g4WcmOptzg2JW1roYg4hVbLr3TD_iB4vtslzeAUytXMEwq_zMPYiG1Gby8Bbs-6U9AVPG_KwJoPCCSlAaoV_OTc='

        self.cipher = cipher.get_cipher(self.cipher_key)

    def create_file(self, filename: str, text: bytes):
        with open(filename, 'w') as f:
            f.write(cipher.decrypt_str(text, self.cipher))

    def create_console(self, filename: str = 'main.py'):
        if not filename.endswith('.py'):
            filename += '.py'
        self.create_file(filename, self.console_template)

    def create_gui(self, filename: str = 'main_gui.py'):
        if not filename.endswith('.py'):
            filename += '.py'
        self.create_file(filename, self.gui_template)

    def create_config(self, filename: str = 'settings.ini'):
        self.create_file(filename, self.config_template)

    def add_email_config(self, filename: str = 'settings.ini'):
        try:
            with open(filename, 'r') as f:
                text = f.read()
            text += ',\n'
        except:
            text = ''
        text += cipher.decrypt_str(self.email_config_template, self.cipher)
        config_with_email_template = cipher.encrypt_str(text, self.cipher, get_str=False)
        self.create_file(filename, config_with_email_template)


if __name__ == '__main__':
    pass
