# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCrossConnectResult',
    'AwaitableGetCrossConnectResult',
    'get_cross_connect',
    'get_cross_connect_output',
]

@pulumi.output_type
class GetCrossConnectResult:
    """
    A collection of values returned by getCrossConnect.
    """
    def __init__(__self__, compartment_id=None, cross_connect_group_id=None, cross_connect_id=None, customer_reference_name=None, defined_tags=None, display_name=None, far_cross_connect_or_cross_connect_group_id=None, freeform_tags=None, id=None, is_active=None, location_name=None, macsec_properties=None, near_cross_connect_or_cross_connect_group_id=None, oci_logical_device_name=None, oci_physical_device_name=None, port_name=None, port_speed_shape_name=None, state=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cross_connect_group_id and not isinstance(cross_connect_group_id, str):
            raise TypeError("Expected argument 'cross_connect_group_id' to be a str")
        pulumi.set(__self__, "cross_connect_group_id", cross_connect_group_id)
        if cross_connect_id and not isinstance(cross_connect_id, str):
            raise TypeError("Expected argument 'cross_connect_id' to be a str")
        pulumi.set(__self__, "cross_connect_id", cross_connect_id)
        if customer_reference_name and not isinstance(customer_reference_name, str):
            raise TypeError("Expected argument 'customer_reference_name' to be a str")
        pulumi.set(__self__, "customer_reference_name", customer_reference_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if far_cross_connect_or_cross_connect_group_id and not isinstance(far_cross_connect_or_cross_connect_group_id, str):
            raise TypeError("Expected argument 'far_cross_connect_or_cross_connect_group_id' to be a str")
        pulumi.set(__self__, "far_cross_connect_or_cross_connect_group_id", far_cross_connect_or_cross_connect_group_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active and not isinstance(is_active, bool):
            raise TypeError("Expected argument 'is_active' to be a bool")
        pulumi.set(__self__, "is_active", is_active)
        if location_name and not isinstance(location_name, str):
            raise TypeError("Expected argument 'location_name' to be a str")
        pulumi.set(__self__, "location_name", location_name)
        if macsec_properties and not isinstance(macsec_properties, list):
            raise TypeError("Expected argument 'macsec_properties' to be a list")
        pulumi.set(__self__, "macsec_properties", macsec_properties)
        if near_cross_connect_or_cross_connect_group_id and not isinstance(near_cross_connect_or_cross_connect_group_id, str):
            raise TypeError("Expected argument 'near_cross_connect_or_cross_connect_group_id' to be a str")
        pulumi.set(__self__, "near_cross_connect_or_cross_connect_group_id", near_cross_connect_or_cross_connect_group_id)
        if oci_logical_device_name and not isinstance(oci_logical_device_name, str):
            raise TypeError("Expected argument 'oci_logical_device_name' to be a str")
        pulumi.set(__self__, "oci_logical_device_name", oci_logical_device_name)
        if oci_physical_device_name and not isinstance(oci_physical_device_name, str):
            raise TypeError("Expected argument 'oci_physical_device_name' to be a str")
        pulumi.set(__self__, "oci_physical_device_name", oci_physical_device_name)
        if port_name and not isinstance(port_name, str):
            raise TypeError("Expected argument 'port_name' to be a str")
        pulumi.set(__self__, "port_name", port_name)
        if port_speed_shape_name and not isinstance(port_speed_shape_name, str):
            raise TypeError("Expected argument 'port_speed_shape_name' to be a str")
        pulumi.set(__self__, "port_speed_shape_name", port_speed_shape_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the cross-connect group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="crossConnectGroupId")
    def cross_connect_group_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect group this cross-connect belongs to (if any).
        """
        return pulumi.get(self, "cross_connect_group_id")

    @property
    @pulumi.getter(name="crossConnectId")
    def cross_connect_id(self) -> str:
        return pulumi.get(self, "cross_connect_id")

    @property
    @pulumi.getter(name="customerReferenceName")
    def customer_reference_name(self) -> str:
        """
        A reference name or identifier for the physical fiber connection that this cross-connect uses.
        """
        return pulumi.get(self, "customer_reference_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="farCrossConnectOrCrossConnectGroupId")
    def far_cross_connect_or_cross_connect_group_id(self) -> str:
        return pulumi.get(self, "far_cross_connect_or_cross_connect_group_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The cross-connect's Oracle ID (OCID).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> bool:
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> str:
        """
        The name of the FastConnect location where this cross-connect is installed.
        """
        return pulumi.get(self, "location_name")

    @property
    @pulumi.getter(name="macsecProperties")
    def macsec_properties(self) -> Sequence['outputs.GetCrossConnectMacsecPropertyResult']:
        """
        Properties used for MACsec (if capable).
        """
        return pulumi.get(self, "macsec_properties")

    @property
    @pulumi.getter(name="nearCrossConnectOrCrossConnectGroupId")
    def near_cross_connect_or_cross_connect_group_id(self) -> str:
        return pulumi.get(self, "near_cross_connect_or_cross_connect_group_id")

    @property
    @pulumi.getter(name="ociLogicalDeviceName")
    def oci_logical_device_name(self) -> str:
        """
        The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_logical_device_name")

    @property
    @pulumi.getter(name="ociPhysicalDeviceName")
    def oci_physical_device_name(self) -> str:
        """
        The FastConnect device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_physical_device_name")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        A string identifying the meet-me room port for this cross-connect.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="portSpeedShapeName")
    def port_speed_shape_name(self) -> str:
        """
        The port speed for this cross-connect.  Example: `10 Gbps`
        """
        return pulumi.get(self, "port_speed_shape_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The cross-connect's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the cross-connect was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetCrossConnectResult(GetCrossConnectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCrossConnectResult(
            compartment_id=self.compartment_id,
            cross_connect_group_id=self.cross_connect_group_id,
            cross_connect_id=self.cross_connect_id,
            customer_reference_name=self.customer_reference_name,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            far_cross_connect_or_cross_connect_group_id=self.far_cross_connect_or_cross_connect_group_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_active=self.is_active,
            location_name=self.location_name,
            macsec_properties=self.macsec_properties,
            near_cross_connect_or_cross_connect_group_id=self.near_cross_connect_or_cross_connect_group_id,
            oci_logical_device_name=self.oci_logical_device_name,
            oci_physical_device_name=self.oci_physical_device_name,
            port_name=self.port_name,
            port_speed_shape_name=self.port_speed_shape_name,
            state=self.state,
            time_created=self.time_created)


def get_cross_connect(cross_connect_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCrossConnectResult:
    """
    This data source provides details about a specific Cross Connect resource in Oracle Cloud Infrastructure Core service.

    Gets the specified cross-connect's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cross_connect = oci.Core.get_cross_connect(cross_connect_id=test_cross_connect_oci_core_cross_connect["id"])
    ```


    :param str cross_connect_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect.
    """
    __args__ = dict()
    __args__['crossConnectId'] = cross_connect_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getCrossConnect:getCrossConnect', __args__, opts=opts, typ=GetCrossConnectResult).value

    return AwaitableGetCrossConnectResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cross_connect_group_id=pulumi.get(__ret__, 'cross_connect_group_id'),
        cross_connect_id=pulumi.get(__ret__, 'cross_connect_id'),
        customer_reference_name=pulumi.get(__ret__, 'customer_reference_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        far_cross_connect_or_cross_connect_group_id=pulumi.get(__ret__, 'far_cross_connect_or_cross_connect_group_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_active=pulumi.get(__ret__, 'is_active'),
        location_name=pulumi.get(__ret__, 'location_name'),
        macsec_properties=pulumi.get(__ret__, 'macsec_properties'),
        near_cross_connect_or_cross_connect_group_id=pulumi.get(__ret__, 'near_cross_connect_or_cross_connect_group_id'),
        oci_logical_device_name=pulumi.get(__ret__, 'oci_logical_device_name'),
        oci_physical_device_name=pulumi.get(__ret__, 'oci_physical_device_name'),
        port_name=pulumi.get(__ret__, 'port_name'),
        port_speed_shape_name=pulumi.get(__ret__, 'port_speed_shape_name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_cross_connect)
def get_cross_connect_output(cross_connect_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCrossConnectResult]:
    """
    This data source provides details about a specific Cross Connect resource in Oracle Cloud Infrastructure Core service.

    Gets the specified cross-connect's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cross_connect = oci.Core.get_cross_connect(cross_connect_id=test_cross_connect_oci_core_cross_connect["id"])
    ```


    :param str cross_connect_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect.
    """
    ...
