# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousExadataInfrastructuresResult',
    'AwaitableGetAutonomousExadataInfrastructuresResult',
    'get_autonomous_exadata_infrastructures',
    'get_autonomous_exadata_infrastructures_output',
]

@pulumi.output_type
class GetAutonomousExadataInfrastructuresResult:
    """
    A collection of values returned by getAutonomousExadataInfrastructures.
    """
    def __init__(__self__, autonomous_exadata_infrastructures=None, availability_domain=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if autonomous_exadata_infrastructures and not isinstance(autonomous_exadata_infrastructures, list):
            raise TypeError("Expected argument 'autonomous_exadata_infrastructures' to be a list")
        pulumi.set(__self__, "autonomous_exadata_infrastructures", autonomous_exadata_infrastructures)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="autonomousExadataInfrastructures")
    def autonomous_exadata_infrastructures(self) -> Sequence['outputs.GetAutonomousExadataInfrastructuresAutonomousExadataInfrastructureResult']:
        """
        The list of autonomous_exadata_infrastructures.
        """
        return pulumi.get(self, "autonomous_exadata_infrastructures")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The name of the availability domain that the Autonomous Exadata Infrastructure is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the Autonomous Exadata Infrastructure.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousExadataInfrastructuresFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the Autonomous Exadata Infrastructure.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutonomousExadataInfrastructuresResult(GetAutonomousExadataInfrastructuresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousExadataInfrastructuresResult(
            autonomous_exadata_infrastructures=self.autonomous_exadata_infrastructures,
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_autonomous_exadata_infrastructures(availability_domain: Optional[str] = None,
                                           compartment_id: Optional[str] = None,
                                           display_name: Optional[str] = None,
                                           filters: Optional[Sequence[pulumi.InputType['GetAutonomousExadataInfrastructuresFilterArgs']]] = None,
                                           state: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousExadataInfrastructuresResult:
    """
    This data source provides the list of Autonomous Exadata Infrastructures in Oracle Cloud Infrastructure Database service.

    **Deprecated.** Use the [ListCloudExadataInfrastructures](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/ListCloudExadataInfrastructures) operation to list Exadata Infrastructures in the Oracle cloud and the  [ListCloudAutonomousVmClusters](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudAutonomousVmCluster/ListCloudAutonomousVmClusters) operation to list Autonomous Exadata VM clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_exadata_infrastructures = oci.Database.get_autonomous_exadata_infrastructures(compartment_id=compartment_id,
        availability_domain=autonomous_exadata_infrastructure_availability_domain,
        display_name=autonomous_exadata_infrastructure_display_name,
        state=autonomous_exadata_infrastructure_state)
    ```


    :param str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousExadataInfrastructures:getAutonomousExadataInfrastructures', __args__, opts=opts, typ=GetAutonomousExadataInfrastructuresResult).value

    return AwaitableGetAutonomousExadataInfrastructuresResult(
        autonomous_exadata_infrastructures=pulumi.get(__ret__, 'autonomous_exadata_infrastructures'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_autonomous_exadata_infrastructures)
def get_autonomous_exadata_infrastructures_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                                                  compartment_id: Optional[pulumi.Input[str]] = None,
                                                  display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                  filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAutonomousExadataInfrastructuresFilterArgs']]]]] = None,
                                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousExadataInfrastructuresResult]:
    """
    This data source provides the list of Autonomous Exadata Infrastructures in Oracle Cloud Infrastructure Database service.

    **Deprecated.** Use the [ListCloudExadataInfrastructures](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/ListCloudExadataInfrastructures) operation to list Exadata Infrastructures in the Oracle cloud and the  [ListCloudAutonomousVmClusters](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudAutonomousVmCluster/ListCloudAutonomousVmClusters) operation to list Autonomous Exadata VM clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_exadata_infrastructures = oci.Database.get_autonomous_exadata_infrastructures(compartment_id=compartment_id,
        availability_domain=autonomous_exadata_infrastructure_availability_domain,
        display_name=autonomous_exadata_infrastructure_display_name,
        state=autonomous_exadata_infrastructure_state)
    ```


    :param str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    ...
