# coding: utf-8

"""
    Martlet Organization API

    Create/maintain organizations, access keys, addresses and permissions.   # noqa: E501

    OpenAPI spec version: 0.129.0
    Contact: apiteam@bmbix.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bmb_martlet_organization_client.api_client import ApiClient


class AddressesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def activate_access_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """\"create an activation record for this list. Removes any other list's activation record.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_access_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListActivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.activate_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.activate_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def activate_access_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """\"create an activation record for this list. Removes any other list's activation record.\"   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_access_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListActivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activate_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `activate_access_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `activate_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/activation', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListActivationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access_list(self, body, address_id, **kwargs):  # noqa: E501
        """Add an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_list(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessList body: List to add (required)
        :param str address_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_access_list_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_access_list_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def create_access_list_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Add an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_list_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessList body: List to add (required)
        :param str address_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_access_list`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access_list_entry(self, body, address_id, list_id, **kwargs):  # noqa: E501
        """Add an entry to an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_list_entry(body, address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessListEntry body: Entry to add to access list (required)
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_access_list_entry_with_http_info(body, address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_access_list_entry_with_http_info(body, address_id, list_id, **kwargs)  # noqa: E501
            return data

    def create_access_list_entry_with_http_info(self, body, address_id, list_id, **kwargs):  # noqa: E501
        """Add an entry to an access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_list_entry_with_http_info(body, address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessListEntry body: Entry to add to access list (required)
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access_list_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_access_list_entry`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_access_list_entry`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `create_access_list_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_message_processed_receipt(self, body, **kwargs):  # noqa: E501
        """Submit notification that a message has been processed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_message_processed_receipt(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageProcessedReceipt body: Message processed receipt data. (required)
        :return: MessageProcessedReceiptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_message_processed_receipt_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_message_processed_receipt_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_message_processed_receipt_with_http_info(self, body, **kwargs):  # noqa: E501
        """Submit notification that a message has been processed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_message_processed_receipt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageProcessedReceipt body: Message processed receipt data. (required)
        :return: MessageProcessedReceiptResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_message_processed_receipt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_message_processed_receipt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/message-processed-receipts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageProcessedReceiptResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_message_type(self, body, address_id, **kwargs):  # noqa: E501
        """Add a message-type processable by this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_message_type(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageType body: The message_type to add. (required)
        :param str address_id: (required)
        :return: MessageTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_message_type_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_message_type_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def create_message_type_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Add a message-type processable by this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_message_type_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageType body: The message_type to add. (required)
        :param str address_id: (required)
        :return: MessageTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_message_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_message_type`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_message_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-types', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_note(self, body, address_id, **kwargs):  # noqa: E501
        """Add a note for a message connected with this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_note(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageNote body: The note to add. (required)
        :param str address_id: (required)
        :return: MessageNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_note_with_http_info(body, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_note_with_http_info(body, address_id, **kwargs)  # noqa: E501
            return data

    def create_note_with_http_info(self, body, address_id, **kwargs):  # noqa: E501
        """Add a note for a message connected with this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_note_with_http_info(body, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MessageNote body: The note to add. (required)
        :param str address_id: (required)
        :return: MessageNote
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_note" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_note`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_note`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-notes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageNote',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_permission(self, body, organization_id, address_id, **kwargs):  # noqa: E501
        """Grant a permission.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permission(body, organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Permission body: Permission data (required)
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_permission_with_http_info(body, organization_id, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_permission_with_http_info(body, organization_id, address_id, **kwargs)  # noqa: E501
            return data

    def create_permission_with_http_info(self, body, organization_id, address_id, **kwargs):  # noqa: E501
        """Grant a permission.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_permission_with_http_info(body, organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Permission body: Permission data (required)
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_permission`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `create_permission`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `create_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses/{address_id}/permissions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deactivate_access_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete an activation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_access_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListDeactivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deactivate_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.deactivate_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def deactivate_access_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete an activation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_access_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListDeactivationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deactivate_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `deactivate_access_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `deactivate_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/activation', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListDeactivationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete a list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def delete_access_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Delete a list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_access_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `delete_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access_list_entry(self, address_id, list_id, entry_id, **kwargs):  # noqa: E501
        """Delete an access list entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_list_entry(address_id, list_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :param str entry_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_access_list_entry_with_http_info(address_id, list_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_access_list_entry_with_http_info(address_id, list_id, entry_id, **kwargs)  # noqa: E501
            return data

    def delete_access_list_entry_with_http_info(self, address_id, list_id, entry_id, **kwargs):  # noqa: E501
        """Delete an access list entry  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_list_entry_with_http_info(address_id, list_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :param str entry_id: (required)
        :return: AccessListEntryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access_list_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_access_list_entry`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `delete_access_list_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_access_list_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entry_id'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries/{entry_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_message_type(self, address_id, message_type_id, **kwargs):  # noqa: E501
        """Delete a message type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_message_type(address_id, message_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_type_id: (required)
        :return: MessageTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_message_type_with_http_info(address_id, message_type_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_message_type_with_http_info(address_id, message_type_id, **kwargs)  # noqa: E501
            return data

    def delete_message_type_with_http_info(self, address_id, message_type_id, **kwargs):  # noqa: E501
        """Delete a message type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_message_type_with_http_info(address_id, message_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_type_id: (required)
        :return: MessageTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_type_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_message_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_message_type`")  # noqa: E501
        # verify the required parameter 'message_type_id' is set
        if ('message_type_id' not in params or
                params['message_type_id'] is None):
            raise ValueError("Missing the required parameter `message_type_id` when calling `delete_message_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'message_type_id' in params:
            path_params['message_type_id'] = params['message_type_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-types/{message_type_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_permission(self, organization_id, address_id, permission_id, **kwargs):  # noqa: E501
        """Remove a permission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_permission(organization_id, address_id, permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str address_id: (required)
        :param str permission_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_permission_with_http_info(organization_id, address_id, permission_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_permission_with_http_info(organization_id, address_id, permission_id, **kwargs)  # noqa: E501
            return data

    def delete_permission_with_http_info(self, organization_id, address_id, permission_id, **kwargs):  # noqa: E501
        """Remove a permission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_permission_with_http_info(organization_id, address_id, permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str address_id: (required)
        :param str permission_id: (required)
        :return: PermissionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'address_id', 'permission_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `delete_permission`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `delete_permission`")  # noqa: E501
        # verify the required parameter 'permission_id' is set
        if ('permission_id' not in params or
                params['permission_id'] is None):
            raise ValueError("Missing the required parameter `permission_id` when calling `delete_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'permission_id' in params:
            path_params['permission_id'] = params['permission_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses/{address_id}/permissions/{permission_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access_list(self, address_id, list_id, **kwargs):  # noqa: E501
        """get single access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_list(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_access_list_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def get_access_list_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """get single access list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_list_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `get_access_list`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_access_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index(self, organization_id, **kwargs):  # noqa: E501
        """list address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: AddressesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.index_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.index_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def index_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """list address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :return: AddressesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `index`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert(self, body, organization_id, **kwargs):  # noqa: E501
        """Create an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: Address data (required)
        :param str organization_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def insert_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Create an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: Address data (required)
        :param str organization_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `insert`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `insert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_access_list_entries(self, address_id, list_id, **kwargs):  # noqa: E501
        """Get list entries  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_list_entries(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_access_list_entries_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_access_list_entries_with_http_info(address_id, list_id, **kwargs)  # noqa: E501
            return data

    def list_access_list_entries_with_http_info(self, address_id, list_id, **kwargs):  # noqa: E501
        """Get list entries  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_list_entries_with_http_info(address_id, list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str list_id: (required)
        :return: AccessListEntriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'list_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_access_list_entries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_access_list_entries`")  # noqa: E501
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `list_access_list_entries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501
        if 'list_id' in params:
            path_params['list_id'] = params['list_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists/{list_id}/entries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListEntriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_access_lists(self, address_id, **kwargs):  # noqa: E501
        """get access lists for address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_lists(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AccessListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_access_lists_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_access_lists_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_access_lists_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """get access lists for address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_lists_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AccessListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_access_lists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_access_lists`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/access-lists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessListsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_message_processed_receipts(self, organization_id, address_id, **kwargs):  # noqa: E501
        """get processed receipts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_processed_receipts(organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: MessageProcessedReceiptsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_message_processed_receipts_with_http_info(organization_id, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_message_processed_receipts_with_http_info(organization_id, address_id, **kwargs)  # noqa: E501
            return data

    def list_message_processed_receipts_with_http_info(self, organization_id, address_id, **kwargs):  # noqa: E501
        """get processed receipts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_processed_receipts_with_http_info(organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: MessageProcessedReceiptsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_message_processed_receipts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `list_message_processed_receipts`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_message_processed_receipts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/message-processed-receipts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageProcessedReceiptsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_message_types(self, address_id, **kwargs):  # noqa: E501
        """Message types processable by this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_types(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: MessageTypesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_message_types_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_message_types_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_message_types_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Message types processable by this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_message_types_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: MessageTypesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_message_types" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_message_types`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageTypesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_notes(self, address_id, **kwargs):  # noqa: E501
        """Message notes for messages connected with this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_notes(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id:
        :return: MessageNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_notes_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_notes_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def list_notes_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """Message notes for messages connected with this address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_notes_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :param str message_id:
        :return: MessageNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id', 'message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_notes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_notes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []
        if 'message_id' in params:
            query_params.append(('message_id', params['message_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}/message-notes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageNotesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_permissions(self, organization_id, address_id, **kwargs):  # noqa: E501
        """Get the permissions for an organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_permissions(organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: PermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_permissions_with_http_info(organization_id, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_permissions_with_http_info(organization_id, address_id, **kwargs)  # noqa: E501
            return data

    def list_permissions_with_http_info(self, organization_id, address_id, **kwargs):  # noqa: E501
        """Get the permissions for an organization.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_permissions_with_http_info(organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: PermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `list_permissions`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `list_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses/{address_id}/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PermissionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch(self, body, organization_id, address_id, **kwargs):  # noqa: E501
        """Update is_closed or purpose status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch(body, organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: Address patch data (required)
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_with_http_info(body, organization_id, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_with_http_info(body, organization_id, address_id, **kwargs)  # noqa: E501
            return data

    def patch_with_http_info(self, body, organization_id, address_id, **kwargs):  # noqa: E501
        """Update is_closed or purpose status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_with_http_info(body, organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Address body: Address patch data (required)
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `patch`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses/{address_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query(self, body, **kwargs):  # noqa: E501
        """Query addresses  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddressQuery body: Query body (required)
        :return: AddressesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.query_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def query_with_http_info(self, body, **kwargs):  # noqa: E501
        """Query addresses  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddressQuery body: Query body (required)
        :return: AddressesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def select(self, organization_id, address_id, **kwargs):  # noqa: E501
        """get an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select(organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.select_with_http_info(organization_id, address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.select_with_http_info(organization_id, address_id, **kwargs)  # noqa: E501
            return data

    def select_with_http_info(self, organization_id, address_id, **kwargs):  # noqa: E501
        """get an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_with_http_info(organization_id, address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_id: (required)
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method select" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if ('organization_id' not in params or
                params['organization_id'] is None):
            raise ValueError("Missing the required parameter `organization_id` when calling `select`")  # noqa: E501
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `select`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organization_id'] = params['organization_id']  # noqa: E501
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organization_id}/addresses/{address_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def select_address(self, address_id, **kwargs):  # noqa: E501
        """get an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_address(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.select_address_with_http_info(address_id, **kwargs)  # noqa: E501
        else:
            (data) = self.select_address_with_http_info(address_id, **kwargs)  # noqa: E501
            return data

    def select_address_with_http_info(self, address_id, **kwargs):  # noqa: E501
        """get an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.select_address_with_http_info(address_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str address_id: (required)
        :return: AddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['address_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method select_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'address_id' is set
        if ('address_id' not in params or
                params['address_id'] is None):
            raise ValueError("Missing the required parameter `address_id` when calling `select_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'address_id' in params:
            path_params['address_id'] = params['address_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/addresses/{address_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
