import numpy as np
from .. import core as jiminy
from ..dynamics import TrajectoryDataType
from .viewer import Tuple4FType, Viewer
from threading import Thread
from types import TracebackType
from typing import Any, Callable, Sequence

__all__ = ['extract_replay_data_from_log', 'play_logs_data', 'play_logs_files', 'async_play_and_record_logs_files']

ColorType = str | Tuple4FType

class QRLock:
    def __init__(self) -> None: ...
    def acquire(self) -> None: ...
    def release(self) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_value: BaseException | None, traceback: TracebackType | None) -> None: ...

def extract_replay_data_from_log(log_data: dict[str, np.ndarray], robot: jiminy.Robot) -> tuple[TrajectoryDataType, Callable[[float, np.ndarray, np.ndarray], None] | None, dict[str, Any]]: ...
def play_logs_data(robots: Sequence[jiminy.Robot] | jiminy.Robot, logs_data: Sequence[dict[str, np.ndarray]] | dict[str, np.ndarray], **kwargs: Any) -> Sequence[Viewer]: ...
def play_logs_files(logs_files: str | Sequence[str], mesh_path_dir: str | None = None, mesh_package_dirs: Sequence[str] = (), **kwargs: Any) -> Sequence[Viewer]: ...
def async_play_and_record_logs_files(logs_files: str | Sequence[str], enable_replay: bool | None = None, mesh_path_dir: str | None = None, mesh_package_dirs: Sequence[str] = (), **kwargs: Any) -> Thread | None: ...
