

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import asyncio
import platform
from .breez_sdk_common import BitcoinAddressDetails
from .breez_sdk_common import Bolt11InvoiceDetails
from .breez_sdk_common import InputType
from .breez_sdk_common import LnurlPayRequestDetails
from .breez_sdk_common import RestClient
from .breez_sdk_common import SuccessAction
from .breez_sdk_common import SuccessActionProcessed
from .breez_sdk_common import _UniffiConverterTypeBitcoinAddressDetails
from .breez_sdk_common import _UniffiConverterTypeBolt11InvoiceDetails
from .breez_sdk_common import _UniffiConverterTypeInputType
from .breez_sdk_common import _UniffiConverterTypeLnurlPayRequestDetails
from .breez_sdk_common import _UniffiConverterTypeRestClient
from .breez_sdk_common import _UniffiConverterTypeSuccessAction
from .breez_sdk_common import _UniffiConverterTypeSuccessActionProcessed
from .breez_sdk_common import _UniffiRustBuffer as _UniffiRustBufferBitcoinAddressDetails
from .breez_sdk_common import _UniffiRustBuffer as _UniffiRustBufferBolt11InvoiceDetails
from .breez_sdk_common import _UniffiRustBuffer as _UniffiRustBufferInputType
from .breez_sdk_common import _UniffiRustBuffer as _UniffiRustBufferLnurlPayRequestDetails
from .breez_sdk_common import _UniffiRustBuffer as _UniffiRustBufferRestClient
from .breez_sdk_common import _UniffiRustBuffer as _UniffiRustBufferSuccessAction
from .breez_sdk_common import _UniffiRustBuffer as _UniffiRustBufferSuccessActionProcessed

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_spark_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_spark_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_spark_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("breez_sdk_spark_bindings")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 26
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_breez_sdk_spark_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_breez_sdk_spark_checksum_func_default_config() != 62194:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_func_default_storage() != 46285:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_func_init_logging() != 8518:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_func_parse() != 58372:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_get_address_utxos() != 20959:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_get_transaction_hex() != 19571:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_broadcast_transaction() != 61083:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_add_event_listener() != 61844:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_claim_deposit() != 43529:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_disconnect() != 30986:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_get_info() != 6771:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_get_payment() != 11540:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_list_payments() != 16156:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_list_unclaimed_deposits() != 22486:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_lnurl_pay() != 10147:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_lnurl_pay() != 37691:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_receive_payment() != 53300:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_send_payment() != 34185:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_receive_payment() != 36984:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_refund_deposit() != 33646:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_remove_event_listener() != 60980:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_send_payment() != 54349:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_send_payment_internal() != 37855:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_breezsdk_sync_wallet() != 36066:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_build() != 8126:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_chain_service() != 2848:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_lnurl_client() != 61720:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_rest_chain_service() != 56288:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_get_cached_item() != 11423:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_set_cached_item() != 17965:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_list_payments() != 55103:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_insert_payment() != 35649:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_set_payment_metadata() != 780:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_get_payment_by_id() != 32084:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_add_deposit() != 31647:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_delete_deposit() != 19211:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_list_deposits() != 11262:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_storage_update_deposit() != 58400:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_constructor_sdkbuilder_new() != 52744:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_eventlistener_on_event() != 10824:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_spark_checksum_method_logger_log() != 11839:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UNIFFI_CALLBACK_INTERFACE_EVENT_LISTENER_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_LOGGER_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD1 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD2 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD1 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD2 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD3 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD4 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD5 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD6 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.c_uint32,ctypes.c_uint64,_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD7 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.c_uint32,_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD9 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.c_uint32,_UniffiRustBuffer,_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID,ctypes.c_uint64,ctypes.POINTER(_UniffiForeignFuture),
)
class _UniffiVTableCallbackInterfaceEventListener(ctypes.Structure):
    _fields_ = [
        ("on_event", _UNIFFI_CALLBACK_INTERFACE_EVENT_LISTENER_METHOD0),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
class _UniffiVTableCallbackInterfaceLogger(ctypes.Structure):
    _fields_ = [
        ("log", _UNIFFI_CALLBACK_INTERFACE_LOGGER_METHOD0),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
class _UniffiVTableCallbackInterfaceBitcoinChainService(ctypes.Structure):
    _fields_ = [
        ("get_address_utxos", _UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD0),
        ("get_transaction_hex", _UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD1),
        ("broadcast_transaction", _UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD2),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
class _UniffiVTableCallbackInterfaceStorage(ctypes.Structure):
    _fields_ = [
        ("get_cached_item", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD0),
        ("set_cached_item", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD1),
        ("list_payments", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD2),
        ("insert_payment", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD3),
        ("set_payment_metadata", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD4),
        ("get_payment_by_id", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD5),
        ("add_deposit", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD6),
        ("delete_deposit", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD7),
        ("list_deposits", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD8),
        ("update_deposit", _UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD9),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
_UniffiLib.uniffi_breez_sdk_spark_fn_clone_bitcoinchainservice.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_clone_bitcoinchainservice.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_spark_fn_free_bitcoinchainservice.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_free_bitcoinchainservice.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_bitcoinchainservice.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceBitcoinChainService),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_bitcoinchainservice.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_get_address_utxos.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_get_address_utxos.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_get_transaction_hex.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_get_transaction_hex.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_broadcast_transaction.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_broadcast_transaction.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_clone_breezsdk.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_clone_breezsdk.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_spark_fn_free_breezsdk.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_free_breezsdk.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_add_event_listener.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_add_event_listener.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_claim_deposit.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_claim_deposit.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_disconnect.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_disconnect.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_get_info.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_get_info.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_get_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_get_payment.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_list_payments.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_list_payments.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_list_unclaimed_deposits.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_list_unclaimed_deposits.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_lnurl_pay.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_lnurl_pay.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_lnurl_pay.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_lnurl_pay.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_receive_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_receive_payment.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_send_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_send_payment.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_receive_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_receive_payment.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_refund_deposit.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_refund_deposit.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_remove_event_listener.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_remove_event_listener.restype = ctypes.c_int8
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_send_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_send_payment.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_send_payment_internal.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int8,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_send_payment_internal.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_sync_wallet.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_sync_wallet.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_spark_fn_clone_sdkbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_clone_sdkbuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_spark_fn_free_sdkbuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_free_sdkbuilder.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_constructor_sdkbuilder_new.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_constructor_sdkbuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_build.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_build.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_chain_service.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_chain_service.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_lnurl_client.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_lnurl_client.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_rest_chain_service.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_rest_chain_service.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_clone_storage.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_clone_storage.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_spark_fn_free_storage.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_free_storage.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_storage.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceStorage),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_storage.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_get_cached_item.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_get_cached_item.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_set_cached_item.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_set_cached_item.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_list_payments.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_list_payments.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_insert_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_insert_payment.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_set_payment_metadata.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_set_payment_metadata.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_get_payment_by_id.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_get_payment_by_id.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_add_deposit.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint32,
    ctypes.c_uint64,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_add_deposit.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_delete_deposit.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint32,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_delete_deposit.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_list_deposits.argtypes = (
    ctypes.c_void_p,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_list_deposits.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_update_deposit.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_uint32,
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_update_deposit.restype = ctypes.c_uint64
_UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_eventlistener.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceEventListener),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_eventlistener.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_logger.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceLogger),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_logger.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_func_default_config.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_func_default_config.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_spark_fn_func_default_storage.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_func_default_storage.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_spark_fn_func_init_logging.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_spark_fn_func_init_logging.restype = None
_UniffiLib.uniffi_breez_sdk_spark_fn_func_parse.argtypes = (
    _UniffiRustBuffer,
)
_UniffiLib.uniffi_breez_sdk_spark_fn_func_parse.restype = ctypes.c_uint64
_UniffiLib.ffi_breez_sdk_spark_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_spark_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_spark_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rustbuffer_free.restype = None
_UniffiLib.ffi_breez_sdk_spark_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_u8.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_u8.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_i8.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_i8.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_u16.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_u16.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_i16.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_i16.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_u32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_u32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_i32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_i32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_u64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_u64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_i64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_i64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_f32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_f32.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_f64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_f64.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_pointer.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_cancel_void.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_free_void.restype = None
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void.restype = None
_UniffiLib.uniffi_breez_sdk_spark_checksum_func_default_config.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_func_default_config.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_func_default_storage.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_func_default_storage.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_func_init_logging.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_func_init_logging.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_func_parse.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_func_parse.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_get_address_utxos.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_get_address_utxos.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_get_transaction_hex.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_get_transaction_hex.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_broadcast_transaction.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_bitcoinchainservice_broadcast_transaction.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_add_event_listener.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_add_event_listener.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_claim_deposit.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_claim_deposit.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_disconnect.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_disconnect.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_get_info.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_get_info.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_get_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_get_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_list_payments.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_list_payments.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_list_unclaimed_deposits.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_list_unclaimed_deposits.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_lnurl_pay.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_lnurl_pay.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_lnurl_pay.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_lnurl_pay.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_receive_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_receive_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_send_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_prepare_send_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_receive_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_receive_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_refund_deposit.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_refund_deposit.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_remove_event_listener.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_remove_event_listener.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_send_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_send_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_send_payment_internal.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_send_payment_internal.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_sync_wallet.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_breezsdk_sync_wallet.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_build.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_build.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_chain_service.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_chain_service.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_lnurl_client.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_lnurl_client.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_rest_chain_service.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_sdkbuilder_with_rest_chain_service.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_get_cached_item.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_get_cached_item.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_set_cached_item.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_set_cached_item.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_list_payments.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_list_payments.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_insert_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_insert_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_set_payment_metadata.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_set_payment_metadata.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_get_payment_by_id.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_get_payment_by_id.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_add_deposit.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_add_deposit.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_delete_deposit.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_delete_deposit.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_list_deposits.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_list_deposits.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_update_deposit.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_storage_update_deposit.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_constructor_sdkbuilder_new.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_constructor_sdkbuilder_new.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_eventlistener_on_event.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_eventlistener_on_event.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_logger_log.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_spark_checksum_method_logger_log.restype = ctypes.c_uint16
_UniffiLib.ffi_breez_sdk_spark_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_breez_sdk_spark_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write(value, buf):
        buf.write_u64(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class BitcoinChainService(typing.Protocol):
    def get_address_utxos(self, address: "str"):
        raise NotImplementedError
    def get_transaction_hex(self, txid: "str"):
        raise NotImplementedError
    def broadcast_transaction(self, tx: "str"):
        raise NotImplementedError


class BitcoinChainServiceImpl:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_free_bitcoinchainservice, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_clone_bitcoinchainservice, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def get_address_utxos(self, address: "str") -> "typing.List[Utxo]":
        _UniffiConverterString.check_lower(address)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_get_address_utxos(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(address)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypeUtxo.lift,
            
    # Error FFI converter
_UniffiConverterTypeChainServiceError,

        )



    async def get_transaction_hex(self, txid: "str") -> "str":
        _UniffiConverterString.check_lower(txid)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_get_transaction_hex(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(txid)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterString.lift,
            
    # Error FFI converter
_UniffiConverterTypeChainServiceError,

        )



    async def broadcast_transaction(self, tx: "str") -> None:

        _UniffiConverterString.check_lower(tx)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_bitcoinchainservice_broadcast_transaction(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(tx)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter
_UniffiConverterTypeChainServiceError,

        )


# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
_UNIFFI_IDX_CALLBACK_FREE = 0
# Return codes for callback calls
_UNIFFI_CALLBACK_SUCCESS = 0
_UNIFFI_CALLBACK_ERROR = 1
_UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

class _UniffiCallbackInterfaceFfiConverter:
    _handle_map = _UniffiHandleMap()

    @classmethod
    def lift(cls, handle):
        return cls._handle_map.get(handle)

    @classmethod
    def read(cls, buf):
        handle = buf.read_u64()
        cls.lift(handle)

    @classmethod
    def check_lower(cls, cb):
        pass

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.write_u64(cls.lower(cb))

# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplBitcoinChainService:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD0
    def get_address_utxos(
            uniffi_handle,
            address,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeBitcoinChainService._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(address), )
            method = uniffi_obj.get_address_utxos
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiConverterSequenceTypeUtxo.lower(return_value),
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiRustBuffer.default(),
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, ChainServiceError, _UniffiConverterTypeChainServiceError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD1
    def get_transaction_hex(
            uniffi_handle,
            txid,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeBitcoinChainService._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(txid), )
            method = uniffi_obj.get_transaction_hex
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiConverterString.lower(return_value),
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiRustBuffer.default(),
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, ChainServiceError, _UniffiConverterTypeChainServiceError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_BITCOIN_CHAIN_SERVICE_METHOD2
    def broadcast_transaction(
            uniffi_handle,
            tx,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeBitcoinChainService._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(tx), )
            method = uniffi_obj.broadcast_transaction
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, ChainServiceError, _UniffiConverterTypeChainServiceError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeBitcoinChainService._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceBitcoinChainService(
        get_address_utxos,
        get_transaction_hex,
        broadcast_transaction,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_bitcoinchainservice(ctypes.byref(_uniffi_vtable))



class _UniffiConverterTypeBitcoinChainService:
    _handle_map = _UniffiHandleMap()

    @staticmethod
    def lift(value: int):
        return BitcoinChainServiceImpl._make_instance_(value)

    @staticmethod
    def check_lower(value: BitcoinChainService):
        pass

    @staticmethod
    def lower(value: BitcoinChainService):
        return _UniffiConverterTypeBitcoinChainService._handle_map.insert(value)

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: BitcoinChainService, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class BreezSdkProtocol(typing.Protocol):
    """
    `BreezSDK` is a wrapper around `SparkSDK` that provides a more structured API
    with request/response objects and comprehensive error handling.
    """

    def add_event_listener(self, listener: "EventListener"):
        """
        Registers a listener to receive SDK events

        # Arguments

        * `listener` - An implementation of the `EventListener` trait

        # Returns

        A unique identifier for the listener, which can be used to remove it later
        """

        raise NotImplementedError
    def claim_deposit(self, request: "ClaimDepositRequest"):
        raise NotImplementedError
    def disconnect(self, ):
        """
        Stops the SDK's background tasks

        This method stops the background tasks started by the `start()` method.
        It should be called before your application terminates to ensure proper cleanup.

        # Returns

        Result containing either success or an `SdkError` if the background task couldn't be stopped
        """

        raise NotImplementedError
    def get_info(self, request: "GetInfoRequest"):
        """
        Returns the balance of the wallet in satoshis
        """

        raise NotImplementedError
    def get_payment(self, request: "GetPaymentRequest"):
        raise NotImplementedError
    def list_payments(self, request: "ListPaymentsRequest"):
        """
        Lists payments from the storage with pagination

        This method provides direct access to the payment history stored in the database.
        It returns payments in reverse chronological order (newest first).

        # Arguments

        * `request` - Contains pagination parameters (offset and limit)

        # Returns

        * `Ok(ListPaymentsResponse)` - Contains the list of payments if successful
        * `Err(SdkError)` - If there was an error accessing the storage

        """

        raise NotImplementedError
    def list_unclaimed_deposits(self, request: "ListUnclaimedDepositsRequest"):
        raise NotImplementedError
    def lnurl_pay(self, request: "LnurlPayRequest"):
        raise NotImplementedError
    def prepare_lnurl_pay(self, request: "PrepareLnurlPayRequest"):
        raise NotImplementedError
    def prepare_receive_payment(self, request: "PrepareReceivePaymentRequest"):
        raise NotImplementedError
    def prepare_send_payment(self, request: "PrepareSendPaymentRequest"):
        raise NotImplementedError
    def receive_payment(self, request: "ReceivePaymentRequest"):
        raise NotImplementedError
    def refund_deposit(self, request: "RefundDepositRequest"):
        raise NotImplementedError
    def remove_event_listener(self, id: "str"):
        """
        Removes a previously registered event listener

        # Arguments

        * `id` - The listener ID returned from `add_event_listener`

        # Returns

        `true` if the listener was found and removed, `false` otherwise
        """

        raise NotImplementedError
    def send_payment(self, request: "SendPaymentRequest"):
        raise NotImplementedError
    def send_payment_internal(self, request: "SendPaymentRequest",suppress_payment_event: "bool"):
        raise NotImplementedError
    def sync_wallet(self, request: "SyncWalletRequest"):
        """
        Synchronizes the wallet with the Spark network
        """

        raise NotImplementedError


class BreezSdk:
    """
    `BreezSDK` is a wrapper around `SparkSDK` that provides a more structured API
    with request/response objects and comprehensive error handling.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_free_breezsdk, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_clone_breezsdk, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def add_event_listener(self, listener: "EventListener") -> "str":
        """
        Registers a listener to receive SDK events

        # Arguments

        * `listener` - An implementation of the `EventListener` trait

        # Returns

        A unique identifier for the listener, which can be used to remove it later
        """

        _UniffiConverterTypeEventListener.check_lower(listener)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_add_event_listener,self._uniffi_clone_pointer(),
        _UniffiConverterTypeEventListener.lower(listener))
        )




    async def claim_deposit(self, request: "ClaimDepositRequest") -> "ClaimDepositResponse":
        _UniffiConverterTypeClaimDepositRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_claim_deposit(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeClaimDepositRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeClaimDepositResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )




    def disconnect(self, ) -> None:
        """
        Stops the SDK's background tasks

        This method stops the background tasks started by the `start()` method.
        It should be called before your application terminates to ensure proper cleanup.

        # Returns

        Result containing either success or an `SdkError` if the background task couldn't be stopped
        """

        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_disconnect,self._uniffi_clone_pointer(),)





    async def get_info(self, request: "GetInfoRequest") -> "GetInfoResponse":
        """
        Returns the balance of the wallet in satoshis
        """

        _UniffiConverterTypeGetInfoRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_get_info(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeGetInfoRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeGetInfoResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def get_payment(self, request: "GetPaymentRequest") -> "GetPaymentResponse":
        _UniffiConverterTypeGetPaymentRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_get_payment(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeGetPaymentRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeGetPaymentResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def list_payments(self, request: "ListPaymentsRequest") -> "ListPaymentsResponse":
        """
        Lists payments from the storage with pagination

        This method provides direct access to the payment history stored in the database.
        It returns payments in reverse chronological order (newest first).

        # Arguments

        * `request` - Contains pagination parameters (offset and limit)

        # Returns

        * `Ok(ListPaymentsResponse)` - Contains the list of payments if successful
        * `Err(SdkError)` - If there was an error accessing the storage

        """

        _UniffiConverterTypeListPaymentsRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_list_payments(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeListPaymentsRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeListPaymentsResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def list_unclaimed_deposits(self, request: "ListUnclaimedDepositsRequest") -> "ListUnclaimedDepositsResponse":
        _UniffiConverterTypeListUnclaimedDepositsRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_list_unclaimed_deposits(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeListUnclaimedDepositsRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeListUnclaimedDepositsResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def lnurl_pay(self, request: "LnurlPayRequest") -> "LnurlPayResponse":
        _UniffiConverterTypeLnurlPayRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_lnurl_pay(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeLnurlPayRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeLnurlPayResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def prepare_lnurl_pay(self, request: "PrepareLnurlPayRequest") -> "PrepareLnurlPayResponse":
        _UniffiConverterTypePrepareLnurlPayRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_lnurl_pay(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypePrepareLnurlPayRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypePrepareLnurlPayResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )




    def prepare_receive_payment(self, request: "PrepareReceivePaymentRequest") -> "PrepareReceivePaymentResponse":
        _UniffiConverterTypePrepareReceivePaymentRequest.check_lower(request)
        
        return _UniffiConverterTypePrepareReceivePaymentResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_receive_payment,self._uniffi_clone_pointer(),
        _UniffiConverterTypePrepareReceivePaymentRequest.lower(request))
        )




    async def prepare_send_payment(self, request: "PrepareSendPaymentRequest") -> "PrepareSendPaymentResponse":
        _UniffiConverterTypePrepareSendPaymentRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_prepare_send_payment(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypePrepareSendPaymentRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypePrepareSendPaymentResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def receive_payment(self, request: "ReceivePaymentRequest") -> "ReceivePaymentResponse":
        _UniffiConverterTypeReceivePaymentRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_receive_payment(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeReceivePaymentRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeReceivePaymentResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def refund_deposit(self, request: "RefundDepositRequest") -> "RefundDepositResponse":
        _UniffiConverterTypeRefundDepositRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_refund_deposit(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeRefundDepositRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeRefundDepositResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )




    def remove_event_listener(self, id: "str") -> "bool":
        """
        Removes a previously registered event listener

        # Arguments

        * `id` - The listener ID returned from `add_event_listener`

        # Returns

        `true` if the listener was found and removed, `false` otherwise
        """

        _UniffiConverterString.check_lower(id)
        
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_remove_event_listener,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(id))
        )




    async def send_payment(self, request: "SendPaymentRequest") -> "SendPaymentResponse":
        _UniffiConverterTypeSendPaymentRequest.check_lower(request)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_send_payment(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeSendPaymentRequest.lower(request)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeSendPaymentResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def send_payment_internal(self, request: "SendPaymentRequest",suppress_payment_event: "bool") -> "SendPaymentResponse":
        _UniffiConverterTypeSendPaymentRequest.check_lower(request)
        
        _UniffiConverterBool.check_lower(suppress_payment_event)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_send_payment_internal(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeSendPaymentRequest.lower(request),
        _UniffiConverterBool.lower(suppress_payment_event)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypeSendPaymentResponse.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )




    def sync_wallet(self, request: "SyncWalletRequest") -> "SyncWalletResponse":
        """
        Synchronizes the wallet with the Spark network
        """

        _UniffiConverterTypeSyncWalletRequest.check_lower(request)
        
        return _UniffiConverterTypeSyncWalletResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_spark_fn_method_breezsdk_sync_wallet,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSyncWalletRequest.lower(request))
        )






class _UniffiConverterTypeBreezSdk:

    @staticmethod
    def lift(value: int):
        return BreezSdk._make_instance_(value)

    @staticmethod
    def check_lower(value: BreezSdk):
        if not isinstance(value, BreezSdk):
            raise TypeError("Expected BreezSdk instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: BreezSdkProtocol):
        if not isinstance(value, BreezSdk):
            raise TypeError("Expected BreezSdk instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: BreezSdkProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class SdkBuilderProtocol(typing.Protocol):
    """
    Builder for creating `BreezSdk` instances with customizable components.
    """

    def build(self, ):
        """
        Builds the `BreezSdk` instance with the configured components.
        """

        raise NotImplementedError
    def with_chain_service(self, chain_service: "BitcoinChainService"):
        """
        Sets the chain service to be used by the SDK.
        Arguments:
        - `chain_service`: The chain service to be used.
        """

        raise NotImplementedError
    def with_lnurl_client(self, lnurl_client: "RestClient"):
        raise NotImplementedError
    def with_rest_chain_service(self, url: "str",credentials: "typing.Optional[Credentials]"):
        """
        Sets the REST chain service to be used by the SDK.
        Arguments:
        - `url`: The base URL of the REST API.
        - `credentials`: Optional credentials for basic authentication.
        """

        raise NotImplementedError


class SdkBuilder:
    """
    Builder for creating `BreezSdk` instances with customizable components.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, config: "Config",mnemonic: "str",storage: "Storage"):
        """
        Creates a new `SdkBuilder` with the provided configuration.
        Arguments:
        - `config`: The configuration to be used.
        - `mnemonic`: The mnemonic phrase for the wallet.
        - `storage`: The storage backend to be used.
        """

        _UniffiConverterTypeConfig.check_lower(config)
        
        _UniffiConverterString.check_lower(mnemonic)
        
        _UniffiConverterTypeStorage.check_lower(storage)
        
        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_constructor_sdkbuilder_new,
        _UniffiConverterTypeConfig.lower(config),
        _UniffiConverterString.lower(mnemonic),
        _UniffiConverterTypeStorage.lower(storage))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_free_sdkbuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_clone_sdkbuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def build(self, ) -> "BreezSdk":
        """
        Builds the `BreezSdk` instance with the configured components.
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_build(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_pointer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_pointer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_pointer,
            # lift function
            _UniffiConverterTypeBreezSdk.lift,
            
    # Error FFI converter
_UniffiConverterTypeSdkError,

        )



    async def with_chain_service(self, chain_service: "BitcoinChainService") -> None:

        """
        Sets the chain service to be used by the SDK.
        Arguments:
        - `chain_service`: The chain service to be used.
        """

        _UniffiConverterTypeBitcoinChainService.check_lower(chain_service)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_chain_service(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeBitcoinChainService.lower(chain_service)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter

    None,

        )



    async def with_lnurl_client(self, lnurl_client: "RestClient") -> None:

        _UniffiConverterTypeRestClient.check_lower(lnurl_client)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_lnurl_client(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypeRestClient.lower(lnurl_client)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter

    None,

        )



    async def with_rest_chain_service(self, url: "str",credentials: "typing.Optional[Credentials]") -> None:

        """
        Sets the REST chain service to be used by the SDK.
        Arguments:
        - `url`: The base URL of the REST API.
        - `credentials`: Optional credentials for basic authentication.
        """

        _UniffiConverterString.check_lower(url)
        
        _UniffiConverterOptionalTypeCredentials.check_lower(credentials)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_sdkbuilder_with_rest_chain_service(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(url),
        _UniffiConverterOptionalTypeCredentials.lower(credentials)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter

    None,

        )





class _UniffiConverterTypeSdkBuilder:

    @staticmethod
    def lift(value: int):
        return SdkBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: SdkBuilder):
        if not isinstance(value, SdkBuilder):
            raise TypeError("Expected SdkBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: SdkBuilderProtocol):
        if not isinstance(value, SdkBuilder):
            raise TypeError("Expected SdkBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: SdkBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class Storage(typing.Protocol):
    """
    Trait for persistent storage
    """

    def get_cached_item(self, key: "str"):
        raise NotImplementedError
    def set_cached_item(self, key: "str",value: "str"):
        raise NotImplementedError
    def list_payments(self, offset: "typing.Optional[int]",limit: "typing.Optional[int]"):
        """
        Lists payments with pagination

        # Arguments

        * `offset` - Number of records to skip
        * `limit` - Maximum number of records to return

        # Returns

        A vector of payments or a `StorageError`
        """

        raise NotImplementedError
    def insert_payment(self, payment: "Payment"):
        """
        Inserts a payment into storage

        # Arguments

        * `payment` - The payment to insert

        # Returns

        Success or a `StorageError`
        """

        raise NotImplementedError
    def set_payment_metadata(self, payment_id: "str",metadata: "PaymentMetadata"):
        """
        Inserts payment metadata into storage

        # Arguments

        * `payment_id` - The ID of the payment
        * `metadata` - The metadata to insert

        # Returns

        Success or a `StorageError`
        """

        raise NotImplementedError
    def get_payment_by_id(self, id: "str"):
        """
        Gets a payment by its ID
        # Arguments

        * `id` - The ID of the payment to retrieve

        # Returns

        The payment if found or None if not found
        """

        raise NotImplementedError
    def add_deposit(self, txid: "str",vout: "int",amount_sats: "int"):
        """
        Add a deposit to storage
        # Arguments

        * `txid` - The transaction ID of the deposit
        * `vout` - The output index of the deposit
        * `amount_sats` - The amount of the deposit in sats

        # Returns

        Success or a `StorageError`
        """

        raise NotImplementedError
    def delete_deposit(self, txid: "str",vout: "int"):
        """
        Removes an unclaimed deposit from storage
        # Arguments

        * `txid` - The transaction ID of the deposit
        * `vout` - The output index of the deposit

        # Returns

        Success or a `StorageError`
        """

        raise NotImplementedError
    def list_deposits(self, ):
        """
        Lists all unclaimed deposits from storage
        # Returns

        A vector of `DepositInfo` or a `StorageError`
        """

        raise NotImplementedError
    def update_deposit(self, txid: "str",vout: "int",payload: "UpdateDepositPayload"):
        """
        Updates or inserts unclaimed deposit details
        # Arguments

        * `txid` - The transaction ID of the deposit
        * `vout` - The output index of the deposit
        * `payload` - The payload for the update

        # Returns

        Success or a `StorageError`
        """

        raise NotImplementedError


class StorageImpl:
    """
    Trait for persistent storage
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_free_storage, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_clone_storage, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst

    async def get_cached_item(self, key: "str") -> "typing.Optional[str]":
        _UniffiConverterString.check_lower(key)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_get_cached_item(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(key)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterOptionalString.lift,
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def set_cached_item(self, key: "str",value: "str") -> None:

        _UniffiConverterString.check_lower(key)
        
        _UniffiConverterString.check_lower(value)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_set_cached_item(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(key),
        _UniffiConverterString.lower(value)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def list_payments(self, offset: "typing.Optional[int]",limit: "typing.Optional[int]") -> "typing.List[Payment]":
        """
        Lists payments with pagination

        # Arguments

        * `offset` - Number of records to skip
        * `limit` - Maximum number of records to return

        # Returns

        A vector of payments or a `StorageError`
        """

        _UniffiConverterOptionalUInt32.check_lower(offset)
        
        _UniffiConverterOptionalUInt32.check_lower(limit)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_list_payments(
                self._uniffi_clone_pointer(), 
        _UniffiConverterOptionalUInt32.lower(offset),
        _UniffiConverterOptionalUInt32.lower(limit)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypePayment.lift,
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def insert_payment(self, payment: "Payment") -> None:

        """
        Inserts a payment into storage

        # Arguments

        * `payment` - The payment to insert

        # Returns

        Success or a `StorageError`
        """

        _UniffiConverterTypePayment.check_lower(payment)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_insert_payment(
                self._uniffi_clone_pointer(), 
        _UniffiConverterTypePayment.lower(payment)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def set_payment_metadata(self, payment_id: "str",metadata: "PaymentMetadata") -> None:

        """
        Inserts payment metadata into storage

        # Arguments

        * `payment_id` - The ID of the payment
        * `metadata` - The metadata to insert

        # Returns

        Success or a `StorageError`
        """

        _UniffiConverterString.check_lower(payment_id)
        
        _UniffiConverterTypePaymentMetadata.check_lower(metadata)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_set_payment_metadata(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(payment_id),
        _UniffiConverterTypePaymentMetadata.lower(metadata)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def get_payment_by_id(self, id: "str") -> "Payment":
        """
        Gets a payment by its ID
        # Arguments

        * `id` - The ID of the payment to retrieve

        # Returns

        The payment if found or None if not found
        """

        _UniffiConverterString.check_lower(id)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_get_payment_by_id(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(id)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterTypePayment.lift,
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def add_deposit(self, txid: "str",vout: "int",amount_sats: "int") -> None:

        """
        Add a deposit to storage
        # Arguments

        * `txid` - The transaction ID of the deposit
        * `vout` - The output index of the deposit
        * `amount_sats` - The amount of the deposit in sats

        # Returns

        Success or a `StorageError`
        """

        _UniffiConverterString.check_lower(txid)
        
        _UniffiConverterUInt32.check_lower(vout)
        
        _UniffiConverterUInt64.check_lower(amount_sats)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_add_deposit(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(txid),
        _UniffiConverterUInt32.lower(vout),
        _UniffiConverterUInt64.lower(amount_sats)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def delete_deposit(self, txid: "str",vout: "int") -> None:

        """
        Removes an unclaimed deposit from storage
        # Arguments

        * `txid` - The transaction ID of the deposit
        * `vout` - The output index of the deposit

        # Returns

        Success or a `StorageError`
        """

        _UniffiConverterString.check_lower(txid)
        
        _UniffiConverterUInt32.check_lower(vout)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_delete_deposit(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(txid),
        _UniffiConverterUInt32.lower(vout)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def list_deposits(self, ) -> "typing.List[DepositInfo]":
        """
        Lists all unclaimed deposits from storage
        # Returns

        A vector of `DepositInfo` or a `StorageError`
        """

        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_list_deposits(
                self._uniffi_clone_pointer(), 
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
            # lift function
            _UniffiConverterSequenceTypeDepositInfo.lift,
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )



    async def update_deposit(self, txid: "str",vout: "int",payload: "UpdateDepositPayload") -> None:

        """
        Updates or inserts unclaimed deposit details
        # Arguments

        * `txid` - The transaction ID of the deposit
        * `vout` - The output index of the deposit
        * `payload` - The payload for the update

        # Returns

        Success or a `StorageError`
        """

        _UniffiConverterString.check_lower(txid)
        
        _UniffiConverterUInt32.check_lower(vout)
        
        _UniffiConverterTypeUpdateDepositPayload.check_lower(payload)
        
        return await _uniffi_rust_call_async(
            _UniffiLib.uniffi_breez_sdk_spark_fn_method_storage_update_deposit(
                self._uniffi_clone_pointer(), 
        _UniffiConverterString.lower(txid),
        _UniffiConverterUInt32.lower(vout),
        _UniffiConverterTypeUpdateDepositPayload.lower(payload)
            ),
            _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_void,
            _UniffiLib.ffi_breez_sdk_spark_rust_future_free_void,
            # lift function
            lambda val: None,
            
            
    # Error FFI converter
_UniffiConverterTypeStorageError,

        )




# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplStorage:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD0
    def get_cached_item(
            uniffi_handle,
            key,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(key), )
            method = uniffi_obj.get_cached_item
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiConverterOptionalString.lower(return_value),
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiRustBuffer.default(),
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD1
    def set_cached_item(
            uniffi_handle,
            key,
            value,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(key), _UniffiConverterString.lift(value), )
            method = uniffi_obj.set_cached_item
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD2
    def list_payments(
            uniffi_handle,
            offset,
            limit,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterOptionalUInt32.lift(offset), _UniffiConverterOptionalUInt32.lift(limit), )
            method = uniffi_obj.list_payments
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiConverterSequenceTypePayment.lower(return_value),
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiRustBuffer.default(),
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD3
    def insert_payment(
            uniffi_handle,
            payment,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypePayment.lift(payment), )
            method = uniffi_obj.insert_payment
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD4
    def set_payment_metadata(
            uniffi_handle,
            payment_id,
            metadata,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(payment_id), _UniffiConverterTypePaymentMetadata.lift(metadata), )
            method = uniffi_obj.set_payment_metadata
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD5
    def get_payment_by_id(
            uniffi_handle,
            id,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(id), )
            method = uniffi_obj.get_payment_by_id
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiConverterTypePayment.lower(return_value),
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiRustBuffer.default(),
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD6
    def add_deposit(
            uniffi_handle,
            txid,
            vout,
            amount_sats,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(txid), _UniffiConverterUInt32.lift(vout), _UniffiConverterUInt64.lift(amount_sats), )
            method = uniffi_obj.add_deposit
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD7
    def delete_deposit(
            uniffi_handle,
            txid,
            vout,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(txid), _UniffiConverterUInt32.lift(vout), )
            method = uniffi_obj.delete_deposit
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD8
    def list_deposits(
            uniffi_handle,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = ()
            method = uniffi_obj.list_deposits
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiConverterSequenceTypeDepositInfo.lower(return_value),
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructRustBuffer(
                    _UniffiRustBuffer.default(),
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_STORAGE_METHOD9
    def update_deposit(
            uniffi_handle,
            txid,
            vout,
            payload,
            uniffi_future_callback,
            uniffi_callback_data,
            uniffi_out_return,
        ):
        uniffi_obj = _UniffiConverterTypeStorage._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(txid), _UniffiConverterUInt32.lift(vout), _UniffiConverterTypeUpdateDepositPayload.lift(payload), )
            method = uniffi_obj.update_deposit
            return method(*args)

        
        def handle_success(return_value):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus.default()
                )
            )

        def handle_error(status_code, rust_buffer):
            uniffi_future_callback(
                uniffi_callback_data,
                _UniffiForeignFutureStructVoid(
                    _UniffiRustCallStatus(status_code, rust_buffer),
                )
            )
        uniffi_out_return[0] = _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, StorageError, _UniffiConverterTypeStorageError.lower)

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeStorage._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceStorage(
        get_cached_item,
        set_cached_item,
        list_payments,
        insert_payment,
        set_payment_metadata,
        get_payment_by_id,
        add_deposit,
        delete_deposit,
        list_deposits,
        update_deposit,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_storage(ctypes.byref(_uniffi_vtable))



class _UniffiConverterTypeStorage:
    _handle_map = _UniffiHandleMap()

    @staticmethod
    def lift(value: int):
        return StorageImpl._make_instance_(value)

    @staticmethod
    def check_lower(value: Storage):
        pass

    @staticmethod
    def lower(value: Storage):
        return _UniffiConverterTypeStorage._handle_map.insert(value)

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: Storage, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))


class ClaimDepositRequest:
    txid: "str"
    vout: "int"
    max_fee: "typing.Optional[Fee]"
    def __init__(self, *, txid: "str", vout: "int", max_fee: "typing.Optional[Fee]"):
        self.txid = txid
        self.vout = vout
        self.max_fee = max_fee

    def __str__(self):
        return "ClaimDepositRequest(txid={}, vout={}, max_fee={})".format(self.txid, self.vout, self.max_fee)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        if self.max_fee != other.max_fee:
            return False
        return True

class _UniffiConverterTypeClaimDepositRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ClaimDepositRequest(
            txid=_UniffiConverterString.read(buf),
            vout=_UniffiConverterUInt32.read(buf),
            max_fee=_UniffiConverterOptionalTypeFee.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.txid)
        _UniffiConverterUInt32.check_lower(value.vout)
        _UniffiConverterOptionalTypeFee.check_lower(value.max_fee)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.txid, buf)
        _UniffiConverterUInt32.write(value.vout, buf)
        _UniffiConverterOptionalTypeFee.write(value.max_fee, buf)


class ClaimDepositResponse:
    payment: "Payment"
    def __init__(self, *, payment: "Payment"):
        self.payment = payment

    def __str__(self):
        return "ClaimDepositResponse(payment={})".format(self.payment)

    def __eq__(self, other):
        if self.payment != other.payment:
            return False
        return True

class _UniffiConverterTypeClaimDepositResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ClaimDepositResponse(
            payment=_UniffiConverterTypePayment.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePayment.check_lower(value.payment)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePayment.write(value.payment, buf)


class Config:
    api_key: "typing.Optional[str]"
    network: "Network"
    sync_interval_secs: "int"
    max_deposit_claim_fee: "typing.Optional[Fee]"
    def __init__(self, *, api_key: "typing.Optional[str]", network: "Network", sync_interval_secs: "int", max_deposit_claim_fee: "typing.Optional[Fee]"):
        self.api_key = api_key
        self.network = network
        self.sync_interval_secs = sync_interval_secs
        self.max_deposit_claim_fee = max_deposit_claim_fee

    def __str__(self):
        return "Config(api_key={}, network={}, sync_interval_secs={}, max_deposit_claim_fee={})".format(self.api_key, self.network, self.sync_interval_secs, self.max_deposit_claim_fee)

    def __eq__(self, other):
        if self.api_key != other.api_key:
            return False
        if self.network != other.network:
            return False
        if self.sync_interval_secs != other.sync_interval_secs:
            return False
        if self.max_deposit_claim_fee != other.max_deposit_claim_fee:
            return False
        return True

class _UniffiConverterTypeConfig(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Config(
            api_key=_UniffiConverterOptionalString.read(buf),
            network=_UniffiConverterTypeNetwork.read(buf),
            sync_interval_secs=_UniffiConverterUInt32.read(buf),
            max_deposit_claim_fee=_UniffiConverterOptionalTypeFee.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.api_key)
        _UniffiConverterTypeNetwork.check_lower(value.network)
        _UniffiConverterUInt32.check_lower(value.sync_interval_secs)
        _UniffiConverterOptionalTypeFee.check_lower(value.max_deposit_claim_fee)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.api_key, buf)
        _UniffiConverterTypeNetwork.write(value.network, buf)
        _UniffiConverterUInt32.write(value.sync_interval_secs, buf)
        _UniffiConverterOptionalTypeFee.write(value.max_deposit_claim_fee, buf)


class Credentials:
    username: "str"
    password: "str"
    def __init__(self, *, username: "str", password: "str"):
        self.username = username
        self.password = password

    def __str__(self):
        return "Credentials(username={}, password={})".format(self.username, self.password)

    def __eq__(self, other):
        if self.username != other.username:
            return False
        if self.password != other.password:
            return False
        return True

class _UniffiConverterTypeCredentials(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Credentials(
            username=_UniffiConverterString.read(buf),
            password=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.username)
        _UniffiConverterString.check_lower(value.password)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.username, buf)
        _UniffiConverterString.write(value.password, buf)


class DepositInfo:
    txid: "str"
    vout: "int"
    amount_sats: "int"
    refund_tx: "typing.Optional[str]"
    refund_tx_id: "typing.Optional[str]"
    claim_error: "typing.Optional[DepositClaimError]"
    def __init__(self, *, txid: "str", vout: "int", amount_sats: "int", refund_tx: "typing.Optional[str]", refund_tx_id: "typing.Optional[str]", claim_error: "typing.Optional[DepositClaimError]"):
        self.txid = txid
        self.vout = vout
        self.amount_sats = amount_sats
        self.refund_tx = refund_tx
        self.refund_tx_id = refund_tx_id
        self.claim_error = claim_error

    def __str__(self):
        return "DepositInfo(txid={}, vout={}, amount_sats={}, refund_tx={}, refund_tx_id={}, claim_error={})".format(self.txid, self.vout, self.amount_sats, self.refund_tx, self.refund_tx_id, self.claim_error)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        if self.amount_sats != other.amount_sats:
            return False
        if self.refund_tx != other.refund_tx:
            return False
        if self.refund_tx_id != other.refund_tx_id:
            return False
        if self.claim_error != other.claim_error:
            return False
        return True

class _UniffiConverterTypeDepositInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return DepositInfo(
            txid=_UniffiConverterString.read(buf),
            vout=_UniffiConverterUInt32.read(buf),
            amount_sats=_UniffiConverterUInt64.read(buf),
            refund_tx=_UniffiConverterOptionalString.read(buf),
            refund_tx_id=_UniffiConverterOptionalString.read(buf),
            claim_error=_UniffiConverterOptionalTypeDepositClaimError.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.txid)
        _UniffiConverterUInt32.check_lower(value.vout)
        _UniffiConverterUInt64.check_lower(value.amount_sats)
        _UniffiConverterOptionalString.check_lower(value.refund_tx)
        _UniffiConverterOptionalString.check_lower(value.refund_tx_id)
        _UniffiConverterOptionalTypeDepositClaimError.check_lower(value.claim_error)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.txid, buf)
        _UniffiConverterUInt32.write(value.vout, buf)
        _UniffiConverterUInt64.write(value.amount_sats, buf)
        _UniffiConverterOptionalString.write(value.refund_tx, buf)
        _UniffiConverterOptionalString.write(value.refund_tx_id, buf)
        _UniffiConverterOptionalTypeDepositClaimError.write(value.claim_error, buf)


class GetInfoRequest:
    """
    Request to get the balance of the wallet
    """


    def __str__(self):
        return "GetInfoRequest()".format()

    def __eq__(self, other):
        return True

class _UniffiConverterTypeGetInfoRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GetInfoRequest(
        )

    @staticmethod
    def check_lower(value):
        pass

    @staticmethod
    def write(value, buf):
        pass


class GetInfoResponse:
    """
    Response containing the balance of the wallet
    """

    balance_sats: "int"
    """
    The balance in satoshis
    """

    def __init__(self, *, balance_sats: "int"):
        self.balance_sats = balance_sats

    def __str__(self):
        return "GetInfoResponse(balance_sats={})".format(self.balance_sats)

    def __eq__(self, other):
        if self.balance_sats != other.balance_sats:
            return False
        return True

class _UniffiConverterTypeGetInfoResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GetInfoResponse(
            balance_sats=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.balance_sats)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.balance_sats, buf)


class GetPaymentRequest:
    payment_id: "str"
    def __init__(self, *, payment_id: "str"):
        self.payment_id = payment_id

    def __str__(self):
        return "GetPaymentRequest(payment_id={})".format(self.payment_id)

    def __eq__(self, other):
        if self.payment_id != other.payment_id:
            return False
        return True

class _UniffiConverterTypeGetPaymentRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GetPaymentRequest(
            payment_id=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.payment_id)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.payment_id, buf)


class GetPaymentResponse:
    payment: "Payment"
    def __init__(self, *, payment: "Payment"):
        self.payment = payment

    def __str__(self):
        return "GetPaymentResponse(payment={})".format(self.payment)

    def __eq__(self, other):
        if self.payment != other.payment:
            return False
        return True

class _UniffiConverterTypeGetPaymentResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GetPaymentResponse(
            payment=_UniffiConverterTypePayment.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePayment.check_lower(value.payment)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePayment.write(value.payment, buf)


class ListPaymentsRequest:
    """
    Request to list payments with pagination
    """

    offset: "typing.Optional[int]"
    """
    Number of records to skip
    """

    limit: "typing.Optional[int]"
    """
    Maximum number of records to return
    """

    def __init__(self, *, offset: "typing.Optional[int]", limit: "typing.Optional[int]"):
        self.offset = offset
        self.limit = limit

    def __str__(self):
        return "ListPaymentsRequest(offset={}, limit={})".format(self.offset, self.limit)

    def __eq__(self, other):
        if self.offset != other.offset:
            return False
        if self.limit != other.limit:
            return False
        return True

class _UniffiConverterTypeListPaymentsRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ListPaymentsRequest(
            offset=_UniffiConverterOptionalUInt32.read(buf),
            limit=_UniffiConverterOptionalUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalUInt32.check_lower(value.offset)
        _UniffiConverterOptionalUInt32.check_lower(value.limit)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalUInt32.write(value.offset, buf)
        _UniffiConverterOptionalUInt32.write(value.limit, buf)


class ListPaymentsResponse:
    """
    Response from listing payments
    """

    payments: "typing.List[Payment]"
    """
    The list of payments
    """

    def __init__(self, *, payments: "typing.List[Payment]"):
        self.payments = payments

    def __str__(self):
        return "ListPaymentsResponse(payments={})".format(self.payments)

    def __eq__(self, other):
        if self.payments != other.payments:
            return False
        return True

class _UniffiConverterTypeListPaymentsResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ListPaymentsResponse(
            payments=_UniffiConverterSequenceTypePayment.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypePayment.check_lower(value.payments)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypePayment.write(value.payments, buf)


class ListUnclaimedDepositsRequest:

    def __str__(self):
        return "ListUnclaimedDepositsRequest()".format()

    def __eq__(self, other):
        return True

class _UniffiConverterTypeListUnclaimedDepositsRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ListUnclaimedDepositsRequest(
        )

    @staticmethod
    def check_lower(value):
        pass

    @staticmethod
    def write(value, buf):
        pass


class ListUnclaimedDepositsResponse:
    deposits: "typing.List[DepositInfo]"
    def __init__(self, *, deposits: "typing.List[DepositInfo]"):
        self.deposits = deposits

    def __str__(self):
        return "ListUnclaimedDepositsResponse(deposits={})".format(self.deposits)

    def __eq__(self, other):
        if self.deposits != other.deposits:
            return False
        return True

class _UniffiConverterTypeListUnclaimedDepositsResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ListUnclaimedDepositsResponse(
            deposits=_UniffiConverterSequenceTypeDepositInfo.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypeDepositInfo.check_lower(value.deposits)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypeDepositInfo.write(value.deposits, buf)


class LnurlPayInfo:
    """
    Represents the payment LNURL info
    """

    ln_address: "typing.Optional[str]"
    comment: "typing.Optional[str]"
    domain: "typing.Optional[str]"
    metadata: "typing.Optional[str]"
    processed_success_action: "typing.Optional[SuccessActionProcessed]"
    raw_success_action: "typing.Optional[SuccessAction]"
    def __init__(self, *, ln_address: "typing.Optional[str]", comment: "typing.Optional[str]", domain: "typing.Optional[str]", metadata: "typing.Optional[str]", processed_success_action: "typing.Optional[SuccessActionProcessed]", raw_success_action: "typing.Optional[SuccessAction]"):
        self.ln_address = ln_address
        self.comment = comment
        self.domain = domain
        self.metadata = metadata
        self.processed_success_action = processed_success_action
        self.raw_success_action = raw_success_action

    def __str__(self):
        return "LnurlPayInfo(ln_address={}, comment={}, domain={}, metadata={}, processed_success_action={}, raw_success_action={})".format(self.ln_address, self.comment, self.domain, self.metadata, self.processed_success_action, self.raw_success_action)

    def __eq__(self, other):
        if self.ln_address != other.ln_address:
            return False
        if self.comment != other.comment:
            return False
        if self.domain != other.domain:
            return False
        if self.metadata != other.metadata:
            return False
        if self.processed_success_action != other.processed_success_action:
            return False
        if self.raw_success_action != other.raw_success_action:
            return False
        return True

class _UniffiConverterTypeLnurlPayInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnurlPayInfo(
            ln_address=_UniffiConverterOptionalString.read(buf),
            comment=_UniffiConverterOptionalString.read(buf),
            domain=_UniffiConverterOptionalString.read(buf),
            metadata=_UniffiConverterOptionalString.read(buf),
            processed_success_action=_UniffiConverterOptionalTypeSuccessActionProcessed.read(buf),
            raw_success_action=_UniffiConverterOptionalTypeSuccessAction.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.ln_address)
        _UniffiConverterOptionalString.check_lower(value.comment)
        _UniffiConverterOptionalString.check_lower(value.domain)
        _UniffiConverterOptionalString.check_lower(value.metadata)
        _UniffiConverterOptionalTypeSuccessActionProcessed.check_lower(value.processed_success_action)
        _UniffiConverterOptionalTypeSuccessAction.check_lower(value.raw_success_action)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.ln_address, buf)
        _UniffiConverterOptionalString.write(value.comment, buf)
        _UniffiConverterOptionalString.write(value.domain, buf)
        _UniffiConverterOptionalString.write(value.metadata, buf)
        _UniffiConverterOptionalTypeSuccessActionProcessed.write(value.processed_success_action, buf)
        _UniffiConverterOptionalTypeSuccessAction.write(value.raw_success_action, buf)


class LnurlPayRequest:
    prepare_response: "PrepareLnurlPayResponse"
    def __init__(self, *, prepare_response: "PrepareLnurlPayResponse"):
        self.prepare_response = prepare_response

    def __str__(self):
        return "LnurlPayRequest(prepare_response={})".format(self.prepare_response)

    def __eq__(self, other):
        if self.prepare_response != other.prepare_response:
            return False
        return True

class _UniffiConverterTypeLnurlPayRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnurlPayRequest(
            prepare_response=_UniffiConverterTypePrepareLnurlPayResponse.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePrepareLnurlPayResponse.check_lower(value.prepare_response)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePrepareLnurlPayResponse.write(value.prepare_response, buf)


class LnurlPayResponse:
    payment: "Payment"
    success_action: "typing.Optional[SuccessActionProcessed]"
    def __init__(self, *, payment: "Payment", success_action: "typing.Optional[SuccessActionProcessed]"):
        self.payment = payment
        self.success_action = success_action

    def __str__(self):
        return "LnurlPayResponse(payment={}, success_action={})".format(self.payment, self.success_action)

    def __eq__(self, other):
        if self.payment != other.payment:
            return False
        if self.success_action != other.success_action:
            return False
        return True

class _UniffiConverterTypeLnurlPayResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnurlPayResponse(
            payment=_UniffiConverterTypePayment.read(buf),
            success_action=_UniffiConverterOptionalTypeSuccessActionProcessed.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePayment.check_lower(value.payment)
        _UniffiConverterOptionalTypeSuccessActionProcessed.check_lower(value.success_action)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePayment.write(value.payment, buf)
        _UniffiConverterOptionalTypeSuccessActionProcessed.write(value.success_action, buf)


class LogEntry:
    line: "str"
    level: "str"
    def __init__(self, *, line: "str", level: "str"):
        self.line = line
        self.level = level

    def __str__(self):
        return "LogEntry(line={}, level={})".format(self.line, self.level)

    def __eq__(self, other):
        if self.line != other.line:
            return False
        if self.level != other.level:
            return False
        return True

class _UniffiConverterTypeLogEntry(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LogEntry(
            line=_UniffiConverterString.read(buf),
            level=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.line)
        _UniffiConverterString.check_lower(value.level)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.line, buf)
        _UniffiConverterString.write(value.level, buf)


class Payment:
    """
    Represents a payment (sent or received)
    """

    id: "str"
    """
    Unique identifier for the payment
    """

    payment_type: "PaymentType"
    """
    Type of payment (send or receive)
    """

    status: "PaymentStatus"
    """
    Status of the payment
    """

    amount: "int"
    """
    Amount in satoshis
    """

    fees: "int"
    """
    Fee paid in satoshis
    """

    timestamp: "int"
    """
    Timestamp of when the payment was created
    """

    method: "PaymentMethod"
    """
    Method of payment. Sometimes the payment details is empty so this field
    is used to determine the payment method.
    """

    details: "typing.Optional[PaymentDetails]"
    """
    Details of the payment
    """

    def __init__(self, *, id: "str", payment_type: "PaymentType", status: "PaymentStatus", amount: "int", fees: "int", timestamp: "int", method: "PaymentMethod", details: "typing.Optional[PaymentDetails]"):
        self.id = id
        self.payment_type = payment_type
        self.status = status
        self.amount = amount
        self.fees = fees
        self.timestamp = timestamp
        self.method = method
        self.details = details

    def __str__(self):
        return "Payment(id={}, payment_type={}, status={}, amount={}, fees={}, timestamp={}, method={}, details={})".format(self.id, self.payment_type, self.status, self.amount, self.fees, self.timestamp, self.method, self.details)

    def __eq__(self, other):
        if self.id != other.id:
            return False
        if self.payment_type != other.payment_type:
            return False
        if self.status != other.status:
            return False
        if self.amount != other.amount:
            return False
        if self.fees != other.fees:
            return False
        if self.timestamp != other.timestamp:
            return False
        if self.method != other.method:
            return False
        if self.details != other.details:
            return False
        return True

class _UniffiConverterTypePayment(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Payment(
            id=_UniffiConverterString.read(buf),
            payment_type=_UniffiConverterTypePaymentType.read(buf),
            status=_UniffiConverterTypePaymentStatus.read(buf),
            amount=_UniffiConverterUInt64.read(buf),
            fees=_UniffiConverterUInt64.read(buf),
            timestamp=_UniffiConverterUInt64.read(buf),
            method=_UniffiConverterTypePaymentMethod.read(buf),
            details=_UniffiConverterOptionalTypePaymentDetails.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.id)
        _UniffiConverterTypePaymentType.check_lower(value.payment_type)
        _UniffiConverterTypePaymentStatus.check_lower(value.status)
        _UniffiConverterUInt64.check_lower(value.amount)
        _UniffiConverterUInt64.check_lower(value.fees)
        _UniffiConverterUInt64.check_lower(value.timestamp)
        _UniffiConverterTypePaymentMethod.check_lower(value.method)
        _UniffiConverterOptionalTypePaymentDetails.check_lower(value.details)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.id, buf)
        _UniffiConverterTypePaymentType.write(value.payment_type, buf)
        _UniffiConverterTypePaymentStatus.write(value.status, buf)
        _UniffiConverterUInt64.write(value.amount, buf)
        _UniffiConverterUInt64.write(value.fees, buf)
        _UniffiConverterUInt64.write(value.timestamp, buf)
        _UniffiConverterTypePaymentMethod.write(value.method, buf)
        _UniffiConverterOptionalTypePaymentDetails.write(value.details, buf)


class PaymentMetadata:
    """
    Metadata associated with a payment that cannot be extracted from the Spark operator.
    """

    lnurl_pay_info: "typing.Optional[LnurlPayInfo]"
    def __init__(self, *, lnurl_pay_info: "typing.Optional[LnurlPayInfo]"):
        self.lnurl_pay_info = lnurl_pay_info

    def __str__(self):
        return "PaymentMetadata(lnurl_pay_info={})".format(self.lnurl_pay_info)

    def __eq__(self, other):
        if self.lnurl_pay_info != other.lnurl_pay_info:
            return False
        return True

class _UniffiConverterTypePaymentMetadata(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PaymentMetadata(
            lnurl_pay_info=_UniffiConverterOptionalTypeLnurlPayInfo.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalTypeLnurlPayInfo.check_lower(value.lnurl_pay_info)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalTypeLnurlPayInfo.write(value.lnurl_pay_info, buf)


class PrepareLnurlPayRequest:
    amount_sats: "int"
    comment: "typing.Optional[str]"
    pay_request: "LnurlPayRequestDetails"
    validate_success_action_url: "typing.Optional[bool]"
    def __init__(self, *, amount_sats: "int", comment: "typing.Optional[str]", pay_request: "LnurlPayRequestDetails", validate_success_action_url: "typing.Optional[bool]"):
        self.amount_sats = amount_sats
        self.comment = comment
        self.pay_request = pay_request
        self.validate_success_action_url = validate_success_action_url

    def __str__(self):
        return "PrepareLnurlPayRequest(amount_sats={}, comment={}, pay_request={}, validate_success_action_url={})".format(self.amount_sats, self.comment, self.pay_request, self.validate_success_action_url)

    def __eq__(self, other):
        if self.amount_sats != other.amount_sats:
            return False
        if self.comment != other.comment:
            return False
        if self.pay_request != other.pay_request:
            return False
        if self.validate_success_action_url != other.validate_success_action_url:
            return False
        return True

class _UniffiConverterTypePrepareLnurlPayRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareLnurlPayRequest(
            amount_sats=_UniffiConverterUInt64.read(buf),
            comment=_UniffiConverterOptionalString.read(buf),
            pay_request=_UniffiConverterTypeLnurlPayRequestDetails.read(buf),
            validate_success_action_url=_UniffiConverterOptionalBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.amount_sats)
        _UniffiConverterOptionalString.check_lower(value.comment)
        _UniffiConverterTypeLnurlPayRequestDetails.check_lower(value.pay_request)
        _UniffiConverterOptionalBool.check_lower(value.validate_success_action_url)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.amount_sats, buf)
        _UniffiConverterOptionalString.write(value.comment, buf)
        _UniffiConverterTypeLnurlPayRequestDetails.write(value.pay_request, buf)
        _UniffiConverterOptionalBool.write(value.validate_success_action_url, buf)


class PrepareLnurlPayResponse:
    amount_sats: "int"
    comment: "typing.Optional[str]"
    pay_request: "LnurlPayRequestDetails"
    fee_sats: "int"
    invoice_details: "Bolt11InvoiceDetails"
    success_action: "typing.Optional[SuccessAction]"
    def __init__(self, *, amount_sats: "int", comment: "typing.Optional[str]", pay_request: "LnurlPayRequestDetails", fee_sats: "int", invoice_details: "Bolt11InvoiceDetails", success_action: "typing.Optional[SuccessAction]"):
        self.amount_sats = amount_sats
        self.comment = comment
        self.pay_request = pay_request
        self.fee_sats = fee_sats
        self.invoice_details = invoice_details
        self.success_action = success_action

    def __str__(self):
        return "PrepareLnurlPayResponse(amount_sats={}, comment={}, pay_request={}, fee_sats={}, invoice_details={}, success_action={})".format(self.amount_sats, self.comment, self.pay_request, self.fee_sats, self.invoice_details, self.success_action)

    def __eq__(self, other):
        if self.amount_sats != other.amount_sats:
            return False
        if self.comment != other.comment:
            return False
        if self.pay_request != other.pay_request:
            return False
        if self.fee_sats != other.fee_sats:
            return False
        if self.invoice_details != other.invoice_details:
            return False
        if self.success_action != other.success_action:
            return False
        return True

class _UniffiConverterTypePrepareLnurlPayResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareLnurlPayResponse(
            amount_sats=_UniffiConverterUInt64.read(buf),
            comment=_UniffiConverterOptionalString.read(buf),
            pay_request=_UniffiConverterTypeLnurlPayRequestDetails.read(buf),
            fee_sats=_UniffiConverterUInt64.read(buf),
            invoice_details=_UniffiConverterTypeBolt11InvoiceDetails.read(buf),
            success_action=_UniffiConverterOptionalTypeSuccessAction.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.amount_sats)
        _UniffiConverterOptionalString.check_lower(value.comment)
        _UniffiConverterTypeLnurlPayRequestDetails.check_lower(value.pay_request)
        _UniffiConverterUInt64.check_lower(value.fee_sats)
        _UniffiConverterTypeBolt11InvoiceDetails.check_lower(value.invoice_details)
        _UniffiConverterOptionalTypeSuccessAction.check_lower(value.success_action)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.amount_sats, buf)
        _UniffiConverterOptionalString.write(value.comment, buf)
        _UniffiConverterTypeLnurlPayRequestDetails.write(value.pay_request, buf)
        _UniffiConverterUInt64.write(value.fee_sats, buf)
        _UniffiConverterTypeBolt11InvoiceDetails.write(value.invoice_details, buf)
        _UniffiConverterOptionalTypeSuccessAction.write(value.success_action, buf)


class PrepareReceivePaymentRequest:
    payment_method: "ReceivePaymentMethod"
    def __init__(self, *, payment_method: "ReceivePaymentMethod"):
        self.payment_method = payment_method

    def __str__(self):
        return "PrepareReceivePaymentRequest(payment_method={})".format(self.payment_method)

    def __eq__(self, other):
        if self.payment_method != other.payment_method:
            return False
        return True

class _UniffiConverterTypePrepareReceivePaymentRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareReceivePaymentRequest(
            payment_method=_UniffiConverterTypeReceivePaymentMethod.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeReceivePaymentMethod.check_lower(value.payment_method)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeReceivePaymentMethod.write(value.payment_method, buf)


class PrepareReceivePaymentResponse:
    payment_method: "ReceivePaymentMethod"
    fee_sats: "int"
    def __init__(self, *, payment_method: "ReceivePaymentMethod", fee_sats: "int"):
        self.payment_method = payment_method
        self.fee_sats = fee_sats

    def __str__(self):
        return "PrepareReceivePaymentResponse(payment_method={}, fee_sats={})".format(self.payment_method, self.fee_sats)

    def __eq__(self, other):
        if self.payment_method != other.payment_method:
            return False
        if self.fee_sats != other.fee_sats:
            return False
        return True

class _UniffiConverterTypePrepareReceivePaymentResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareReceivePaymentResponse(
            payment_method=_UniffiConverterTypeReceivePaymentMethod.read(buf),
            fee_sats=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeReceivePaymentMethod.check_lower(value.payment_method)
        _UniffiConverterUInt64.check_lower(value.fee_sats)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeReceivePaymentMethod.write(value.payment_method, buf)
        _UniffiConverterUInt64.write(value.fee_sats, buf)


class PrepareSendPaymentRequest:
    payment_request: "str"
    amount_sats: "typing.Optional[int]"
    def __init__(self, *, payment_request: "str", amount_sats: "typing.Optional[int]"):
        self.payment_request = payment_request
        self.amount_sats = amount_sats

    def __str__(self):
        return "PrepareSendPaymentRequest(payment_request={}, amount_sats={})".format(self.payment_request, self.amount_sats)

    def __eq__(self, other):
        if self.payment_request != other.payment_request:
            return False
        if self.amount_sats != other.amount_sats:
            return False
        return True

class _UniffiConverterTypePrepareSendPaymentRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareSendPaymentRequest(
            payment_request=_UniffiConverterString.read(buf),
            amount_sats=_UniffiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.payment_request)
        _UniffiConverterOptionalUInt64.check_lower(value.amount_sats)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.payment_request, buf)
        _UniffiConverterOptionalUInt64.write(value.amount_sats, buf)


class PrepareSendPaymentResponse:
    payment_method: "SendPaymentMethod"
    amount_sats: "int"
    def __init__(self, *, payment_method: "SendPaymentMethod", amount_sats: "int"):
        self.payment_method = payment_method
        self.amount_sats = amount_sats

    def __str__(self):
        return "PrepareSendPaymentResponse(payment_method={}, amount_sats={})".format(self.payment_method, self.amount_sats)

    def __eq__(self, other):
        if self.payment_method != other.payment_method:
            return False
        if self.amount_sats != other.amount_sats:
            return False
        return True

class _UniffiConverterTypePrepareSendPaymentResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareSendPaymentResponse(
            payment_method=_UniffiConverterTypeSendPaymentMethod.read(buf),
            amount_sats=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeSendPaymentMethod.check_lower(value.payment_method)
        _UniffiConverterUInt64.check_lower(value.amount_sats)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeSendPaymentMethod.write(value.payment_method, buf)
        _UniffiConverterUInt64.write(value.amount_sats, buf)


class ReceivePaymentRequest:
    prepare_response: "PrepareReceivePaymentResponse"
    def __init__(self, *, prepare_response: "PrepareReceivePaymentResponse"):
        self.prepare_response = prepare_response

    def __str__(self):
        return "ReceivePaymentRequest(prepare_response={})".format(self.prepare_response)

    def __eq__(self, other):
        if self.prepare_response != other.prepare_response:
            return False
        return True

class _UniffiConverterTypeReceivePaymentRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ReceivePaymentRequest(
            prepare_response=_UniffiConverterTypePrepareReceivePaymentResponse.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePrepareReceivePaymentResponse.check_lower(value.prepare_response)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePrepareReceivePaymentResponse.write(value.prepare_response, buf)


class ReceivePaymentResponse:
    payment_request: "str"
    def __init__(self, *, payment_request: "str"):
        self.payment_request = payment_request

    def __str__(self):
        return "ReceivePaymentResponse(payment_request={})".format(self.payment_request)

    def __eq__(self, other):
        if self.payment_request != other.payment_request:
            return False
        return True

class _UniffiConverterTypeReceivePaymentResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ReceivePaymentResponse(
            payment_request=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.payment_request)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.payment_request, buf)


class RefundDepositRequest:
    txid: "str"
    vout: "int"
    destination_address: "str"
    fee: "Fee"
    def __init__(self, *, txid: "str", vout: "int", destination_address: "str", fee: "Fee"):
        self.txid = txid
        self.vout = vout
        self.destination_address = destination_address
        self.fee = fee

    def __str__(self):
        return "RefundDepositRequest(txid={}, vout={}, destination_address={}, fee={})".format(self.txid, self.vout, self.destination_address, self.fee)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        if self.destination_address != other.destination_address:
            return False
        if self.fee != other.fee:
            return False
        return True

class _UniffiConverterTypeRefundDepositRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RefundDepositRequest(
            txid=_UniffiConverterString.read(buf),
            vout=_UniffiConverterUInt32.read(buf),
            destination_address=_UniffiConverterString.read(buf),
            fee=_UniffiConverterTypeFee.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.txid)
        _UniffiConverterUInt32.check_lower(value.vout)
        _UniffiConverterString.check_lower(value.destination_address)
        _UniffiConverterTypeFee.check_lower(value.fee)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.txid, buf)
        _UniffiConverterUInt32.write(value.vout, buf)
        _UniffiConverterString.write(value.destination_address, buf)
        _UniffiConverterTypeFee.write(value.fee, buf)


class RefundDepositResponse:
    tx_id: "str"
    tx_hex: "str"
    def __init__(self, *, tx_id: "str", tx_hex: "str"):
        self.tx_id = tx_id
        self.tx_hex = tx_hex

    def __str__(self):
        return "RefundDepositResponse(tx_id={}, tx_hex={})".format(self.tx_id, self.tx_hex)

    def __eq__(self, other):
        if self.tx_id != other.tx_id:
            return False
        if self.tx_hex != other.tx_hex:
            return False
        return True

class _UniffiConverterTypeRefundDepositResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RefundDepositResponse(
            tx_id=_UniffiConverterString.read(buf),
            tx_hex=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.tx_id)
        _UniffiConverterString.check_lower(value.tx_hex)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.tx_id, buf)
        _UniffiConverterString.write(value.tx_hex, buf)


class SendOnchainFeeQuote:
    id: "str"
    expires_at: "int"
    speed_fast: "SendOnchainSpeedFeeQuote"
    speed_medium: "SendOnchainSpeedFeeQuote"
    speed_slow: "SendOnchainSpeedFeeQuote"
    def __init__(self, *, id: "str", expires_at: "int", speed_fast: "SendOnchainSpeedFeeQuote", speed_medium: "SendOnchainSpeedFeeQuote", speed_slow: "SendOnchainSpeedFeeQuote"):
        self.id = id
        self.expires_at = expires_at
        self.speed_fast = speed_fast
        self.speed_medium = speed_medium
        self.speed_slow = speed_slow

    def __str__(self):
        return "SendOnchainFeeQuote(id={}, expires_at={}, speed_fast={}, speed_medium={}, speed_slow={})".format(self.id, self.expires_at, self.speed_fast, self.speed_medium, self.speed_slow)

    def __eq__(self, other):
        if self.id != other.id:
            return False
        if self.expires_at != other.expires_at:
            return False
        if self.speed_fast != other.speed_fast:
            return False
        if self.speed_medium != other.speed_medium:
            return False
        if self.speed_slow != other.speed_slow:
            return False
        return True

class _UniffiConverterTypeSendOnchainFeeQuote(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SendOnchainFeeQuote(
            id=_UniffiConverterString.read(buf),
            expires_at=_UniffiConverterUInt64.read(buf),
            speed_fast=_UniffiConverterTypeSendOnchainSpeedFeeQuote.read(buf),
            speed_medium=_UniffiConverterTypeSendOnchainSpeedFeeQuote.read(buf),
            speed_slow=_UniffiConverterTypeSendOnchainSpeedFeeQuote.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.id)
        _UniffiConverterUInt64.check_lower(value.expires_at)
        _UniffiConverterTypeSendOnchainSpeedFeeQuote.check_lower(value.speed_fast)
        _UniffiConverterTypeSendOnchainSpeedFeeQuote.check_lower(value.speed_medium)
        _UniffiConverterTypeSendOnchainSpeedFeeQuote.check_lower(value.speed_slow)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.id, buf)
        _UniffiConverterUInt64.write(value.expires_at, buf)
        _UniffiConverterTypeSendOnchainSpeedFeeQuote.write(value.speed_fast, buf)
        _UniffiConverterTypeSendOnchainSpeedFeeQuote.write(value.speed_medium, buf)
        _UniffiConverterTypeSendOnchainSpeedFeeQuote.write(value.speed_slow, buf)


class SendOnchainSpeedFeeQuote:
    user_fee_sat: "int"
    l1_broadcast_fee_sat: "int"
    def __init__(self, *, user_fee_sat: "int", l1_broadcast_fee_sat: "int"):
        self.user_fee_sat = user_fee_sat
        self.l1_broadcast_fee_sat = l1_broadcast_fee_sat

    def __str__(self):
        return "SendOnchainSpeedFeeQuote(user_fee_sat={}, l1_broadcast_fee_sat={})".format(self.user_fee_sat, self.l1_broadcast_fee_sat)

    def __eq__(self, other):
        if self.user_fee_sat != other.user_fee_sat:
            return False
        if self.l1_broadcast_fee_sat != other.l1_broadcast_fee_sat:
            return False
        return True

class _UniffiConverterTypeSendOnchainSpeedFeeQuote(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SendOnchainSpeedFeeQuote(
            user_fee_sat=_UniffiConverterUInt64.read(buf),
            l1_broadcast_fee_sat=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.user_fee_sat)
        _UniffiConverterUInt64.check_lower(value.l1_broadcast_fee_sat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.user_fee_sat, buf)
        _UniffiConverterUInt64.write(value.l1_broadcast_fee_sat, buf)


class SendPaymentRequest:
    prepare_response: "PrepareSendPaymentResponse"
    options: "typing.Optional[SendPaymentOptions]"
    def __init__(self, *, prepare_response: "PrepareSendPaymentResponse", options: "typing.Optional[SendPaymentOptions]"):
        self.prepare_response = prepare_response
        self.options = options

    def __str__(self):
        return "SendPaymentRequest(prepare_response={}, options={})".format(self.prepare_response, self.options)

    def __eq__(self, other):
        if self.prepare_response != other.prepare_response:
            return False
        if self.options != other.options:
            return False
        return True

class _UniffiConverterTypeSendPaymentRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SendPaymentRequest(
            prepare_response=_UniffiConverterTypePrepareSendPaymentResponse.read(buf),
            options=_UniffiConverterOptionalTypeSendPaymentOptions.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePrepareSendPaymentResponse.check_lower(value.prepare_response)
        _UniffiConverterOptionalTypeSendPaymentOptions.check_lower(value.options)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePrepareSendPaymentResponse.write(value.prepare_response, buf)
        _UniffiConverterOptionalTypeSendPaymentOptions.write(value.options, buf)


class SendPaymentResponse:
    payment: "Payment"
    def __init__(self, *, payment: "Payment"):
        self.payment = payment

    def __str__(self):
        return "SendPaymentResponse(payment={})".format(self.payment)

    def __eq__(self, other):
        if self.payment != other.payment:
            return False
        return True

class _UniffiConverterTypeSendPaymentResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SendPaymentResponse(
            payment=_UniffiConverterTypePayment.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePayment.check_lower(value.payment)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePayment.write(value.payment, buf)


class SyncWalletRequest:
    """
    Request to sync the wallet with the Spark network
    """


    def __str__(self):
        return "SyncWalletRequest()".format()

    def __eq__(self, other):
        return True

class _UniffiConverterTypeSyncWalletRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SyncWalletRequest(
        )

    @staticmethod
    def check_lower(value):
        pass

    @staticmethod
    def write(value, buf):
        pass


class SyncWalletResponse:
    """
    Response from synchronizing the wallet
    """


    def __str__(self):
        return "SyncWalletResponse()".format()

    def __eq__(self, other):
        return True

class _UniffiConverterTypeSyncWalletResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SyncWalletResponse(
        )

    @staticmethod
    def check_lower(value):
        pass

    @staticmethod
    def write(value, buf):
        pass


class TxStatus:
    confirmed: "bool"
    block_height: "typing.Optional[int]"
    block_time: "typing.Optional[int]"
    def __init__(self, *, confirmed: "bool", block_height: "typing.Optional[int]", block_time: "typing.Optional[int]"):
        self.confirmed = confirmed
        self.block_height = block_height
        self.block_time = block_time

    def __str__(self):
        return "TxStatus(confirmed={}, block_height={}, block_time={})".format(self.confirmed, self.block_height, self.block_time)

    def __eq__(self, other):
        if self.confirmed != other.confirmed:
            return False
        if self.block_height != other.block_height:
            return False
        if self.block_time != other.block_time:
            return False
        return True

class _UniffiConverterTypeTxStatus(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return TxStatus(
            confirmed=_UniffiConverterBool.read(buf),
            block_height=_UniffiConverterOptionalUInt32.read(buf),
            block_time=_UniffiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterBool.check_lower(value.confirmed)
        _UniffiConverterOptionalUInt32.check_lower(value.block_height)
        _UniffiConverterOptionalUInt64.check_lower(value.block_time)

    @staticmethod
    def write(value, buf):
        _UniffiConverterBool.write(value.confirmed, buf)
        _UniffiConverterOptionalUInt32.write(value.block_height, buf)
        _UniffiConverterOptionalUInt64.write(value.block_time, buf)


class Utxo:
    txid: "str"
    vout: "int"
    value: "int"
    status: "TxStatus"
    def __init__(self, *, txid: "str", vout: "int", value: "int", status: "TxStatus"):
        self.txid = txid
        self.vout = vout
        self.value = value
        self.status = status

    def __str__(self):
        return "Utxo(txid={}, vout={}, value={}, status={})".format(self.txid, self.vout, self.value, self.status)

    def __eq__(self, other):
        if self.txid != other.txid:
            return False
        if self.vout != other.vout:
            return False
        if self.value != other.value:
            return False
        if self.status != other.status:
            return False
        return True

class _UniffiConverterTypeUtxo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Utxo(
            txid=_UniffiConverterString.read(buf),
            vout=_UniffiConverterUInt32.read(buf),
            value=_UniffiConverterUInt64.read(buf),
            status=_UniffiConverterTypeTxStatus.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.txid)
        _UniffiConverterUInt32.check_lower(value.vout)
        _UniffiConverterUInt64.check_lower(value.value)
        _UniffiConverterTypeTxStatus.check_lower(value.status)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.txid, buf)
        _UniffiConverterUInt32.write(value.vout, buf)
        _UniffiConverterUInt64.write(value.value, buf)
        _UniffiConverterTypeTxStatus.write(value.status, buf)


# ChainServiceError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class ChainServiceError(Exception):
    pass

_UniffiTempChainServiceError = ChainServiceError

class ChainServiceError:  # type: ignore
    class InvalidAddress(_UniffiTempChainServiceError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ChainServiceError.InvalidAddress({})".format(str(self))
    _UniffiTempChainServiceError.InvalidAddress = InvalidAddress # type: ignore
    class ServiceConnectivity(_UniffiTempChainServiceError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ChainServiceError.ServiceConnectivity({})".format(str(self))
    _UniffiTempChainServiceError.ServiceConnectivity = ServiceConnectivity # type: ignore
    class Generic(_UniffiTempChainServiceError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "ChainServiceError.Generic({})".format(str(self))
    _UniffiTempChainServiceError.Generic = Generic # type: ignore

ChainServiceError = _UniffiTempChainServiceError # type: ignore
del _UniffiTempChainServiceError


class _UniffiConverterTypeChainServiceError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ChainServiceError.InvalidAddress(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return ChainServiceError.ServiceConnectivity(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return ChainServiceError.Generic(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, ChainServiceError.InvalidAddress):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ChainServiceError.ServiceConnectivity):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, ChainServiceError.Generic):
            _UniffiConverterString.check_lower(value._values[0])
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, ChainServiceError.InvalidAddress):
            buf.write_i32(1)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ChainServiceError.ServiceConnectivity):
            buf.write_i32(2)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, ChainServiceError.Generic):
            buf.write_i32(3)
            _UniffiConverterString.write(value._values[0], buf)





class DepositClaimError:
    def __init__(self):
        raise RuntimeError("DepositClaimError cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class DEPOSIT_CLAIM_FEE_EXCEEDED:
        tx: "str"
        vout: "int"
        max_fee: "Fee"
        actual_fee: "int"

        def __init__(self,tx: "str", vout: "int", max_fee: "Fee", actual_fee: "int"):
            self.tx = tx
            self.vout = vout
            self.max_fee = max_fee
            self.actual_fee = actual_fee

        def __str__(self):
            return "DepositClaimError.DEPOSIT_CLAIM_FEE_EXCEEDED(tx={}, vout={}, max_fee={}, actual_fee={})".format(self.tx, self.vout, self.max_fee, self.actual_fee)

        def __eq__(self, other):
            if not other.is_deposit_claim_fee_exceeded():
                return False
            if self.tx != other.tx:
                return False
            if self.vout != other.vout:
                return False
            if self.max_fee != other.max_fee:
                return False
            if self.actual_fee != other.actual_fee:
                return False
            return True
    
    class MISSING_UTXO:
        tx: "str"
        vout: "int"

        def __init__(self,tx: "str", vout: "int"):
            self.tx = tx
            self.vout = vout

        def __str__(self):
            return "DepositClaimError.MISSING_UTXO(tx={}, vout={})".format(self.tx, self.vout)

        def __eq__(self, other):
            if not other.is_missing_utxo():
                return False
            if self.tx != other.tx:
                return False
            if self.vout != other.vout:
                return False
            return True
    
    class GENERIC:
        message: "str"

        def __init__(self,message: "str"):
            self.message = message

        def __str__(self):
            return "DepositClaimError.GENERIC(message={})".format(self.message)

        def __eq__(self, other):
            if not other.is_generic():
                return False
            if self.message != other.message:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_deposit_claim_fee_exceeded(self) -> bool:
        return isinstance(self, DepositClaimError.DEPOSIT_CLAIM_FEE_EXCEEDED)
    def is_missing_utxo(self) -> bool:
        return isinstance(self, DepositClaimError.MISSING_UTXO)
    def is_generic(self) -> bool:
        return isinstance(self, DepositClaimError.GENERIC)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
DepositClaimError.DEPOSIT_CLAIM_FEE_EXCEEDED = type("DepositClaimError.DEPOSIT_CLAIM_FEE_EXCEEDED", (DepositClaimError.DEPOSIT_CLAIM_FEE_EXCEEDED, DepositClaimError,), {})  # type: ignore
DepositClaimError.MISSING_UTXO = type("DepositClaimError.MISSING_UTXO", (DepositClaimError.MISSING_UTXO, DepositClaimError,), {})  # type: ignore
DepositClaimError.GENERIC = type("DepositClaimError.GENERIC", (DepositClaimError.GENERIC, DepositClaimError,), {})  # type: ignore




class _UniffiConverterTypeDepositClaimError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return DepositClaimError.DEPOSIT_CLAIM_FEE_EXCEEDED(
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt32.read(buf),
                _UniffiConverterTypeFee.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 2:
            return DepositClaimError.MISSING_UTXO(
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 3:
            return DepositClaimError.GENERIC(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_deposit_claim_fee_exceeded():
            _UniffiConverterString.check_lower(value.tx)
            _UniffiConverterUInt32.check_lower(value.vout)
            _UniffiConverterTypeFee.check_lower(value.max_fee)
            _UniffiConverterUInt64.check_lower(value.actual_fee)
            return
        if value.is_missing_utxo():
            _UniffiConverterString.check_lower(value.tx)
            _UniffiConverterUInt32.check_lower(value.vout)
            return
        if value.is_generic():
            _UniffiConverterString.check_lower(value.message)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_deposit_claim_fee_exceeded():
            buf.write_i32(1)
            _UniffiConverterString.write(value.tx, buf)
            _UniffiConverterUInt32.write(value.vout, buf)
            _UniffiConverterTypeFee.write(value.max_fee, buf)
            _UniffiConverterUInt64.write(value.actual_fee, buf)
        if value.is_missing_utxo():
            buf.write_i32(2)
            _UniffiConverterString.write(value.tx, buf)
            _UniffiConverterUInt32.write(value.vout, buf)
        if value.is_generic():
            buf.write_i32(3)
            _UniffiConverterString.write(value.message, buf)







class Fee:
    def __init__(self):
        raise RuntimeError("Fee cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class FIXED:
        amount: "int"

        def __init__(self,amount: "int"):
            self.amount = amount

        def __str__(self):
            return "Fee.FIXED(amount={})".format(self.amount)

        def __eq__(self, other):
            if not other.is_fixed():
                return False
            if self.amount != other.amount:
                return False
            return True
    
    class RATE:
        sat_per_vbyte: "int"

        def __init__(self,sat_per_vbyte: "int"):
            self.sat_per_vbyte = sat_per_vbyte

        def __str__(self):
            return "Fee.RATE(sat_per_vbyte={})".format(self.sat_per_vbyte)

        def __eq__(self, other):
            if not other.is_rate():
                return False
            if self.sat_per_vbyte != other.sat_per_vbyte:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_fixed(self) -> bool:
        return isinstance(self, Fee.FIXED)
    def is_rate(self) -> bool:
        return isinstance(self, Fee.RATE)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
Fee.FIXED = type("Fee.FIXED", (Fee.FIXED, Fee,), {})  # type: ignore
Fee.RATE = type("Fee.RATE", (Fee.RATE, Fee,), {})  # type: ignore




class _UniffiConverterTypeFee(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Fee.FIXED(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 2:
            return Fee.RATE(
                _UniffiConverterUInt64.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_fixed():
            _UniffiConverterUInt64.check_lower(value.amount)
            return
        if value.is_rate():
            _UniffiConverterUInt64.check_lower(value.sat_per_vbyte)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_fixed():
            buf.write_i32(1)
            _UniffiConverterUInt64.write(value.amount, buf)
        if value.is_rate():
            buf.write_i32(2)
            _UniffiConverterUInt64.write(value.sat_per_vbyte, buf)







class Network(enum.Enum):
    MAINNET = 0
    
    REGTEST = 1
    


class _UniffiConverterTypeNetwork(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Network.MAINNET
        if variant == 2:
            return Network.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Network.MAINNET:
            return
        if value == Network.REGTEST:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == Network.MAINNET:
            buf.write_i32(1)
        if value == Network.REGTEST:
            buf.write_i32(2)







class OnchainConfirmationSpeed(enum.Enum):
    FAST = 0
    
    MEDIUM = 1
    
    SLOW = 2
    


class _UniffiConverterTypeOnchainConfirmationSpeed(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return OnchainConfirmationSpeed.FAST
        if variant == 2:
            return OnchainConfirmationSpeed.MEDIUM
        if variant == 3:
            return OnchainConfirmationSpeed.SLOW
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == OnchainConfirmationSpeed.FAST:
            return
        if value == OnchainConfirmationSpeed.MEDIUM:
            return
        if value == OnchainConfirmationSpeed.SLOW:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == OnchainConfirmationSpeed.FAST:
            buf.write_i32(1)
        if value == OnchainConfirmationSpeed.MEDIUM:
            buf.write_i32(2)
        if value == OnchainConfirmationSpeed.SLOW:
            buf.write_i32(3)







class PaymentDetails:
    def __init__(self):
        raise RuntimeError("PaymentDetails cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class SPARK:

        def __init__(self,):
            pass

        def __str__(self):
            return "PaymentDetails.SPARK()".format()

        def __eq__(self, other):
            if not other.is_spark():
                return False
            return True
    
    class LIGHTNING:
        description: "typing.Optional[str]"
        """
        Represents the invoice description
        """

        preimage: "typing.Optional[str]"
        """
        The preimage of the paid invoice (proof of payment).
        """

        invoice: "str"
        """
        Represents the Bolt11/Bolt12 invoice associated with a payment
        In the case of a Send payment, this is the invoice paid by the user
        In the case of a Receive payment, this is the invoice paid to the user
        """

        payment_hash: "str"
        """
        The payment hash of the invoice
        """

        destination_pubkey: "str"
        """
        The invoice destination/payee pubkey
        """

        lnurl_pay_info: "typing.Optional[LnurlPayInfo]"
        """
        Lnurl payment information if this was an lnurl payment.
        """


        def __init__(self,description: "typing.Optional[str]", preimage: "typing.Optional[str]", invoice: "str", payment_hash: "str", destination_pubkey: "str", lnurl_pay_info: "typing.Optional[LnurlPayInfo]"):
            self.description = description
            self.preimage = preimage
            self.invoice = invoice
            self.payment_hash = payment_hash
            self.destination_pubkey = destination_pubkey
            self.lnurl_pay_info = lnurl_pay_info

        def __str__(self):
            return "PaymentDetails.LIGHTNING(description={}, preimage={}, invoice={}, payment_hash={}, destination_pubkey={}, lnurl_pay_info={})".format(self.description, self.preimage, self.invoice, self.payment_hash, self.destination_pubkey, self.lnurl_pay_info)

        def __eq__(self, other):
            if not other.is_lightning():
                return False
            if self.description != other.description:
                return False
            if self.preimage != other.preimage:
                return False
            if self.invoice != other.invoice:
                return False
            if self.payment_hash != other.payment_hash:
                return False
            if self.destination_pubkey != other.destination_pubkey:
                return False
            if self.lnurl_pay_info != other.lnurl_pay_info:
                return False
            return True
    
    class WITHDRAW:
        tx_id: "str"

        def __init__(self,tx_id: "str"):
            self.tx_id = tx_id

        def __str__(self):
            return "PaymentDetails.WITHDRAW(tx_id={})".format(self.tx_id)

        def __eq__(self, other):
            if not other.is_withdraw():
                return False
            if self.tx_id != other.tx_id:
                return False
            return True
    
    class DEPOSIT:
        tx_id: "str"

        def __init__(self,tx_id: "str"):
            self.tx_id = tx_id

        def __str__(self):
            return "PaymentDetails.DEPOSIT(tx_id={})".format(self.tx_id)

        def __eq__(self, other):
            if not other.is_deposit():
                return False
            if self.tx_id != other.tx_id:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_spark(self) -> bool:
        return isinstance(self, PaymentDetails.SPARK)
    def is_lightning(self) -> bool:
        return isinstance(self, PaymentDetails.LIGHTNING)
    def is_withdraw(self) -> bool:
        return isinstance(self, PaymentDetails.WITHDRAW)
    def is_deposit(self) -> bool:
        return isinstance(self, PaymentDetails.DEPOSIT)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
PaymentDetails.SPARK = type("PaymentDetails.SPARK", (PaymentDetails.SPARK, PaymentDetails,), {})  # type: ignore
PaymentDetails.LIGHTNING = type("PaymentDetails.LIGHTNING", (PaymentDetails.LIGHTNING, PaymentDetails,), {})  # type: ignore
PaymentDetails.WITHDRAW = type("PaymentDetails.WITHDRAW", (PaymentDetails.WITHDRAW, PaymentDetails,), {})  # type: ignore
PaymentDetails.DEPOSIT = type("PaymentDetails.DEPOSIT", (PaymentDetails.DEPOSIT, PaymentDetails,), {})  # type: ignore




class _UniffiConverterTypePaymentDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentDetails.SPARK(
            )
        if variant == 2:
            return PaymentDetails.LIGHTNING(
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterOptionalTypeLnurlPayInfo.read(buf),
            )
        if variant == 3:
            return PaymentDetails.WITHDRAW(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return PaymentDetails.DEPOSIT(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_spark():
            return
        if value.is_lightning():
            _UniffiConverterOptionalString.check_lower(value.description)
            _UniffiConverterOptionalString.check_lower(value.preimage)
            _UniffiConverterString.check_lower(value.invoice)
            _UniffiConverterString.check_lower(value.payment_hash)
            _UniffiConverterString.check_lower(value.destination_pubkey)
            _UniffiConverterOptionalTypeLnurlPayInfo.check_lower(value.lnurl_pay_info)
            return
        if value.is_withdraw():
            _UniffiConverterString.check_lower(value.tx_id)
            return
        if value.is_deposit():
            _UniffiConverterString.check_lower(value.tx_id)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_spark():
            buf.write_i32(1)
        if value.is_lightning():
            buf.write_i32(2)
            _UniffiConverterOptionalString.write(value.description, buf)
            _UniffiConverterOptionalString.write(value.preimage, buf)
            _UniffiConverterString.write(value.invoice, buf)
            _UniffiConverterString.write(value.payment_hash, buf)
            _UniffiConverterString.write(value.destination_pubkey, buf)
            _UniffiConverterOptionalTypeLnurlPayInfo.write(value.lnurl_pay_info, buf)
        if value.is_withdraw():
            buf.write_i32(3)
            _UniffiConverterString.write(value.tx_id, buf)
        if value.is_deposit():
            buf.write_i32(4)
            _UniffiConverterString.write(value.tx_id, buf)







class PaymentMethod(enum.Enum):
    LIGHTNING = 0
    
    SPARK = 1
    
    DEPOSIT = 2
    
    WITHDRAW = 3
    
    UNKNOWN = 4
    


class _UniffiConverterTypePaymentMethod(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentMethod.LIGHTNING
        if variant == 2:
            return PaymentMethod.SPARK
        if variant == 3:
            return PaymentMethod.DEPOSIT
        if variant == 4:
            return PaymentMethod.WITHDRAW
        if variant == 5:
            return PaymentMethod.UNKNOWN
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == PaymentMethod.LIGHTNING:
            return
        if value == PaymentMethod.SPARK:
            return
        if value == PaymentMethod.DEPOSIT:
            return
        if value == PaymentMethod.WITHDRAW:
            return
        if value == PaymentMethod.UNKNOWN:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == PaymentMethod.LIGHTNING:
            buf.write_i32(1)
        if value == PaymentMethod.SPARK:
            buf.write_i32(2)
        if value == PaymentMethod.DEPOSIT:
            buf.write_i32(3)
        if value == PaymentMethod.WITHDRAW:
            buf.write_i32(4)
        if value == PaymentMethod.UNKNOWN:
            buf.write_i32(5)







class PaymentStatus(enum.Enum):
    """
    The status of a payment
    """

    COMPLETED = 0
    """
    Payment is completed successfully
    """

    
    PENDING = 1
    """
    Payment is in progress
    """

    
    FAILED = 2
    """
    Payment has failed
    """

    


class _UniffiConverterTypePaymentStatus(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentStatus.COMPLETED
        if variant == 2:
            return PaymentStatus.PENDING
        if variant == 3:
            return PaymentStatus.FAILED
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == PaymentStatus.COMPLETED:
            return
        if value == PaymentStatus.PENDING:
            return
        if value == PaymentStatus.FAILED:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == PaymentStatus.COMPLETED:
            buf.write_i32(1)
        if value == PaymentStatus.PENDING:
            buf.write_i32(2)
        if value == PaymentStatus.FAILED:
            buf.write_i32(3)







class PaymentType(enum.Enum):
    """
    The type of payment
    """

    SEND = 0
    """
    Payment sent from this wallet
    """

    
    RECEIVE = 1
    """
    Payment received to this wallet
    """

    


class _UniffiConverterTypePaymentType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentType.SEND
        if variant == 2:
            return PaymentType.RECEIVE
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == PaymentType.SEND:
            return
        if value == PaymentType.RECEIVE:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == PaymentType.SEND:
            buf.write_i32(1)
        if value == PaymentType.RECEIVE:
            buf.write_i32(2)







class ReceivePaymentMethod:
    def __init__(self):
        raise RuntimeError("ReceivePaymentMethod cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class SPARK_ADDRESS:

        def __init__(self,):
            pass

        def __str__(self):
            return "ReceivePaymentMethod.SPARK_ADDRESS()".format()

        def __eq__(self, other):
            if not other.is_spark_address():
                return False
            return True
    
    class BITCOIN_ADDRESS:

        def __init__(self,):
            pass

        def __str__(self):
            return "ReceivePaymentMethod.BITCOIN_ADDRESS()".format()

        def __eq__(self, other):
            if not other.is_bitcoin_address():
                return False
            return True
    
    class BOLT11_INVOICE:
        description: "str"
        amount_sats: "typing.Optional[int]"

        def __init__(self,description: "str", amount_sats: "typing.Optional[int]"):
            self.description = description
            self.amount_sats = amount_sats

        def __str__(self):
            return "ReceivePaymentMethod.BOLT11_INVOICE(description={}, amount_sats={})".format(self.description, self.amount_sats)

        def __eq__(self, other):
            if not other.is_bolt11_invoice():
                return False
            if self.description != other.description:
                return False
            if self.amount_sats != other.amount_sats:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_spark_address(self) -> bool:
        return isinstance(self, ReceivePaymentMethod.SPARK_ADDRESS)
    def is_bitcoin_address(self) -> bool:
        return isinstance(self, ReceivePaymentMethod.BITCOIN_ADDRESS)
    def is_bolt11_invoice(self) -> bool:
        return isinstance(self, ReceivePaymentMethod.BOLT11_INVOICE)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
ReceivePaymentMethod.SPARK_ADDRESS = type("ReceivePaymentMethod.SPARK_ADDRESS", (ReceivePaymentMethod.SPARK_ADDRESS, ReceivePaymentMethod,), {})  # type: ignore
ReceivePaymentMethod.BITCOIN_ADDRESS = type("ReceivePaymentMethod.BITCOIN_ADDRESS", (ReceivePaymentMethod.BITCOIN_ADDRESS, ReceivePaymentMethod,), {})  # type: ignore
ReceivePaymentMethod.BOLT11_INVOICE = type("ReceivePaymentMethod.BOLT11_INVOICE", (ReceivePaymentMethod.BOLT11_INVOICE, ReceivePaymentMethod,), {})  # type: ignore




class _UniffiConverterTypeReceivePaymentMethod(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ReceivePaymentMethod.SPARK_ADDRESS(
            )
        if variant == 2:
            return ReceivePaymentMethod.BITCOIN_ADDRESS(
            )
        if variant == 3:
            return ReceivePaymentMethod.BOLT11_INVOICE(
                _UniffiConverterString.read(buf),
                _UniffiConverterOptionalUInt64.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_spark_address():
            return
        if value.is_bitcoin_address():
            return
        if value.is_bolt11_invoice():
            _UniffiConverterString.check_lower(value.description)
            _UniffiConverterOptionalUInt64.check_lower(value.amount_sats)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_spark_address():
            buf.write_i32(1)
        if value.is_bitcoin_address():
            buf.write_i32(2)
        if value.is_bolt11_invoice():
            buf.write_i32(3)
            _UniffiConverterString.write(value.description, buf)
            _UniffiConverterOptionalUInt64.write(value.amount_sats, buf)




# SdkError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class SdkError(Exception):
    """
    Error type for the `BreezSdk`
    """

    pass

_UniffiTempSdkError = SdkError

class SdkError:  # type: ignore
    """
    Error type for the `BreezSdk`
    """

    class SparkError(_UniffiTempSdkError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "SdkError.SparkError({})".format(str(self))
    _UniffiTempSdkError.SparkError = SparkError # type: ignore
    class InvalidUuid(_UniffiTempSdkError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "SdkError.InvalidUuid({})".format(str(self))
    _UniffiTempSdkError.InvalidUuid = InvalidUuid # type: ignore
    class InvalidInput(_UniffiTempSdkError):
        """
        Invalid input error
        """

        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "SdkError.InvalidInput({})".format(str(self))
    _UniffiTempSdkError.InvalidInput = InvalidInput # type: ignore
    class NetworkError(_UniffiTempSdkError):
        """
        Network error
        """

        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "SdkError.NetworkError({})".format(str(self))
    _UniffiTempSdkError.NetworkError = NetworkError # type: ignore
    class StorageError(_UniffiTempSdkError):
        """
        Storage error
        """

        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "SdkError.StorageError({})".format(str(self))
    _UniffiTempSdkError.StorageError = StorageError # type: ignore
    class ChainServiceError(_UniffiTempSdkError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "SdkError.ChainServiceError({})".format(str(self))
    _UniffiTempSdkError.ChainServiceError = ChainServiceError # type: ignore
    class DepositClaimFeeExceeded(_UniffiTempSdkError):
        def __init__(self, tx, vout, max_fee, actual_fee):
            super().__init__(", ".join([
                "tx={!r}".format(tx),
                "vout={!r}".format(vout),
                "max_fee={!r}".format(max_fee),
                "actual_fee={!r}".format(actual_fee),
            ]))
            self.tx = tx
            self.vout = vout
            self.max_fee = max_fee
            self.actual_fee = actual_fee

        def __repr__(self):
            return "SdkError.DepositClaimFeeExceeded({})".format(str(self))
    _UniffiTempSdkError.DepositClaimFeeExceeded = DepositClaimFeeExceeded # type: ignore
    class MissingUtxo(_UniffiTempSdkError):
        def __init__(self, tx, vout):
            super().__init__(", ".join([
                "tx={!r}".format(tx),
                "vout={!r}".format(vout),
            ]))
            self.tx = tx
            self.vout = vout

        def __repr__(self):
            return "SdkError.MissingUtxo({})".format(str(self))
    _UniffiTempSdkError.MissingUtxo = MissingUtxo # type: ignore
    class LnurlError(_UniffiTempSdkError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "SdkError.LnurlError({})".format(str(self))
    _UniffiTempSdkError.LnurlError = LnurlError # type: ignore
    class Generic(_UniffiTempSdkError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "SdkError.Generic({})".format(str(self))
    _UniffiTempSdkError.Generic = Generic # type: ignore

SdkError = _UniffiTempSdkError # type: ignore
del _UniffiTempSdkError


class _UniffiConverterTypeSdkError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SdkError.SparkError(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return SdkError.InvalidUuid(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return SdkError.InvalidInput(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return SdkError.NetworkError(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return SdkError.StorageError(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return SdkError.ChainServiceError(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return SdkError.DepositClaimFeeExceeded(
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt32.read(buf),
                _UniffiConverterTypeFee.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 8:
            return SdkError.MissingUtxo(
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 9:
            return SdkError.LnurlError(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return SdkError.Generic(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, SdkError.SparkError):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, SdkError.InvalidUuid):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, SdkError.InvalidInput):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, SdkError.NetworkError):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, SdkError.StorageError):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, SdkError.ChainServiceError):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, SdkError.DepositClaimFeeExceeded):
            _UniffiConverterString.check_lower(value.tx)
            _UniffiConverterUInt32.check_lower(value.vout)
            _UniffiConverterTypeFee.check_lower(value.max_fee)
            _UniffiConverterUInt64.check_lower(value.actual_fee)
            return
        if isinstance(value, SdkError.MissingUtxo):
            _UniffiConverterString.check_lower(value.tx)
            _UniffiConverterUInt32.check_lower(value.vout)
            return
        if isinstance(value, SdkError.LnurlError):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, SdkError.Generic):
            _UniffiConverterString.check_lower(value._values[0])
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, SdkError.SparkError):
            buf.write_i32(1)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, SdkError.InvalidUuid):
            buf.write_i32(2)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, SdkError.InvalidInput):
            buf.write_i32(3)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, SdkError.NetworkError):
            buf.write_i32(4)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, SdkError.StorageError):
            buf.write_i32(5)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, SdkError.ChainServiceError):
            buf.write_i32(6)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, SdkError.DepositClaimFeeExceeded):
            buf.write_i32(7)
            _UniffiConverterString.write(value.tx, buf)
            _UniffiConverterUInt32.write(value.vout, buf)
            _UniffiConverterTypeFee.write(value.max_fee, buf)
            _UniffiConverterUInt64.write(value.actual_fee, buf)
        if isinstance(value, SdkError.MissingUtxo):
            buf.write_i32(8)
            _UniffiConverterString.write(value.tx, buf)
            _UniffiConverterUInt32.write(value.vout, buf)
        if isinstance(value, SdkError.LnurlError):
            buf.write_i32(9)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, SdkError.Generic):
            buf.write_i32(10)
            _UniffiConverterString.write(value._values[0], buf)





class SdkEvent:
    """
    Events emitted by the SDK
    """

    def __init__(self):
        raise RuntimeError("SdkEvent cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class SYNCED:
        """
        Emitted when the wallet has been synchronized with the network
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "SdkEvent.SYNCED()".format()

        def __eq__(self, other):
            if not other.is_synced():
                return False
            return True
    
    class CLAIM_DEPOSITS_FAILED:
        """
        Emitted when the wallet failed to claim some deposits
        """

        unclaimed_deposits: "typing.List[DepositInfo]"

        def __init__(self,unclaimed_deposits: "typing.List[DepositInfo]"):
            self.unclaimed_deposits = unclaimed_deposits

        def __str__(self):
            return "SdkEvent.CLAIM_DEPOSITS_FAILED(unclaimed_deposits={})".format(self.unclaimed_deposits)

        def __eq__(self, other):
            if not other.is_claim_deposits_failed():
                return False
            if self.unclaimed_deposits != other.unclaimed_deposits:
                return False
            return True
    
    class CLAIM_DEPOSITS_SUCCEEDED:
        claimed_deposits: "typing.List[DepositInfo]"

        def __init__(self,claimed_deposits: "typing.List[DepositInfo]"):
            self.claimed_deposits = claimed_deposits

        def __str__(self):
            return "SdkEvent.CLAIM_DEPOSITS_SUCCEEDED(claimed_deposits={})".format(self.claimed_deposits)

        def __eq__(self, other):
            if not other.is_claim_deposits_succeeded():
                return False
            if self.claimed_deposits != other.claimed_deposits:
                return False
            return True
    
    class PAYMENT_SUCCEEDED:
        payment: "Payment"

        def __init__(self,payment: "Payment"):
            self.payment = payment

        def __str__(self):
            return "SdkEvent.PAYMENT_SUCCEEDED(payment={})".format(self.payment)

        def __eq__(self, other):
            if not other.is_payment_succeeded():
                return False
            if self.payment != other.payment:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_synced(self) -> bool:
        return isinstance(self, SdkEvent.SYNCED)
    def is_claim_deposits_failed(self) -> bool:
        return isinstance(self, SdkEvent.CLAIM_DEPOSITS_FAILED)
    def is_claim_deposits_succeeded(self) -> bool:
        return isinstance(self, SdkEvent.CLAIM_DEPOSITS_SUCCEEDED)
    def is_payment_succeeded(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_SUCCEEDED)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SdkEvent.SYNCED = type("SdkEvent.SYNCED", (SdkEvent.SYNCED, SdkEvent,), {})  # type: ignore
SdkEvent.CLAIM_DEPOSITS_FAILED = type("SdkEvent.CLAIM_DEPOSITS_FAILED", (SdkEvent.CLAIM_DEPOSITS_FAILED, SdkEvent,), {})  # type: ignore
SdkEvent.CLAIM_DEPOSITS_SUCCEEDED = type("SdkEvent.CLAIM_DEPOSITS_SUCCEEDED", (SdkEvent.CLAIM_DEPOSITS_SUCCEEDED, SdkEvent,), {})  # type: ignore
SdkEvent.PAYMENT_SUCCEEDED = type("SdkEvent.PAYMENT_SUCCEEDED", (SdkEvent.PAYMENT_SUCCEEDED, SdkEvent,), {})  # type: ignore




class _UniffiConverterTypeSdkEvent(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SdkEvent.SYNCED(
            )
        if variant == 2:
            return SdkEvent.CLAIM_DEPOSITS_FAILED(
                _UniffiConverterSequenceTypeDepositInfo.read(buf),
            )
        if variant == 3:
            return SdkEvent.CLAIM_DEPOSITS_SUCCEEDED(
                _UniffiConverterSequenceTypeDepositInfo.read(buf),
            )
        if variant == 4:
            return SdkEvent.PAYMENT_SUCCEEDED(
                _UniffiConverterTypePayment.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_synced():
            return
        if value.is_claim_deposits_failed():
            _UniffiConverterSequenceTypeDepositInfo.check_lower(value.unclaimed_deposits)
            return
        if value.is_claim_deposits_succeeded():
            _UniffiConverterSequenceTypeDepositInfo.check_lower(value.claimed_deposits)
            return
        if value.is_payment_succeeded():
            _UniffiConverterTypePayment.check_lower(value.payment)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_synced():
            buf.write_i32(1)
        if value.is_claim_deposits_failed():
            buf.write_i32(2)
            _UniffiConverterSequenceTypeDepositInfo.write(value.unclaimed_deposits, buf)
        if value.is_claim_deposits_succeeded():
            buf.write_i32(3)
            _UniffiConverterSequenceTypeDepositInfo.write(value.claimed_deposits, buf)
        if value.is_payment_succeeded():
            buf.write_i32(4)
            _UniffiConverterTypePayment.write(value.payment, buf)







class SendPaymentMethod:
    def __init__(self):
        raise RuntimeError("SendPaymentMethod cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BITCOIN_ADDRESS:
        address: "BitcoinAddressDetails"
        fee_quote: "SendOnchainFeeQuote"

        def __init__(self,address: "BitcoinAddressDetails", fee_quote: "SendOnchainFeeQuote"):
            self.address = address
            self.fee_quote = fee_quote

        def __str__(self):
            return "SendPaymentMethod.BITCOIN_ADDRESS(address={}, fee_quote={})".format(self.address, self.fee_quote)

        def __eq__(self, other):
            if not other.is_bitcoin_address():
                return False
            if self.address != other.address:
                return False
            if self.fee_quote != other.fee_quote:
                return False
            return True
    
    class BOLT11_INVOICE:
        invoice_details: "Bolt11InvoiceDetails"
        spark_transfer_fee_sats: "typing.Optional[int]"
        lightning_fee_sats: "int"

        def __init__(self,invoice_details: "Bolt11InvoiceDetails", spark_transfer_fee_sats: "typing.Optional[int]", lightning_fee_sats: "int"):
            self.invoice_details = invoice_details
            self.spark_transfer_fee_sats = spark_transfer_fee_sats
            self.lightning_fee_sats = lightning_fee_sats

        def __str__(self):
            return "SendPaymentMethod.BOLT11_INVOICE(invoice_details={}, spark_transfer_fee_sats={}, lightning_fee_sats={})".format(self.invoice_details, self.spark_transfer_fee_sats, self.lightning_fee_sats)

        def __eq__(self, other):
            if not other.is_bolt11_invoice():
                return False
            if self.invoice_details != other.invoice_details:
                return False
            if self.spark_transfer_fee_sats != other.spark_transfer_fee_sats:
                return False
            if self.lightning_fee_sats != other.lightning_fee_sats:
                return False
            return True
    
    class SPARK_ADDRESS:
        address: "str"
        fee_sats: "int"

        def __init__(self,address: "str", fee_sats: "int"):
            self.address = address
            self.fee_sats = fee_sats

        def __str__(self):
            return "SendPaymentMethod.SPARK_ADDRESS(address={}, fee_sats={})".format(self.address, self.fee_sats)

        def __eq__(self, other):
            if not other.is_spark_address():
                return False
            if self.address != other.address:
                return False
            if self.fee_sats != other.fee_sats:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_bitcoin_address(self) -> bool:
        return isinstance(self, SendPaymentMethod.BITCOIN_ADDRESS)
    def is_bolt11_invoice(self) -> bool:
        return isinstance(self, SendPaymentMethod.BOLT11_INVOICE)
    def is_spark_address(self) -> bool:
        return isinstance(self, SendPaymentMethod.SPARK_ADDRESS)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SendPaymentMethod.BITCOIN_ADDRESS = type("SendPaymentMethod.BITCOIN_ADDRESS", (SendPaymentMethod.BITCOIN_ADDRESS, SendPaymentMethod,), {})  # type: ignore
SendPaymentMethod.BOLT11_INVOICE = type("SendPaymentMethod.BOLT11_INVOICE", (SendPaymentMethod.BOLT11_INVOICE, SendPaymentMethod,), {})  # type: ignore
SendPaymentMethod.SPARK_ADDRESS = type("SendPaymentMethod.SPARK_ADDRESS", (SendPaymentMethod.SPARK_ADDRESS, SendPaymentMethod,), {})  # type: ignore




class _UniffiConverterTypeSendPaymentMethod(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SendPaymentMethod.BITCOIN_ADDRESS(
                _UniffiConverterTypeBitcoinAddressDetails.read(buf),
                _UniffiConverterTypeSendOnchainFeeQuote.read(buf),
            )
        if variant == 2:
            return SendPaymentMethod.BOLT11_INVOICE(
                _UniffiConverterTypeBolt11InvoiceDetails.read(buf),
                _UniffiConverterOptionalUInt64.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 3:
            return SendPaymentMethod.SPARK_ADDRESS(
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_bitcoin_address():
            _UniffiConverterTypeBitcoinAddressDetails.check_lower(value.address)
            _UniffiConverterTypeSendOnchainFeeQuote.check_lower(value.fee_quote)
            return
        if value.is_bolt11_invoice():
            _UniffiConverterTypeBolt11InvoiceDetails.check_lower(value.invoice_details)
            _UniffiConverterOptionalUInt64.check_lower(value.spark_transfer_fee_sats)
            _UniffiConverterUInt64.check_lower(value.lightning_fee_sats)
            return
        if value.is_spark_address():
            _UniffiConverterString.check_lower(value.address)
            _UniffiConverterUInt64.check_lower(value.fee_sats)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_bitcoin_address():
            buf.write_i32(1)
            _UniffiConverterTypeBitcoinAddressDetails.write(value.address, buf)
            _UniffiConverterTypeSendOnchainFeeQuote.write(value.fee_quote, buf)
        if value.is_bolt11_invoice():
            buf.write_i32(2)
            _UniffiConverterTypeBolt11InvoiceDetails.write(value.invoice_details, buf)
            _UniffiConverterOptionalUInt64.write(value.spark_transfer_fee_sats, buf)
            _UniffiConverterUInt64.write(value.lightning_fee_sats, buf)
        if value.is_spark_address():
            buf.write_i32(3)
            _UniffiConverterString.write(value.address, buf)
            _UniffiConverterUInt64.write(value.fee_sats, buf)







class SendPaymentOptions:
    def __init__(self):
        raise RuntimeError("SendPaymentOptions cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BITCOIN_ADDRESS:
        confirmation_speed: "OnchainConfirmationSpeed"

        def __init__(self,confirmation_speed: "OnchainConfirmationSpeed"):
            self.confirmation_speed = confirmation_speed

        def __str__(self):
            return "SendPaymentOptions.BITCOIN_ADDRESS(confirmation_speed={})".format(self.confirmation_speed)

        def __eq__(self, other):
            if not other.is_bitcoin_address():
                return False
            if self.confirmation_speed != other.confirmation_speed:
                return False
            return True
    
    class BOLT11_INVOICE:
        use_spark: "bool"

        def __init__(self,use_spark: "bool"):
            self.use_spark = use_spark

        def __str__(self):
            return "SendPaymentOptions.BOLT11_INVOICE(use_spark={})".format(self.use_spark)

        def __eq__(self, other):
            if not other.is_bolt11_invoice():
                return False
            if self.use_spark != other.use_spark:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_bitcoin_address(self) -> bool:
        return isinstance(self, SendPaymentOptions.BITCOIN_ADDRESS)
    def is_bolt11_invoice(self) -> bool:
        return isinstance(self, SendPaymentOptions.BOLT11_INVOICE)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SendPaymentOptions.BITCOIN_ADDRESS = type("SendPaymentOptions.BITCOIN_ADDRESS", (SendPaymentOptions.BITCOIN_ADDRESS, SendPaymentOptions,), {})  # type: ignore
SendPaymentOptions.BOLT11_INVOICE = type("SendPaymentOptions.BOLT11_INVOICE", (SendPaymentOptions.BOLT11_INVOICE, SendPaymentOptions,), {})  # type: ignore




class _UniffiConverterTypeSendPaymentOptions(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SendPaymentOptions.BITCOIN_ADDRESS(
                _UniffiConverterTypeOnchainConfirmationSpeed.read(buf),
            )
        if variant == 2:
            return SendPaymentOptions.BOLT11_INVOICE(
                _UniffiConverterBool.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_bitcoin_address():
            _UniffiConverterTypeOnchainConfirmationSpeed.check_lower(value.confirmation_speed)
            return
        if value.is_bolt11_invoice():
            _UniffiConverterBool.check_lower(value.use_spark)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_bitcoin_address():
            buf.write_i32(1)
            _UniffiConverterTypeOnchainConfirmationSpeed.write(value.confirmation_speed, buf)
        if value.is_bolt11_invoice():
            buf.write_i32(2)
            _UniffiConverterBool.write(value.use_spark, buf)




# StorageError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class StorageError(Exception):
    """
    Errors that can occur during storage operations
    """

    pass

_UniffiTempStorageError = StorageError

class StorageError:  # type: ignore
    """
    Errors that can occur during storage operations
    """

    class Implementation(_UniffiTempStorageError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "StorageError.Implementation({})".format(str(self))
    _UniffiTempStorageError.Implementation = Implementation # type: ignore
    class InitializationError(_UniffiTempStorageError):
        """
        Database initialization error
        """

        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "StorageError.InitializationError({})".format(str(self))
    _UniffiTempStorageError.InitializationError = InitializationError # type: ignore
    class Serialization(_UniffiTempStorageError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "StorageError.Serialization({})".format(str(self))
    _UniffiTempStorageError.Serialization = Serialization # type: ignore

StorageError = _UniffiTempStorageError # type: ignore
del _UniffiTempStorageError


class _UniffiConverterTypeStorageError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return StorageError.Implementation(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return StorageError.InitializationError(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return StorageError.Serialization(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, StorageError.Implementation):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, StorageError.InitializationError):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, StorageError.Serialization):
            _UniffiConverterString.check_lower(value._values[0])
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, StorageError.Implementation):
            buf.write_i32(1)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, StorageError.InitializationError):
            buf.write_i32(2)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, StorageError.Serialization):
            buf.write_i32(3)
            _UniffiConverterString.write(value._values[0], buf)





class UpdateDepositPayload:
    def __init__(self):
        raise RuntimeError("UpdateDepositPayload cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class CLAIM_ERROR:
        error: "DepositClaimError"

        def __init__(self,error: "DepositClaimError"):
            self.error = error

        def __str__(self):
            return "UpdateDepositPayload.CLAIM_ERROR(error={})".format(self.error)

        def __eq__(self, other):
            if not other.is_claim_error():
                return False
            if self.error != other.error:
                return False
            return True
    
    class REFUND:
        refund_txid: "str"
        refund_tx: "str"

        def __init__(self,refund_txid: "str", refund_tx: "str"):
            self.refund_txid = refund_txid
            self.refund_tx = refund_tx

        def __str__(self):
            return "UpdateDepositPayload.REFUND(refund_txid={}, refund_tx={})".format(self.refund_txid, self.refund_tx)

        def __eq__(self, other):
            if not other.is_refund():
                return False
            if self.refund_txid != other.refund_txid:
                return False
            if self.refund_tx != other.refund_tx:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_claim_error(self) -> bool:
        return isinstance(self, UpdateDepositPayload.CLAIM_ERROR)
    def is_refund(self) -> bool:
        return isinstance(self, UpdateDepositPayload.REFUND)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
UpdateDepositPayload.CLAIM_ERROR = type("UpdateDepositPayload.CLAIM_ERROR", (UpdateDepositPayload.CLAIM_ERROR, UpdateDepositPayload,), {})  # type: ignore
UpdateDepositPayload.REFUND = type("UpdateDepositPayload.REFUND", (UpdateDepositPayload.REFUND, UpdateDepositPayload,), {})  # type: ignore




class _UniffiConverterTypeUpdateDepositPayload(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return UpdateDepositPayload.CLAIM_ERROR(
                _UniffiConverterTypeDepositClaimError.read(buf),
            )
        if variant == 2:
            return UpdateDepositPayload.REFUND(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_claim_error():
            _UniffiConverterTypeDepositClaimError.check_lower(value.error)
            return
        if value.is_refund():
            _UniffiConverterString.check_lower(value.refund_txid)
            _UniffiConverterString.check_lower(value.refund_tx)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_claim_error():
            buf.write_i32(1)
            _UniffiConverterTypeDepositClaimError.write(value.error, buf)
        if value.is_refund():
            buf.write_i32(2)
            _UniffiConverterString.write(value.refund_txid, buf)
            _UniffiConverterString.write(value.refund_tx, buf)





class EventListener(typing.Protocol):
    """
    Trait for event listeners
    """

    def on_event(self, event: "SdkEvent"):
        """
        Called when an event occurs
        """

        raise NotImplementedError


# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplEventListener:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_EVENT_LISTENER_METHOD0
    def on_event(
            uniffi_handle,
            event,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeEventListener._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypeSdkEvent.lift(event), )
            method = uniffi_obj.on_event
            return method(*args)

        
        write_return_value = lambda v: None
        _uniffi_trait_interface_call(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeEventListener._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceEventListener(
        on_event,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_eventlistener(ctypes.byref(_uniffi_vtable))

# The _UniffiConverter which transforms the Callbacks in to Handles to pass to Rust.
_UniffiConverterTypeEventListener = _UniffiCallbackInterfaceFfiConverter()



class Logger(typing.Protocol):
    def log(self, l: "LogEntry"):
        raise NotImplementedError


# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplLogger:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_LOGGER_METHOD0
    def log(
            uniffi_handle,
            l,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeLogger._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypeLogEntry.lift(l), )
            method = uniffi_obj.log
            return method(*args)

        
        write_return_value = lambda v: None
        _uniffi_trait_interface_call(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeLogger._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceLogger(
        log,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_breez_sdk_spark_fn_init_callback_vtable_logger(ctypes.byref(_uniffi_vtable))

# The _UniffiConverter which transforms the Callbacks in to Handles to pass to Rust.
_UniffiConverterTypeLogger = _UniffiCallbackInterfaceFfiConverter()



class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalBool(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterBool.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterBool.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterBool.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeCredentials(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeCredentials.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeCredentials.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeCredentials.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeLnurlPayInfo(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeLnurlPayInfo.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeLnurlPayInfo.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeLnurlPayInfo.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeDepositClaimError(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeDepositClaimError.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeDepositClaimError.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeDepositClaimError.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeFee(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeFee.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeFee.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeFee.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypePaymentDetails(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypePaymentDetails.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypePaymentDetails.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypePaymentDetails.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSendPaymentOptions(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSendPaymentOptions.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSendPaymentOptions.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSendPaymentOptions.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeLogger(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeLogger.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeLogger.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeLogger.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSuccessAction(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSuccessAction.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSuccessAction.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSuccessAction.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSuccessActionProcessed(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSuccessActionProcessed.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSuccessActionProcessed.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSuccessActionProcessed.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceTypeDepositInfo(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeDepositInfo.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeDepositInfo.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeDepositInfo.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePayment(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePayment.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePayment.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePayment.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeUtxo(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeUtxo.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeUtxo.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeUtxo.read(buf) for i in range(count)
        ]

# External type BitcoinAddressDetails is in namespace "breez_sdk_common", crate breez_sdk_common




# External type Bolt11InvoiceDetails is in namespace "breez_sdk_common", crate breez_sdk_common




# External type InputType is in namespace "breez_sdk_common", crate breez_sdk_common




# External type LnurlPayRequestDetails is in namespace "breez_sdk_common", crate breez_sdk_common




# External type RestClient is in namespace "breez_sdk_common", crate breez_sdk_common




# External type SuccessAction is in namespace "breez_sdk_common", crate breez_sdk_common




# External type SuccessActionProcessed is in namespace "breez_sdk_common", crate breez_sdk_common




# Async support# RustFuturePoll values
_UNIFFI_RUST_FUTURE_POLL_READY = 0
_UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1

# Stores futures for _uniffi_continuation_callback
_UniffiContinuationHandleMap = _UniffiHandleMap()

_UNIFFI_GLOBAL_EVENT_LOOP = None

"""
Set the event loop to use for async functions

This is needed if some async functions run outside of the eventloop, for example:
    - A non-eventloop thread is spawned, maybe from `EventLoop.run_in_executor` or maybe from the
      Rust code spawning its own thread.
    - The Rust code calls an async callback method from a sync callback function, using something
      like `pollster` to block on the async call.

In this case, we need an event loop to run the Python async function, but there's no eventloop set
for the thread.  Use `uniffi_set_event_loop` to force an eventloop to be used in this case.
"""
def uniffi_set_event_loop(eventloop: asyncio.BaseEventLoop):
    global _UNIFFI_GLOBAL_EVENT_LOOP
    _UNIFFI_GLOBAL_EVENT_LOOP = eventloop

def _uniffi_get_event_loop():
    if _UNIFFI_GLOBAL_EVENT_LOOP is not None:
        return _UNIFFI_GLOBAL_EVENT_LOOP
    else:
        return asyncio.get_running_loop()

# Continuation callback for async functions
# lift the return value or error and resolve the future, causing the async function to resume.
@_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK
def _uniffi_continuation_callback(future_ptr, poll_code):
    (eventloop, future) = _UniffiContinuationHandleMap.remove(future_ptr)
    eventloop.call_soon_threadsafe(_uniffi_set_future_result, future, poll_code)

def _uniffi_set_future_result(future, poll_code):
    if not future.cancelled():
        future.set_result(poll_code)

async def _uniffi_rust_call_async(rust_future, ffi_poll, ffi_complete, ffi_free, lift_func, error_ffi_converter):
    try:
        eventloop = _uniffi_get_event_loop()

        # Loop and poll until we see a _UNIFFI_RUST_FUTURE_POLL_READY value
        while True:
            future = eventloop.create_future()
            ffi_poll(
                rust_future,
                _uniffi_continuation_callback,
                _UniffiContinuationHandleMap.insert((eventloop, future)),
            )
            poll_code = await future
            if poll_code == _UNIFFI_RUST_FUTURE_POLL_READY:
                break

        return lift_func(
            _uniffi_rust_call_with_error(error_ffi_converter, ffi_complete, rust_future)
        )
    finally:
        ffi_free(rust_future)
def _uniffi_trait_interface_call_async(make_call, handle_success, handle_error):
    async def make_call_and_call_callback():
        try:
            handle_success(await make_call())
        except Exception as e:
            print("UniFFI: Unhandled exception in trait interface call", file=sys.stderr)
            traceback.print_exc(file=sys.stderr)
            handle_error(
                _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR,
                _UniffiConverterString.lower(repr(e)),
            )
    eventloop = _uniffi_get_event_loop()
    task = asyncio.run_coroutine_threadsafe(make_call_and_call_callback(), eventloop)
    handle = _UNIFFI_FOREIGN_FUTURE_HANDLE_MAP.insert((eventloop, task))
    return _UniffiForeignFuture(handle, _uniffi_foreign_future_free)

def _uniffi_trait_interface_call_async_with_error(make_call, handle_success, handle_error, error_type, lower_error):
    async def make_call_and_call_callback():
        try:
            try:
                handle_success(await make_call())
            except error_type as e:
                handle_error(
                    _UniffiRustCallStatus.CALL_ERROR,
                    lower_error(e),
                )
        except Exception as e:
            print("UniFFI: Unhandled exception in trait interface call", file=sys.stderr)
            traceback.print_exc(file=sys.stderr)
            handle_error(
                _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR,
                _UniffiConverterString.lower(repr(e)),
            )
    eventloop = _uniffi_get_event_loop()
    task = asyncio.run_coroutine_threadsafe(make_call_and_call_callback(), eventloop)
    handle = _UNIFFI_FOREIGN_FUTURE_HANDLE_MAP.insert((eventloop, task))
    return _UniffiForeignFuture(handle, _uniffi_foreign_future_free)

_UNIFFI_FOREIGN_FUTURE_HANDLE_MAP = _UniffiHandleMap()

@_UNIFFI_FOREIGN_FUTURE_FREE
def _uniffi_foreign_future_free(handle):
    (eventloop, task) = _UNIFFI_FOREIGN_FUTURE_HANDLE_MAP.remove(handle)
    eventloop.call_soon(_uniffi_foreign_future_do_free, task)

def _uniffi_foreign_future_do_free(task):
    if not task.done():
        task.cancel()

def default_config(network: "Network") -> "Config":
    _UniffiConverterTypeNetwork.check_lower(network)
    
    return _UniffiConverterTypeConfig.lift(_uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_spark_fn_func_default_config,
        _UniffiConverterTypeNetwork.lower(network)))


def default_storage(data_dir: "str") -> "Storage":
    _UniffiConverterString.check_lower(data_dir)
    
    return _UniffiConverterTypeStorage.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_spark_fn_func_default_storage,
        _UniffiConverterString.lower(data_dir)))


def init_logging(log_dir: "typing.Optional[str]",app_logger: "typing.Optional[Logger]",log_filter: "typing.Optional[str]") -> None:
    _UniffiConverterOptionalString.check_lower(log_dir)
    
    _UniffiConverterOptionalTypeLogger.check_lower(app_logger)
    
    _UniffiConverterOptionalString.check_lower(log_filter)
    
    _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_spark_fn_func_init_logging,
        _UniffiConverterOptionalString.lower(log_dir),
        _UniffiConverterOptionalTypeLogger.lower(app_logger),
        _UniffiConverterOptionalString.lower(log_filter))

async def parse(input: "str") -> "InputType":

    _UniffiConverterString.check_lower(input)
    
    return await _uniffi_rust_call_async(
        _UniffiLib.uniffi_breez_sdk_spark_fn_func_parse(
        _UniffiConverterString.lower(input)),
        _UniffiLib.ffi_breez_sdk_spark_rust_future_poll_rust_buffer,
        _UniffiLib.ffi_breez_sdk_spark_rust_future_complete_rust_buffer,
        _UniffiLib.ffi_breez_sdk_spark_rust_future_free_rust_buffer,
        # lift function
        _UniffiConverterTypeInputType.lift,
        
    # Error FFI converter
_UniffiConverterTypeSdkError,

    )

__all__ = [
    "InternalError",
    "ChainServiceError",
    "DepositClaimError",
    "Fee",
    "Network",
    "OnchainConfirmationSpeed",
    "PaymentDetails",
    "PaymentMethod",
    "PaymentStatus",
    "PaymentType",
    "ReceivePaymentMethod",
    "SdkError",
    "SdkEvent",
    "SendPaymentMethod",
    "SendPaymentOptions",
    "StorageError",
    "UpdateDepositPayload",
    "ClaimDepositRequest",
    "ClaimDepositResponse",
    "Config",
    "Credentials",
    "DepositInfo",
    "GetInfoRequest",
    "GetInfoResponse",
    "GetPaymentRequest",
    "GetPaymentResponse",
    "ListPaymentsRequest",
    "ListPaymentsResponse",
    "ListUnclaimedDepositsRequest",
    "ListUnclaimedDepositsResponse",
    "LnurlPayInfo",
    "LnurlPayRequest",
    "LnurlPayResponse",
    "LogEntry",
    "Payment",
    "PaymentMetadata",
    "PrepareLnurlPayRequest",
    "PrepareLnurlPayResponse",
    "PrepareReceivePaymentRequest",
    "PrepareReceivePaymentResponse",
    "PrepareSendPaymentRequest",
    "PrepareSendPaymentResponse",
    "ReceivePaymentRequest",
    "ReceivePaymentResponse",
    "RefundDepositRequest",
    "RefundDepositResponse",
    "SendOnchainFeeQuote",
    "SendOnchainSpeedFeeQuote",
    "SendPaymentRequest",
    "SendPaymentResponse",
    "SyncWalletRequest",
    "SyncWalletResponse",
    "TxStatus",
    "Utxo",
    "default_config",
    "default_storage",
    "init_logging",
    "parse",
    "BitcoinChainService",
    "BreezSdk",
    "SdkBuilder",
    "Storage",
    "EventListener",
    "Logger",
]

