/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLbOutboundRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/lb_outbound_rule#id DataAzurermLbOutboundRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/lb_outbound_rule#loadbalancer_id DataAzurermLbOutboundRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/lb_outbound_rule#name DataAzurermLbOutboundRule#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/lb_outbound_rule#timeouts DataAzurermLbOutboundRule#timeouts}
    */
    readonly timeouts?: DataAzurermLbOutboundRuleTimeouts;
}
export interface DataAzurermLbOutboundRuleFrontendIpConfiguration {
}
export declare function dataAzurermLbOutboundRuleFrontendIpConfigurationToTerraform(struct?: DataAzurermLbOutboundRuleFrontendIpConfiguration): any;
export declare class DataAzurermLbOutboundRuleFrontendIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLbOutboundRuleFrontendIpConfiguration | undefined;
    set internalValue(value: DataAzurermLbOutboundRuleFrontendIpConfiguration | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataAzurermLbOutboundRuleFrontendIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLbOutboundRuleFrontendIpConfigurationOutputReference;
}
export interface DataAzurermLbOutboundRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/lb_outbound_rule#read DataAzurermLbOutboundRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLbOutboundRuleTimeoutsToTerraform(struct?: DataAzurermLbOutboundRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLbOutboundRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLbOutboundRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLbOutboundRuleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/lb_outbound_rule azurerm_lb_outbound_rule}
*/
export declare class DataAzurermLbOutboundRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_lb_outbound_rule";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/lb_outbound_rule azurerm_lb_outbound_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLbOutboundRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLbOutboundRuleConfig);
    get allocatedOutboundPorts(): number;
    get backendAddressPoolId(): string;
    private _frontendIpConfiguration;
    get frontendIpConfiguration(): DataAzurermLbOutboundRuleFrontendIpConfigurationList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idleTimeoutInMinutes(): number;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get protocol(): string;
    get tcpResetEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermLbOutboundRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLbOutboundRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLbOutboundRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
