/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPolicySetDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/policy_set_definition#display_name DataAzurermPolicySetDefinition#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/policy_set_definition#id DataAzurermPolicySetDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/policy_set_definition#management_group_name DataAzurermPolicySetDefinition#management_group_name}
    */
    readonly managementGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/policy_set_definition#name DataAzurermPolicySetDefinition#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/policy_set_definition#timeouts DataAzurermPolicySetDefinition#timeouts}
    */
    readonly timeouts?: DataAzurermPolicySetDefinitionTimeouts;
}
export interface DataAzurermPolicySetDefinitionPolicyDefinitionGroup {
}
export declare function dataAzurermPolicySetDefinitionPolicyDefinitionGroupToTerraform(struct?: DataAzurermPolicySetDefinitionPolicyDefinitionGroup): any;
export declare class DataAzurermPolicySetDefinitionPolicyDefinitionGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPolicySetDefinitionPolicyDefinitionGroup | undefined;
    set internalValue(value: DataAzurermPolicySetDefinitionPolicyDefinitionGroup | undefined);
    get additionalMetadataResourceId(): string;
    get category(): string;
    get description(): string;
    get displayName(): string;
    get name(): string;
}
export declare class DataAzurermPolicySetDefinitionPolicyDefinitionGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPolicySetDefinitionPolicyDefinitionGroupOutputReference;
}
export interface DataAzurermPolicySetDefinitionPolicyDefinitionReference {
}
export declare function dataAzurermPolicySetDefinitionPolicyDefinitionReferenceToTerraform(struct?: DataAzurermPolicySetDefinitionPolicyDefinitionReference): any;
export declare class DataAzurermPolicySetDefinitionPolicyDefinitionReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPolicySetDefinitionPolicyDefinitionReference | undefined;
    set internalValue(value: DataAzurermPolicySetDefinitionPolicyDefinitionReference | undefined);
    get parameterValues(): string;
    private _parameters;
    get parameters(): cdktf.StringMap;
    get policyDefinitionId(): string;
    get policyGroupNames(): string[];
    get referenceId(): string;
}
export declare class DataAzurermPolicySetDefinitionPolicyDefinitionReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPolicySetDefinitionPolicyDefinitionReferenceOutputReference;
}
export interface DataAzurermPolicySetDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/policy_set_definition#read DataAzurermPolicySetDefinition#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPolicySetDefinitionTimeoutsToTerraform(struct?: DataAzurermPolicySetDefinitionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPolicySetDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPolicySetDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPolicySetDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/policy_set_definition azurerm_policy_set_definition}
*/
export declare class DataAzurermPolicySetDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_policy_set_definition";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/policy_set_definition azurerm_policy_set_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPolicySetDefinitionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermPolicySetDefinitionConfig);
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managementGroupName?;
    get managementGroupName(): string;
    set managementGroupName(value: string);
    resetManagementGroupName(): void;
    get managementGroupNameInput(): string | undefined;
    get metadata(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get parameters(): string;
    private _policyDefinitionGroup;
    get policyDefinitionGroup(): DataAzurermPolicySetDefinitionPolicyDefinitionGroupList;
    private _policyDefinitionReference;
    get policyDefinitionReference(): DataAzurermPolicySetDefinitionPolicyDefinitionReferenceList;
    get policyDefinitions(): string;
    get policyType(): string;
    private _timeouts;
    get timeouts(): DataAzurermPolicySetDefinitionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPolicySetDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPolicySetDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
