/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPostgresqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/postgresql_flexible_server#id DataAzurermPostgresqlFlexibleServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/postgresql_flexible_server#name DataAzurermPostgresqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/postgresql_flexible_server#resource_group_name DataAzurermPostgresqlFlexibleServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/postgresql_flexible_server#timeouts DataAzurermPostgresqlFlexibleServer#timeouts}
    */
    readonly timeouts?: DataAzurermPostgresqlFlexibleServerTimeouts;
}
export interface DataAzurermPostgresqlFlexibleServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/postgresql_flexible_server#read DataAzurermPostgresqlFlexibleServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPostgresqlFlexibleServerTimeoutsToTerraform(struct?: DataAzurermPostgresqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPostgresqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPostgresqlFlexibleServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPostgresqlFlexibleServerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/postgresql_flexible_server azurerm_postgresql_flexible_server}
*/
export declare class DataAzurermPostgresqlFlexibleServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_postgresql_flexible_server";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/postgresql_flexible_server azurerm_postgresql_flexible_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPostgresqlFlexibleServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPostgresqlFlexibleServerConfig);
    get administratorLogin(): string;
    get backupRetentionDays(): number;
    get delegatedSubnetId(): string;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get storageMb(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermPostgresqlFlexibleServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPostgresqlFlexibleServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPostgresqlFlexibleServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
