/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateDnsSoaRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/private_dns_soa_record#id DataAzurermPrivateDnsSoaRecord#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/private_dns_soa_record#name DataAzurermPrivateDnsSoaRecord#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/private_dns_soa_record#resource_group_name DataAzurermPrivateDnsSoaRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/private_dns_soa_record#zone_name DataAzurermPrivateDnsSoaRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/private_dns_soa_record#timeouts DataAzurermPrivateDnsSoaRecord#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateDnsSoaRecordTimeouts;
}
export interface DataAzurermPrivateDnsSoaRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/private_dns_soa_record#read DataAzurermPrivateDnsSoaRecord#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateDnsSoaRecordTimeoutsToTerraform(struct?: DataAzurermPrivateDnsSoaRecordTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateDnsSoaRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPrivateDnsSoaRecordTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPrivateDnsSoaRecordTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/private_dns_soa_record azurerm_private_dns_soa_record}
*/
export declare class DataAzurermPrivateDnsSoaRecord extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_private_dns_soa_record";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/private_dns_soa_record azurerm_private_dns_soa_record} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateDnsSoaRecordConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateDnsSoaRecordConfig);
    get email(): string;
    get expireTime(): number;
    get fqdn(): string;
    get hostName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get minimumTtl(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get refreshTime(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get retryTime(): number;
    get serialNumber(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    get ttl(): number;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPrivateDnsSoaRecordTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateDnsSoaRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPrivateDnsSoaRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
