/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVmwarePrivateCloudConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/vmware_private_cloud#id DataAzurermVmwarePrivateCloud#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/vmware_private_cloud#name DataAzurermVmwarePrivateCloud#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/vmware_private_cloud#resource_group_name DataAzurermVmwarePrivateCloud#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/vmware_private_cloud#timeouts DataAzurermVmwarePrivateCloud#timeouts}
    */
    readonly timeouts?: DataAzurermVmwarePrivateCloudTimeouts;
}
export interface DataAzurermVmwarePrivateCloudCircuit {
}
export declare function dataAzurermVmwarePrivateCloudCircuitToTerraform(struct?: DataAzurermVmwarePrivateCloudCircuit): any;
export declare class DataAzurermVmwarePrivateCloudCircuitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVmwarePrivateCloudCircuit | undefined;
    set internalValue(value: DataAzurermVmwarePrivateCloudCircuit | undefined);
    get expressRouteId(): string;
    get expressRoutePrivatePeeringId(): string;
    get primarySubnetCidr(): string;
    get secondarySubnetCidr(): string;
}
export declare class DataAzurermVmwarePrivateCloudCircuitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVmwarePrivateCloudCircuitOutputReference;
}
export interface DataAzurermVmwarePrivateCloudManagementCluster {
}
export declare function dataAzurermVmwarePrivateCloudManagementClusterToTerraform(struct?: DataAzurermVmwarePrivateCloudManagementCluster): any;
export declare class DataAzurermVmwarePrivateCloudManagementClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVmwarePrivateCloudManagementCluster | undefined;
    set internalValue(value: DataAzurermVmwarePrivateCloudManagementCluster | undefined);
    get hosts(): string[];
    get id(): number;
    get size(): number;
}
export declare class DataAzurermVmwarePrivateCloudManagementClusterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVmwarePrivateCloudManagementClusterOutputReference;
}
export interface DataAzurermVmwarePrivateCloudTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/vmware_private_cloud#read DataAzurermVmwarePrivateCloud#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVmwarePrivateCloudTimeoutsToTerraform(struct?: DataAzurermVmwarePrivateCloudTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVmwarePrivateCloudTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVmwarePrivateCloudTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVmwarePrivateCloudTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/vmware_private_cloud azurerm_vmware_private_cloud}
*/
export declare class DataAzurermVmwarePrivateCloud extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_vmware_private_cloud";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/data-sources/vmware_private_cloud azurerm_vmware_private_cloud} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVmwarePrivateCloudConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVmwarePrivateCloudConfig);
    private _circuit;
    get circuit(): DataAzurermVmwarePrivateCloudCircuitList;
    get hcxCloudManagerEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internetConnectionEnabled(): cdktf.IResolvable;
    get location(): string;
    private _managementCluster;
    get managementCluster(): DataAzurermVmwarePrivateCloudManagementClusterList;
    get managementSubnetCidr(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkSubnetCidr(): string;
    get nsxtCertificateThumbprint(): string;
    get nsxtManagerEndpoint(): string;
    get provisioningSubnetCidr(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get vcenterCertificateThumbprint(): string;
    get vcsaEndpoint(): string;
    get vmotionSubnetCidr(): string;
    private _timeouts;
    get timeouts(): DataAzurermVmwarePrivateCloudTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVmwarePrivateCloudTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVmwarePrivateCloudTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
