/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryLinkedServiceAzureDatabricksConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#access_token DataFactoryLinkedServiceAzureDatabricks#access_token}
    */
    readonly accessToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#adb_domain DataFactoryLinkedServiceAzureDatabricks#adb_domain}
    */
    readonly adbDomain: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#additional_properties DataFactoryLinkedServiceAzureDatabricks#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#annotations DataFactoryLinkedServiceAzureDatabricks#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#data_factory_id DataFactoryLinkedServiceAzureDatabricks#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#description DataFactoryLinkedServiceAzureDatabricks#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#existing_cluster_id DataFactoryLinkedServiceAzureDatabricks#existing_cluster_id}
    */
    readonly existingClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#id DataFactoryLinkedServiceAzureDatabricks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#integration_runtime_name DataFactoryLinkedServiceAzureDatabricks#integration_runtime_name}
    */
    readonly integrationRuntimeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#msi_work_space_resource_id DataFactoryLinkedServiceAzureDatabricks#msi_work_space_resource_id}
    */
    readonly msiWorkSpaceResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#name DataFactoryLinkedServiceAzureDatabricks#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#parameters DataFactoryLinkedServiceAzureDatabricks#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * instance_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#instance_pool DataFactoryLinkedServiceAzureDatabricks#instance_pool}
    */
    readonly instancePool?: DataFactoryLinkedServiceAzureDatabricksInstancePool;
    /**
    * key_vault_password block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#key_vault_password DataFactoryLinkedServiceAzureDatabricks#key_vault_password}
    */
    readonly keyVaultPassword?: DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword;
    /**
    * new_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#new_cluster_config DataFactoryLinkedServiceAzureDatabricks#new_cluster_config}
    */
    readonly newClusterConfig?: DataFactoryLinkedServiceAzureDatabricksNewClusterConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#timeouts DataFactoryLinkedServiceAzureDatabricks#timeouts}
    */
    readonly timeouts?: DataFactoryLinkedServiceAzureDatabricksTimeouts;
}
export interface DataFactoryLinkedServiceAzureDatabricksInstancePool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#cluster_version DataFactoryLinkedServiceAzureDatabricks#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#instance_pool_id DataFactoryLinkedServiceAzureDatabricks#instance_pool_id}
    */
    readonly instancePoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#max_number_of_workers DataFactoryLinkedServiceAzureDatabricks#max_number_of_workers}
    */
    readonly maxNumberOfWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#min_number_of_workers DataFactoryLinkedServiceAzureDatabricks#min_number_of_workers}
    */
    readonly minNumberOfWorkers?: number;
}
export declare function dataFactoryLinkedServiceAzureDatabricksInstancePoolToTerraform(struct?: DataFactoryLinkedServiceAzureDatabricksInstancePoolOutputReference | DataFactoryLinkedServiceAzureDatabricksInstancePool): any;
export declare class DataFactoryLinkedServiceAzureDatabricksInstancePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryLinkedServiceAzureDatabricksInstancePool | undefined;
    set internalValue(value: DataFactoryLinkedServiceAzureDatabricksInstancePool | undefined);
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    private _instancePoolId?;
    get instancePoolId(): string;
    set instancePoolId(value: string);
    get instancePoolIdInput(): string | undefined;
    private _maxNumberOfWorkers?;
    get maxNumberOfWorkers(): number;
    set maxNumberOfWorkers(value: number);
    resetMaxNumberOfWorkers(): void;
    get maxNumberOfWorkersInput(): number | undefined;
    private _minNumberOfWorkers?;
    get minNumberOfWorkers(): number;
    set minNumberOfWorkers(value: number);
    resetMinNumberOfWorkers(): void;
    get minNumberOfWorkersInput(): number | undefined;
}
export interface DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#linked_service_name DataFactoryLinkedServiceAzureDatabricks#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#secret_name DataFactoryLinkedServiceAzureDatabricks#secret_name}
    */
    readonly secretName: string;
}
export declare function dataFactoryLinkedServiceAzureDatabricksKeyVaultPasswordToTerraform(struct?: DataFactoryLinkedServiceAzureDatabricksKeyVaultPasswordOutputReference | DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword): any;
export declare class DataFactoryLinkedServiceAzureDatabricksKeyVaultPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword | undefined;
    set internalValue(value: DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword | undefined);
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
}
export interface DataFactoryLinkedServiceAzureDatabricksNewClusterConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#cluster_version DataFactoryLinkedServiceAzureDatabricks#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#custom_tags DataFactoryLinkedServiceAzureDatabricks#custom_tags}
    */
    readonly customTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#driver_node_type DataFactoryLinkedServiceAzureDatabricks#driver_node_type}
    */
    readonly driverNodeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#init_scripts DataFactoryLinkedServiceAzureDatabricks#init_scripts}
    */
    readonly initScripts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#log_destination DataFactoryLinkedServiceAzureDatabricks#log_destination}
    */
    readonly logDestination?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#max_number_of_workers DataFactoryLinkedServiceAzureDatabricks#max_number_of_workers}
    */
    readonly maxNumberOfWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#min_number_of_workers DataFactoryLinkedServiceAzureDatabricks#min_number_of_workers}
    */
    readonly minNumberOfWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#node_type DataFactoryLinkedServiceAzureDatabricks#node_type}
    */
    readonly nodeType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#spark_config DataFactoryLinkedServiceAzureDatabricks#spark_config}
    */
    readonly sparkConfig?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#spark_environment_variables DataFactoryLinkedServiceAzureDatabricks#spark_environment_variables}
    */
    readonly sparkEnvironmentVariables?: {
        [key: string]: string;
    };
}
export declare function dataFactoryLinkedServiceAzureDatabricksNewClusterConfigToTerraform(struct?: DataFactoryLinkedServiceAzureDatabricksNewClusterConfigOutputReference | DataFactoryLinkedServiceAzureDatabricksNewClusterConfig): any;
export declare class DataFactoryLinkedServiceAzureDatabricksNewClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryLinkedServiceAzureDatabricksNewClusterConfig | undefined;
    set internalValue(value: DataFactoryLinkedServiceAzureDatabricksNewClusterConfig | undefined);
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    private _customTags?;
    get customTags(): {
        [key: string]: string;
    };
    set customTags(value: {
        [key: string]: string;
    });
    resetCustomTags(): void;
    get customTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _driverNodeType?;
    get driverNodeType(): string;
    set driverNodeType(value: string);
    resetDriverNodeType(): void;
    get driverNodeTypeInput(): string | undefined;
    private _initScripts?;
    get initScripts(): string[];
    set initScripts(value: string[]);
    resetInitScripts(): void;
    get initScriptsInput(): string[] | undefined;
    private _logDestination?;
    get logDestination(): string;
    set logDestination(value: string);
    resetLogDestination(): void;
    get logDestinationInput(): string | undefined;
    private _maxNumberOfWorkers?;
    get maxNumberOfWorkers(): number;
    set maxNumberOfWorkers(value: number);
    resetMaxNumberOfWorkers(): void;
    get maxNumberOfWorkersInput(): number | undefined;
    private _minNumberOfWorkers?;
    get minNumberOfWorkers(): number;
    set minNumberOfWorkers(value: number);
    resetMinNumberOfWorkers(): void;
    get minNumberOfWorkersInput(): number | undefined;
    private _nodeType?;
    get nodeType(): string;
    set nodeType(value: string);
    get nodeTypeInput(): string | undefined;
    private _sparkConfig?;
    get sparkConfig(): {
        [key: string]: string;
    };
    set sparkConfig(value: {
        [key: string]: string;
    });
    resetSparkConfig(): void;
    get sparkConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _sparkEnvironmentVariables?;
    get sparkEnvironmentVariables(): {
        [key: string]: string;
    };
    set sparkEnvironmentVariables(value: {
        [key: string]: string;
    });
    resetSparkEnvironmentVariables(): void;
    get sparkEnvironmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryLinkedServiceAzureDatabricksTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#create DataFactoryLinkedServiceAzureDatabricks#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#delete DataFactoryLinkedServiceAzureDatabricks#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#read DataFactoryLinkedServiceAzureDatabricks#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks#update DataFactoryLinkedServiceAzureDatabricks#update}
    */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceAzureDatabricksTimeoutsToTerraform(struct?: DataFactoryLinkedServiceAzureDatabricksTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryLinkedServiceAzureDatabricksTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryLinkedServiceAzureDatabricksTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryLinkedServiceAzureDatabricksTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks azurerm_data_factory_linked_service_azure_databricks}
*/
export declare class DataFactoryLinkedServiceAzureDatabricks extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_linked_service_azure_databricks";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/data_factory_linked_service_azure_databricks azurerm_data_factory_linked_service_azure_databricks} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryLinkedServiceAzureDatabricksConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceAzureDatabricksConfig);
    private _accessToken?;
    get accessToken(): string;
    set accessToken(value: string);
    resetAccessToken(): void;
    get accessTokenInput(): string | undefined;
    private _adbDomain?;
    get adbDomain(): string;
    set adbDomain(value: string);
    get adbDomainInput(): string | undefined;
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _existingClusterId?;
    get existingClusterId(): string;
    set existingClusterId(value: string);
    resetExistingClusterId(): void;
    get existingClusterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationRuntimeName?;
    get integrationRuntimeName(): string;
    set integrationRuntimeName(value: string);
    resetIntegrationRuntimeName(): void;
    get integrationRuntimeNameInput(): string | undefined;
    private _msiWorkSpaceResourceId?;
    get msiWorkSpaceResourceId(): string;
    set msiWorkSpaceResourceId(value: string);
    resetMsiWorkSpaceResourceId(): void;
    get msiWorkSpaceResourceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _instancePool;
    get instancePool(): DataFactoryLinkedServiceAzureDatabricksInstancePoolOutputReference;
    putInstancePool(value: DataFactoryLinkedServiceAzureDatabricksInstancePool): void;
    resetInstancePool(): void;
    get instancePoolInput(): DataFactoryLinkedServiceAzureDatabricksInstancePool | undefined;
    private _keyVaultPassword;
    get keyVaultPassword(): DataFactoryLinkedServiceAzureDatabricksKeyVaultPasswordOutputReference;
    putKeyVaultPassword(value: DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword): void;
    resetKeyVaultPassword(): void;
    get keyVaultPasswordInput(): DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword | undefined;
    private _newClusterConfig;
    get newClusterConfig(): DataFactoryLinkedServiceAzureDatabricksNewClusterConfigOutputReference;
    putNewClusterConfig(value: DataFactoryLinkedServiceAzureDatabricksNewClusterConfig): void;
    resetNewClusterConfig(): void;
    get newClusterConfigInput(): DataFactoryLinkedServiceAzureDatabricksNewClusterConfig | undefined;
    private _timeouts;
    get timeouts(): DataFactoryLinkedServiceAzureDatabricksTimeoutsOutputReference;
    putTimeouts(value: DataFactoryLinkedServiceAzureDatabricksTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryLinkedServiceAzureDatabricksTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
