/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareMedtechServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#device_mapping_json HealthcareMedtechService#device_mapping_json}
    */
    readonly deviceMappingJson: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#eventhub_consumer_group_name HealthcareMedtechService#eventhub_consumer_group_name}
    */
    readonly eventhubConsumerGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#eventhub_name HealthcareMedtechService#eventhub_name}
    */
    readonly eventhubName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#eventhub_namespace_name HealthcareMedtechService#eventhub_namespace_name}
    */
    readonly eventhubNamespaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#id HealthcareMedtechService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#location HealthcareMedtechService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#name HealthcareMedtechService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#tags HealthcareMedtechService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#workspace_id HealthcareMedtechService#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#identity HealthcareMedtechService#identity}
    */
    readonly identity?: HealthcareMedtechServiceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#timeouts HealthcareMedtechService#timeouts}
    */
    readonly timeouts?: HealthcareMedtechServiceTimeouts;
}
export interface HealthcareMedtechServiceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#identity_ids HealthcareMedtechService#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#type HealthcareMedtechService#type}
    */
    readonly type: string;
}
export declare function healthcareMedtechServiceIdentityToTerraform(struct?: HealthcareMedtechServiceIdentityOutputReference | HealthcareMedtechServiceIdentity): any;
export declare class HealthcareMedtechServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareMedtechServiceIdentity | undefined;
    set internalValue(value: HealthcareMedtechServiceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface HealthcareMedtechServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#create HealthcareMedtechService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#delete HealthcareMedtechService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#read HealthcareMedtechService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service#update HealthcareMedtechService#update}
    */
    readonly update?: string;
}
export declare function healthcareMedtechServiceTimeoutsToTerraform(struct?: HealthcareMedtechServiceTimeouts | cdktf.IResolvable): any;
export declare class HealthcareMedtechServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareMedtechServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HealthcareMedtechServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service azurerm_healthcare_medtech_service}
*/
export declare class HealthcareMedtechService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_healthcare_medtech_service";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/healthcare_medtech_service azurerm_healthcare_medtech_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareMedtechServiceConfig
    */
    constructor(scope: Construct, id: string, config: HealthcareMedtechServiceConfig);
    private _deviceMappingJson?;
    get deviceMappingJson(): string;
    set deviceMappingJson(value: string);
    get deviceMappingJsonInput(): string | undefined;
    private _eventhubConsumerGroupName?;
    get eventhubConsumerGroupName(): string;
    set eventhubConsumerGroupName(value: string);
    get eventhubConsumerGroupNameInput(): string | undefined;
    private _eventhubName?;
    get eventhubName(): string;
    set eventhubName(value: string);
    get eventhubNameInput(): string | undefined;
    private _eventhubNamespaceName?;
    get eventhubNamespaceName(): string;
    set eventhubNamespaceName(value: string);
    get eventhubNamespaceNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _identity;
    get identity(): HealthcareMedtechServiceIdentityOutputReference;
    putIdentity(value: HealthcareMedtechServiceIdentity): void;
    resetIdentity(): void;
    get identityInput(): HealthcareMedtechServiceIdentity | undefined;
    private _timeouts;
    get timeouts(): HealthcareMedtechServiceTimeoutsOutputReference;
    putTimeouts(value: HealthcareMedtechServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HealthcareMedtechServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
