/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubDpsSharedAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#enrollment_read IothubDpsSharedAccessPolicy#enrollment_read}
    */
    readonly enrollmentRead?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#enrollment_write IothubDpsSharedAccessPolicy#enrollment_write}
    */
    readonly enrollmentWrite?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#id IothubDpsSharedAccessPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#iothub_dps_name IothubDpsSharedAccessPolicy#iothub_dps_name}
    */
    readonly iothubDpsName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#name IothubDpsSharedAccessPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#registration_read IothubDpsSharedAccessPolicy#registration_read}
    */
    readonly registrationRead?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#registration_write IothubDpsSharedAccessPolicy#registration_write}
    */
    readonly registrationWrite?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#resource_group_name IothubDpsSharedAccessPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#service_config IothubDpsSharedAccessPolicy#service_config}
    */
    readonly serviceConfig?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#timeouts IothubDpsSharedAccessPolicy#timeouts}
    */
    readonly timeouts?: IothubDpsSharedAccessPolicyTimeouts;
}
export interface IothubDpsSharedAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#create IothubDpsSharedAccessPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#delete IothubDpsSharedAccessPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#read IothubDpsSharedAccessPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy#update IothubDpsSharedAccessPolicy#update}
    */
    readonly update?: string;
}
export declare function iothubDpsSharedAccessPolicyTimeoutsToTerraform(struct?: IothubDpsSharedAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class IothubDpsSharedAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubDpsSharedAccessPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IothubDpsSharedAccessPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy azurerm_iothub_dps_shared_access_policy}
*/
export declare class IothubDpsSharedAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iothub_dps_shared_access_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/iothub_dps_shared_access_policy azurerm_iothub_dps_shared_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubDpsSharedAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: IothubDpsSharedAccessPolicyConfig);
    private _enrollmentRead?;
    get enrollmentRead(): boolean | cdktf.IResolvable;
    set enrollmentRead(value: boolean | cdktf.IResolvable);
    resetEnrollmentRead(): void;
    get enrollmentReadInput(): boolean | cdktf.IResolvable | undefined;
    private _enrollmentWrite?;
    get enrollmentWrite(): boolean | cdktf.IResolvable;
    set enrollmentWrite(value: boolean | cdktf.IResolvable);
    resetEnrollmentWrite(): void;
    get enrollmentWriteInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iothubDpsName?;
    get iothubDpsName(): string;
    set iothubDpsName(value: string);
    get iothubDpsNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryKey(): string;
    private _registrationRead?;
    get registrationRead(): boolean | cdktf.IResolvable;
    set registrationRead(value: boolean | cdktf.IResolvable);
    resetRegistrationRead(): void;
    get registrationReadInput(): boolean | cdktf.IResolvable | undefined;
    private _registrationWrite?;
    get registrationWrite(): boolean | cdktf.IResolvable;
    set registrationWrite(value: boolean | cdktf.IResolvable);
    resetRegistrationWrite(): void;
    get registrationWriteInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryKey(): string;
    private _serviceConfig?;
    get serviceConfig(): boolean | cdktf.IResolvable;
    set serviceConfig(value: boolean | cdktf.IResolvable);
    resetServiceConfig(): void;
    get serviceConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): IothubDpsSharedAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: IothubDpsSharedAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IothubDpsSharedAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
