/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultManagedStorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#id KeyVaultManagedStorageAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#key_vault_id KeyVaultManagedStorageAccount#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#name KeyVaultManagedStorageAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#regenerate_key_automatically KeyVaultManagedStorageAccount#regenerate_key_automatically}
    */
    readonly regenerateKeyAutomatically?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#regeneration_period KeyVaultManagedStorageAccount#regeneration_period}
    */
    readonly regenerationPeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#storage_account_id KeyVaultManagedStorageAccount#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#storage_account_key KeyVaultManagedStorageAccount#storage_account_key}
    */
    readonly storageAccountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#tags KeyVaultManagedStorageAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#timeouts KeyVaultManagedStorageAccount#timeouts}
    */
    readonly timeouts?: KeyVaultManagedStorageAccountTimeouts;
}
export interface KeyVaultManagedStorageAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#create KeyVaultManagedStorageAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#delete KeyVaultManagedStorageAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#read KeyVaultManagedStorageAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account#update KeyVaultManagedStorageAccount#update}
    */
    readonly update?: string;
}
export declare function keyVaultManagedStorageAccountTimeoutsToTerraform(struct?: KeyVaultManagedStorageAccountTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultManagedStorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultManagedStorageAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultManagedStorageAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account azurerm_key_vault_managed_storage_account}
*/
export declare class KeyVaultManagedStorageAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_key_vault_managed_storage_account";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/key_vault_managed_storage_account azurerm_key_vault_managed_storage_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultManagedStorageAccountConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultManagedStorageAccountConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _regenerateKeyAutomatically?;
    get regenerateKeyAutomatically(): boolean | cdktf.IResolvable;
    set regenerateKeyAutomatically(value: boolean | cdktf.IResolvable);
    resetRegenerateKeyAutomatically(): void;
    get regenerateKeyAutomaticallyInput(): boolean | cdktf.IResolvable | undefined;
    private _regenerationPeriod?;
    get regenerationPeriod(): string;
    set regenerationPeriod(value: string);
    resetRegenerationPeriod(): void;
    get regenerationPeriodInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _storageAccountKey?;
    get storageAccountKey(): string;
    set storageAccountKey(value: string);
    get storageAccountKeyInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): KeyVaultManagedStorageAccountTimeoutsOutputReference;
    putTimeouts(value: KeyVaultManagedStorageAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KeyVaultManagedStorageAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
