"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesClusterNodePool = exports.KubernetesClusterNodePoolWindowsProfileOutputReference = exports.kubernetesClusterNodePoolWindowsProfileToTerraform = exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = exports.KubernetesClusterNodePoolTimeoutsOutputReference = exports.kubernetesClusterNodePoolTimeoutsToTerraform = exports.KubernetesClusterNodePoolNodeNetworkProfileOutputReference = exports.kubernetesClusterNodePoolNodeNetworkProfileToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = exports.KubernetesClusterNodePoolKubeletConfigOutputReference = exports.kubernetesClusterNodePoolKubeletConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function kubernetesClusterNodePoolKubeletConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_unsafe_sysctls: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.allowedUnsafeSysctls),
        container_log_max_line: cdktf.numberToTerraform(struct.containerLogMaxLine),
        container_log_max_size_mb: cdktf.numberToTerraform(struct.containerLogMaxSizeMb),
        cpu_cfs_quota_enabled: cdktf.booleanToTerraform(struct.cpuCfsQuotaEnabled),
        cpu_cfs_quota_period: cdktf.stringToTerraform(struct.cpuCfsQuotaPeriod),
        cpu_manager_policy: cdktf.stringToTerraform(struct.cpuManagerPolicy),
        image_gc_high_threshold: cdktf.numberToTerraform(struct.imageGcHighThreshold),
        image_gc_low_threshold: cdktf.numberToTerraform(struct.imageGcLowThreshold),
        pod_max_pid: cdktf.numberToTerraform(struct.podMaxPid),
        topology_manager_policy: cdktf.stringToTerraform(struct.topologyManagerPolicy),
    };
}
exports.kubernetesClusterNodePoolKubeletConfigToTerraform = kubernetesClusterNodePoolKubeletConfigToTerraform;
class KubernetesClusterNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedUnsafeSysctls !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedUnsafeSysctls = this._allowedUnsafeSysctls;
        }
        if (this._containerLogMaxLine !== undefined) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxLine = this._containerLogMaxLine;
        }
        if (this._containerLogMaxSizeMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxSizeMb = this._containerLogMaxSizeMb;
        }
        if (this._cpuCfsQuotaEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaEnabled = this._cpuCfsQuotaEnabled;
        }
        if (this._cpuCfsQuotaPeriod !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaPeriod = this._cpuCfsQuotaPeriod;
        }
        if (this._cpuManagerPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuManagerPolicy = this._cpuManagerPolicy;
        }
        if (this._imageGcHighThreshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageGcHighThreshold = this._imageGcHighThreshold;
        }
        if (this._imageGcLowThreshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageGcLowThreshold = this._imageGcLowThreshold;
        }
        if (this._podMaxPid !== undefined) {
            hasAnyValues = true;
            internalValueResult.podMaxPid = this._podMaxPid;
        }
        if (this._topologyManagerPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.topologyManagerPolicy = this._topologyManagerPolicy;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._allowedUnsafeSysctls = undefined;
            this._containerLogMaxLine = undefined;
            this._containerLogMaxSizeMb = undefined;
            this._cpuCfsQuotaEnabled = undefined;
            this._cpuCfsQuotaPeriod = undefined;
            this._cpuManagerPolicy = undefined;
            this._imageGcHighThreshold = undefined;
            this._imageGcLowThreshold = undefined;
            this._podMaxPid = undefined;
            this._topologyManagerPolicy = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._allowedUnsafeSysctls = value.allowedUnsafeSysctls;
            this._containerLogMaxLine = value.containerLogMaxLine;
            this._containerLogMaxSizeMb = value.containerLogMaxSizeMb;
            this._cpuCfsQuotaEnabled = value.cpuCfsQuotaEnabled;
            this._cpuCfsQuotaPeriod = value.cpuCfsQuotaPeriod;
            this._cpuManagerPolicy = value.cpuManagerPolicy;
            this._imageGcHighThreshold = value.imageGcHighThreshold;
            this._imageGcLowThreshold = value.imageGcLowThreshold;
            this._podMaxPid = value.podMaxPid;
            this._topologyManagerPolicy = value.topologyManagerPolicy;
        }
    }
    get allowedUnsafeSysctls() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_unsafe_sysctls'));
    }
    set allowedUnsafeSysctls(value) {
        this._allowedUnsafeSysctls = value;
    }
    resetAllowedUnsafeSysctls() {
        this._allowedUnsafeSysctls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedUnsafeSysctlsInput() {
        return this._allowedUnsafeSysctls;
    }
    get containerLogMaxLine() {
        return this.getNumberAttribute('container_log_max_line');
    }
    set containerLogMaxLine(value) {
        this._containerLogMaxLine = value;
    }
    resetContainerLogMaxLine() {
        this._containerLogMaxLine = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerLogMaxLineInput() {
        return this._containerLogMaxLine;
    }
    get containerLogMaxSizeMb() {
        return this.getNumberAttribute('container_log_max_size_mb');
    }
    set containerLogMaxSizeMb(value) {
        this._containerLogMaxSizeMb = value;
    }
    resetContainerLogMaxSizeMb() {
        this._containerLogMaxSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerLogMaxSizeMbInput() {
        return this._containerLogMaxSizeMb;
    }
    get cpuCfsQuotaEnabled() {
        return this.getBooleanAttribute('cpu_cfs_quota_enabled');
    }
    set cpuCfsQuotaEnabled(value) {
        this._cpuCfsQuotaEnabled = value;
    }
    resetCpuCfsQuotaEnabled() {
        this._cpuCfsQuotaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuCfsQuotaEnabledInput() {
        return this._cpuCfsQuotaEnabled;
    }
    get cpuCfsQuotaPeriod() {
        return this.getStringAttribute('cpu_cfs_quota_period');
    }
    set cpuCfsQuotaPeriod(value) {
        this._cpuCfsQuotaPeriod = value;
    }
    resetCpuCfsQuotaPeriod() {
        this._cpuCfsQuotaPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuCfsQuotaPeriodInput() {
        return this._cpuCfsQuotaPeriod;
    }
    get cpuManagerPolicy() {
        return this.getStringAttribute('cpu_manager_policy');
    }
    set cpuManagerPolicy(value) {
        this._cpuManagerPolicy = value;
    }
    resetCpuManagerPolicy() {
        this._cpuManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuManagerPolicyInput() {
        return this._cpuManagerPolicy;
    }
    get imageGcHighThreshold() {
        return this.getNumberAttribute('image_gc_high_threshold');
    }
    set imageGcHighThreshold(value) {
        this._imageGcHighThreshold = value;
    }
    resetImageGcHighThreshold() {
        this._imageGcHighThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageGcHighThresholdInput() {
        return this._imageGcHighThreshold;
    }
    get imageGcLowThreshold() {
        return this.getNumberAttribute('image_gc_low_threshold');
    }
    set imageGcLowThreshold(value) {
        this._imageGcLowThreshold = value;
    }
    resetImageGcLowThreshold() {
        this._imageGcLowThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageGcLowThresholdInput() {
        return this._imageGcLowThreshold;
    }
    get podMaxPid() {
        return this.getNumberAttribute('pod_max_pid');
    }
    set podMaxPid(value) {
        this._podMaxPid = value;
    }
    resetPodMaxPid() {
        this._podMaxPid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podMaxPidInput() {
        return this._podMaxPid;
    }
    get topologyManagerPolicy() {
        return this.getStringAttribute('topology_manager_policy');
    }
    set topologyManagerPolicy(value) {
        this._topologyManagerPolicy = value;
    }
    resetTopologyManagerPolicy() {
        this._topologyManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topologyManagerPolicyInput() {
        return this._topologyManagerPolicy;
    }
}
exports.KubernetesClusterNodePoolKubeletConfigOutputReference = KubernetesClusterNodePoolKubeletConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolKubeletConfigOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolKubeletConfigOutputReference", version: "9.0.3" };
function kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        fs_aio_max_nr: cdktf.numberToTerraform(struct.fsAioMaxNr),
        fs_file_max: cdktf.numberToTerraform(struct.fsFileMax),
        fs_inotify_max_user_watches: cdktf.numberToTerraform(struct.fsInotifyMaxUserWatches),
        fs_nr_open: cdktf.numberToTerraform(struct.fsNrOpen),
        kernel_threads_max: cdktf.numberToTerraform(struct.kernelThreadsMax),
        net_core_netdev_max_backlog: cdktf.numberToTerraform(struct.netCoreNetdevMaxBacklog),
        net_core_optmem_max: cdktf.numberToTerraform(struct.netCoreOptmemMax),
        net_core_rmem_default: cdktf.numberToTerraform(struct.netCoreRmemDefault),
        net_core_rmem_max: cdktf.numberToTerraform(struct.netCoreRmemMax),
        net_core_somaxconn: cdktf.numberToTerraform(struct.netCoreSomaxconn),
        net_core_wmem_default: cdktf.numberToTerraform(struct.netCoreWmemDefault),
        net_core_wmem_max: cdktf.numberToTerraform(struct.netCoreWmemMax),
        net_ipv4_ip_local_port_range_max: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMax),
        net_ipv4_ip_local_port_range_min: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMin),
        net_ipv4_neigh_default_gc_thresh1: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh1),
        net_ipv4_neigh_default_gc_thresh2: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh2),
        net_ipv4_neigh_default_gc_thresh3: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh3),
        net_ipv4_tcp_fin_timeout: cdktf.numberToTerraform(struct.netIpv4TcpFinTimeout),
        net_ipv4_tcp_keepalive_intvl: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveIntvl),
        net_ipv4_tcp_keepalive_probes: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveProbes),
        net_ipv4_tcp_keepalive_time: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveTime),
        net_ipv4_tcp_max_syn_backlog: cdktf.numberToTerraform(struct.netIpv4TcpMaxSynBacklog),
        net_ipv4_tcp_max_tw_buckets: cdktf.numberToTerraform(struct.netIpv4TcpMaxTwBuckets),
        net_ipv4_tcp_tw_reuse: cdktf.booleanToTerraform(struct.netIpv4TcpTwReuse),
        net_netfilter_nf_conntrack_buckets: cdktf.numberToTerraform(struct.netNetfilterNfConntrackBuckets),
        net_netfilter_nf_conntrack_max: cdktf.numberToTerraform(struct.netNetfilterNfConntrackMax),
        vm_max_map_count: cdktf.numberToTerraform(struct.vmMaxMapCount),
        vm_swappiness: cdktf.numberToTerraform(struct.vmSwappiness),
        vm_vfs_cache_pressure: cdktf.numberToTerraform(struct.vmVfsCachePressure),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform;
class KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._fsAioMaxNr !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsAioMaxNr = this._fsAioMaxNr;
        }
        if (this._fsFileMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsFileMax = this._fsFileMax;
        }
        if (this._fsInotifyMaxUserWatches !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsInotifyMaxUserWatches = this._fsInotifyMaxUserWatches;
        }
        if (this._fsNrOpen !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsNrOpen = this._fsNrOpen;
        }
        if (this._kernelThreadsMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.kernelThreadsMax = this._kernelThreadsMax;
        }
        if (this._netCoreNetdevMaxBacklog !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreNetdevMaxBacklog = this._netCoreNetdevMaxBacklog;
        }
        if (this._netCoreOptmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreOptmemMax = this._netCoreOptmemMax;
        }
        if (this._netCoreRmemDefault !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemDefault = this._netCoreRmemDefault;
        }
        if (this._netCoreRmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemMax = this._netCoreRmemMax;
        }
        if (this._netCoreSomaxconn !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreSomaxconn = this._netCoreSomaxconn;
        }
        if (this._netCoreWmemDefault !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemDefault = this._netCoreWmemDefault;
        }
        if (this._netCoreWmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemMax = this._netCoreWmemMax;
        }
        if (this._netIpv4IpLocalPortRangeMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMax = this._netIpv4IpLocalPortRangeMax;
        }
        if (this._netIpv4IpLocalPortRangeMin !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMin = this._netIpv4IpLocalPortRangeMin;
        }
        if (this._netIpv4NeighDefaultGcThresh1 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh1 = this._netIpv4NeighDefaultGcThresh1;
        }
        if (this._netIpv4NeighDefaultGcThresh2 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh2 = this._netIpv4NeighDefaultGcThresh2;
        }
        if (this._netIpv4NeighDefaultGcThresh3 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh3 = this._netIpv4NeighDefaultGcThresh3;
        }
        if (this._netIpv4TcpFinTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpFinTimeout = this._netIpv4TcpFinTimeout;
        }
        if (this._netIpv4TcpKeepaliveIntvl !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveIntvl = this._netIpv4TcpKeepaliveIntvl;
        }
        if (this._netIpv4TcpKeepaliveProbes !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveProbes = this._netIpv4TcpKeepaliveProbes;
        }
        if (this._netIpv4TcpKeepaliveTime !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveTime = this._netIpv4TcpKeepaliveTime;
        }
        if (this._netIpv4TcpMaxSynBacklog !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxSynBacklog = this._netIpv4TcpMaxSynBacklog;
        }
        if (this._netIpv4TcpMaxTwBuckets !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxTwBuckets = this._netIpv4TcpMaxTwBuckets;
        }
        if (this._netIpv4TcpTwReuse !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpTwReuse = this._netIpv4TcpTwReuse;
        }
        if (this._netNetfilterNfConntrackBuckets !== undefined) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackBuckets = this._netNetfilterNfConntrackBuckets;
        }
        if (this._netNetfilterNfConntrackMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackMax = this._netNetfilterNfConntrackMax;
        }
        if (this._vmMaxMapCount !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmMaxMapCount = this._vmMaxMapCount;
        }
        if (this._vmSwappiness !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmSwappiness = this._vmSwappiness;
        }
        if (this._vmVfsCachePressure !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmVfsCachePressure = this._vmVfsCachePressure;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._fsAioMaxNr = undefined;
            this._fsFileMax = undefined;
            this._fsInotifyMaxUserWatches = undefined;
            this._fsNrOpen = undefined;
            this._kernelThreadsMax = undefined;
            this._netCoreNetdevMaxBacklog = undefined;
            this._netCoreOptmemMax = undefined;
            this._netCoreRmemDefault = undefined;
            this._netCoreRmemMax = undefined;
            this._netCoreSomaxconn = undefined;
            this._netCoreWmemDefault = undefined;
            this._netCoreWmemMax = undefined;
            this._netIpv4IpLocalPortRangeMax = undefined;
            this._netIpv4IpLocalPortRangeMin = undefined;
            this._netIpv4NeighDefaultGcThresh1 = undefined;
            this._netIpv4NeighDefaultGcThresh2 = undefined;
            this._netIpv4NeighDefaultGcThresh3 = undefined;
            this._netIpv4TcpFinTimeout = undefined;
            this._netIpv4TcpKeepaliveIntvl = undefined;
            this._netIpv4TcpKeepaliveProbes = undefined;
            this._netIpv4TcpKeepaliveTime = undefined;
            this._netIpv4TcpMaxSynBacklog = undefined;
            this._netIpv4TcpMaxTwBuckets = undefined;
            this._netIpv4TcpTwReuse = undefined;
            this._netNetfilterNfConntrackBuckets = undefined;
            this._netNetfilterNfConntrackMax = undefined;
            this._vmMaxMapCount = undefined;
            this._vmSwappiness = undefined;
            this._vmVfsCachePressure = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._fsAioMaxNr = value.fsAioMaxNr;
            this._fsFileMax = value.fsFileMax;
            this._fsInotifyMaxUserWatches = value.fsInotifyMaxUserWatches;
            this._fsNrOpen = value.fsNrOpen;
            this._kernelThreadsMax = value.kernelThreadsMax;
            this._netCoreNetdevMaxBacklog = value.netCoreNetdevMaxBacklog;
            this._netCoreOptmemMax = value.netCoreOptmemMax;
            this._netCoreRmemDefault = value.netCoreRmemDefault;
            this._netCoreRmemMax = value.netCoreRmemMax;
            this._netCoreSomaxconn = value.netCoreSomaxconn;
            this._netCoreWmemDefault = value.netCoreWmemDefault;
            this._netCoreWmemMax = value.netCoreWmemMax;
            this._netIpv4IpLocalPortRangeMax = value.netIpv4IpLocalPortRangeMax;
            this._netIpv4IpLocalPortRangeMin = value.netIpv4IpLocalPortRangeMin;
            this._netIpv4NeighDefaultGcThresh1 = value.netIpv4NeighDefaultGcThresh1;
            this._netIpv4NeighDefaultGcThresh2 = value.netIpv4NeighDefaultGcThresh2;
            this._netIpv4NeighDefaultGcThresh3 = value.netIpv4NeighDefaultGcThresh3;
            this._netIpv4TcpFinTimeout = value.netIpv4TcpFinTimeout;
            this._netIpv4TcpKeepaliveIntvl = value.netIpv4TcpKeepaliveIntvl;
            this._netIpv4TcpKeepaliveProbes = value.netIpv4TcpKeepaliveProbes;
            this._netIpv4TcpKeepaliveTime = value.netIpv4TcpKeepaliveTime;
            this._netIpv4TcpMaxSynBacklog = value.netIpv4TcpMaxSynBacklog;
            this._netIpv4TcpMaxTwBuckets = value.netIpv4TcpMaxTwBuckets;
            this._netIpv4TcpTwReuse = value.netIpv4TcpTwReuse;
            this._netNetfilterNfConntrackBuckets = value.netNetfilterNfConntrackBuckets;
            this._netNetfilterNfConntrackMax = value.netNetfilterNfConntrackMax;
            this._vmMaxMapCount = value.vmMaxMapCount;
            this._vmSwappiness = value.vmSwappiness;
            this._vmVfsCachePressure = value.vmVfsCachePressure;
        }
    }
    get fsAioMaxNr() {
        return this.getNumberAttribute('fs_aio_max_nr');
    }
    set fsAioMaxNr(value) {
        this._fsAioMaxNr = value;
    }
    resetFsAioMaxNr() {
        this._fsAioMaxNr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsAioMaxNrInput() {
        return this._fsAioMaxNr;
    }
    get fsFileMax() {
        return this.getNumberAttribute('fs_file_max');
    }
    set fsFileMax(value) {
        this._fsFileMax = value;
    }
    resetFsFileMax() {
        this._fsFileMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsFileMaxInput() {
        return this._fsFileMax;
    }
    get fsInotifyMaxUserWatches() {
        return this.getNumberAttribute('fs_inotify_max_user_watches');
    }
    set fsInotifyMaxUserWatches(value) {
        this._fsInotifyMaxUserWatches = value;
    }
    resetFsInotifyMaxUserWatches() {
        this._fsInotifyMaxUserWatches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsInotifyMaxUserWatchesInput() {
        return this._fsInotifyMaxUserWatches;
    }
    get fsNrOpen() {
        return this.getNumberAttribute('fs_nr_open');
    }
    set fsNrOpen(value) {
        this._fsNrOpen = value;
    }
    resetFsNrOpen() {
        this._fsNrOpen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsNrOpenInput() {
        return this._fsNrOpen;
    }
    get kernelThreadsMax() {
        return this.getNumberAttribute('kernel_threads_max');
    }
    set kernelThreadsMax(value) {
        this._kernelThreadsMax = value;
    }
    resetKernelThreadsMax() {
        this._kernelThreadsMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kernelThreadsMaxInput() {
        return this._kernelThreadsMax;
    }
    get netCoreNetdevMaxBacklog() {
        return this.getNumberAttribute('net_core_netdev_max_backlog');
    }
    set netCoreNetdevMaxBacklog(value) {
        this._netCoreNetdevMaxBacklog = value;
    }
    resetNetCoreNetdevMaxBacklog() {
        this._netCoreNetdevMaxBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreNetdevMaxBacklogInput() {
        return this._netCoreNetdevMaxBacklog;
    }
    get netCoreOptmemMax() {
        return this.getNumberAttribute('net_core_optmem_max');
    }
    set netCoreOptmemMax(value) {
        this._netCoreOptmemMax = value;
    }
    resetNetCoreOptmemMax() {
        this._netCoreOptmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreOptmemMaxInput() {
        return this._netCoreOptmemMax;
    }
    get netCoreRmemDefault() {
        return this.getNumberAttribute('net_core_rmem_default');
    }
    set netCoreRmemDefault(value) {
        this._netCoreRmemDefault = value;
    }
    resetNetCoreRmemDefault() {
        this._netCoreRmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreRmemDefaultInput() {
        return this._netCoreRmemDefault;
    }
    get netCoreRmemMax() {
        return this.getNumberAttribute('net_core_rmem_max');
    }
    set netCoreRmemMax(value) {
        this._netCoreRmemMax = value;
    }
    resetNetCoreRmemMax() {
        this._netCoreRmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreRmemMaxInput() {
        return this._netCoreRmemMax;
    }
    get netCoreSomaxconn() {
        return this.getNumberAttribute('net_core_somaxconn');
    }
    set netCoreSomaxconn(value) {
        this._netCoreSomaxconn = value;
    }
    resetNetCoreSomaxconn() {
        this._netCoreSomaxconn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreSomaxconnInput() {
        return this._netCoreSomaxconn;
    }
    get netCoreWmemDefault() {
        return this.getNumberAttribute('net_core_wmem_default');
    }
    set netCoreWmemDefault(value) {
        this._netCoreWmemDefault = value;
    }
    resetNetCoreWmemDefault() {
        this._netCoreWmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreWmemDefaultInput() {
        return this._netCoreWmemDefault;
    }
    get netCoreWmemMax() {
        return this.getNumberAttribute('net_core_wmem_max');
    }
    set netCoreWmemMax(value) {
        this._netCoreWmemMax = value;
    }
    resetNetCoreWmemMax() {
        this._netCoreWmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreWmemMaxInput() {
        return this._netCoreWmemMax;
    }
    get netIpv4IpLocalPortRangeMax() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_max');
    }
    set netIpv4IpLocalPortRangeMax(value) {
        this._netIpv4IpLocalPortRangeMax = value;
    }
    resetNetIpv4IpLocalPortRangeMax() {
        this._netIpv4IpLocalPortRangeMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4IpLocalPortRangeMaxInput() {
        return this._netIpv4IpLocalPortRangeMax;
    }
    get netIpv4IpLocalPortRangeMin() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_min');
    }
    set netIpv4IpLocalPortRangeMin(value) {
        this._netIpv4IpLocalPortRangeMin = value;
    }
    resetNetIpv4IpLocalPortRangeMin() {
        this._netIpv4IpLocalPortRangeMin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4IpLocalPortRangeMinInput() {
        return this._netIpv4IpLocalPortRangeMin;
    }
    get netIpv4NeighDefaultGcThresh1() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh1');
    }
    set netIpv4NeighDefaultGcThresh1(value) {
        this._netIpv4NeighDefaultGcThresh1 = value;
    }
    resetNetIpv4NeighDefaultGcThresh1() {
        this._netIpv4NeighDefaultGcThresh1 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh1Input() {
        return this._netIpv4NeighDefaultGcThresh1;
    }
    get netIpv4NeighDefaultGcThresh2() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh2');
    }
    set netIpv4NeighDefaultGcThresh2(value) {
        this._netIpv4NeighDefaultGcThresh2 = value;
    }
    resetNetIpv4NeighDefaultGcThresh2() {
        this._netIpv4NeighDefaultGcThresh2 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh2Input() {
        return this._netIpv4NeighDefaultGcThresh2;
    }
    get netIpv4NeighDefaultGcThresh3() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh3');
    }
    set netIpv4NeighDefaultGcThresh3(value) {
        this._netIpv4NeighDefaultGcThresh3 = value;
    }
    resetNetIpv4NeighDefaultGcThresh3() {
        this._netIpv4NeighDefaultGcThresh3 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh3Input() {
        return this._netIpv4NeighDefaultGcThresh3;
    }
    get netIpv4TcpFinTimeout() {
        return this.getNumberAttribute('net_ipv4_tcp_fin_timeout');
    }
    set netIpv4TcpFinTimeout(value) {
        this._netIpv4TcpFinTimeout = value;
    }
    resetNetIpv4TcpFinTimeout() {
        this._netIpv4TcpFinTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpFinTimeoutInput() {
        return this._netIpv4TcpFinTimeout;
    }
    get netIpv4TcpKeepaliveIntvl() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_intvl');
    }
    set netIpv4TcpKeepaliveIntvl(value) {
        this._netIpv4TcpKeepaliveIntvl = value;
    }
    resetNetIpv4TcpKeepaliveIntvl() {
        this._netIpv4TcpKeepaliveIntvl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveIntvlInput() {
        return this._netIpv4TcpKeepaliveIntvl;
    }
    get netIpv4TcpKeepaliveProbes() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_probes');
    }
    set netIpv4TcpKeepaliveProbes(value) {
        this._netIpv4TcpKeepaliveProbes = value;
    }
    resetNetIpv4TcpKeepaliveProbes() {
        this._netIpv4TcpKeepaliveProbes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveProbesInput() {
        return this._netIpv4TcpKeepaliveProbes;
    }
    get netIpv4TcpKeepaliveTime() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_time');
    }
    set netIpv4TcpKeepaliveTime(value) {
        this._netIpv4TcpKeepaliveTime = value;
    }
    resetNetIpv4TcpKeepaliveTime() {
        this._netIpv4TcpKeepaliveTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveTimeInput() {
        return this._netIpv4TcpKeepaliveTime;
    }
    get netIpv4TcpMaxSynBacklog() {
        return this.getNumberAttribute('net_ipv4_tcp_max_syn_backlog');
    }
    set netIpv4TcpMaxSynBacklog(value) {
        this._netIpv4TcpMaxSynBacklog = value;
    }
    resetNetIpv4TcpMaxSynBacklog() {
        this._netIpv4TcpMaxSynBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpMaxSynBacklogInput() {
        return this._netIpv4TcpMaxSynBacklog;
    }
    get netIpv4TcpMaxTwBuckets() {
        return this.getNumberAttribute('net_ipv4_tcp_max_tw_buckets');
    }
    set netIpv4TcpMaxTwBuckets(value) {
        this._netIpv4TcpMaxTwBuckets = value;
    }
    resetNetIpv4TcpMaxTwBuckets() {
        this._netIpv4TcpMaxTwBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpMaxTwBucketsInput() {
        return this._netIpv4TcpMaxTwBuckets;
    }
    get netIpv4TcpTwReuse() {
        return this.getBooleanAttribute('net_ipv4_tcp_tw_reuse');
    }
    set netIpv4TcpTwReuse(value) {
        this._netIpv4TcpTwReuse = value;
    }
    resetNetIpv4TcpTwReuse() {
        this._netIpv4TcpTwReuse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpTwReuseInput() {
        return this._netIpv4TcpTwReuse;
    }
    get netNetfilterNfConntrackBuckets() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_buckets');
    }
    set netNetfilterNfConntrackBuckets(value) {
        this._netNetfilterNfConntrackBuckets = value;
    }
    resetNetNetfilterNfConntrackBuckets() {
        this._netNetfilterNfConntrackBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netNetfilterNfConntrackBucketsInput() {
        return this._netNetfilterNfConntrackBuckets;
    }
    get netNetfilterNfConntrackMax() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_max');
    }
    set netNetfilterNfConntrackMax(value) {
        this._netNetfilterNfConntrackMax = value;
    }
    resetNetNetfilterNfConntrackMax() {
        this._netNetfilterNfConntrackMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netNetfilterNfConntrackMaxInput() {
        return this._netNetfilterNfConntrackMax;
    }
    get vmMaxMapCount() {
        return this.getNumberAttribute('vm_max_map_count');
    }
    set vmMaxMapCount(value) {
        this._vmMaxMapCount = value;
    }
    resetVmMaxMapCount() {
        this._vmMaxMapCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmMaxMapCountInput() {
        return this._vmMaxMapCount;
    }
    get vmSwappiness() {
        return this.getNumberAttribute('vm_swappiness');
    }
    set vmSwappiness(value) {
        this._vmSwappiness = value;
    }
    resetVmSwappiness() {
        this._vmSwappiness = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmSwappinessInput() {
        return this._vmSwappiness;
    }
    get vmVfsCachePressure() {
        return this.getNumberAttribute('vm_vfs_cache_pressure');
    }
    set vmVfsCachePressure(value) {
        this._vmVfsCachePressure = value;
    }
    resetVmVfsCachePressure() {
        this._vmVfsCachePressure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmVfsCachePressureInput() {
        return this._vmVfsCachePressure;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference;
_b = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference", version: "9.0.3" };
function kubernetesClusterNodePoolLinuxOsConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        swap_file_size_mb: cdktf.numberToTerraform(struct.swapFileSizeMb),
        transparent_huge_page_defrag: cdktf.stringToTerraform(struct.transparentHugePageDefrag),
        transparent_huge_page_enabled: cdktf.stringToTerraform(struct.transparentHugePageEnabled),
        sysctl_config: kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct.sysctlConfig),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigToTerraform;
class KubernetesClusterNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // sysctl_config - computed: false, optional: true, required: false
        this._sysctlConfig = new KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference(this, "sysctl_config");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._swapFileSizeMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.swapFileSizeMb = this._swapFileSizeMb;
        }
        if (this._transparentHugePageDefrag !== undefined) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageDefrag = this._transparentHugePageDefrag;
        }
        if (this._transparentHugePageEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageEnabled = this._transparentHugePageEnabled;
        }
        if (this._sysctlConfig?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.sysctlConfig = this._sysctlConfig?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._swapFileSizeMb = undefined;
            this._transparentHugePageDefrag = undefined;
            this._transparentHugePageEnabled = undefined;
            this._sysctlConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._swapFileSizeMb = value.swapFileSizeMb;
            this._transparentHugePageDefrag = value.transparentHugePageDefrag;
            this._transparentHugePageEnabled = value.transparentHugePageEnabled;
            this._sysctlConfig.internalValue = value.sysctlConfig;
        }
    }
    get swapFileSizeMb() {
        return this.getNumberAttribute('swap_file_size_mb');
    }
    set swapFileSizeMb(value) {
        this._swapFileSizeMb = value;
    }
    resetSwapFileSizeMb() {
        this._swapFileSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swapFileSizeMbInput() {
        return this._swapFileSizeMb;
    }
    get transparentHugePageDefrag() {
        return this.getStringAttribute('transparent_huge_page_defrag');
    }
    set transparentHugePageDefrag(value) {
        this._transparentHugePageDefrag = value;
    }
    resetTransparentHugePageDefrag() {
        this._transparentHugePageDefrag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentHugePageDefragInput() {
        return this._transparentHugePageDefrag;
    }
    get transparentHugePageEnabled() {
        return this.getStringAttribute('transparent_huge_page_enabled');
    }
    set transparentHugePageEnabled(value) {
        this._transparentHugePageEnabled = value;
    }
    resetTransparentHugePageEnabled() {
        this._transparentHugePageEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentHugePageEnabledInput() {
        return this._transparentHugePageEnabled;
    }
    get sysctlConfig() {
        return this._sysctlConfig;
    }
    putSysctlConfig(value) {
        this._sysctlConfig.internalValue = value;
    }
    resetSysctlConfig() {
        this._sysctlConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sysctlConfigInput() {
        return this._sysctlConfig.internalValue;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigOutputReference;
_c = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolLinuxOsConfigOutputReference", version: "9.0.3" };
function kubernetesClusterNodePoolNodeNetworkProfileToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        node_public_ip_tags: cdktf.hashMapper(cdktf.stringToTerraform)(struct.nodePublicIpTags),
    };
}
exports.kubernetesClusterNodePoolNodeNetworkProfileToTerraform = kubernetesClusterNodePoolNodeNetworkProfileToTerraform;
class KubernetesClusterNodePoolNodeNetworkProfileOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._nodePublicIpTags !== undefined) {
            hasAnyValues = true;
            internalValueResult.nodePublicIpTags = this._nodePublicIpTags;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._nodePublicIpTags = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._nodePublicIpTags = value.nodePublicIpTags;
        }
    }
    get nodePublicIpTags() {
        return this.getStringMapAttribute('node_public_ip_tags');
    }
    set nodePublicIpTags(value) {
        this._nodePublicIpTags = value;
    }
    resetNodePublicIpTags() {
        this._nodePublicIpTags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodePublicIpTagsInput() {
        return this._nodePublicIpTags;
    }
}
exports.KubernetesClusterNodePoolNodeNetworkProfileOutputReference = KubernetesClusterNodePoolNodeNetworkProfileOutputReference;
_d = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolNodeNetworkProfileOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolNodeNetworkProfileOutputReference", version: "9.0.3" };
function kubernetesClusterNodePoolTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.kubernetesClusterNodePoolTimeoutsToTerraform = kubernetesClusterNodePoolTimeoutsToTerraform;
class KubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.KubernetesClusterNodePoolTimeoutsOutputReference = KubernetesClusterNodePoolTimeoutsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolTimeoutsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolTimeoutsOutputReference", version: "9.0.3" };
function kubernetesClusterNodePoolUpgradeSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_surge: cdktf.stringToTerraform(struct.maxSurge),
    };
}
exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = kubernetesClusterNodePoolUpgradeSettingsToTerraform;
class KubernetesClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxSurge !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxSurge = this._maxSurge;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maxSurge = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maxSurge = value.maxSurge;
        }
    }
    get maxSurge() {
        return this.getStringAttribute('max_surge');
    }
    set maxSurge(value) {
        this._maxSurge = value;
    }
    // Temporarily expose input value. Use with caution.
    get maxSurgeInput() {
        return this._maxSurge;
    }
}
exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = KubernetesClusterNodePoolUpgradeSettingsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolUpgradeSettingsOutputReference[_f] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolUpgradeSettingsOutputReference", version: "9.0.3" };
function kubernetesClusterNodePoolWindowsProfileToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        outbound_nat_enabled: cdktf.booleanToTerraform(struct.outboundNatEnabled),
    };
}
exports.kubernetesClusterNodePoolWindowsProfileToTerraform = kubernetesClusterNodePoolWindowsProfileToTerraform;
class KubernetesClusterNodePoolWindowsProfileOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._outboundNatEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.outboundNatEnabled = this._outboundNatEnabled;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._outboundNatEnabled = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._outboundNatEnabled = value.outboundNatEnabled;
        }
    }
    get outboundNatEnabled() {
        return this.getBooleanAttribute('outbound_nat_enabled');
    }
    set outboundNatEnabled(value) {
        this._outboundNatEnabled = value;
    }
    resetOutboundNatEnabled() {
        this._outboundNatEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get outboundNatEnabledInput() {
        return this._outboundNatEnabled;
    }
}
exports.KubernetesClusterNodePoolWindowsProfileOutputReference = KubernetesClusterNodePoolWindowsProfileOutputReference;
_g = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolWindowsProfileOutputReference[_g] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolWindowsProfileOutputReference", version: "9.0.3" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool}
*/
class KubernetesClusterNodePool extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterNodePoolConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_kubernetes_cluster_node_pool',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.65.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // kubelet_config - computed: false, optional: true, required: false
        this._kubeletConfig = new KubernetesClusterNodePoolKubeletConfigOutputReference(this, "kubelet_config");
        // linux_os_config - computed: false, optional: true, required: false
        this._linuxOsConfig = new KubernetesClusterNodePoolLinuxOsConfigOutputReference(this, "linux_os_config");
        // node_network_profile - computed: false, optional: true, required: false
        this._nodeNetworkProfile = new KubernetesClusterNodePoolNodeNetworkProfileOutputReference(this, "node_network_profile");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new KubernetesClusterNodePoolTimeoutsOutputReference(this, "timeouts");
        // upgrade_settings - computed: false, optional: true, required: false
        this._upgradeSettings = new KubernetesClusterNodePoolUpgradeSettingsOutputReference(this, "upgrade_settings");
        // windows_profile - computed: false, optional: true, required: false
        this._windowsProfile = new KubernetesClusterNodePoolWindowsProfileOutputReference(this, "windows_profile");
        this._capacityReservationGroupId = config.capacityReservationGroupId;
        this._customCaTrustEnabled = config.customCaTrustEnabled;
        this._enableAutoScaling = config.enableAutoScaling;
        this._enableHostEncryption = config.enableHostEncryption;
        this._enableNodePublicIp = config.enableNodePublicIp;
        this._evictionPolicy = config.evictionPolicy;
        this._fipsEnabled = config.fipsEnabled;
        this._hostGroupId = config.hostGroupId;
        this._id = config.id;
        this._kubeletDiskType = config.kubeletDiskType;
        this._kubernetesClusterId = config.kubernetesClusterId;
        this._maxCount = config.maxCount;
        this._maxPods = config.maxPods;
        this._messageOfTheDay = config.messageOfTheDay;
        this._minCount = config.minCount;
        this._mode = config.mode;
        this._name = config.name;
        this._nodeCount = config.nodeCount;
        this._nodeLabels = config.nodeLabels;
        this._nodePublicIpPrefixId = config.nodePublicIpPrefixId;
        this._nodeTaints = config.nodeTaints;
        this._orchestratorVersion = config.orchestratorVersion;
        this._osDiskSizeGb = config.osDiskSizeGb;
        this._osDiskType = config.osDiskType;
        this._osSku = config.osSku;
        this._osType = config.osType;
        this._podSubnetId = config.podSubnetId;
        this._priority = config.priority;
        this._proximityPlacementGroupId = config.proximityPlacementGroupId;
        this._scaleDownMode = config.scaleDownMode;
        this._snapshotId = config.snapshotId;
        this._spotMaxPrice = config.spotMaxPrice;
        this._tags = config.tags;
        this._ultraSsdEnabled = config.ultraSsdEnabled;
        this._vmSize = config.vmSize;
        this._vnetSubnetId = config.vnetSubnetId;
        this._workloadRuntime = config.workloadRuntime;
        this._zones = config.zones;
        this._kubeletConfig.internalValue = config.kubeletConfig;
        this._linuxOsConfig.internalValue = config.linuxOsConfig;
        this._nodeNetworkProfile.internalValue = config.nodeNetworkProfile;
        this._timeouts.internalValue = config.timeouts;
        this._upgradeSettings.internalValue = config.upgradeSettings;
        this._windowsProfile.internalValue = config.windowsProfile;
    }
    get capacityReservationGroupId() {
        return this.getStringAttribute('capacity_reservation_group_id');
    }
    set capacityReservationGroupId(value) {
        this._capacityReservationGroupId = value;
    }
    resetCapacityReservationGroupId() {
        this._capacityReservationGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get capacityReservationGroupIdInput() {
        return this._capacityReservationGroupId;
    }
    get customCaTrustEnabled() {
        return this.getBooleanAttribute('custom_ca_trust_enabled');
    }
    set customCaTrustEnabled(value) {
        this._customCaTrustEnabled = value;
    }
    resetCustomCaTrustEnabled() {
        this._customCaTrustEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customCaTrustEnabledInput() {
        return this._customCaTrustEnabled;
    }
    get enableAutoScaling() {
        return this.getBooleanAttribute('enable_auto_scaling');
    }
    set enableAutoScaling(value) {
        this._enableAutoScaling = value;
    }
    resetEnableAutoScaling() {
        this._enableAutoScaling = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableAutoScalingInput() {
        return this._enableAutoScaling;
    }
    get enableHostEncryption() {
        return this.getBooleanAttribute('enable_host_encryption');
    }
    set enableHostEncryption(value) {
        this._enableHostEncryption = value;
    }
    resetEnableHostEncryption() {
        this._enableHostEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHostEncryptionInput() {
        return this._enableHostEncryption;
    }
    get enableNodePublicIp() {
        return this.getBooleanAttribute('enable_node_public_ip');
    }
    set enableNodePublicIp(value) {
        this._enableNodePublicIp = value;
    }
    resetEnableNodePublicIp() {
        this._enableNodePublicIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableNodePublicIpInput() {
        return this._enableNodePublicIp;
    }
    get evictionPolicy() {
        return this.getStringAttribute('eviction_policy');
    }
    set evictionPolicy(value) {
        this._evictionPolicy = value;
    }
    resetEvictionPolicy() {
        this._evictionPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get evictionPolicyInput() {
        return this._evictionPolicy;
    }
    get fipsEnabled() {
        return this.getBooleanAttribute('fips_enabled');
    }
    set fipsEnabled(value) {
        this._fipsEnabled = value;
    }
    resetFipsEnabled() {
        this._fipsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fipsEnabledInput() {
        return this._fipsEnabled;
    }
    get hostGroupId() {
        return this.getStringAttribute('host_group_id');
    }
    set hostGroupId(value) {
        this._hostGroupId = value;
    }
    resetHostGroupId() {
        this._hostGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostGroupIdInput() {
        return this._hostGroupId;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get kubeletDiskType() {
        return this.getStringAttribute('kubelet_disk_type');
    }
    set kubeletDiskType(value) {
        this._kubeletDiskType = value;
    }
    resetKubeletDiskType() {
        this._kubeletDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubeletDiskTypeInput() {
        return this._kubeletDiskType;
    }
    get kubernetesClusterId() {
        return this.getStringAttribute('kubernetes_cluster_id');
    }
    set kubernetesClusterId(value) {
        this._kubernetesClusterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesClusterIdInput() {
        return this._kubernetesClusterId;
    }
    get maxCount() {
        return this.getNumberAttribute('max_count');
    }
    set maxCount(value) {
        this._maxCount = value;
    }
    resetMaxCount() {
        this._maxCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxCountInput() {
        return this._maxCount;
    }
    get maxPods() {
        return this.getNumberAttribute('max_pods');
    }
    set maxPods(value) {
        this._maxPods = value;
    }
    resetMaxPods() {
        this._maxPods = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxPodsInput() {
        return this._maxPods;
    }
    get messageOfTheDay() {
        return this.getStringAttribute('message_of_the_day');
    }
    set messageOfTheDay(value) {
        this._messageOfTheDay = value;
    }
    resetMessageOfTheDay() {
        this._messageOfTheDay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageOfTheDayInput() {
        return this._messageOfTheDay;
    }
    get minCount() {
        return this.getNumberAttribute('min_count');
    }
    set minCount(value) {
        this._minCount = value;
    }
    resetMinCount() {
        this._minCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minCountInput() {
        return this._minCount;
    }
    get mode() {
        return this.getStringAttribute('mode');
    }
    set mode(value) {
        this._mode = value;
    }
    resetMode() {
        this._mode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get modeInput() {
        return this._mode;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nodeCount() {
        return this.getNumberAttribute('node_count');
    }
    set nodeCount(value) {
        this._nodeCount = value;
    }
    resetNodeCount() {
        this._nodeCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeCountInput() {
        return this._nodeCount;
    }
    get nodeLabels() {
        return this.getStringMapAttribute('node_labels');
    }
    set nodeLabels(value) {
        this._nodeLabels = value;
    }
    resetNodeLabels() {
        this._nodeLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeLabelsInput() {
        return this._nodeLabels;
    }
    get nodePublicIpPrefixId() {
        return this.getStringAttribute('node_public_ip_prefix_id');
    }
    set nodePublicIpPrefixId(value) {
        this._nodePublicIpPrefixId = value;
    }
    resetNodePublicIpPrefixId() {
        this._nodePublicIpPrefixId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodePublicIpPrefixIdInput() {
        return this._nodePublicIpPrefixId;
    }
    get nodeTaints() {
        return this.getListAttribute('node_taints');
    }
    set nodeTaints(value) {
        this._nodeTaints = value;
    }
    resetNodeTaints() {
        this._nodeTaints = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeTaintsInput() {
        return this._nodeTaints;
    }
    get orchestratorVersion() {
        return this.getStringAttribute('orchestrator_version');
    }
    set orchestratorVersion(value) {
        this._orchestratorVersion = value;
    }
    resetOrchestratorVersion() {
        this._orchestratorVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orchestratorVersionInput() {
        return this._orchestratorVersion;
    }
    get osDiskSizeGb() {
        return this.getNumberAttribute('os_disk_size_gb');
    }
    set osDiskSizeGb(value) {
        this._osDiskSizeGb = value;
    }
    resetOsDiskSizeGb() {
        this._osDiskSizeGb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osDiskSizeGbInput() {
        return this._osDiskSizeGb;
    }
    get osDiskType() {
        return this.getStringAttribute('os_disk_type');
    }
    set osDiskType(value) {
        this._osDiskType = value;
    }
    resetOsDiskType() {
        this._osDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osDiskTypeInput() {
        return this._osDiskType;
    }
    get osSku() {
        return this.getStringAttribute('os_sku');
    }
    set osSku(value) {
        this._osSku = value;
    }
    resetOsSku() {
        this._osSku = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osSkuInput() {
        return this._osSku;
    }
    get osType() {
        return this.getStringAttribute('os_type');
    }
    set osType(value) {
        this._osType = value;
    }
    resetOsType() {
        this._osType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osTypeInput() {
        return this._osType;
    }
    get podSubnetId() {
        return this.getStringAttribute('pod_subnet_id');
    }
    set podSubnetId(value) {
        this._podSubnetId = value;
    }
    resetPodSubnetId() {
        this._podSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podSubnetIdInput() {
        return this._podSubnetId;
    }
    get priority() {
        return this.getStringAttribute('priority');
    }
    set priority(value) {
        this._priority = value;
    }
    resetPriority() {
        this._priority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get priorityInput() {
        return this._priority;
    }
    get proximityPlacementGroupId() {
        return this.getStringAttribute('proximity_placement_group_id');
    }
    set proximityPlacementGroupId(value) {
        this._proximityPlacementGroupId = value;
    }
    resetProximityPlacementGroupId() {
        this._proximityPlacementGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proximityPlacementGroupIdInput() {
        return this._proximityPlacementGroupId;
    }
    get scaleDownMode() {
        return this.getStringAttribute('scale_down_mode');
    }
    set scaleDownMode(value) {
        this._scaleDownMode = value;
    }
    resetScaleDownMode() {
        this._scaleDownMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scaleDownModeInput() {
        return this._scaleDownMode;
    }
    get snapshotId() {
        return this.getStringAttribute('snapshot_id');
    }
    set snapshotId(value) {
        this._snapshotId = value;
    }
    resetSnapshotId() {
        this._snapshotId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snapshotIdInput() {
        return this._snapshotId;
    }
    get spotMaxPrice() {
        return this.getNumberAttribute('spot_max_price');
    }
    set spotMaxPrice(value) {
        this._spotMaxPrice = value;
    }
    resetSpotMaxPrice() {
        this._spotMaxPrice = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spotMaxPriceInput() {
        return this._spotMaxPrice;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get ultraSsdEnabled() {
        return this.getBooleanAttribute('ultra_ssd_enabled');
    }
    set ultraSsdEnabled(value) {
        this._ultraSsdEnabled = value;
    }
    resetUltraSsdEnabled() {
        this._ultraSsdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ultraSsdEnabledInput() {
        return this._ultraSsdEnabled;
    }
    get vmSize() {
        return this.getStringAttribute('vm_size');
    }
    set vmSize(value) {
        this._vmSize = value;
    }
    // Temporarily expose input value. Use with caution.
    get vmSizeInput() {
        return this._vmSize;
    }
    get vnetSubnetId() {
        return this.getStringAttribute('vnet_subnet_id');
    }
    set vnetSubnetId(value) {
        this._vnetSubnetId = value;
    }
    resetVnetSubnetId() {
        this._vnetSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vnetSubnetIdInput() {
        return this._vnetSubnetId;
    }
    get workloadRuntime() {
        return this.getStringAttribute('workload_runtime');
    }
    set workloadRuntime(value) {
        this._workloadRuntime = value;
    }
    resetWorkloadRuntime() {
        this._workloadRuntime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workloadRuntimeInput() {
        return this._workloadRuntime;
    }
    get zones() {
        return cdktf.Fn.tolist(this.getListAttribute('zones'));
    }
    set zones(value) {
        this._zones = value;
    }
    resetZones() {
        this._zones = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zonesInput() {
        return this._zones;
    }
    get kubeletConfig() {
        return this._kubeletConfig;
    }
    putKubeletConfig(value) {
        this._kubeletConfig.internalValue = value;
    }
    resetKubeletConfig() {
        this._kubeletConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubeletConfigInput() {
        return this._kubeletConfig.internalValue;
    }
    get linuxOsConfig() {
        return this._linuxOsConfig;
    }
    putLinuxOsConfig(value) {
        this._linuxOsConfig.internalValue = value;
    }
    resetLinuxOsConfig() {
        this._linuxOsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linuxOsConfigInput() {
        return this._linuxOsConfig.internalValue;
    }
    get nodeNetworkProfile() {
        return this._nodeNetworkProfile;
    }
    putNodeNetworkProfile(value) {
        this._nodeNetworkProfile.internalValue = value;
    }
    resetNodeNetworkProfile() {
        this._nodeNetworkProfile.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeNetworkProfileInput() {
        return this._nodeNetworkProfile.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get upgradeSettings() {
        return this._upgradeSettings;
    }
    putUpgradeSettings(value) {
        this._upgradeSettings.internalValue = value;
    }
    resetUpgradeSettings() {
        this._upgradeSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upgradeSettingsInput() {
        return this._upgradeSettings.internalValue;
    }
    get windowsProfile() {
        return this._windowsProfile;
    }
    putWindowsProfile(value) {
        this._windowsProfile.internalValue = value;
    }
    resetWindowsProfile() {
        this._windowsProfile.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get windowsProfileInput() {
        return this._windowsProfile.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            capacity_reservation_group_id: cdktf.stringToTerraform(this._capacityReservationGroupId),
            custom_ca_trust_enabled: cdktf.booleanToTerraform(this._customCaTrustEnabled),
            enable_auto_scaling: cdktf.booleanToTerraform(this._enableAutoScaling),
            enable_host_encryption: cdktf.booleanToTerraform(this._enableHostEncryption),
            enable_node_public_ip: cdktf.booleanToTerraform(this._enableNodePublicIp),
            eviction_policy: cdktf.stringToTerraform(this._evictionPolicy),
            fips_enabled: cdktf.booleanToTerraform(this._fipsEnabled),
            host_group_id: cdktf.stringToTerraform(this._hostGroupId),
            id: cdktf.stringToTerraform(this._id),
            kubelet_disk_type: cdktf.stringToTerraform(this._kubeletDiskType),
            kubernetes_cluster_id: cdktf.stringToTerraform(this._kubernetesClusterId),
            max_count: cdktf.numberToTerraform(this._maxCount),
            max_pods: cdktf.numberToTerraform(this._maxPods),
            message_of_the_day: cdktf.stringToTerraform(this._messageOfTheDay),
            min_count: cdktf.numberToTerraform(this._minCount),
            mode: cdktf.stringToTerraform(this._mode),
            name: cdktf.stringToTerraform(this._name),
            node_count: cdktf.numberToTerraform(this._nodeCount),
            node_labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._nodeLabels),
            node_public_ip_prefix_id: cdktf.stringToTerraform(this._nodePublicIpPrefixId),
            node_taints: cdktf.listMapper(cdktf.stringToTerraform, false)(this._nodeTaints),
            orchestrator_version: cdktf.stringToTerraform(this._orchestratorVersion),
            os_disk_size_gb: cdktf.numberToTerraform(this._osDiskSizeGb),
            os_disk_type: cdktf.stringToTerraform(this._osDiskType),
            os_sku: cdktf.stringToTerraform(this._osSku),
            os_type: cdktf.stringToTerraform(this._osType),
            pod_subnet_id: cdktf.stringToTerraform(this._podSubnetId),
            priority: cdktf.stringToTerraform(this._priority),
            proximity_placement_group_id: cdktf.stringToTerraform(this._proximityPlacementGroupId),
            scale_down_mode: cdktf.stringToTerraform(this._scaleDownMode),
            snapshot_id: cdktf.stringToTerraform(this._snapshotId),
            spot_max_price: cdktf.numberToTerraform(this._spotMaxPrice),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            ultra_ssd_enabled: cdktf.booleanToTerraform(this._ultraSsdEnabled),
            vm_size: cdktf.stringToTerraform(this._vmSize),
            vnet_subnet_id: cdktf.stringToTerraform(this._vnetSubnetId),
            workload_runtime: cdktf.stringToTerraform(this._workloadRuntime),
            zones: cdktf.listMapper(cdktf.stringToTerraform, false)(this._zones),
            kubelet_config: kubernetesClusterNodePoolKubeletConfigToTerraform(this._kubeletConfig.internalValue),
            linux_os_config: kubernetesClusterNodePoolLinuxOsConfigToTerraform(this._linuxOsConfig.internalValue),
            node_network_profile: kubernetesClusterNodePoolNodeNetworkProfileToTerraform(this._nodeNetworkProfile.internalValue),
            timeouts: kubernetesClusterNodePoolTimeoutsToTerraform(this._timeouts.internalValue),
            upgrade_settings: kubernetesClusterNodePoolUpgradeSettingsToTerraform(this._upgradeSettings.internalValue),
            windows_profile: kubernetesClusterNodePoolWindowsProfileToTerraform(this._windowsProfile.internalValue),
        };
    }
}
exports.KubernetesClusterNodePool = KubernetesClusterNodePool;
_h = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePool[_h] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePool", version: "9.0.3" };
// =================
// STATIC PROPERTIES
// =================
KubernetesClusterNodePool.tfResourceType = "azurerm_kubernetes_cluster_node_pool";
//# sourceMappingURL=data:application/json;base64,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