/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#edge_zone Lb#edge_zone}
    */
    readonly edgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#id Lb#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#location Lb#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#name Lb#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#resource_group_name Lb#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#sku Lb#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#sku_tier Lb#sku_tier}
    */
    readonly skuTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#tags Lb#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * frontend_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#frontend_ip_configuration Lb#frontend_ip_configuration}
    */
    readonly frontendIpConfiguration?: LbFrontendIpConfiguration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#timeouts Lb#timeouts}
    */
    readonly timeouts?: LbTimeouts;
}
export interface LbFrontendIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#gateway_load_balancer_frontend_ip_configuration_id Lb#gateway_load_balancer_frontend_ip_configuration_id}
    */
    readonly gatewayLoadBalancerFrontendIpConfigurationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#name Lb#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#private_ip_address Lb#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#private_ip_address_allocation Lb#private_ip_address_allocation}
    */
    readonly privateIpAddressAllocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#private_ip_address_version Lb#private_ip_address_version}
    */
    readonly privateIpAddressVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#public_ip_address_id Lb#public_ip_address_id}
    */
    readonly publicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#public_ip_prefix_id Lb#public_ip_prefix_id}
    */
    readonly publicIpPrefixId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#subnet_id Lb#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#zones Lb#zones}
    */
    readonly zones?: string[];
}
export declare function lbFrontendIpConfigurationToTerraform(struct?: LbFrontendIpConfiguration | cdktf.IResolvable): any;
export declare class LbFrontendIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LbFrontendIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: LbFrontendIpConfiguration | cdktf.IResolvable | undefined);
    private _gatewayLoadBalancerFrontendIpConfigurationId?;
    get gatewayLoadBalancerFrontendIpConfigurationId(): string;
    set gatewayLoadBalancerFrontendIpConfigurationId(value: string);
    resetGatewayLoadBalancerFrontendIpConfigurationId(): void;
    get gatewayLoadBalancerFrontendIpConfigurationIdInput(): string | undefined;
    get id(): string;
    get inboundNatRules(): string[];
    get loadBalancerRules(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundRules(): string[];
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    resetPrivateIpAddress(): void;
    get privateIpAddressInput(): string | undefined;
    private _privateIpAddressAllocation?;
    get privateIpAddressAllocation(): string;
    set privateIpAddressAllocation(value: string);
    resetPrivateIpAddressAllocation(): void;
    get privateIpAddressAllocationInput(): string | undefined;
    private _privateIpAddressVersion?;
    get privateIpAddressVersion(): string;
    set privateIpAddressVersion(value: string);
    resetPrivateIpAddressVersion(): void;
    get privateIpAddressVersionInput(): string | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    resetPublicIpAddressId(): void;
    get publicIpAddressIdInput(): string | undefined;
    private _publicIpPrefixId?;
    get publicIpPrefixId(): string;
    set publicIpPrefixId(value: string);
    resetPublicIpPrefixId(): void;
    get publicIpPrefixIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
}
export declare class LbFrontendIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LbFrontendIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LbFrontendIpConfigurationOutputReference;
}
export interface LbTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#create Lb#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#delete Lb#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#read Lb#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb#update Lb#update}
    */
    readonly update?: string;
}
export declare function lbTimeoutsToTerraform(struct?: LbTimeouts | cdktf.IResolvable): any;
export declare class LbTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LbTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb azurerm_lb}
*/
export declare class Lb extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lb";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/lb azurerm_lb} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbConfig
    */
    constructor(scope: Construct, id: string, config: LbConfig);
    private _edgeZone?;
    get edgeZone(): string;
    set edgeZone(value: string);
    resetEdgeZone(): void;
    get edgeZoneInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _skuTier?;
    get skuTier(): string;
    set skuTier(value: string);
    resetSkuTier(): void;
    get skuTierInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _frontendIpConfiguration;
    get frontendIpConfiguration(): LbFrontendIpConfigurationList;
    putFrontendIpConfiguration(value: LbFrontendIpConfiguration[] | cdktf.IResolvable): void;
    resetFrontendIpConfiguration(): void;
    get frontendIpConfigurationInput(): cdktf.IResolvable | LbFrontendIpConfiguration[] | undefined;
    private _timeouts;
    get timeouts(): LbTimeoutsOutputReference;
    putTimeouts(value: LbTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LbTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
