/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LinuxWebAppSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#app_service_id LinuxWebAppSlot#app_service_id}
    */
    readonly appServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#app_settings LinuxWebAppSlot#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_affinity_enabled LinuxWebAppSlot#client_affinity_enabled}
    */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_certificate_enabled LinuxWebAppSlot#client_certificate_enabled}
    */
    readonly clientCertificateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Paths to exclude when using client certificates, separated by ;
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_certificate_exclusion_paths LinuxWebAppSlot#client_certificate_exclusion_paths}
    */
    readonly clientCertificateExclusionPaths?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_certificate_mode LinuxWebAppSlot#client_certificate_mode}
    */
    readonly clientCertificateMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#enabled LinuxWebAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#https_only LinuxWebAppSlot#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#id LinuxWebAppSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#key_vault_reference_identity_id LinuxWebAppSlot#key_vault_reference_identity_id}
    */
    readonly keyVaultReferenceIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#name LinuxWebAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#public_network_access_enabled LinuxWebAppSlot#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#service_plan_id LinuxWebAppSlot#service_plan_id}
    */
    readonly servicePlanId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#tags LinuxWebAppSlot#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#virtual_network_subnet_id LinuxWebAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
    /**
    * The local path and filename of the Zip packaged application to deploy to this Windows Web App. **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` on the App in `app_settings`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#zip_deploy_file LinuxWebAppSlot#zip_deploy_file}
    */
    readonly zipDeployFile?: string;
    /**
    * auth_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#auth_settings LinuxWebAppSlot#auth_settings}
    */
    readonly authSettings?: LinuxWebAppSlotAuthSettings;
    /**
    * auth_settings_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#auth_settings_v2 LinuxWebAppSlot#auth_settings_v2}
    */
    readonly authSettingsV2?: LinuxWebAppSlotAuthSettingsV2;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#backup LinuxWebAppSlot#backup}
    */
    readonly backup?: LinuxWebAppSlotBackup;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#connection_string LinuxWebAppSlot#connection_string}
    */
    readonly connectionString?: LinuxWebAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#identity LinuxWebAppSlot#identity}
    */
    readonly identity?: LinuxWebAppSlotIdentity;
    /**
    * logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#logs LinuxWebAppSlot#logs}
    */
    readonly logs?: LinuxWebAppSlotLogs;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#site_config LinuxWebAppSlot#site_config}
    */
    readonly siteConfig: LinuxWebAppSlotSiteConfig;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#storage_account LinuxWebAppSlot#storage_account}
    */
    readonly storageAccount?: LinuxWebAppSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#timeouts LinuxWebAppSlot#timeouts}
    */
    readonly timeouts?: LinuxWebAppSlotTimeouts;
}
export interface LinuxWebAppSlotSiteCredential {
}
export declare function linuxWebAppSlotSiteCredentialToTerraform(struct?: LinuxWebAppSlotSiteCredential): any;
export declare class LinuxWebAppSlotSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotSiteCredential | undefined;
    set internalValue(value: LinuxWebAppSlotSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class LinuxWebAppSlotSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotSiteCredentialOutputReference;
}
export interface LinuxWebAppSlotAuthSettingsActiveDirectory {
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_audiences LinuxWebAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret for the Client ID. Cannot be used with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret LinuxWebAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The App Setting name that contains the client secret of the Client. Cannot be used with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
}
export declare function linuxWebAppSlotAuthSettingsActiveDirectoryToTerraform(struct?: LinuxWebAppSlotAuthSettingsActiveDirectoryOutputReference | LinuxWebAppSlotAuthSettingsActiveDirectory): any;
export declare class LinuxWebAppSlotAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsActiveDirectory | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
}
export interface LinuxWebAppSlotAuthSettingsFacebook {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#app_id LinuxWebAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * The App Secret of the Facebook app used for Facebook Login. Cannot be specified with `app_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#app_secret LinuxWebAppSlot#app_secret}
    */
    readonly appSecret?: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login. Cannot be specified with `app_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#app_secret_setting_name LinuxWebAppSlot#app_secret_setting_name}
    */
    readonly appSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#oauth_scopes LinuxWebAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsFacebookToTerraform(struct?: LinuxWebAppSlotAuthSettingsFacebookOutputReference | LinuxWebAppSlotAuthSettingsFacebook): any;
export declare class LinuxWebAppSlotAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsFacebook | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsFacebook | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    resetAppSecret(): void;
    get appSecretInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    resetAppSecretSettingName(): void;
    get appSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxWebAppSlotAuthSettingsGithub {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret of the GitHub app used for GitHub Login. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret LinuxWebAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#oauth_scopes LinuxWebAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsGithubToTerraform(struct?: LinuxWebAppSlotAuthSettingsGithubOutputReference | LinuxWebAppSlotAuthSettingsGithub): any;
export declare class LinuxWebAppSlotAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsGithub | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsGithub | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxWebAppSlotAuthSettingsGoogle {
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret associated with the Google web application.  Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret LinuxWebAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. If not specified, "openid", "profile", and "email" are used as default scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#oauth_scopes LinuxWebAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsGoogleToTerraform(struct?: LinuxWebAppSlotAuthSettingsGoogleOutputReference | LinuxWebAppSlotAuthSettingsGoogle): any;
export declare class LinuxWebAppSlotAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsGoogle | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsGoogle | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxWebAppSlotAuthSettingsMicrosoft {
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret LinuxWebAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * The list of OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. If not specified, `wl.basic` is used as the default scope.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#oauth_scopes LinuxWebAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsMicrosoftToTerraform(struct?: LinuxWebAppSlotAuthSettingsMicrosoftOutputReference | LinuxWebAppSlotAuthSettingsMicrosoft): any;
export declare class LinuxWebAppSlotAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsMicrosoft | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsMicrosoft | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface LinuxWebAppSlotAuthSettingsTwitter {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#consumer_key LinuxWebAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#consumer_secret LinuxWebAppSlot#consumer_secret}
    */
    readonly consumerSecret?: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#consumer_secret_setting_name LinuxWebAppSlot#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName?: string;
}
export declare function linuxWebAppSlotAuthSettingsTwitterToTerraform(struct?: LinuxWebAppSlotAuthSettingsTwitterOutputReference | LinuxWebAppSlotAuthSettingsTwitter): any;
export declare class LinuxWebAppSlotAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsTwitter | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsTwitter | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    get consumerSecret(): string;
    set consumerSecret(value: string);
    resetConsumerSecret(): void;
    get consumerSecretInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    resetConsumerSecretSettingName(): void;
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface LinuxWebAppSlotAuthSettings {
    /**
    * Specifies a map of Login Parameters to send to the OpenID Connect authorization endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#additional_login_parameters LinuxWebAppSlot#additional_login_parameters}
    */
    readonly additionalLoginParameters?: {
        [key: string]: string;
    };
    /**
    * Specifies a list of External URLs that can be redirected to as part of logging in or logging out of the Windows Web App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_external_redirect_urls LinuxWebAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The default authentication provider to use when multiple providers are configured. Possible values include: `AzureActiveDirectory`, `Facebook`, `Google`, `MicrosoftAccount`, `Twitter`, `Github`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#default_provider LinuxWebAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * Should the Authentication / Authorization feature be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#enabled LinuxWebAppSlot#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The OpenID Connect Issuer URI that represents the entity which issues access tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#issuer LinuxWebAppSlot#issuer}
    */
    readonly issuer?: string;
    /**
    * The RuntimeVersion of the Authentication / Authorization feature in use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#runtime_version LinuxWebAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#token_refresh_extension_hours LinuxWebAppSlot#token_refresh_extension_hours}
    */
    readonly tokenRefreshExtensionHours?: number;
    /**
    * Should the Windows Web App durably store platform-specific security tokens that are obtained during login flows? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#token_store_enabled LinuxWebAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The action to take when an unauthenticated client attempts to access the app. Possible values include: `RedirectToLoginPage`, `AllowAnonymous`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#unauthenticated_client_action LinuxWebAppSlot#unauthenticated_client_action}
    */
    readonly unauthenticatedClientAction?: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#active_directory LinuxWebAppSlot#active_directory}
    */
    readonly activeDirectory?: LinuxWebAppSlotAuthSettingsActiveDirectory;
    /**
    * facebook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#facebook LinuxWebAppSlot#facebook}
    */
    readonly facebook?: LinuxWebAppSlotAuthSettingsFacebook;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#github LinuxWebAppSlot#github}
    */
    readonly github?: LinuxWebAppSlotAuthSettingsGithub;
    /**
    * google block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#google LinuxWebAppSlot#google}
    */
    readonly google?: LinuxWebAppSlotAuthSettingsGoogle;
    /**
    * microsoft block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#microsoft LinuxWebAppSlot#microsoft}
    */
    readonly microsoft?: LinuxWebAppSlotAuthSettingsMicrosoft;
    /**
    * twitter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#twitter LinuxWebAppSlot#twitter}
    */
    readonly twitter?: LinuxWebAppSlotAuthSettingsTwitter;
}
export declare function linuxWebAppSlotAuthSettingsToTerraform(struct?: LinuxWebAppSlotAuthSettingsOutputReference | LinuxWebAppSlotAuthSettings): any;
export declare class LinuxWebAppSlotAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettings | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettings | undefined);
    private _additionalLoginParameters?;
    get additionalLoginParameters(): {
        [key: string]: string;
    };
    set additionalLoginParameters(value: {
        [key: string]: string;
    });
    resetAdditionalLoginParameters(): void;
    get additionalLoginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    get tokenRefreshExtensionHours(): number;
    set tokenRefreshExtensionHours(value: number);
    resetTokenRefreshExtensionHours(): void;
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    get unauthenticatedClientAction(): string;
    set unauthenticatedClientAction(value: string);
    resetUnauthenticatedClientAction(): void;
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): LinuxWebAppSlotAuthSettingsActiveDirectoryOutputReference;
    putActiveDirectory(value: LinuxWebAppSlotAuthSettingsActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): LinuxWebAppSlotAuthSettingsActiveDirectory | undefined;
    private _facebook;
    get facebook(): LinuxWebAppSlotAuthSettingsFacebookOutputReference;
    putFacebook(value: LinuxWebAppSlotAuthSettingsFacebook): void;
    resetFacebook(): void;
    get facebookInput(): LinuxWebAppSlotAuthSettingsFacebook | undefined;
    private _github;
    get github(): LinuxWebAppSlotAuthSettingsGithubOutputReference;
    putGithub(value: LinuxWebAppSlotAuthSettingsGithub): void;
    resetGithub(): void;
    get githubInput(): LinuxWebAppSlotAuthSettingsGithub | undefined;
    private _google;
    get google(): LinuxWebAppSlotAuthSettingsGoogleOutputReference;
    putGoogle(value: LinuxWebAppSlotAuthSettingsGoogle): void;
    resetGoogle(): void;
    get googleInput(): LinuxWebAppSlotAuthSettingsGoogle | undefined;
    private _microsoft;
    get microsoft(): LinuxWebAppSlotAuthSettingsMicrosoftOutputReference;
    putMicrosoft(value: LinuxWebAppSlotAuthSettingsMicrosoft): void;
    resetMicrosoft(): void;
    get microsoftInput(): LinuxWebAppSlotAuthSettingsMicrosoft | undefined;
    private _twitter;
    get twitter(): LinuxWebAppSlotAuthSettingsTwitterOutputReference;
    putTwitter(value: LinuxWebAppSlotAuthSettingsTwitter): void;
    resetTwitter(): void;
    get twitterInput(): LinuxWebAppSlotAuthSettingsTwitter | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2 {
    /**
    * The list of allowed Applications for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_applications LinuxWebAppSlot#allowed_applications}
    */
    readonly allowedApplications?: string[];
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_audiences LinuxWebAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The list of allowed Group Names for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_groups LinuxWebAppSlot#allowed_groups}
    */
    readonly allowedGroups?: string[];
    /**
    * The list of allowed Identities for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_identities LinuxWebAppSlot#allowed_identities}
    */
    readonly allowedIdentities?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The thumbprint of the certificate used for signing purposes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_certificate_thumbprint LinuxWebAppSlot#client_secret_certificate_thumbprint}
    */
    readonly clientSecretCertificateThumbprint?: string;
    /**
    * The App Setting name that contains the client secret of the Client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * A list of Allowed Client Applications in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#jwt_allowed_client_applications LinuxWebAppSlot#jwt_allowed_client_applications}
    */
    readonly jwtAllowedClientApplications?: string[];
    /**
    * A list of Allowed Groups in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#jwt_allowed_groups LinuxWebAppSlot#jwt_allowed_groups}
    */
    readonly jwtAllowedGroups?: string[];
    /**
    * A map of key-value pairs to send to the Authorisation Endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#login_parameters LinuxWebAppSlot#login_parameters}
    */
    readonly loginParameters?: {
        [key: string]: string;
    };
    /**
    * The Azure Tenant Endpoint for the Authenticating Tenant. e.g. `https://login.microsoftonline.com/v2.0/{tenant-guid}/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#tenant_auth_endpoint LinuxWebAppSlot#tenant_auth_endpoint}
    */
    readonly tenantAuthEndpoint: string;
    /**
    * Should the www-authenticate provider should be omitted from the request? Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#www_authentication_disabled LinuxWebAppSlot#www_authentication_disabled}
    */
    readonly wwwAuthenticationDisabled?: boolean | cdktf.IResolvable;
}
export declare function linuxWebAppSlotAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference | LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined);
    private _allowedApplications?;
    get allowedApplications(): string[];
    set allowedApplications(value: string[]);
    resetAllowedApplications(): void;
    get allowedApplicationsInput(): string[] | undefined;
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _allowedGroups?;
    get allowedGroups(): string[];
    set allowedGroups(value: string[]);
    resetAllowedGroups(): void;
    get allowedGroupsInput(): string[] | undefined;
    private _allowedIdentities?;
    get allowedIdentities(): string[];
    set allowedIdentities(value: string[]);
    resetAllowedIdentities(): void;
    get allowedIdentitiesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretCertificateThumbprint?;
    get clientSecretCertificateThumbprint(): string;
    set clientSecretCertificateThumbprint(value: string);
    resetClientSecretCertificateThumbprint(): void;
    get clientSecretCertificateThumbprintInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _jwtAllowedClientApplications?;
    get jwtAllowedClientApplications(): string[];
    set jwtAllowedClientApplications(value: string[]);
    resetJwtAllowedClientApplications(): void;
    get jwtAllowedClientApplicationsInput(): string[] | undefined;
    private _jwtAllowedGroups?;
    get jwtAllowedGroups(): string[];
    set jwtAllowedGroups(value: string[]);
    resetJwtAllowedGroups(): void;
    get jwtAllowedGroupsInput(): string[] | undefined;
    private _loginParameters?;
    get loginParameters(): {
        [key: string]: string;
    };
    set loginParameters(value: {
        [key: string]: string;
    });
    resetLoginParameters(): void;
    get loginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantAuthEndpoint?;
    get tenantAuthEndpoint(): string;
    set tenantAuthEndpoint(value: string);
    get tenantAuthEndpointInput(): string | undefined;
    private _wwwAuthenticationDisabled?;
    get wwwAuthenticationDisabled(): boolean | cdktf.IResolvable;
    set wwwAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    resetWwwAuthenticationDisabled(): void;
    get wwwAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2AppleV2 {
    /**
    * The OpenID Connect Client ID for the Apple web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Apple Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
}
export declare function linuxWebAppSlotAuthSettingsV2AppleV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2AppleV2OutputReference | LinuxWebAppSlotAuthSettingsV2AppleV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2AppleV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    get loginScopes(): string[];
}
export interface LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2 {
    /**
    * The ID of the Client to use to authenticate with Azure Static Web App Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
}
export declare function linuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference | LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2CustomOidcV2 {
    /**
    * The ID of the Client to use to authenticate with this Custom OIDC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The name of the Custom OIDC Authentication Provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#name LinuxWebAppSlot#name}
    */
    readonly name: string;
    /**
    * The name of the claim that contains the users name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#name_claim_type LinuxWebAppSlot#name_claim_type}
    */
    readonly nameClaimType?: string;
    /**
    * The endpoint that contains all the configuration endpoints for this Custom OIDC provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#openid_configuration_endpoint LinuxWebAppSlot#openid_configuration_endpoint}
    */
    readonly openidConfigurationEndpoint: string;
    /**
    * The list of the scopes that should be requested while authenticating.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#scopes LinuxWebAppSlot#scopes}
    */
    readonly scopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsV2CustomOidcV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameClaimType?;
    get nameClaimType(): string;
    set nameClaimType(value: string);
    resetNameClaimType(): void;
    get nameClaimTypeInput(): string | undefined;
    private _openidConfigurationEndpoint?;
    get openidConfigurationEndpoint(): string;
    set openidConfigurationEndpoint(value: string);
    get openidConfigurationEndpointInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    get tokenEndpoint(): string;
}
export declare class LinuxWebAppSlotAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotAuthSettingsV2CustomOidcV2OutputReference;
}
export interface LinuxWebAppSlotAuthSettingsV2FacebookV2 {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#app_id LinuxWebAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#app_secret_setting_name LinuxWebAppSlot#app_secret_setting_name}
    */
    readonly appSecretSettingName: string;
    /**
    * The version of the Facebook API to be used while logging in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#graph_api_version LinuxWebAppSlot#graph_api_version}
    */
    readonly graphApiVersion?: string;
    /**
    * Specifies a list of scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#login_scopes LinuxWebAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsV2FacebookV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2FacebookV2OutputReference | LinuxWebAppSlotAuthSettingsV2FacebookV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2FacebookV2 | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    get appSecretSettingNameInput(): string | undefined;
    private _graphApiVersion?;
    get graphApiVersion(): string;
    set graphApiVersion(value: string);
    resetGraphApiVersion(): void;
    get graphApiVersionInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2GithubV2 {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#login_scopes LinuxWebAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsV2GithubV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2GithubV2OutputReference | LinuxWebAppSlotAuthSettingsV2GithubV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2GithubV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2GoogleV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_audiences LinuxWebAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of Login scopes that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#login_scopes LinuxWebAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsV2GoogleV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2GoogleV2OutputReference | LinuxWebAppSlotAuthSettingsV2GoogleV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2GoogleV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2Login {
    /**
    * External URLs that can be redirected to as part of logging in or logging out of the app. This is an advanced setting typically only needed by Windows Store application backends. **Note:** URLs within the current domain are always implicitly allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_external_redirect_urls LinuxWebAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The method by which cookies expire. Possible values include: `FixedTime`, and `IdentityProviderDerived`. Defaults to `FixedTime`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#cookie_expiration_convention LinuxWebAppSlot#cookie_expiration_convention}
    */
    readonly cookieExpirationConvention?: string;
    /**
    * The time after the request is made when the session cookie should expire. Defaults to `08:00:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#cookie_expiration_time LinuxWebAppSlot#cookie_expiration_time}
    */
    readonly cookieExpirationTime?: string;
    /**
    * The endpoint to which logout requests should be made.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#logout_endpoint LinuxWebAppSlot#logout_endpoint}
    */
    readonly logoutEndpoint?: string;
    /**
    * The time after the request is made when the nonce should expire. Defaults to `00:05:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#nonce_expiration_time LinuxWebAppSlot#nonce_expiration_time}
    */
    readonly nonceExpirationTime?: string;
    /**
    * Should the fragments from the request be preserved after the login request is made. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#preserve_url_fragments_for_logins LinuxWebAppSlot#preserve_url_fragments_for_logins}
    */
    readonly preserveUrlFragmentsForLogins?: boolean | cdktf.IResolvable;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#token_refresh_extension_time LinuxWebAppSlot#token_refresh_extension_time}
    */
    readonly tokenRefreshExtensionTime?: number;
    /**
    * Should the Token Store configuration Enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#token_store_enabled LinuxWebAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The directory path in the App Filesystem in which the tokens will be stored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#token_store_path LinuxWebAppSlot#token_store_path}
    */
    readonly tokenStorePath?: string;
    /**
    * The name of the app setting which contains the SAS URL of the blob storage containing the tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#token_store_sas_setting_name LinuxWebAppSlot#token_store_sas_setting_name}
    */
    readonly tokenStoreSasSettingName?: string;
    /**
    * Should the nonce be validated while completing the login flow. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#validate_nonce LinuxWebAppSlot#validate_nonce}
    */
    readonly validateNonce?: boolean | cdktf.IResolvable;
}
export declare function linuxWebAppSlotAuthSettingsV2LoginToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2LoginOutputReference | LinuxWebAppSlotAuthSettingsV2Login): any;
export declare class LinuxWebAppSlotAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2Login | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2Login | undefined);
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _cookieExpirationConvention?;
    get cookieExpirationConvention(): string;
    set cookieExpirationConvention(value: string);
    resetCookieExpirationConvention(): void;
    get cookieExpirationConventionInput(): string | undefined;
    private _cookieExpirationTime?;
    get cookieExpirationTime(): string;
    set cookieExpirationTime(value: string);
    resetCookieExpirationTime(): void;
    get cookieExpirationTimeInput(): string | undefined;
    private _logoutEndpoint?;
    get logoutEndpoint(): string;
    set logoutEndpoint(value: string);
    resetLogoutEndpoint(): void;
    get logoutEndpointInput(): string | undefined;
    private _nonceExpirationTime?;
    get nonceExpirationTime(): string;
    set nonceExpirationTime(value: string);
    resetNonceExpirationTime(): void;
    get nonceExpirationTimeInput(): string | undefined;
    private _preserveUrlFragmentsForLogins?;
    get preserveUrlFragmentsForLogins(): boolean | cdktf.IResolvable;
    set preserveUrlFragmentsForLogins(value: boolean | cdktf.IResolvable);
    resetPreserveUrlFragmentsForLogins(): void;
    get preserveUrlFragmentsForLoginsInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenRefreshExtensionTime?;
    get tokenRefreshExtensionTime(): number;
    set tokenRefreshExtensionTime(value: number);
    resetTokenRefreshExtensionTime(): void;
    get tokenRefreshExtensionTimeInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenStorePath?;
    get tokenStorePath(): string;
    set tokenStorePath(value: string);
    resetTokenStorePath(): void;
    get tokenStorePathInput(): string | undefined;
    private _tokenStoreSasSettingName?;
    get tokenStoreSasSettingName(): string;
    set tokenStoreSasSettingName(value: string);
    resetTokenStoreSasSettingName(): void;
    get tokenStoreSasSettingNameInput(): string | undefined;
    private _validateNonce?;
    get validateNonce(): boolean | cdktf.IResolvable;
    set validateNonce(value: boolean | cdktf.IResolvable);
    resetValidateNonce(): void;
    get validateNonceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2MicrosoftV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Microsoft Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_audiences LinuxWebAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_id LinuxWebAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#client_secret_setting_name LinuxWebAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * The list of Login scopes that will be requested as part of Microsoft Account authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#login_scopes LinuxWebAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function linuxWebAppSlotAuthSettingsV2MicrosoftV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2MicrosoftV2OutputReference | LinuxWebAppSlotAuthSettingsV2MicrosoftV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2MicrosoftV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2TwitterV2 {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#consumer_key LinuxWebAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#consumer_secret_setting_name LinuxWebAppSlot#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName: string;
}
export declare function linuxWebAppSlotAuthSettingsV2TwitterV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2TwitterV2OutputReference | LinuxWebAppSlotAuthSettingsV2TwitterV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2TwitterV2 | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface LinuxWebAppSlotAuthSettingsV2 {
    /**
    * Should the AuthV2 Settings be enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#auth_enabled LinuxWebAppSlot#auth_enabled}
    */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
    * The path to the App Auth settings. **Note:** Relative Paths are evaluated from the Site Root directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#config_file_path LinuxWebAppSlot#config_file_path}
    */
    readonly configFilePath?: string;
    /**
    * The Default Authentication Provider to use when the `unauthenticated_action` is set to `RedirectToLoginPage`. Possible values include: `apple`, `azureactivedirectory`, `facebook`, `github`, `google`, `twitter` and the `name` of your `custom_oidc_v2` provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#default_provider LinuxWebAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * The paths which should be excluded from the `unauthenticated_action` when it is set to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#excluded_paths LinuxWebAppSlot#excluded_paths}
    */
    readonly excludedPaths?: string[];
    /**
    * The convention used to determine the url of the request made. Possible values include `ForwardProxyConventionNoProxy`, `ForwardProxyConventionStandard`, `ForwardProxyConventionCustom`. Defaults to `ForwardProxyConventionNoProxy`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#forward_proxy_convention LinuxWebAppSlot#forward_proxy_convention}
    */
    readonly forwardProxyConvention?: string;
    /**
    * The name of the header containing the host of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#forward_proxy_custom_host_header_name LinuxWebAppSlot#forward_proxy_custom_host_header_name}
    */
    readonly forwardProxyCustomHostHeaderName?: string;
    /**
    * The name of the header containing the scheme of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#forward_proxy_custom_scheme_header_name LinuxWebAppSlot#forward_proxy_custom_scheme_header_name}
    */
    readonly forwardProxyCustomSchemeHeaderName?: string;
    /**
    * The prefix that should precede all the authentication and authorisation paths. Defaults to `/.auth`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#http_route_api_prefix LinuxWebAppSlot#http_route_api_prefix}
    */
    readonly httpRouteApiPrefix?: string;
    /**
    * Should the authentication flow be used for all requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#require_authentication LinuxWebAppSlot#require_authentication}
    */
    readonly requireAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Should HTTPS be required on connections? Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#require_https LinuxWebAppSlot#require_https}
    */
    readonly requireHttps?: boolean | cdktf.IResolvable;
    /**
    * The Runtime Version of the Authentication and Authorisation feature of this App. Defaults to `~1`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#runtime_version LinuxWebAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The action to take for requests made without authentication. Possible values include `RedirectToLoginPage`, `AllowAnonymous`, `Return401`, and `Return403`. Defaults to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#unauthenticated_action LinuxWebAppSlot#unauthenticated_action}
    */
    readonly unauthenticatedAction?: string;
    /**
    * active_directory_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#active_directory_v2 LinuxWebAppSlot#active_directory_v2}
    */
    readonly activeDirectoryV2?: LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2;
    /**
    * apple_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#apple_v2 LinuxWebAppSlot#apple_v2}
    */
    readonly appleV2?: LinuxWebAppSlotAuthSettingsV2AppleV2;
    /**
    * azure_static_web_app_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#azure_static_web_app_v2 LinuxWebAppSlot#azure_static_web_app_v2}
    */
    readonly azureStaticWebAppV2?: LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2;
    /**
    * custom_oidc_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#custom_oidc_v2 LinuxWebAppSlot#custom_oidc_v2}
    */
    readonly customOidcV2?: LinuxWebAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * facebook_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#facebook_v2 LinuxWebAppSlot#facebook_v2}
    */
    readonly facebookV2?: LinuxWebAppSlotAuthSettingsV2FacebookV2;
    /**
    * github_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#github_v2 LinuxWebAppSlot#github_v2}
    */
    readonly githubV2?: LinuxWebAppSlotAuthSettingsV2GithubV2;
    /**
    * google_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#google_v2 LinuxWebAppSlot#google_v2}
    */
    readonly googleV2?: LinuxWebAppSlotAuthSettingsV2GoogleV2;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#login LinuxWebAppSlot#login}
    */
    readonly login: LinuxWebAppSlotAuthSettingsV2Login;
    /**
    * microsoft_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#microsoft_v2 LinuxWebAppSlot#microsoft_v2}
    */
    readonly microsoftV2?: LinuxWebAppSlotAuthSettingsV2MicrosoftV2;
    /**
    * twitter_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#twitter_v2 LinuxWebAppSlot#twitter_v2}
    */
    readonly twitterV2?: LinuxWebAppSlotAuthSettingsV2TwitterV2;
}
export declare function linuxWebAppSlotAuthSettingsV2ToTerraform(struct?: LinuxWebAppSlotAuthSettingsV2OutputReference | LinuxWebAppSlotAuthSettingsV2): any;
export declare class LinuxWebAppSlotAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotAuthSettingsV2 | undefined;
    set internalValue(value: LinuxWebAppSlotAuthSettingsV2 | undefined);
    private _authEnabled?;
    get authEnabled(): boolean | cdktf.IResolvable;
    set authEnabled(value: boolean | cdktf.IResolvable);
    resetAuthEnabled(): void;
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _configFilePath?;
    get configFilePath(): string;
    set configFilePath(value: string);
    resetConfigFilePath(): void;
    get configFilePathInput(): string | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _excludedPaths?;
    get excludedPaths(): string[];
    set excludedPaths(value: string[]);
    resetExcludedPaths(): void;
    get excludedPathsInput(): string[] | undefined;
    private _forwardProxyConvention?;
    get forwardProxyConvention(): string;
    set forwardProxyConvention(value: string);
    resetForwardProxyConvention(): void;
    get forwardProxyConventionInput(): string | undefined;
    private _forwardProxyCustomHostHeaderName?;
    get forwardProxyCustomHostHeaderName(): string;
    set forwardProxyCustomHostHeaderName(value: string);
    resetForwardProxyCustomHostHeaderName(): void;
    get forwardProxyCustomHostHeaderNameInput(): string | undefined;
    private _forwardProxyCustomSchemeHeaderName?;
    get forwardProxyCustomSchemeHeaderName(): string;
    set forwardProxyCustomSchemeHeaderName(value: string);
    resetForwardProxyCustomSchemeHeaderName(): void;
    get forwardProxyCustomSchemeHeaderNameInput(): string | undefined;
    private _httpRouteApiPrefix?;
    get httpRouteApiPrefix(): string;
    set httpRouteApiPrefix(value: string);
    resetHttpRouteApiPrefix(): void;
    get httpRouteApiPrefixInput(): string | undefined;
    private _requireAuthentication?;
    get requireAuthentication(): boolean | cdktf.IResolvable;
    set requireAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireAuthentication(): void;
    get requireAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireHttps?;
    get requireHttps(): boolean | cdktf.IResolvable;
    set requireHttps(value: boolean | cdktf.IResolvable);
    resetRequireHttps(): void;
    get requireHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _unauthenticatedAction?;
    get unauthenticatedAction(): string;
    set unauthenticatedAction(value: string);
    resetUnauthenticatedAction(): void;
    get unauthenticatedActionInput(): string | undefined;
    private _activeDirectoryV2;
    get activeDirectoryV2(): LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference;
    putActiveDirectoryV2(value: LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2): void;
    resetActiveDirectoryV2(): void;
    get activeDirectoryV2Input(): LinuxWebAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined;
    private _appleV2;
    get appleV2(): LinuxWebAppSlotAuthSettingsV2AppleV2OutputReference;
    putAppleV2(value: LinuxWebAppSlotAuthSettingsV2AppleV2): void;
    resetAppleV2(): void;
    get appleV2Input(): LinuxWebAppSlotAuthSettingsV2AppleV2 | undefined;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference;
    putAzureStaticWebAppV2(value: LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2): void;
    resetAzureStaticWebAppV2(): void;
    get azureStaticWebAppV2Input(): LinuxWebAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined;
    private _customOidcV2;
    get customOidcV2(): LinuxWebAppSlotAuthSettingsV2CustomOidcV2List;
    putCustomOidcV2(value: LinuxWebAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable): void;
    resetCustomOidcV2(): void;
    get customOidcV2Input(): cdktf.IResolvable | LinuxWebAppSlotAuthSettingsV2CustomOidcV2[] | undefined;
    private _facebookV2;
    get facebookV2(): LinuxWebAppSlotAuthSettingsV2FacebookV2OutputReference;
    putFacebookV2(value: LinuxWebAppSlotAuthSettingsV2FacebookV2): void;
    resetFacebookV2(): void;
    get facebookV2Input(): LinuxWebAppSlotAuthSettingsV2FacebookV2 | undefined;
    private _githubV2;
    get githubV2(): LinuxWebAppSlotAuthSettingsV2GithubV2OutputReference;
    putGithubV2(value: LinuxWebAppSlotAuthSettingsV2GithubV2): void;
    resetGithubV2(): void;
    get githubV2Input(): LinuxWebAppSlotAuthSettingsV2GithubV2 | undefined;
    private _googleV2;
    get googleV2(): LinuxWebAppSlotAuthSettingsV2GoogleV2OutputReference;
    putGoogleV2(value: LinuxWebAppSlotAuthSettingsV2GoogleV2): void;
    resetGoogleV2(): void;
    get googleV2Input(): LinuxWebAppSlotAuthSettingsV2GoogleV2 | undefined;
    private _login;
    get login(): LinuxWebAppSlotAuthSettingsV2LoginOutputReference;
    putLogin(value: LinuxWebAppSlotAuthSettingsV2Login): void;
    get loginInput(): LinuxWebAppSlotAuthSettingsV2Login | undefined;
    private _microsoftV2;
    get microsoftV2(): LinuxWebAppSlotAuthSettingsV2MicrosoftV2OutputReference;
    putMicrosoftV2(value: LinuxWebAppSlotAuthSettingsV2MicrosoftV2): void;
    resetMicrosoftV2(): void;
    get microsoftV2Input(): LinuxWebAppSlotAuthSettingsV2MicrosoftV2 | undefined;
    private _twitterV2;
    get twitterV2(): LinuxWebAppSlotAuthSettingsV2TwitterV2OutputReference;
    putTwitterV2(value: LinuxWebAppSlotAuthSettingsV2TwitterV2): void;
    resetTwitterV2(): void;
    get twitterV2Input(): LinuxWebAppSlotAuthSettingsV2TwitterV2 | undefined;
}
export interface LinuxWebAppSlotBackupSchedule {
    /**
    * How often the backup should be executed (e.g. for weekly backup, this should be set to `7` and `frequency_unit` should be set to `Day`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#frequency_interval LinuxWebAppSlot#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * The unit of time for how often the backup should take place. Possible values include: `Day` and `Hour`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#frequency_unit LinuxWebAppSlot#frequency_unit}
    */
    readonly frequencyUnit: string;
    /**
    * Should the service keep at least one backup, regardless of age of backup. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#keep_at_least_one_backup LinuxWebAppSlot#keep_at_least_one_backup}
    */
    readonly keepAtLeastOneBackup?: boolean | cdktf.IResolvable;
    /**
    * After how many days backups should be deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#retention_period_days LinuxWebAppSlot#retention_period_days}
    */
    readonly retentionPeriodDays?: number;
    /**
    * When the schedule should start working in RFC-3339 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#start_time LinuxWebAppSlot#start_time}
    */
    readonly startTime?: string;
}
export declare function linuxWebAppSlotBackupScheduleToTerraform(struct?: LinuxWebAppSlotBackupScheduleOutputReference | LinuxWebAppSlotBackupSchedule): any;
export declare class LinuxWebAppSlotBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotBackupSchedule | undefined;
    set internalValue(value: LinuxWebAppSlotBackupSchedule | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    private _frequencyUnit?;
    get frequencyUnit(): string;
    set frequencyUnit(value: string);
    get frequencyUnitInput(): string | undefined;
    private _keepAtLeastOneBackup?;
    get keepAtLeastOneBackup(): boolean | cdktf.IResolvable;
    set keepAtLeastOneBackup(value: boolean | cdktf.IResolvable);
    resetKeepAtLeastOneBackup(): void;
    get keepAtLeastOneBackupInput(): boolean | cdktf.IResolvable | undefined;
    get lastExecutionTime(): string;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    resetRetentionPeriodDays(): void;
    get retentionPeriodDaysInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface LinuxWebAppSlotBackup {
    /**
    * Should this backup job be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#enabled LinuxWebAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The name which should be used for this Backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#name LinuxWebAppSlot#name}
    */
    readonly name: string;
    /**
    * The SAS URL to the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#storage_account_url LinuxWebAppSlot#storage_account_url}
    */
    readonly storageAccountUrl: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#schedule LinuxWebAppSlot#schedule}
    */
    readonly schedule: LinuxWebAppSlotBackupSchedule;
}
export declare function linuxWebAppSlotBackupToTerraform(struct?: LinuxWebAppSlotBackupOutputReference | LinuxWebAppSlotBackup): any;
export declare class LinuxWebAppSlotBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotBackup | undefined;
    set internalValue(value: LinuxWebAppSlotBackup | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountUrl?;
    get storageAccountUrl(): string;
    set storageAccountUrl(value: string);
    get storageAccountUrlInput(): string | undefined;
    private _schedule;
    get schedule(): LinuxWebAppSlotBackupScheduleOutputReference;
    putSchedule(value: LinuxWebAppSlotBackupSchedule): void;
    get scheduleInput(): LinuxWebAppSlotBackupSchedule | undefined;
}
export interface LinuxWebAppSlotConnectionString {
    /**
    * The name which should be used for this Connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#name LinuxWebAppSlot#name}
    */
    readonly name: string;
    /**
    * Type of database. Possible values include: `MySQL`, `SQLServer`, `SQLAzure`, `Custom`, `NotificationHub`, `ServiceBus`, `EventHub`, `APIHub`, `DocDb`, `RedisCache`, and `PostgreSQL`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#type LinuxWebAppSlot#type}
    */
    readonly type: string;
    /**
    * The connection string value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#value LinuxWebAppSlot#value}
    */
    readonly value: string;
}
export declare function linuxWebAppSlotConnectionStringToTerraform(struct?: LinuxWebAppSlotConnectionString | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotConnectionString | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotConnectionString | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class LinuxWebAppSlotConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotConnectionStringOutputReference;
}
export interface LinuxWebAppSlotIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#identity_ids LinuxWebAppSlot#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#type LinuxWebAppSlot#type}
    */
    readonly type: string;
}
export declare function linuxWebAppSlotIdentityToTerraform(struct?: LinuxWebAppSlotIdentityOutputReference | LinuxWebAppSlotIdentity): any;
export declare class LinuxWebAppSlotIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotIdentity | undefined;
    set internalValue(value: LinuxWebAppSlotIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface LinuxWebAppSlotLogsApplicationLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#level LinuxWebAppSlot#level}
    */
    readonly level: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#retention_in_days LinuxWebAppSlot#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#sas_url LinuxWebAppSlot#sas_url}
    */
    readonly sasUrl: string;
}
export declare function linuxWebAppSlotLogsApplicationLogsAzureBlobStorageToTerraform(struct?: LinuxWebAppSlotLogsApplicationLogsAzureBlobStorageOutputReference | LinuxWebAppSlotLogsApplicationLogsAzureBlobStorage): any;
export declare class LinuxWebAppSlotLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotLogsApplicationLogsAzureBlobStorage | undefined;
    set internalValue(value: LinuxWebAppSlotLogsApplicationLogsAzureBlobStorage | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    get levelInput(): string | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface LinuxWebAppSlotLogsApplicationLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#file_system_level LinuxWebAppSlot#file_system_level}
    */
    readonly fileSystemLevel: string;
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#azure_blob_storage LinuxWebAppSlot#azure_blob_storage}
    */
    readonly azureBlobStorage?: LinuxWebAppSlotLogsApplicationLogsAzureBlobStorage;
}
export declare function linuxWebAppSlotLogsApplicationLogsToTerraform(struct?: LinuxWebAppSlotLogsApplicationLogsOutputReference | LinuxWebAppSlotLogsApplicationLogs): any;
export declare class LinuxWebAppSlotLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotLogsApplicationLogs | undefined;
    set internalValue(value: LinuxWebAppSlotLogsApplicationLogs | undefined);
    private _fileSystemLevel?;
    get fileSystemLevel(): string;
    set fileSystemLevel(value: string);
    get fileSystemLevelInput(): string | undefined;
    private _azureBlobStorage;
    get azureBlobStorage(): LinuxWebAppSlotLogsApplicationLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: LinuxWebAppSlotLogsApplicationLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): LinuxWebAppSlotLogsApplicationLogsAzureBlobStorage | undefined;
}
export interface LinuxWebAppSlotLogsHttpLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#retention_in_days LinuxWebAppSlot#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#sas_url LinuxWebAppSlot#sas_url}
    */
    readonly sasUrl: string;
}
export declare function linuxWebAppSlotLogsHttpLogsAzureBlobStorageToTerraform(struct?: LinuxWebAppSlotLogsHttpLogsAzureBlobStorageOutputReference | LinuxWebAppSlotLogsHttpLogsAzureBlobStorage): any;
export declare class LinuxWebAppSlotLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotLogsHttpLogsAzureBlobStorage | undefined;
    set internalValue(value: LinuxWebAppSlotLogsHttpLogsAzureBlobStorage | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface LinuxWebAppSlotLogsHttpLogsFileSystem {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#retention_in_days LinuxWebAppSlot#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#retention_in_mb LinuxWebAppSlot#retention_in_mb}
    */
    readonly retentionInMb: number;
}
export declare function linuxWebAppSlotLogsHttpLogsFileSystemToTerraform(struct?: LinuxWebAppSlotLogsHttpLogsFileSystemOutputReference | LinuxWebAppSlotLogsHttpLogsFileSystem): any;
export declare class LinuxWebAppSlotLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotLogsHttpLogsFileSystem | undefined;
    set internalValue(value: LinuxWebAppSlotLogsHttpLogsFileSystem | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _retentionInMb?;
    get retentionInMb(): number;
    set retentionInMb(value: number);
    get retentionInMbInput(): number | undefined;
}
export interface LinuxWebAppSlotLogsHttpLogs {
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#azure_blob_storage LinuxWebAppSlot#azure_blob_storage}
    */
    readonly azureBlobStorage?: LinuxWebAppSlotLogsHttpLogsAzureBlobStorage;
    /**
    * file_system block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#file_system LinuxWebAppSlot#file_system}
    */
    readonly fileSystem?: LinuxWebAppSlotLogsHttpLogsFileSystem;
}
export declare function linuxWebAppSlotLogsHttpLogsToTerraform(struct?: LinuxWebAppSlotLogsHttpLogsOutputReference | LinuxWebAppSlotLogsHttpLogs): any;
export declare class LinuxWebAppSlotLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotLogsHttpLogs | undefined;
    set internalValue(value: LinuxWebAppSlotLogsHttpLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): LinuxWebAppSlotLogsHttpLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: LinuxWebAppSlotLogsHttpLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): LinuxWebAppSlotLogsHttpLogsAzureBlobStorage | undefined;
    private _fileSystem;
    get fileSystem(): LinuxWebAppSlotLogsHttpLogsFileSystemOutputReference;
    putFileSystem(value: LinuxWebAppSlotLogsHttpLogsFileSystem): void;
    resetFileSystem(): void;
    get fileSystemInput(): LinuxWebAppSlotLogsHttpLogsFileSystem | undefined;
}
export interface LinuxWebAppSlotLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#detailed_error_messages LinuxWebAppSlot#detailed_error_messages}
    */
    readonly detailedErrorMessages?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#failed_request_tracing LinuxWebAppSlot#failed_request_tracing}
    */
    readonly failedRequestTracing?: boolean | cdktf.IResolvable;
    /**
    * application_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#application_logs LinuxWebAppSlot#application_logs}
    */
    readonly applicationLogs?: LinuxWebAppSlotLogsApplicationLogs;
    /**
    * http_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#http_logs LinuxWebAppSlot#http_logs}
    */
    readonly httpLogs?: LinuxWebAppSlotLogsHttpLogs;
}
export declare function linuxWebAppSlotLogsToTerraform(struct?: LinuxWebAppSlotLogsOutputReference | LinuxWebAppSlotLogs): any;
export declare class LinuxWebAppSlotLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotLogs | undefined;
    set internalValue(value: LinuxWebAppSlotLogs | undefined);
    private _detailedErrorMessages?;
    get detailedErrorMessages(): boolean | cdktf.IResolvable;
    set detailedErrorMessages(value: boolean | cdktf.IResolvable);
    resetDetailedErrorMessages(): void;
    get detailedErrorMessagesInput(): boolean | cdktf.IResolvable | undefined;
    private _failedRequestTracing?;
    get failedRequestTracing(): boolean | cdktf.IResolvable;
    set failedRequestTracing(value: boolean | cdktf.IResolvable);
    resetFailedRequestTracing(): void;
    get failedRequestTracingInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationLogs;
    get applicationLogs(): LinuxWebAppSlotLogsApplicationLogsOutputReference;
    putApplicationLogs(value: LinuxWebAppSlotLogsApplicationLogs): void;
    resetApplicationLogs(): void;
    get applicationLogsInput(): LinuxWebAppSlotLogsApplicationLogs | undefined;
    private _httpLogs;
    get httpLogs(): LinuxWebAppSlotLogsHttpLogsOutputReference;
    putHttpLogs(value: LinuxWebAppSlotLogsHttpLogs): void;
    resetHttpLogs(): void;
    get httpLogsInput(): LinuxWebAppSlotLogsHttpLogs | undefined;
}
export interface LinuxWebAppSlotSiteConfigApplicationStack {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#docker_image LinuxWebAppSlot#docker_image}
    */
    readonly dockerImage?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#docker_image_name LinuxWebAppSlot#docker_image_name}
    */
    readonly dockerImageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#docker_image_tag LinuxWebAppSlot#docker_image_tag}
    */
    readonly dockerImageTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#docker_registry_password LinuxWebAppSlot#docker_registry_password}
    */
    readonly dockerRegistryPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#docker_registry_url LinuxWebAppSlot#docker_registry_url}
    */
    readonly dockerRegistryUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#docker_registry_username LinuxWebAppSlot#docker_registry_username}
    */
    readonly dockerRegistryUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#dotnet_version LinuxWebAppSlot#dotnet_version}
    */
    readonly dotnetVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#go_version LinuxWebAppSlot#go_version}
    */
    readonly goVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#java_server LinuxWebAppSlot#java_server}
    */
    readonly javaServer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#java_server_version LinuxWebAppSlot#java_server_version}
    */
    readonly javaServerVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#java_version LinuxWebAppSlot#java_version}
    */
    readonly javaVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#node_version LinuxWebAppSlot#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#php_version LinuxWebAppSlot#php_version}
    */
    readonly phpVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#python_version LinuxWebAppSlot#python_version}
    */
    readonly pythonVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#ruby_version LinuxWebAppSlot#ruby_version}
    */
    readonly rubyVersion?: string;
}
export declare function linuxWebAppSlotSiteConfigApplicationStackToTerraform(struct?: LinuxWebAppSlotSiteConfigApplicationStackOutputReference | LinuxWebAppSlotSiteConfigApplicationStack): any;
export declare class LinuxWebAppSlotSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotSiteConfigApplicationStack | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigApplicationStack | undefined);
    private _dockerImage?;
    get dockerImage(): string;
    set dockerImage(value: string);
    resetDockerImage(): void;
    get dockerImageInput(): string | undefined;
    private _dockerImageName?;
    get dockerImageName(): string;
    set dockerImageName(value: string);
    resetDockerImageName(): void;
    get dockerImageNameInput(): string | undefined;
    private _dockerImageTag?;
    get dockerImageTag(): string;
    set dockerImageTag(value: string);
    resetDockerImageTag(): void;
    get dockerImageTagInput(): string | undefined;
    private _dockerRegistryPassword?;
    get dockerRegistryPassword(): string;
    set dockerRegistryPassword(value: string);
    resetDockerRegistryPassword(): void;
    get dockerRegistryPasswordInput(): string | undefined;
    private _dockerRegistryUrl?;
    get dockerRegistryUrl(): string;
    set dockerRegistryUrl(value: string);
    resetDockerRegistryUrl(): void;
    get dockerRegistryUrlInput(): string | undefined;
    private _dockerRegistryUsername?;
    get dockerRegistryUsername(): string;
    set dockerRegistryUsername(value: string);
    resetDockerRegistryUsername(): void;
    get dockerRegistryUsernameInput(): string | undefined;
    private _dotnetVersion?;
    get dotnetVersion(): string;
    set dotnetVersion(value: string);
    resetDotnetVersion(): void;
    get dotnetVersionInput(): string | undefined;
    private _goVersion?;
    get goVersion(): string;
    set goVersion(value: string);
    resetGoVersion(): void;
    get goVersionInput(): string | undefined;
    private _javaServer?;
    get javaServer(): string;
    set javaServer(value: string);
    resetJavaServer(): void;
    get javaServerInput(): string | undefined;
    private _javaServerVersion?;
    get javaServerVersion(): string;
    set javaServerVersion(value: string);
    resetJavaServerVersion(): void;
    get javaServerVersionInput(): string | undefined;
    private _javaVersion?;
    get javaVersion(): string;
    set javaVersion(value: string);
    resetJavaVersion(): void;
    get javaVersionInput(): string | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    private _phpVersion?;
    get phpVersion(): string;
    set phpVersion(value: string);
    resetPhpVersion(): void;
    get phpVersionInput(): string | undefined;
    private _pythonVersion?;
    get pythonVersion(): string;
    set pythonVersion(value: string);
    resetPythonVersion(): void;
    get pythonVersionInput(): string | undefined;
    private _rubyVersion?;
    get rubyVersion(): string;
    set rubyVersion(value: string);
    resetRubyVersion(): void;
    get rubyVersionInput(): string | undefined;
}
export interface LinuxWebAppSlotSiteConfigAutoHealSettingAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#action_type LinuxWebAppSlot#action_type}
    */
    readonly actionType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#minimum_process_execution_time LinuxWebAppSlot#minimum_process_execution_time}
    */
    readonly minimumProcessExecutionTime?: string;
}
export declare function linuxWebAppSlotSiteConfigAutoHealSettingActionToTerraform(struct?: LinuxWebAppSlotSiteConfigAutoHealSettingActionOutputReference | LinuxWebAppSlotSiteConfigAutoHealSettingAction): any;
export declare class LinuxWebAppSlotSiteConfigAutoHealSettingActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotSiteConfigAutoHealSettingAction | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigAutoHealSettingAction | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    get actionTypeInput(): string | undefined;
    private _minimumProcessExecutionTime?;
    get minimumProcessExecutionTime(): string;
    set minimumProcessExecutionTime(value: string);
    resetMinimumProcessExecutionTime(): void;
    get minimumProcessExecutionTimeInput(): string | undefined;
}
export interface LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequests {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#count LinuxWebAppSlot#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#interval LinuxWebAppSlot#interval}
    */
    readonly interval: string;
}
export declare function linuxWebAppSlotSiteConfigAutoHealSettingTriggerRequestsToTerraform(struct?: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequestsOutputReference | LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequests): any;
export declare class LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequests | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequests | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
}
export interface LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#count LinuxWebAppSlot#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#interval LinuxWebAppSlot#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#path LinuxWebAppSlot#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#time_taken LinuxWebAppSlot#time_taken}
    */
    readonly timeTaken: string;
}
export declare function linuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequestToTerraform(struct?: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequestOutputReference | LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare class LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _timeTaken?;
    get timeTaken(): string;
    set timeTaken(value: string);
    get timeTakenInput(): string | undefined;
}
export interface LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#count LinuxWebAppSlot#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#interval LinuxWebAppSlot#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#path LinuxWebAppSlot#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#status_code_range LinuxWebAppSlot#status_code_range}
    */
    readonly statusCodeRange: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#sub_status LinuxWebAppSlot#sub_status}
    */
    readonly subStatus?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#win32_status LinuxWebAppSlot#win32_status}
    */
    readonly win32Status?: number;
}
export declare function linuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeToTerraform(struct?: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _statusCodeRange?;
    get statusCodeRange(): string;
    set statusCodeRange(value: string);
    get statusCodeRangeInput(): string | undefined;
    private _subStatus?;
    get subStatus(): number;
    set subStatus(value: number);
    resetSubStatus(): void;
    get subStatusInput(): number | undefined;
    private _win32Status?;
    get win32Status(): number;
    set win32Status(value: number);
    resetWin32Status(): void;
    get win32StatusInput(): number | undefined;
}
export declare class LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeOutputReference;
}
export interface LinuxWebAppSlotSiteConfigAutoHealSettingTrigger {
    /**
    * requests block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#requests LinuxWebAppSlot#requests}
    */
    readonly requests?: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequests;
    /**
    * slow_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#slow_request LinuxWebAppSlot#slow_request}
    */
    readonly slowRequest?: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest;
    /**
    * status_code block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#status_code LinuxWebAppSlot#status_code}
    */
    readonly statusCode?: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable;
}
export declare function linuxWebAppSlotSiteConfigAutoHealSettingTriggerToTerraform(struct?: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerOutputReference | LinuxWebAppSlotSiteConfigAutoHealSettingTrigger): any;
export declare class LinuxWebAppSlotSiteConfigAutoHealSettingTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotSiteConfigAutoHealSettingTrigger | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigAutoHealSettingTrigger | undefined);
    private _requests;
    get requests(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequestsOutputReference;
    putRequests(value: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequests): void;
    resetRequests(): void;
    get requestsInput(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerRequests | undefined;
    private _slowRequest;
    get slowRequest(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequestOutputReference;
    putSlowRequest(value: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest): void;
    resetSlowRequest(): void;
    get slowRequestInput(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    private _statusCode;
    get statusCode(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCodeList;
    putStatusCode(value: LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable): void;
    resetStatusCode(): void;
    get statusCodeInput(): cdktf.IResolvable | LinuxWebAppSlotSiteConfigAutoHealSettingTriggerStatusCode[] | undefined;
}
export interface LinuxWebAppSlotSiteConfigAutoHealSetting {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#action LinuxWebAppSlot#action}
    */
    readonly action?: LinuxWebAppSlotSiteConfigAutoHealSettingAction;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#trigger LinuxWebAppSlot#trigger}
    */
    readonly trigger?: LinuxWebAppSlotSiteConfigAutoHealSettingTrigger;
}
export declare function linuxWebAppSlotSiteConfigAutoHealSettingToTerraform(struct?: LinuxWebAppSlotSiteConfigAutoHealSettingOutputReference | LinuxWebAppSlotSiteConfigAutoHealSetting): any;
export declare class LinuxWebAppSlotSiteConfigAutoHealSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotSiteConfigAutoHealSetting | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigAutoHealSetting | undefined);
    private _action;
    get action(): LinuxWebAppSlotSiteConfigAutoHealSettingActionOutputReference;
    putAction(value: LinuxWebAppSlotSiteConfigAutoHealSettingAction): void;
    resetAction(): void;
    get actionInput(): LinuxWebAppSlotSiteConfigAutoHealSettingAction | undefined;
    private _trigger;
    get trigger(): LinuxWebAppSlotSiteConfigAutoHealSettingTriggerOutputReference;
    putTrigger(value: LinuxWebAppSlotSiteConfigAutoHealSettingTrigger): void;
    resetTrigger(): void;
    get triggerInput(): LinuxWebAppSlotSiteConfigAutoHealSettingTrigger | undefined;
}
export interface LinuxWebAppSlotSiteConfigCors {
    /**
    * Specifies a list of origins that should be allowed to make cross-origin calls.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#allowed_origins LinuxWebAppSlot#allowed_origins}
    */
    readonly allowedOrigins?: string[];
    /**
    * Are credentials allowed in CORS requests? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#support_credentials LinuxWebAppSlot#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function linuxWebAppSlotSiteConfigCorsToTerraform(struct?: LinuxWebAppSlotSiteConfigCorsOutputReference | LinuxWebAppSlotSiteConfigCors): any;
export declare class LinuxWebAppSlotSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotSiteConfigCors | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    resetAllowedOrigins(): void;
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxWebAppSlotSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#x_azure_fdid LinuxWebAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#x_fd_health_probe LinuxWebAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#x_forwarded_for LinuxWebAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#x_forwarded_host LinuxWebAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function linuxWebAppSlotSiteConfigIpRestrictionHeadersToTerraform(struct?: LinuxWebAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class LinuxWebAppSlotSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotSiteConfigIpRestrictionHeadersOutputReference;
}
export interface LinuxWebAppSlotSiteConfigIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#action LinuxWebAppSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#headers LinuxWebAppSlot#headers}
    */
    readonly headers?: LinuxWebAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#ip_address LinuxWebAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#name LinuxWebAppSlot#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#priority LinuxWebAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#service_tag LinuxWebAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#virtual_network_subnet_id LinuxWebAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function linuxWebAppSlotSiteConfigIpRestrictionToTerraform(struct?: LinuxWebAppSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): LinuxWebAppSlotSiteConfigIpRestrictionHeadersList;
    putHeaders(value: LinuxWebAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | LinuxWebAppSlotSiteConfigIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class LinuxWebAppSlotSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotSiteConfigIpRestrictionOutputReference;
}
export interface LinuxWebAppSlotSiteConfigScmIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#x_azure_fdid LinuxWebAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#x_fd_health_probe LinuxWebAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#x_forwarded_for LinuxWebAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#x_forwarded_host LinuxWebAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function linuxWebAppSlotSiteConfigScmIpRestrictionHeadersToTerraform(struct?: LinuxWebAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class LinuxWebAppSlotSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface LinuxWebAppSlotSiteConfigScmIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#action LinuxWebAppSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#headers LinuxWebAppSlot#headers}
    */
    readonly headers?: LinuxWebAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#ip_address LinuxWebAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#name LinuxWebAppSlot#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#priority LinuxWebAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#service_tag LinuxWebAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#virtual_network_subnet_id LinuxWebAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function linuxWebAppSlotSiteConfigScmIpRestrictionToTerraform(struct?: LinuxWebAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): LinuxWebAppSlotSiteConfigScmIpRestrictionHeadersList;
    putHeaders(value: LinuxWebAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | LinuxWebAppSlotSiteConfigScmIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class LinuxWebAppSlotSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotSiteConfigScmIpRestrictionOutputReference;
}
export interface LinuxWebAppSlotSiteConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#always_on LinuxWebAppSlot#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#api_definition_url LinuxWebAppSlot#api_definition_url}
    */
    readonly apiDefinitionUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#api_management_api_id LinuxWebAppSlot#api_management_api_id}
    */
    readonly apiManagementApiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#app_command_line LinuxWebAppSlot#app_command_line}
    */
    readonly appCommandLine?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#auto_heal_enabled LinuxWebAppSlot#auto_heal_enabled}
    */
    readonly autoHealEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#auto_swap_slot_name LinuxWebAppSlot#auto_swap_slot_name}
    */
    readonly autoSwapSlotName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#container_registry_managed_identity_client_id LinuxWebAppSlot#container_registry_managed_identity_client_id}
    */
    readonly containerRegistryManagedIdentityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#container_registry_use_managed_identity LinuxWebAppSlot#container_registry_use_managed_identity}
    */
    readonly containerRegistryUseManagedIdentity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#default_documents LinuxWebAppSlot#default_documents}
    */
    readonly defaultDocuments?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#ftps_state LinuxWebAppSlot#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * The amount of time in minutes that a node is unhealthy before being removed from the load balancer. Possible values are between `2` and `10`. Defaults to `10`. Only valid in conjunction with `health_check_path`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#health_check_eviction_time_in_min LinuxWebAppSlot#health_check_eviction_time_in_min}
    */
    readonly healthCheckEvictionTimeInMin?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#health_check_path LinuxWebAppSlot#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#http2_enabled LinuxWebAppSlot#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#load_balancing_mode LinuxWebAppSlot#load_balancing_mode}
    */
    readonly loadBalancingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#local_mysql_enabled LinuxWebAppSlot#local_mysql_enabled}
    */
    readonly localMysqlEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#managed_pipeline_mode LinuxWebAppSlot#managed_pipeline_mode}
    */
    readonly managedPipelineMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#minimum_tls_version LinuxWebAppSlot#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#remote_debugging_enabled LinuxWebAppSlot#remote_debugging_enabled}
    */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#remote_debugging_version LinuxWebAppSlot#remote_debugging_version}
    */
    readonly remoteDebuggingVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#scm_minimum_tls_version LinuxWebAppSlot#scm_minimum_tls_version}
    */
    readonly scmMinimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#scm_use_main_ip_restriction LinuxWebAppSlot#scm_use_main_ip_restriction}
    */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#use_32_bit_worker LinuxWebAppSlot#use_32_bit_worker}
    */
    readonly use32BitWorker?: boolean | cdktf.IResolvable;
    /**
    * Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#vnet_route_all_enabled LinuxWebAppSlot#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#websockets_enabled LinuxWebAppSlot#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#worker_count LinuxWebAppSlot#worker_count}
    */
    readonly workerCount?: number;
    /**
    * application_stack block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#application_stack LinuxWebAppSlot#application_stack}
    */
    readonly applicationStack?: LinuxWebAppSlotSiteConfigApplicationStack;
    /**
    * auto_heal_setting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#auto_heal_setting LinuxWebAppSlot#auto_heal_setting}
    */
    readonly autoHealSetting?: LinuxWebAppSlotSiteConfigAutoHealSetting;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#cors LinuxWebAppSlot#cors}
    */
    readonly cors?: LinuxWebAppSlotSiteConfigCors;
    /**
    * ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#ip_restriction LinuxWebAppSlot#ip_restriction}
    */
    readonly ipRestriction?: LinuxWebAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * scm_ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#scm_ip_restriction LinuxWebAppSlot#scm_ip_restriction}
    */
    readonly scmIpRestriction?: LinuxWebAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
}
export declare function linuxWebAppSlotSiteConfigToTerraform(struct?: LinuxWebAppSlotSiteConfigOutputReference | LinuxWebAppSlotSiteConfig): any;
export declare class LinuxWebAppSlotSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotSiteConfig | undefined;
    set internalValue(value: LinuxWebAppSlotSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _apiDefinitionUrl?;
    get apiDefinitionUrl(): string;
    set apiDefinitionUrl(value: string);
    resetApiDefinitionUrl(): void;
    get apiDefinitionUrlInput(): string | undefined;
    private _apiManagementApiId?;
    get apiManagementApiId(): string;
    set apiManagementApiId(value: string);
    resetApiManagementApiId(): void;
    get apiManagementApiIdInput(): string | undefined;
    private _appCommandLine?;
    get appCommandLine(): string;
    set appCommandLine(value: string);
    resetAppCommandLine(): void;
    get appCommandLineInput(): string | undefined;
    private _autoHealEnabled?;
    get autoHealEnabled(): boolean | cdktf.IResolvable;
    set autoHealEnabled(value: boolean | cdktf.IResolvable);
    resetAutoHealEnabled(): void;
    get autoHealEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSwapSlotName?;
    get autoSwapSlotName(): string;
    set autoSwapSlotName(value: string);
    resetAutoSwapSlotName(): void;
    get autoSwapSlotNameInput(): string | undefined;
    private _containerRegistryManagedIdentityClientId?;
    get containerRegistryManagedIdentityClientId(): string;
    set containerRegistryManagedIdentityClientId(value: string);
    resetContainerRegistryManagedIdentityClientId(): void;
    get containerRegistryManagedIdentityClientIdInput(): string | undefined;
    private _containerRegistryUseManagedIdentity?;
    get containerRegistryUseManagedIdentity(): boolean | cdktf.IResolvable;
    set containerRegistryUseManagedIdentity(value: boolean | cdktf.IResolvable);
    resetContainerRegistryUseManagedIdentity(): void;
    get containerRegistryUseManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultDocuments?;
    get defaultDocuments(): string[];
    set defaultDocuments(value: string[]);
    resetDefaultDocuments(): void;
    get defaultDocumentsInput(): string[] | undefined;
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckEvictionTimeInMin?;
    get healthCheckEvictionTimeInMin(): number;
    set healthCheckEvictionTimeInMin(value: number);
    resetHealthCheckEvictionTimeInMin(): void;
    get healthCheckEvictionTimeInMinInput(): number | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    get linuxFxVersion(): string;
    private _loadBalancingMode?;
    get loadBalancingMode(): string;
    set loadBalancingMode(value: string);
    resetLoadBalancingMode(): void;
    get loadBalancingModeInput(): string | undefined;
    private _localMysqlEnabled?;
    get localMysqlEnabled(): boolean | cdktf.IResolvable;
    set localMysqlEnabled(value: boolean | cdktf.IResolvable);
    resetLocalMysqlEnabled(): void;
    get localMysqlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedPipelineMode?;
    get managedPipelineMode(): string;
    set managedPipelineMode(value: string);
    resetManagedPipelineMode(): void;
    get managedPipelineModeInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _remoteDebuggingEnabled?;
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteDebuggingEnabled(): void;
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    get remoteDebuggingVersion(): string;
    set remoteDebuggingVersion(value: string);
    resetRemoteDebuggingVersion(): void;
    get remoteDebuggingVersionInput(): string | undefined;
    private _scmMinimumTlsVersion?;
    get scmMinimumTlsVersion(): string;
    set scmMinimumTlsVersion(value: string);
    resetScmMinimumTlsVersion(): void;
    get scmMinimumTlsVersionInput(): string | undefined;
    get scmType(): string;
    private _scmUseMainIpRestriction?;
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    resetScmUseMainIpRestriction(): void;
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorker?;
    get use32BitWorker(): boolean | cdktf.IResolvable;
    set use32BitWorker(value: boolean | cdktf.IResolvable);
    resetUse32BitWorker(): void;
    get use32BitWorkerInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _workerCount?;
    get workerCount(): number;
    set workerCount(value: number);
    resetWorkerCount(): void;
    get workerCountInput(): number | undefined;
    private _applicationStack;
    get applicationStack(): LinuxWebAppSlotSiteConfigApplicationStackOutputReference;
    putApplicationStack(value: LinuxWebAppSlotSiteConfigApplicationStack): void;
    resetApplicationStack(): void;
    get applicationStackInput(): LinuxWebAppSlotSiteConfigApplicationStack | undefined;
    private _autoHealSetting;
    get autoHealSetting(): LinuxWebAppSlotSiteConfigAutoHealSettingOutputReference;
    putAutoHealSetting(value: LinuxWebAppSlotSiteConfigAutoHealSetting): void;
    resetAutoHealSetting(): void;
    get autoHealSettingInput(): LinuxWebAppSlotSiteConfigAutoHealSetting | undefined;
    private _cors;
    get cors(): LinuxWebAppSlotSiteConfigCorsOutputReference;
    putCors(value: LinuxWebAppSlotSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): LinuxWebAppSlotSiteConfigCors | undefined;
    private _ipRestriction;
    get ipRestriction(): LinuxWebAppSlotSiteConfigIpRestrictionList;
    putIpRestriction(value: LinuxWebAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable): void;
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | LinuxWebAppSlotSiteConfigIpRestriction[] | undefined;
    private _scmIpRestriction;
    get scmIpRestriction(): LinuxWebAppSlotSiteConfigScmIpRestrictionList;
    putScmIpRestriction(value: LinuxWebAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable): void;
    resetScmIpRestriction(): void;
    get scmIpRestrictionInput(): cdktf.IResolvable | LinuxWebAppSlotSiteConfigScmIpRestriction[] | undefined;
}
export interface LinuxWebAppSlotStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#access_key LinuxWebAppSlot#access_key}
    */
    readonly accessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#account_name LinuxWebAppSlot#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#mount_path LinuxWebAppSlot#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#name LinuxWebAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#share_name LinuxWebAppSlot#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#type LinuxWebAppSlot#type}
    */
    readonly type: string;
}
export declare function linuxWebAppSlotStorageAccountToTerraform(struct?: LinuxWebAppSlotStorageAccount | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxWebAppSlotStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotStorageAccount | cdktf.IResolvable | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class LinuxWebAppSlotStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxWebAppSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxWebAppSlotStorageAccountOutputReference;
}
export interface LinuxWebAppSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#create LinuxWebAppSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#delete LinuxWebAppSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#read LinuxWebAppSlot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot#update LinuxWebAppSlot#update}
    */
    readonly update?: string;
}
export declare function linuxWebAppSlotTimeoutsToTerraform(struct?: LinuxWebAppSlotTimeouts | cdktf.IResolvable): any;
export declare class LinuxWebAppSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxWebAppSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxWebAppSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot azurerm_linux_web_app_slot}
*/
export declare class LinuxWebAppSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_linux_web_app_slot";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/linux_web_app_slot azurerm_linux_web_app_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LinuxWebAppSlotConfig
    */
    constructor(scope: Construct, id: string, config: LinuxWebAppSlotConfig);
    private _appMetadata;
    get appMetadata(): cdktf.StringMap;
    private _appServiceId?;
    get appServiceId(): string;
    set appServiceId(value: string);
    get appServiceIdInput(): string | undefined;
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    resetClientAffinityEnabled(): void;
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateEnabled?;
    get clientCertificateEnabled(): boolean | cdktf.IResolvable;
    set clientCertificateEnabled(value: boolean | cdktf.IResolvable);
    resetClientCertificateEnabled(): void;
    get clientCertificateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateExclusionPaths?;
    get clientCertificateExclusionPaths(): string;
    set clientCertificateExclusionPaths(value: string);
    resetClientCertificateExclusionPaths(): void;
    get clientCertificateExclusionPathsInput(): string | undefined;
    private _clientCertificateMode?;
    get clientCertificateMode(): string;
    set clientCertificateMode(value: string);
    resetClientCertificateMode(): void;
    get clientCertificateModeInput(): string | undefined;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get hostingEnvironmentId(): string;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultReferenceIdentityId?;
    get keyVaultReferenceIdentityId(): string;
    set keyVaultReferenceIdentityId(value: string);
    resetKeyVaultReferenceIdentityId(): void;
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    get kind(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _servicePlanId?;
    get servicePlanId(): string;
    set servicePlanId(value: string);
    resetServicePlanId(): void;
    get servicePlanIdInput(): string | undefined;
    private _siteCredential;
    get siteCredential(): LinuxWebAppSlotSiteCredentialList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
    private _zipDeployFile?;
    get zipDeployFile(): string;
    set zipDeployFile(value: string);
    resetZipDeployFile(): void;
    get zipDeployFileInput(): string | undefined;
    private _authSettings;
    get authSettings(): LinuxWebAppSlotAuthSettingsOutputReference;
    putAuthSettings(value: LinuxWebAppSlotAuthSettings): void;
    resetAuthSettings(): void;
    get authSettingsInput(): LinuxWebAppSlotAuthSettings | undefined;
    private _authSettingsV2;
    get authSettingsV2(): LinuxWebAppSlotAuthSettingsV2OutputReference;
    putAuthSettingsV2(value: LinuxWebAppSlotAuthSettingsV2): void;
    resetAuthSettingsV2(): void;
    get authSettingsV2Input(): LinuxWebAppSlotAuthSettingsV2 | undefined;
    private _backup;
    get backup(): LinuxWebAppSlotBackupOutputReference;
    putBackup(value: LinuxWebAppSlotBackup): void;
    resetBackup(): void;
    get backupInput(): LinuxWebAppSlotBackup | undefined;
    private _connectionString;
    get connectionString(): LinuxWebAppSlotConnectionStringList;
    putConnectionString(value: LinuxWebAppSlotConnectionString[] | cdktf.IResolvable): void;
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | LinuxWebAppSlotConnectionString[] | undefined;
    private _identity;
    get identity(): LinuxWebAppSlotIdentityOutputReference;
    putIdentity(value: LinuxWebAppSlotIdentity): void;
    resetIdentity(): void;
    get identityInput(): LinuxWebAppSlotIdentity | undefined;
    private _logs;
    get logs(): LinuxWebAppSlotLogsOutputReference;
    putLogs(value: LinuxWebAppSlotLogs): void;
    resetLogs(): void;
    get logsInput(): LinuxWebAppSlotLogs | undefined;
    private _siteConfig;
    get siteConfig(): LinuxWebAppSlotSiteConfigOutputReference;
    putSiteConfig(value: LinuxWebAppSlotSiteConfig): void;
    get siteConfigInput(): LinuxWebAppSlotSiteConfig | undefined;
    private _storageAccount;
    get storageAccount(): LinuxWebAppSlotStorageAccountList;
    putStorageAccount(value: LinuxWebAppSlotStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | LinuxWebAppSlotStorageAccount[] | undefined;
    private _timeouts;
    get timeouts(): LinuxWebAppSlotTimeoutsOutputReference;
    putTimeouts(value: LinuxWebAppSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LinuxWebAppSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
