/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppActionHttpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#body LogicAppActionHttp#body}
    */
    readonly body?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#headers LogicAppActionHttp#headers}
    */
    readonly headers?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#id LogicAppActionHttp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#logic_app_id LogicAppActionHttp#logic_app_id}
    */
    readonly logicAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#method LogicAppActionHttp#method}
    */
    readonly method: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#name LogicAppActionHttp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#queries LogicAppActionHttp#queries}
    */
    readonly queries?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#uri LogicAppActionHttp#uri}
    */
    readonly uri: string;
    /**
    * run_after block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#run_after LogicAppActionHttp#run_after}
    */
    readonly runAfter?: LogicAppActionHttpRunAfter[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#timeouts LogicAppActionHttp#timeouts}
    */
    readonly timeouts?: LogicAppActionHttpTimeouts;
}
export interface LogicAppActionHttpRunAfter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#action_name LogicAppActionHttp#action_name}
    */
    readonly actionName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#action_result LogicAppActionHttp#action_result}
    */
    readonly actionResult: string;
}
export declare function logicAppActionHttpRunAfterToTerraform(struct?: LogicAppActionHttpRunAfter | cdktf.IResolvable): any;
export declare class LogicAppActionHttpRunAfterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogicAppActionHttpRunAfter | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppActionHttpRunAfter | cdktf.IResolvable | undefined);
    private _actionName?;
    get actionName(): string;
    set actionName(value: string);
    get actionNameInput(): string | undefined;
    private _actionResult?;
    get actionResult(): string;
    set actionResult(value: string);
    get actionResultInput(): string | undefined;
}
export declare class LogicAppActionHttpRunAfterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogicAppActionHttpRunAfter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogicAppActionHttpRunAfterOutputReference;
}
export interface LogicAppActionHttpTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#create LogicAppActionHttp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#delete LogicAppActionHttp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#read LogicAppActionHttp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http#update LogicAppActionHttp#update}
    */
    readonly update?: string;
}
export declare function logicAppActionHttpTimeoutsToTerraform(struct?: LogicAppActionHttpTimeouts | cdktf.IResolvable): any;
export declare class LogicAppActionHttpTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppActionHttpTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppActionHttpTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http azurerm_logic_app_action_http}
*/
export declare class LogicAppActionHttp extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_action_http";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/logic_app_action_http azurerm_logic_app_action_http} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppActionHttpConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppActionHttpConfig);
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _headers?;
    get headers(): {
        [key: string]: string;
    };
    set headers(value: {
        [key: string]: string;
    });
    resetHeaders(): void;
    get headersInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logicAppId?;
    get logicAppId(): string;
    set logicAppId(value: string);
    get logicAppIdInput(): string | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queries?;
    get queries(): {
        [key: string]: string;
    };
    set queries(value: {
        [key: string]: string;
    });
    resetQueries(): void;
    get queriesInput(): {
        [key: string]: string;
    } | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _runAfter;
    get runAfter(): LogicAppActionHttpRunAfterList;
    putRunAfter(value: LogicAppActionHttpRunAfter[] | cdktf.IResolvable): void;
    resetRunAfter(): void;
    get runAfterInput(): cdktf.IResolvable | LogicAppActionHttpRunAfter[] | undefined;
    private _timeouts;
    get timeouts(): LogicAppActionHttpTimeoutsOutputReference;
    putTimeouts(value: LogicAppActionHttpTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogicAppActionHttpTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
