/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlManagedDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#id MssqlManagedDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#managed_instance_id MssqlManagedDatabase#managed_instance_id}
    */
    readonly managedInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#name MssqlManagedDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#short_term_retention_days MssqlManagedDatabase#short_term_retention_days}
    */
    readonly shortTermRetentionDays?: number;
    /**
    * long_term_retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#long_term_retention_policy MssqlManagedDatabase#long_term_retention_policy}
    */
    readonly longTermRetentionPolicy?: MssqlManagedDatabaseLongTermRetentionPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#timeouts MssqlManagedDatabase#timeouts}
    */
    readonly timeouts?: MssqlManagedDatabaseTimeouts;
}
export interface MssqlManagedDatabaseLongTermRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#monthly_retention MssqlManagedDatabase#monthly_retention}
    */
    readonly monthlyRetention?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#week_of_year MssqlManagedDatabase#week_of_year}
    */
    readonly weekOfYear?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#weekly_retention MssqlManagedDatabase#weekly_retention}
    */
    readonly weeklyRetention?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#yearly_retention MssqlManagedDatabase#yearly_retention}
    */
    readonly yearlyRetention?: string;
}
export declare function mssqlManagedDatabaseLongTermRetentionPolicyToTerraform(struct?: MssqlManagedDatabaseLongTermRetentionPolicyOutputReference | MssqlManagedDatabaseLongTermRetentionPolicy): any;
export declare class MssqlManagedDatabaseLongTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedDatabaseLongTermRetentionPolicy | undefined;
    set internalValue(value: MssqlManagedDatabaseLongTermRetentionPolicy | undefined);
    private _monthlyRetention?;
    get monthlyRetention(): string;
    set monthlyRetention(value: string);
    resetMonthlyRetention(): void;
    get monthlyRetentionInput(): string | undefined;
    private _weekOfYear?;
    get weekOfYear(): number;
    set weekOfYear(value: number);
    resetWeekOfYear(): void;
    get weekOfYearInput(): number | undefined;
    private _weeklyRetention?;
    get weeklyRetention(): string;
    set weeklyRetention(value: string);
    resetWeeklyRetention(): void;
    get weeklyRetentionInput(): string | undefined;
    private _yearlyRetention?;
    get yearlyRetention(): string;
    set yearlyRetention(value: string);
    resetYearlyRetention(): void;
    get yearlyRetentionInput(): string | undefined;
}
export interface MssqlManagedDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#create MssqlManagedDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#delete MssqlManagedDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#read MssqlManagedDatabase#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database#update MssqlManagedDatabase#update}
    */
    readonly update?: string;
}
export declare function mssqlManagedDatabaseTimeoutsToTerraform(struct?: MssqlManagedDatabaseTimeouts | cdktf.IResolvable): any;
export declare class MssqlManagedDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlManagedDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database azurerm_mssql_managed_database}
*/
export declare class MssqlManagedDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_managed_database";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_managed_database azurerm_mssql_managed_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlManagedDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: MssqlManagedDatabaseConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedInstanceId?;
    get managedInstanceId(): string;
    set managedInstanceId(value: string);
    get managedInstanceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shortTermRetentionDays?;
    get shortTermRetentionDays(): number;
    set shortTermRetentionDays(value: number);
    resetShortTermRetentionDays(): void;
    get shortTermRetentionDaysInput(): number | undefined;
    private _longTermRetentionPolicy;
    get longTermRetentionPolicy(): MssqlManagedDatabaseLongTermRetentionPolicyOutputReference;
    putLongTermRetentionPolicy(value: MssqlManagedDatabaseLongTermRetentionPolicy): void;
    resetLongTermRetentionPolicy(): void;
    get longTermRetentionPolicyInput(): MssqlManagedDatabaseLongTermRetentionPolicy | undefined;
    private _timeouts;
    get timeouts(): MssqlManagedDatabaseTimeoutsOutputReference;
    putTimeouts(value: MssqlManagedDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlManagedDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
