/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#id MssqlVirtualMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#r_services_enabled MssqlVirtualMachine#r_services_enabled}
    */
    readonly rServicesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#sql_connectivity_port MssqlVirtualMachine#sql_connectivity_port}
    */
    readonly sqlConnectivityPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#sql_connectivity_type MssqlVirtualMachine#sql_connectivity_type}
    */
    readonly sqlConnectivityType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#sql_connectivity_update_password MssqlVirtualMachine#sql_connectivity_update_password}
    */
    readonly sqlConnectivityUpdatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#sql_connectivity_update_username MssqlVirtualMachine#sql_connectivity_update_username}
    */
    readonly sqlConnectivityUpdateUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#sql_license_type MssqlVirtualMachine#sql_license_type}
    */
    readonly sqlLicenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#tags MssqlVirtualMachine#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#virtual_machine_id MssqlVirtualMachine#virtual_machine_id}
    */
    readonly virtualMachineId: string;
    /**
    * assessment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#assessment MssqlVirtualMachine#assessment}
    */
    readonly assessment?: MssqlVirtualMachineAssessment;
    /**
    * auto_backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#auto_backup MssqlVirtualMachine#auto_backup}
    */
    readonly autoBackup?: MssqlVirtualMachineAutoBackup;
    /**
    * auto_patching block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#auto_patching MssqlVirtualMachine#auto_patching}
    */
    readonly autoPatching?: MssqlVirtualMachineAutoPatching;
    /**
    * key_vault_credential block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#key_vault_credential MssqlVirtualMachine#key_vault_credential}
    */
    readonly keyVaultCredential?: MssqlVirtualMachineKeyVaultCredential;
    /**
    * sql_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#sql_instance MssqlVirtualMachine#sql_instance}
    */
    readonly sqlInstance?: MssqlVirtualMachineSqlInstance;
    /**
    * storage_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#storage_configuration MssqlVirtualMachine#storage_configuration}
    */
    readonly storageConfiguration?: MssqlVirtualMachineStorageConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#timeouts MssqlVirtualMachine#timeouts}
    */
    readonly timeouts?: MssqlVirtualMachineTimeouts;
}
export interface MssqlVirtualMachineAssessmentSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#day_of_week MssqlVirtualMachine#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#monthly_occurrence MssqlVirtualMachine#monthly_occurrence}
    */
    readonly monthlyOccurrence?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#start_time MssqlVirtualMachine#start_time}
    */
    readonly startTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#weekly_interval MssqlVirtualMachine#weekly_interval}
    */
    readonly weeklyInterval?: number;
}
export declare function mssqlVirtualMachineAssessmentScheduleToTerraform(struct?: MssqlVirtualMachineAssessmentScheduleOutputReference | MssqlVirtualMachineAssessmentSchedule): any;
export declare class MssqlVirtualMachineAssessmentScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineAssessmentSchedule | undefined;
    set internalValue(value: MssqlVirtualMachineAssessmentSchedule | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _monthlyOccurrence?;
    get monthlyOccurrence(): number;
    set monthlyOccurrence(value: number);
    resetMonthlyOccurrence(): void;
    get monthlyOccurrenceInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
    private _weeklyInterval?;
    get weeklyInterval(): number;
    set weeklyInterval(value: number);
    resetWeeklyInterval(): void;
    get weeklyIntervalInput(): number | undefined;
}
export interface MssqlVirtualMachineAssessment {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#enabled MssqlVirtualMachine#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#run_immediately MssqlVirtualMachine#run_immediately}
    */
    readonly runImmediately?: boolean | cdktf.IResolvable;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#schedule MssqlVirtualMachine#schedule}
    */
    readonly schedule?: MssqlVirtualMachineAssessmentSchedule;
}
export declare function mssqlVirtualMachineAssessmentToTerraform(struct?: MssqlVirtualMachineAssessmentOutputReference | MssqlVirtualMachineAssessment): any;
export declare class MssqlVirtualMachineAssessmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineAssessment | undefined;
    set internalValue(value: MssqlVirtualMachineAssessment | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _runImmediately?;
    get runImmediately(): boolean | cdktf.IResolvable;
    set runImmediately(value: boolean | cdktf.IResolvable);
    resetRunImmediately(): void;
    get runImmediatelyInput(): boolean | cdktf.IResolvable | undefined;
    private _schedule;
    get schedule(): MssqlVirtualMachineAssessmentScheduleOutputReference;
    putSchedule(value: MssqlVirtualMachineAssessmentSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): MssqlVirtualMachineAssessmentSchedule | undefined;
}
export interface MssqlVirtualMachineAutoBackupManualSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#days_of_week MssqlVirtualMachine#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#full_backup_frequency MssqlVirtualMachine#full_backup_frequency}
    */
    readonly fullBackupFrequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#full_backup_start_hour MssqlVirtualMachine#full_backup_start_hour}
    */
    readonly fullBackupStartHour: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#full_backup_window_in_hours MssqlVirtualMachine#full_backup_window_in_hours}
    */
    readonly fullBackupWindowInHours: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#log_backup_frequency_in_minutes MssqlVirtualMachine#log_backup_frequency_in_minutes}
    */
    readonly logBackupFrequencyInMinutes: number;
}
export declare function mssqlVirtualMachineAutoBackupManualScheduleToTerraform(struct?: MssqlVirtualMachineAutoBackupManualScheduleOutputReference | MssqlVirtualMachineAutoBackupManualSchedule): any;
export declare class MssqlVirtualMachineAutoBackupManualScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineAutoBackupManualSchedule | undefined;
    set internalValue(value: MssqlVirtualMachineAutoBackupManualSchedule | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _fullBackupFrequency?;
    get fullBackupFrequency(): string;
    set fullBackupFrequency(value: string);
    get fullBackupFrequencyInput(): string | undefined;
    private _fullBackupStartHour?;
    get fullBackupStartHour(): number;
    set fullBackupStartHour(value: number);
    get fullBackupStartHourInput(): number | undefined;
    private _fullBackupWindowInHours?;
    get fullBackupWindowInHours(): number;
    set fullBackupWindowInHours(value: number);
    get fullBackupWindowInHoursInput(): number | undefined;
    private _logBackupFrequencyInMinutes?;
    get logBackupFrequencyInMinutes(): number;
    set logBackupFrequencyInMinutes(value: number);
    get logBackupFrequencyInMinutesInput(): number | undefined;
}
export interface MssqlVirtualMachineAutoBackup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#encryption_enabled MssqlVirtualMachine#encryption_enabled}
    */
    readonly encryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#encryption_password MssqlVirtualMachine#encryption_password}
    */
    readonly encryptionPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#retention_period_in_days MssqlVirtualMachine#retention_period_in_days}
    */
    readonly retentionPeriodInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#storage_account_access_key MssqlVirtualMachine#storage_account_access_key}
    */
    readonly storageAccountAccessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#storage_blob_endpoint MssqlVirtualMachine#storage_blob_endpoint}
    */
    readonly storageBlobEndpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#system_databases_backup_enabled MssqlVirtualMachine#system_databases_backup_enabled}
    */
    readonly systemDatabasesBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * manual_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#manual_schedule MssqlVirtualMachine#manual_schedule}
    */
    readonly manualSchedule?: MssqlVirtualMachineAutoBackupManualSchedule;
}
export declare function mssqlVirtualMachineAutoBackupToTerraform(struct?: MssqlVirtualMachineAutoBackupOutputReference | MssqlVirtualMachineAutoBackup): any;
export declare class MssqlVirtualMachineAutoBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineAutoBackup | undefined;
    set internalValue(value: MssqlVirtualMachineAutoBackup | undefined);
    private _encryptionEnabled?;
    get encryptionEnabled(): boolean | cdktf.IResolvable;
    set encryptionEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionEnabled(): void;
    get encryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionPassword?;
    get encryptionPassword(): string;
    set encryptionPassword(value: string);
    resetEncryptionPassword(): void;
    get encryptionPasswordInput(): string | undefined;
    private _retentionPeriodInDays?;
    get retentionPeriodInDays(): number;
    set retentionPeriodInDays(value: number);
    get retentionPeriodInDaysInput(): number | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageBlobEndpoint?;
    get storageBlobEndpoint(): string;
    set storageBlobEndpoint(value: string);
    get storageBlobEndpointInput(): string | undefined;
    private _systemDatabasesBackupEnabled?;
    get systemDatabasesBackupEnabled(): boolean | cdktf.IResolvable;
    set systemDatabasesBackupEnabled(value: boolean | cdktf.IResolvable);
    resetSystemDatabasesBackupEnabled(): void;
    get systemDatabasesBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _manualSchedule;
    get manualSchedule(): MssqlVirtualMachineAutoBackupManualScheduleOutputReference;
    putManualSchedule(value: MssqlVirtualMachineAutoBackupManualSchedule): void;
    resetManualSchedule(): void;
    get manualScheduleInput(): MssqlVirtualMachineAutoBackupManualSchedule | undefined;
}
export interface MssqlVirtualMachineAutoPatching {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#day_of_week MssqlVirtualMachine#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#maintenance_window_duration_in_minutes MssqlVirtualMachine#maintenance_window_duration_in_minutes}
    */
    readonly maintenanceWindowDurationInMinutes: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#maintenance_window_starting_hour MssqlVirtualMachine#maintenance_window_starting_hour}
    */
    readonly maintenanceWindowStartingHour: number;
}
export declare function mssqlVirtualMachineAutoPatchingToTerraform(struct?: MssqlVirtualMachineAutoPatchingOutputReference | MssqlVirtualMachineAutoPatching): any;
export declare class MssqlVirtualMachineAutoPatchingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineAutoPatching | undefined;
    set internalValue(value: MssqlVirtualMachineAutoPatching | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _maintenanceWindowDurationInMinutes?;
    get maintenanceWindowDurationInMinutes(): number;
    set maintenanceWindowDurationInMinutes(value: number);
    get maintenanceWindowDurationInMinutesInput(): number | undefined;
    private _maintenanceWindowStartingHour?;
    get maintenanceWindowStartingHour(): number;
    set maintenanceWindowStartingHour(value: number);
    get maintenanceWindowStartingHourInput(): number | undefined;
}
export interface MssqlVirtualMachineKeyVaultCredential {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#key_vault_url MssqlVirtualMachine#key_vault_url}
    */
    readonly keyVaultUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#name MssqlVirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#service_principal_name MssqlVirtualMachine#service_principal_name}
    */
    readonly servicePrincipalName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#service_principal_secret MssqlVirtualMachine#service_principal_secret}
    */
    readonly servicePrincipalSecret: string;
}
export declare function mssqlVirtualMachineKeyVaultCredentialToTerraform(struct?: MssqlVirtualMachineKeyVaultCredentialOutputReference | MssqlVirtualMachineKeyVaultCredential): any;
export declare class MssqlVirtualMachineKeyVaultCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineKeyVaultCredential | undefined;
    set internalValue(value: MssqlVirtualMachineKeyVaultCredential | undefined);
    private _keyVaultUrl?;
    get keyVaultUrl(): string;
    set keyVaultUrl(value: string);
    get keyVaultUrlInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _servicePrincipalName?;
    get servicePrincipalName(): string;
    set servicePrincipalName(value: string);
    get servicePrincipalNameInput(): string | undefined;
    private _servicePrincipalSecret?;
    get servicePrincipalSecret(): string;
    set servicePrincipalSecret(value: string);
    get servicePrincipalSecretInput(): string | undefined;
}
export interface MssqlVirtualMachineSqlInstance {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#adhoc_workloads_optimization_enabled MssqlVirtualMachine#adhoc_workloads_optimization_enabled}
    */
    readonly adhocWorkloadsOptimizationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#collation MssqlVirtualMachine#collation}
    */
    readonly collation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#instant_file_initialization_enabled MssqlVirtualMachine#instant_file_initialization_enabled}
    */
    readonly instantFileInitializationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#lock_pages_in_memory_enabled MssqlVirtualMachine#lock_pages_in_memory_enabled}
    */
    readonly lockPagesInMemoryEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#max_dop MssqlVirtualMachine#max_dop}
    */
    readonly maxDop?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#max_server_memory_mb MssqlVirtualMachine#max_server_memory_mb}
    */
    readonly maxServerMemoryMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#min_server_memory_mb MssqlVirtualMachine#min_server_memory_mb}
    */
    readonly minServerMemoryMb?: number;
}
export declare function mssqlVirtualMachineSqlInstanceToTerraform(struct?: MssqlVirtualMachineSqlInstanceOutputReference | MssqlVirtualMachineSqlInstance): any;
export declare class MssqlVirtualMachineSqlInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineSqlInstance | undefined;
    set internalValue(value: MssqlVirtualMachineSqlInstance | undefined);
    private _adhocWorkloadsOptimizationEnabled?;
    get adhocWorkloadsOptimizationEnabled(): boolean | cdktf.IResolvable;
    set adhocWorkloadsOptimizationEnabled(value: boolean | cdktf.IResolvable);
    resetAdhocWorkloadsOptimizationEnabled(): void;
    get adhocWorkloadsOptimizationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _instantFileInitializationEnabled?;
    get instantFileInitializationEnabled(): boolean | cdktf.IResolvable;
    set instantFileInitializationEnabled(value: boolean | cdktf.IResolvable);
    resetInstantFileInitializationEnabled(): void;
    get instantFileInitializationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _lockPagesInMemoryEnabled?;
    get lockPagesInMemoryEnabled(): boolean | cdktf.IResolvable;
    set lockPagesInMemoryEnabled(value: boolean | cdktf.IResolvable);
    resetLockPagesInMemoryEnabled(): void;
    get lockPagesInMemoryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _maxDop?;
    get maxDop(): number;
    set maxDop(value: number);
    resetMaxDop(): void;
    get maxDopInput(): number | undefined;
    private _maxServerMemoryMb?;
    get maxServerMemoryMb(): number;
    set maxServerMemoryMb(value: number);
    resetMaxServerMemoryMb(): void;
    get maxServerMemoryMbInput(): number | undefined;
    private _minServerMemoryMb?;
    get minServerMemoryMb(): number;
    set minServerMemoryMb(value: number);
    resetMinServerMemoryMb(): void;
    get minServerMemoryMbInput(): number | undefined;
}
export interface MssqlVirtualMachineStorageConfigurationDataSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#default_file_path MssqlVirtualMachine#default_file_path}
    */
    readonly defaultFilePath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#luns MssqlVirtualMachine#luns}
    */
    readonly luns: number[];
}
export declare function mssqlVirtualMachineStorageConfigurationDataSettingsToTerraform(struct?: MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference | MssqlVirtualMachineStorageConfigurationDataSettings): any;
export declare class MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineStorageConfigurationDataSettings | undefined;
    set internalValue(value: MssqlVirtualMachineStorageConfigurationDataSettings | undefined);
    private _defaultFilePath?;
    get defaultFilePath(): string;
    set defaultFilePath(value: string);
    get defaultFilePathInput(): string | undefined;
    private _luns?;
    get luns(): number[];
    set luns(value: number[]);
    get lunsInput(): number[] | undefined;
}
export interface MssqlVirtualMachineStorageConfigurationLogSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#default_file_path MssqlVirtualMachine#default_file_path}
    */
    readonly defaultFilePath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#luns MssqlVirtualMachine#luns}
    */
    readonly luns: number[];
}
export declare function mssqlVirtualMachineStorageConfigurationLogSettingsToTerraform(struct?: MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference | MssqlVirtualMachineStorageConfigurationLogSettings): any;
export declare class MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineStorageConfigurationLogSettings | undefined;
    set internalValue(value: MssqlVirtualMachineStorageConfigurationLogSettings | undefined);
    private _defaultFilePath?;
    get defaultFilePath(): string;
    set defaultFilePath(value: string);
    get defaultFilePathInput(): string | undefined;
    private _luns?;
    get luns(): number[];
    set luns(value: number[]);
    get lunsInput(): number[] | undefined;
}
export interface MssqlVirtualMachineStorageConfigurationTempDbSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#data_file_count MssqlVirtualMachine#data_file_count}
    */
    readonly dataFileCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#data_file_growth_in_mb MssqlVirtualMachine#data_file_growth_in_mb}
    */
    readonly dataFileGrowthInMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#data_file_size_mb MssqlVirtualMachine#data_file_size_mb}
    */
    readonly dataFileSizeMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#default_file_path MssqlVirtualMachine#default_file_path}
    */
    readonly defaultFilePath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#log_file_growth_mb MssqlVirtualMachine#log_file_growth_mb}
    */
    readonly logFileGrowthMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#log_file_size_mb MssqlVirtualMachine#log_file_size_mb}
    */
    readonly logFileSizeMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#luns MssqlVirtualMachine#luns}
    */
    readonly luns: number[];
}
export declare function mssqlVirtualMachineStorageConfigurationTempDbSettingsToTerraform(struct?: MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference | MssqlVirtualMachineStorageConfigurationTempDbSettings): any;
export declare class MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineStorageConfigurationTempDbSettings | undefined;
    set internalValue(value: MssqlVirtualMachineStorageConfigurationTempDbSettings | undefined);
    private _dataFileCount?;
    get dataFileCount(): number;
    set dataFileCount(value: number);
    resetDataFileCount(): void;
    get dataFileCountInput(): number | undefined;
    private _dataFileGrowthInMb?;
    get dataFileGrowthInMb(): number;
    set dataFileGrowthInMb(value: number);
    resetDataFileGrowthInMb(): void;
    get dataFileGrowthInMbInput(): number | undefined;
    private _dataFileSizeMb?;
    get dataFileSizeMb(): number;
    set dataFileSizeMb(value: number);
    resetDataFileSizeMb(): void;
    get dataFileSizeMbInput(): number | undefined;
    private _defaultFilePath?;
    get defaultFilePath(): string;
    set defaultFilePath(value: string);
    get defaultFilePathInput(): string | undefined;
    private _logFileGrowthMb?;
    get logFileGrowthMb(): number;
    set logFileGrowthMb(value: number);
    resetLogFileGrowthMb(): void;
    get logFileGrowthMbInput(): number | undefined;
    private _logFileSizeMb?;
    get logFileSizeMb(): number;
    set logFileSizeMb(value: number);
    resetLogFileSizeMb(): void;
    get logFileSizeMbInput(): number | undefined;
    private _luns?;
    get luns(): number[];
    set luns(value: number[]);
    get lunsInput(): number[] | undefined;
}
export interface MssqlVirtualMachineStorageConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#disk_type MssqlVirtualMachine#disk_type}
    */
    readonly diskType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#storage_workload_type MssqlVirtualMachine#storage_workload_type}
    */
    readonly storageWorkloadType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#system_db_on_data_disk_enabled MssqlVirtualMachine#system_db_on_data_disk_enabled}
    */
    readonly systemDbOnDataDiskEnabled?: boolean | cdktf.IResolvable;
    /**
    * data_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#data_settings MssqlVirtualMachine#data_settings}
    */
    readonly dataSettings?: MssqlVirtualMachineStorageConfigurationDataSettings;
    /**
    * log_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#log_settings MssqlVirtualMachine#log_settings}
    */
    readonly logSettings?: MssqlVirtualMachineStorageConfigurationLogSettings;
    /**
    * temp_db_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#temp_db_settings MssqlVirtualMachine#temp_db_settings}
    */
    readonly tempDbSettings?: MssqlVirtualMachineStorageConfigurationTempDbSettings;
}
export declare function mssqlVirtualMachineStorageConfigurationToTerraform(struct?: MssqlVirtualMachineStorageConfigurationOutputReference | MssqlVirtualMachineStorageConfiguration): any;
export declare class MssqlVirtualMachineStorageConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineStorageConfiguration | undefined;
    set internalValue(value: MssqlVirtualMachineStorageConfiguration | undefined);
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    get diskTypeInput(): string | undefined;
    private _storageWorkloadType?;
    get storageWorkloadType(): string;
    set storageWorkloadType(value: string);
    get storageWorkloadTypeInput(): string | undefined;
    private _systemDbOnDataDiskEnabled?;
    get systemDbOnDataDiskEnabled(): boolean | cdktf.IResolvable;
    set systemDbOnDataDiskEnabled(value: boolean | cdktf.IResolvable);
    resetSystemDbOnDataDiskEnabled(): void;
    get systemDbOnDataDiskEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dataSettings;
    get dataSettings(): MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference;
    putDataSettings(value: MssqlVirtualMachineStorageConfigurationDataSettings): void;
    resetDataSettings(): void;
    get dataSettingsInput(): MssqlVirtualMachineStorageConfigurationDataSettings | undefined;
    private _logSettings;
    get logSettings(): MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference;
    putLogSettings(value: MssqlVirtualMachineStorageConfigurationLogSettings): void;
    resetLogSettings(): void;
    get logSettingsInput(): MssqlVirtualMachineStorageConfigurationLogSettings | undefined;
    private _tempDbSettings;
    get tempDbSettings(): MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference;
    putTempDbSettings(value: MssqlVirtualMachineStorageConfigurationTempDbSettings): void;
    resetTempDbSettings(): void;
    get tempDbSettingsInput(): MssqlVirtualMachineStorageConfigurationTempDbSettings | undefined;
}
export interface MssqlVirtualMachineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#create MssqlVirtualMachine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#delete MssqlVirtualMachine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#read MssqlVirtualMachine#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine#update MssqlVirtualMachine#update}
    */
    readonly update?: string;
}
export declare function mssqlVirtualMachineTimeoutsToTerraform(struct?: MssqlVirtualMachineTimeouts | cdktf.IResolvable): any;
export declare class MssqlVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlVirtualMachineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine azurerm_mssql_virtual_machine}
*/
export declare class MssqlVirtualMachine extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_virtual_machine";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/mssql_virtual_machine azurerm_mssql_virtual_machine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlVirtualMachineConfig
    */
    constructor(scope: Construct, id: string, config: MssqlVirtualMachineConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _rServicesEnabled?;
    get rServicesEnabled(): boolean | cdktf.IResolvable;
    set rServicesEnabled(value: boolean | cdktf.IResolvable);
    resetRServicesEnabled(): void;
    get rServicesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sqlConnectivityPort?;
    get sqlConnectivityPort(): number;
    set sqlConnectivityPort(value: number);
    resetSqlConnectivityPort(): void;
    get sqlConnectivityPortInput(): number | undefined;
    private _sqlConnectivityType?;
    get sqlConnectivityType(): string;
    set sqlConnectivityType(value: string);
    resetSqlConnectivityType(): void;
    get sqlConnectivityTypeInput(): string | undefined;
    private _sqlConnectivityUpdatePassword?;
    get sqlConnectivityUpdatePassword(): string;
    set sqlConnectivityUpdatePassword(value: string);
    resetSqlConnectivityUpdatePassword(): void;
    get sqlConnectivityUpdatePasswordInput(): string | undefined;
    private _sqlConnectivityUpdateUsername?;
    get sqlConnectivityUpdateUsername(): string;
    set sqlConnectivityUpdateUsername(value: string);
    resetSqlConnectivityUpdateUsername(): void;
    get sqlConnectivityUpdateUsernameInput(): string | undefined;
    private _sqlLicenseType?;
    get sqlLicenseType(): string;
    set sqlLicenseType(value: string);
    resetSqlLicenseType(): void;
    get sqlLicenseTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    get virtualMachineIdInput(): string | undefined;
    private _assessment;
    get assessment(): MssqlVirtualMachineAssessmentOutputReference;
    putAssessment(value: MssqlVirtualMachineAssessment): void;
    resetAssessment(): void;
    get assessmentInput(): MssqlVirtualMachineAssessment | undefined;
    private _autoBackup;
    get autoBackup(): MssqlVirtualMachineAutoBackupOutputReference;
    putAutoBackup(value: MssqlVirtualMachineAutoBackup): void;
    resetAutoBackup(): void;
    get autoBackupInput(): MssqlVirtualMachineAutoBackup | undefined;
    private _autoPatching;
    get autoPatching(): MssqlVirtualMachineAutoPatchingOutputReference;
    putAutoPatching(value: MssqlVirtualMachineAutoPatching): void;
    resetAutoPatching(): void;
    get autoPatchingInput(): MssqlVirtualMachineAutoPatching | undefined;
    private _keyVaultCredential;
    get keyVaultCredential(): MssqlVirtualMachineKeyVaultCredentialOutputReference;
    putKeyVaultCredential(value: MssqlVirtualMachineKeyVaultCredential): void;
    resetKeyVaultCredential(): void;
    get keyVaultCredentialInput(): MssqlVirtualMachineKeyVaultCredential | undefined;
    private _sqlInstance;
    get sqlInstance(): MssqlVirtualMachineSqlInstanceOutputReference;
    putSqlInstance(value: MssqlVirtualMachineSqlInstance): void;
    resetSqlInstance(): void;
    get sqlInstanceInput(): MssqlVirtualMachineSqlInstance | undefined;
    private _storageConfiguration;
    get storageConfiguration(): MssqlVirtualMachineStorageConfigurationOutputReference;
    putStorageConfiguration(value: MssqlVirtualMachineStorageConfiguration): void;
    resetStorageConfiguration(): void;
    get storageConfigurationInput(): MssqlVirtualMachineStorageConfiguration | undefined;
    private _timeouts;
    get timeouts(): MssqlVirtualMachineTimeoutsOutputReference;
    putTimeouts(value: MssqlVirtualMachineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlVirtualMachineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
