/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NginxDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#diagnose_support_enabled NginxDeployment#diagnose_support_enabled}
    */
    readonly diagnoseSupportEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#id NginxDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#location NginxDeployment#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#managed_resource_group NginxDeployment#managed_resource_group}
    */
    readonly managedResourceGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#name NginxDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#resource_group_name NginxDeployment#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#sku NginxDeployment#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#tags NginxDeployment#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * frontend_private block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#frontend_private NginxDeployment#frontend_private}
    */
    readonly frontendPrivate?: NginxDeploymentFrontendPrivate[] | cdktf.IResolvable;
    /**
    * frontend_public block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#frontend_public NginxDeployment#frontend_public}
    */
    readonly frontendPublic?: NginxDeploymentFrontendPublic;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#identity NginxDeployment#identity}
    */
    readonly identity?: NginxDeploymentIdentity;
    /**
    * logging_storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#logging_storage_account NginxDeployment#logging_storage_account}
    */
    readonly loggingStorageAccount?: NginxDeploymentLoggingStorageAccount[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#network_interface NginxDeployment#network_interface}
    */
    readonly networkInterface?: NginxDeploymentNetworkInterface[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#timeouts NginxDeployment#timeouts}
    */
    readonly timeouts?: NginxDeploymentTimeouts;
}
export interface NginxDeploymentFrontendPrivate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#allocation_method NginxDeployment#allocation_method}
    */
    readonly allocationMethod: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#ip_address NginxDeployment#ip_address}
    */
    readonly ipAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#subnet_id NginxDeployment#subnet_id}
    */
    readonly subnetId: string;
}
export declare function nginxDeploymentFrontendPrivateToTerraform(struct?: NginxDeploymentFrontendPrivate | cdktf.IResolvable): any;
export declare class NginxDeploymentFrontendPrivateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NginxDeploymentFrontendPrivate | cdktf.IResolvable | undefined;
    set internalValue(value: NginxDeploymentFrontendPrivate | cdktf.IResolvable | undefined);
    private _allocationMethod?;
    get allocationMethod(): string;
    set allocationMethod(value: string);
    get allocationMethodInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class NginxDeploymentFrontendPrivateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NginxDeploymentFrontendPrivate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NginxDeploymentFrontendPrivateOutputReference;
}
export interface NginxDeploymentFrontendPublic {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#ip_address NginxDeployment#ip_address}
    */
    readonly ipAddress?: string[];
}
export declare function nginxDeploymentFrontendPublicToTerraform(struct?: NginxDeploymentFrontendPublicOutputReference | NginxDeploymentFrontendPublic): any;
export declare class NginxDeploymentFrontendPublicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NginxDeploymentFrontendPublic | undefined;
    set internalValue(value: NginxDeploymentFrontendPublic | undefined);
    private _ipAddress?;
    get ipAddress(): string[];
    set ipAddress(value: string[]);
    resetIpAddress(): void;
    get ipAddressInput(): string[] | undefined;
}
export interface NginxDeploymentIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#identity_ids NginxDeployment#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#type NginxDeployment#type}
    */
    readonly type: string;
}
export declare function nginxDeploymentIdentityToTerraform(struct?: NginxDeploymentIdentityOutputReference | NginxDeploymentIdentity): any;
export declare class NginxDeploymentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NginxDeploymentIdentity | undefined;
    set internalValue(value: NginxDeploymentIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface NginxDeploymentLoggingStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#container_name NginxDeployment#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#name NginxDeployment#name}
    */
    readonly name?: string;
}
export declare function nginxDeploymentLoggingStorageAccountToTerraform(struct?: NginxDeploymentLoggingStorageAccount | cdktf.IResolvable): any;
export declare class NginxDeploymentLoggingStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NginxDeploymentLoggingStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: NginxDeploymentLoggingStorageAccount | cdktf.IResolvable | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class NginxDeploymentLoggingStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NginxDeploymentLoggingStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NginxDeploymentLoggingStorageAccountOutputReference;
}
export interface NginxDeploymentNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#subnet_id NginxDeployment#subnet_id}
    */
    readonly subnetId: string;
}
export declare function nginxDeploymentNetworkInterfaceToTerraform(struct?: NginxDeploymentNetworkInterface | cdktf.IResolvable): any;
export declare class NginxDeploymentNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NginxDeploymentNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: NginxDeploymentNetworkInterface | cdktf.IResolvable | undefined);
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class NginxDeploymentNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NginxDeploymentNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NginxDeploymentNetworkInterfaceOutputReference;
}
export interface NginxDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#create NginxDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#delete NginxDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#read NginxDeployment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment#update NginxDeployment#update}
    */
    readonly update?: string;
}
export declare function nginxDeploymentTimeoutsToTerraform(struct?: NginxDeploymentTimeouts | cdktf.IResolvable): any;
export declare class NginxDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NginxDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NginxDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment azurerm_nginx_deployment}
*/
export declare class NginxDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_nginx_deployment";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/nginx_deployment azurerm_nginx_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NginxDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: NginxDeploymentConfig);
    private _diagnoseSupportEnabled?;
    get diagnoseSupportEnabled(): boolean | cdktf.IResolvable;
    set diagnoseSupportEnabled(value: boolean | cdktf.IResolvable);
    resetDiagnoseSupportEnabled(): void;
    get diagnoseSupportEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipAddress(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedResourceGroup?;
    get managedResourceGroup(): string;
    set managedResourceGroup(value: string);
    resetManagedResourceGroup(): void;
    get managedResourceGroupInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nginxVersion(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _frontendPrivate;
    get frontendPrivate(): NginxDeploymentFrontendPrivateList;
    putFrontendPrivate(value: NginxDeploymentFrontendPrivate[] | cdktf.IResolvable): void;
    resetFrontendPrivate(): void;
    get frontendPrivateInput(): cdktf.IResolvable | NginxDeploymentFrontendPrivate[] | undefined;
    private _frontendPublic;
    get frontendPublic(): NginxDeploymentFrontendPublicOutputReference;
    putFrontendPublic(value: NginxDeploymentFrontendPublic): void;
    resetFrontendPublic(): void;
    get frontendPublicInput(): NginxDeploymentFrontendPublic | undefined;
    private _identity;
    get identity(): NginxDeploymentIdentityOutputReference;
    putIdentity(value: NginxDeploymentIdentity): void;
    resetIdentity(): void;
    get identityInput(): NginxDeploymentIdentity | undefined;
    private _loggingStorageAccount;
    get loggingStorageAccount(): NginxDeploymentLoggingStorageAccountList;
    putLoggingStorageAccount(value: NginxDeploymentLoggingStorageAccount[] | cdktf.IResolvable): void;
    resetLoggingStorageAccount(): void;
    get loggingStorageAccountInput(): cdktf.IResolvable | NginxDeploymentLoggingStorageAccount[] | undefined;
    private _networkInterface;
    get networkInterface(): NginxDeploymentNetworkInterfaceList;
    putNetworkInterface(value: NginxDeploymentNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | NginxDeploymentNetworkInterface[] | undefined;
    private _timeouts;
    get timeouts(): NginxDeploymentTimeoutsOutputReference;
    putTimeouts(value: NginxDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NginxDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
