"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzurermProvider = exports.azurermProviderFeaturesToTerraform = exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = exports.azurermProviderFeaturesVirtualMachineToTerraform = exports.azurermProviderFeaturesTemplateDeploymentToTerraform = exports.azurermProviderFeaturesResourceGroupToTerraform = exports.azurermProviderFeaturesManagedDiskToTerraform = exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = exports.azurermProviderFeaturesKeyVaultToTerraform = exports.azurermProviderFeaturesCognitiveAccountToTerraform = exports.azurermProviderFeaturesApplicationInsightsToTerraform = exports.azurermProviderFeaturesAppConfigurationToTerraform = exports.azurermProviderFeaturesApiManagementToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function azurermProviderFeaturesApiManagementToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        recover_soft_deleted: cdktf.booleanToTerraform(struct.recoverSoftDeleted),
    };
}
exports.azurermProviderFeaturesApiManagementToTerraform = azurermProviderFeaturesApiManagementToTerraform;
function azurermProviderFeaturesAppConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        recover_soft_deleted: cdktf.booleanToTerraform(struct.recoverSoftDeleted),
    };
}
exports.azurermProviderFeaturesAppConfigurationToTerraform = azurermProviderFeaturesAppConfigurationToTerraform;
function azurermProviderFeaturesApplicationInsightsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disable_generated_rule: cdktf.booleanToTerraform(struct.disableGeneratedRule),
    };
}
exports.azurermProviderFeaturesApplicationInsightsToTerraform = azurermProviderFeaturesApplicationInsightsToTerraform;
function azurermProviderFeaturesCognitiveAccountToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesCognitiveAccountToTerraform = azurermProviderFeaturesCognitiveAccountToTerraform;
function azurermProviderFeaturesKeyVaultToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        purge_soft_deleted_certificates_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedCertificatesOnDestroy),
        purge_soft_deleted_hardware_security_modules_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedHardwareSecurityModulesOnDestroy),
        purge_soft_deleted_keys_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedKeysOnDestroy),
        purge_soft_deleted_secrets_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedSecretsOnDestroy),
        recover_soft_deleted_certificates: cdktf.booleanToTerraform(struct.recoverSoftDeletedCertificates),
        recover_soft_deleted_key_vaults: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeyVaults),
        recover_soft_deleted_keys: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeys),
        recover_soft_deleted_secrets: cdktf.booleanToTerraform(struct.recoverSoftDeletedSecrets),
    };
}
exports.azurermProviderFeaturesKeyVaultToTerraform = azurermProviderFeaturesKeyVaultToTerraform;
function azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        permanently_delete_on_destroy: cdktf.booleanToTerraform(struct.permanentlyDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform;
function azurermProviderFeaturesManagedDiskToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        expand_without_downtime: cdktf.booleanToTerraform(struct.expandWithoutDowntime),
    };
}
exports.azurermProviderFeaturesManagedDiskToTerraform = azurermProviderFeaturesManagedDiskToTerraform;
function azurermProviderFeaturesResourceGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        prevent_deletion_if_contains_resources: cdktf.booleanToTerraform(struct.preventDeletionIfContainsResources),
    };
}
exports.azurermProviderFeaturesResourceGroupToTerraform = azurermProviderFeaturesResourceGroupToTerraform;
function azurermProviderFeaturesTemplateDeploymentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_nested_items_during_deletion: cdktf.booleanToTerraform(struct.deleteNestedItemsDuringDeletion),
    };
}
exports.azurermProviderFeaturesTemplateDeploymentToTerraform = azurermProviderFeaturesTemplateDeploymentToTerraform;
function azurermProviderFeaturesVirtualMachineToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_os_disk_on_deletion: cdktf.booleanToTerraform(struct.deleteOsDiskOnDeletion),
        graceful_shutdown: cdktf.booleanToTerraform(struct.gracefulShutdown),
        skip_shutdown_and_force_delete: cdktf.booleanToTerraform(struct.skipShutdownAndForceDelete),
    };
}
exports.azurermProviderFeaturesVirtualMachineToTerraform = azurermProviderFeaturesVirtualMachineToTerraform;
function azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        force_delete: cdktf.booleanToTerraform(struct.forceDelete),
        roll_instances_when_required: cdktf.booleanToTerraform(struct.rollInstancesWhenRequired),
        scale_to_zero_before_deletion: cdktf.booleanToTerraform(struct.scaleToZeroBeforeDeletion),
    };
}
exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = azurermProviderFeaturesVirtualMachineScaleSetToTerraform;
function azurermProviderFeaturesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        api_management: azurermProviderFeaturesApiManagementToTerraform(struct.apiManagement),
        app_configuration: azurermProviderFeaturesAppConfigurationToTerraform(struct.appConfiguration),
        application_insights: azurermProviderFeaturesApplicationInsightsToTerraform(struct.applicationInsights),
        cognitive_account: azurermProviderFeaturesCognitiveAccountToTerraform(struct.cognitiveAccount),
        key_vault: azurermProviderFeaturesKeyVaultToTerraform(struct.keyVault),
        log_analytics_workspace: azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct.logAnalyticsWorkspace),
        managed_disk: azurermProviderFeaturesManagedDiskToTerraform(struct.managedDisk),
        resource_group: azurermProviderFeaturesResourceGroupToTerraform(struct.resourceGroup),
        template_deployment: azurermProviderFeaturesTemplateDeploymentToTerraform(struct.templateDeployment),
        virtual_machine: azurermProviderFeaturesVirtualMachineToTerraform(struct.virtualMachine),
        virtual_machine_scale_set: azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct.virtualMachineScaleSet),
    };
}
exports.azurermProviderFeaturesToTerraform = azurermProviderFeaturesToTerraform;
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs azurerm}
*/
class AzurermProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs azurerm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzurermProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.65.0',
                providerVersionConstraint: '~> 3.10'
            },
            terraformProviderSource: 'azurerm'
        });
        this._auxiliaryTenantIds = config.auxiliaryTenantIds;
        this._clientCertificate = config.clientCertificate;
        this._clientCertificatePassword = config.clientCertificatePassword;
        this._clientCertificatePath = config.clientCertificatePath;
        this._clientId = config.clientId;
        this._clientIdFilePath = config.clientIdFilePath;
        this._clientSecret = config.clientSecret;
        this._clientSecretFilePath = config.clientSecretFilePath;
        this._disableCorrelationRequestId = config.disableCorrelationRequestId;
        this._disableTerraformPartnerId = config.disableTerraformPartnerId;
        this._environment = config.environment;
        this._metadataHost = config.metadataHost;
        this._msiEndpoint = config.msiEndpoint;
        this._oidcRequestToken = config.oidcRequestToken;
        this._oidcRequestUrl = config.oidcRequestUrl;
        this._oidcToken = config.oidcToken;
        this._oidcTokenFilePath = config.oidcTokenFilePath;
        this._partnerId = config.partnerId;
        this._skipProviderRegistration = config.skipProviderRegistration;
        this._storageUseAzuread = config.storageUseAzuread;
        this._subscriptionId = config.subscriptionId;
        this._tenantId = config.tenantId;
        this._useCli = config.useCli;
        this._useMsi = config.useMsi;
        this._useOidc = config.useOidc;
        this._alias = config.alias;
        this._features = config.features;
    }
    get auxiliaryTenantIds() {
        return this._auxiliaryTenantIds;
    }
    set auxiliaryTenantIds(value) {
        this._auxiliaryTenantIds = value;
    }
    resetAuxiliaryTenantIds() {
        this._auxiliaryTenantIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auxiliaryTenantIdsInput() {
        return this._auxiliaryTenantIds;
    }
    get clientCertificate() {
        return this._clientCertificate;
    }
    set clientCertificate(value) {
        this._clientCertificate = value;
    }
    resetClientCertificate() {
        this._clientCertificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificateInput() {
        return this._clientCertificate;
    }
    get clientCertificatePassword() {
        return this._clientCertificatePassword;
    }
    set clientCertificatePassword(value) {
        this._clientCertificatePassword = value;
    }
    resetClientCertificatePassword() {
        this._clientCertificatePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePasswordInput() {
        return this._clientCertificatePassword;
    }
    get clientCertificatePath() {
        return this._clientCertificatePath;
    }
    set clientCertificatePath(value) {
        this._clientCertificatePath = value;
    }
    resetClientCertificatePath() {
        this._clientCertificatePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePathInput() {
        return this._clientCertificatePath;
    }
    get clientId() {
        return this._clientId;
    }
    set clientId(value) {
        this._clientId = value;
    }
    resetClientId() {
        this._clientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdInput() {
        return this._clientId;
    }
    get clientIdFilePath() {
        return this._clientIdFilePath;
    }
    set clientIdFilePath(value) {
        this._clientIdFilePath = value;
    }
    resetClientIdFilePath() {
        this._clientIdFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdFilePathInput() {
        return this._clientIdFilePath;
    }
    get clientSecret() {
        return this._clientSecret;
    }
    set clientSecret(value) {
        this._clientSecret = value;
    }
    resetClientSecret() {
        this._clientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSecretInput() {
        return this._clientSecret;
    }
    get clientSecretFilePath() {
        return this._clientSecretFilePath;
    }
    set clientSecretFilePath(value) {
        this._clientSecretFilePath = value;
    }
    resetClientSecretFilePath() {
        this._clientSecretFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSecretFilePathInput() {
        return this._clientSecretFilePath;
    }
    get disableCorrelationRequestId() {
        return this._disableCorrelationRequestId;
    }
    set disableCorrelationRequestId(value) {
        this._disableCorrelationRequestId = value;
    }
    resetDisableCorrelationRequestId() {
        this._disableCorrelationRequestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableCorrelationRequestIdInput() {
        return this._disableCorrelationRequestId;
    }
    get disableTerraformPartnerId() {
        return this._disableTerraformPartnerId;
    }
    set disableTerraformPartnerId(value) {
        this._disableTerraformPartnerId = value;
    }
    resetDisableTerraformPartnerId() {
        this._disableTerraformPartnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableTerraformPartnerIdInput() {
        return this._disableTerraformPartnerId;
    }
    get environment() {
        return this._environment;
    }
    set environment(value) {
        this._environment = value;
    }
    resetEnvironment() {
        this._environment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentInput() {
        return this._environment;
    }
    get metadataHost() {
        return this._metadataHost;
    }
    set metadataHost(value) {
        this._metadataHost = value;
    }
    resetMetadataHost() {
        this._metadataHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metadataHostInput() {
        return this._metadataHost;
    }
    get msiEndpoint() {
        return this._msiEndpoint;
    }
    set msiEndpoint(value) {
        this._msiEndpoint = value;
    }
    resetMsiEndpoint() {
        this._msiEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get msiEndpointInput() {
        return this._msiEndpoint;
    }
    get oidcRequestToken() {
        return this._oidcRequestToken;
    }
    set oidcRequestToken(value) {
        this._oidcRequestToken = value;
    }
    resetOidcRequestToken() {
        this._oidcRequestToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestTokenInput() {
        return this._oidcRequestToken;
    }
    get oidcRequestUrl() {
        return this._oidcRequestUrl;
    }
    set oidcRequestUrl(value) {
        this._oidcRequestUrl = value;
    }
    resetOidcRequestUrl() {
        this._oidcRequestUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestUrlInput() {
        return this._oidcRequestUrl;
    }
    get oidcToken() {
        return this._oidcToken;
    }
    set oidcToken(value) {
        this._oidcToken = value;
    }
    resetOidcToken() {
        this._oidcToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenInput() {
        return this._oidcToken;
    }
    get oidcTokenFilePath() {
        return this._oidcTokenFilePath;
    }
    set oidcTokenFilePath(value) {
        this._oidcTokenFilePath = value;
    }
    resetOidcTokenFilePath() {
        this._oidcTokenFilePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenFilePathInput() {
        return this._oidcTokenFilePath;
    }
    get partnerId() {
        return this._partnerId;
    }
    set partnerId(value) {
        this._partnerId = value;
    }
    resetPartnerId() {
        this._partnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get partnerIdInput() {
        return this._partnerId;
    }
    get skipProviderRegistration() {
        return this._skipProviderRegistration;
    }
    set skipProviderRegistration(value) {
        this._skipProviderRegistration = value;
    }
    resetSkipProviderRegistration() {
        this._skipProviderRegistration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipProviderRegistrationInput() {
        return this._skipProviderRegistration;
    }
    get storageUseAzuread() {
        return this._storageUseAzuread;
    }
    set storageUseAzuread(value) {
        this._storageUseAzuread = value;
    }
    resetStorageUseAzuread() {
        this._storageUseAzuread = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageUseAzureadInput() {
        return this._storageUseAzuread;
    }
    get subscriptionId() {
        return this._subscriptionId;
    }
    set subscriptionId(value) {
        this._subscriptionId = value;
    }
    resetSubscriptionId() {
        this._subscriptionId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subscriptionIdInput() {
        return this._subscriptionId;
    }
    get tenantId() {
        return this._tenantId;
    }
    set tenantId(value) {
        this._tenantId = value;
    }
    resetTenantId() {
        this._tenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tenantIdInput() {
        return this._tenantId;
    }
    get useCli() {
        return this._useCli;
    }
    set useCli(value) {
        this._useCli = value;
    }
    resetUseCli() {
        this._useCli = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCliInput() {
        return this._useCli;
    }
    get useMsi() {
        return this._useMsi;
    }
    set useMsi(value) {
        this._useMsi = value;
    }
    resetUseMsi() {
        this._useMsi = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useMsiInput() {
        return this._useMsi;
    }
    get useOidc() {
        return this._useOidc;
    }
    set useOidc(value) {
        this._useOidc = value;
    }
    resetUseOidc() {
        this._useOidc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useOidcInput() {
        return this._useOidc;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get features() {
        return this._features;
    }
    set features(value) {
        this._features = value;
    }
    // Temporarily expose input value. Use with caution.
    get featuresInput() {
        return this._features;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auxiliary_tenant_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._auxiliaryTenantIds),
            client_certificate: cdktf.stringToTerraform(this._clientCertificate),
            client_certificate_password: cdktf.stringToTerraform(this._clientCertificatePassword),
            client_certificate_path: cdktf.stringToTerraform(this._clientCertificatePath),
            client_id: cdktf.stringToTerraform(this._clientId),
            client_id_file_path: cdktf.stringToTerraform(this._clientIdFilePath),
            client_secret: cdktf.stringToTerraform(this._clientSecret),
            client_secret_file_path: cdktf.stringToTerraform(this._clientSecretFilePath),
            disable_correlation_request_id: cdktf.booleanToTerraform(this._disableCorrelationRequestId),
            disable_terraform_partner_id: cdktf.booleanToTerraform(this._disableTerraformPartnerId),
            environment: cdktf.stringToTerraform(this._environment),
            metadata_host: cdktf.stringToTerraform(this._metadataHost),
            msi_endpoint: cdktf.stringToTerraform(this._msiEndpoint),
            oidc_request_token: cdktf.stringToTerraform(this._oidcRequestToken),
            oidc_request_url: cdktf.stringToTerraform(this._oidcRequestUrl),
            oidc_token: cdktf.stringToTerraform(this._oidcToken),
            oidc_token_file_path: cdktf.stringToTerraform(this._oidcTokenFilePath),
            partner_id: cdktf.stringToTerraform(this._partnerId),
            skip_provider_registration: cdktf.booleanToTerraform(this._skipProviderRegistration),
            storage_use_azuread: cdktf.booleanToTerraform(this._storageUseAzuread),
            subscription_id: cdktf.stringToTerraform(this._subscriptionId),
            tenant_id: cdktf.stringToTerraform(this._tenantId),
            use_cli: cdktf.booleanToTerraform(this._useCli),
            use_msi: cdktf.booleanToTerraform(this._useMsi),
            use_oidc: cdktf.booleanToTerraform(this._useOidc),
            alias: cdktf.stringToTerraform(this._alias),
            features: azurermProviderFeaturesToTerraform(this._features),
        };
    }
}
exports.AzurermProvider = AzurermProvider;
_a = JSII_RTTI_SYMBOL_1;
AzurermProvider[_a] = { fqn: "@cdktf/provider-azurerm.provider.AzurermProvider", version: "9.0.3" };
// =================
// STATIC PROPERTIES
// =================
AzurermProvider.tfResourceType = "azurerm";
//# sourceMappingURL=data:application/json;base64,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