/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RedisLinkedServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#id RedisLinkedServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#linked_redis_cache_id RedisLinkedServer#linked_redis_cache_id}
    */
    readonly linkedRedisCacheId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#linked_redis_cache_location RedisLinkedServer#linked_redis_cache_location}
    */
    readonly linkedRedisCacheLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#resource_group_name RedisLinkedServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#server_role RedisLinkedServer#server_role}
    */
    readonly serverRole: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#target_redis_cache_name RedisLinkedServer#target_redis_cache_name}
    */
    readonly targetRedisCacheName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#timeouts RedisLinkedServer#timeouts}
    */
    readonly timeouts?: RedisLinkedServerTimeouts;
}
export interface RedisLinkedServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#create RedisLinkedServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#delete RedisLinkedServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#read RedisLinkedServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server#update RedisLinkedServer#update}
    */
    readonly update?: string;
}
export declare function redisLinkedServerTimeoutsToTerraform(struct?: RedisLinkedServerTimeouts | cdktf.IResolvable): any;
export declare class RedisLinkedServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisLinkedServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RedisLinkedServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server azurerm_redis_linked_server}
*/
export declare class RedisLinkedServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_redis_linked_server";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/redis_linked_server azurerm_redis_linked_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RedisLinkedServerConfig
    */
    constructor(scope: Construct, id: string, config: RedisLinkedServerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkedRedisCacheId?;
    get linkedRedisCacheId(): string;
    set linkedRedisCacheId(value: string);
    get linkedRedisCacheIdInput(): string | undefined;
    private _linkedRedisCacheLocation?;
    get linkedRedisCacheLocation(): string;
    set linkedRedisCacheLocation(value: string);
    get linkedRedisCacheLocationInput(): string | undefined;
    get name(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serverRole?;
    get serverRole(): string;
    set serverRole(value: string);
    get serverRoleInput(): string | undefined;
    private _targetRedisCacheName?;
    get targetRedisCacheName(): string;
    set targetRedisCacheName(value: string);
    get targetRedisCacheNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): RedisLinkedServerTimeoutsOutputReference;
    putTimeouts(value: RedisLinkedServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RedisLinkedServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
