/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelThreatIntelligenceIndicatorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#confidence SentinelThreatIntelligenceIndicator#confidence}
    */
    readonly confidence?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#created_by SentinelThreatIntelligenceIndicator#created_by}
    */
    readonly createdBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#description SentinelThreatIntelligenceIndicator#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#display_name SentinelThreatIntelligenceIndicator#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#extension SentinelThreatIntelligenceIndicator#extension}
    */
    readonly extension?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#id SentinelThreatIntelligenceIndicator#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#language SentinelThreatIntelligenceIndicator#language}
    */
    readonly language?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#object_marking_refs SentinelThreatIntelligenceIndicator#object_marking_refs}
    */
    readonly objectMarkingRefs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#pattern SentinelThreatIntelligenceIndicator#pattern}
    */
    readonly pattern: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#pattern_type SentinelThreatIntelligenceIndicator#pattern_type}
    */
    readonly patternType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#pattern_version SentinelThreatIntelligenceIndicator#pattern_version}
    */
    readonly patternVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#revoked SentinelThreatIntelligenceIndicator#revoked}
    */
    readonly revoked?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#source SentinelThreatIntelligenceIndicator#source}
    */
    readonly source: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#tags SentinelThreatIntelligenceIndicator#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#threat_types SentinelThreatIntelligenceIndicator#threat_types}
    */
    readonly threatTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#validate_from_utc SentinelThreatIntelligenceIndicator#validate_from_utc}
    */
    readonly validateFromUtc: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#validate_until_utc SentinelThreatIntelligenceIndicator#validate_until_utc}
    */
    readonly validateUntilUtc?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#workspace_id SentinelThreatIntelligenceIndicator#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * external_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#external_reference SentinelThreatIntelligenceIndicator#external_reference}
    */
    readonly externalReference?: SentinelThreatIntelligenceIndicatorExternalReference[] | cdktf.IResolvable;
    /**
    * granular_marking block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#granular_marking SentinelThreatIntelligenceIndicator#granular_marking}
    */
    readonly granularMarking?: SentinelThreatIntelligenceIndicatorGranularMarking[] | cdktf.IResolvable;
    /**
    * kill_chain_phase block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#kill_chain_phase SentinelThreatIntelligenceIndicator#kill_chain_phase}
    */
    readonly killChainPhase?: SentinelThreatIntelligenceIndicatorKillChainPhase[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#timeouts SentinelThreatIntelligenceIndicator#timeouts}
    */
    readonly timeouts?: SentinelThreatIntelligenceIndicatorTimeouts;
}
export interface SentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValues {
}
export declare function sentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValuesToTerraform(struct?: SentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValues): any;
export declare class SentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValues | undefined;
    set internalValue(value: SentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValues | undefined);
    get value(): string;
    get valueType(): string;
}
export declare class SentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValuesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValuesOutputReference;
}
export interface SentinelThreatIntelligenceIndicatorParsedPattern {
}
export declare function sentinelThreatIntelligenceIndicatorParsedPatternToTerraform(struct?: SentinelThreatIntelligenceIndicatorParsedPattern): any;
export declare class SentinelThreatIntelligenceIndicatorParsedPatternOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelThreatIntelligenceIndicatorParsedPattern | undefined;
    set internalValue(value: SentinelThreatIntelligenceIndicatorParsedPattern | undefined);
    get patternTypeKey(): string;
    private _patternTypeValues;
    get patternTypeValues(): SentinelThreatIntelligenceIndicatorParsedPatternPatternTypeValuesList;
}
export declare class SentinelThreatIntelligenceIndicatorParsedPatternList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelThreatIntelligenceIndicatorParsedPatternOutputReference;
}
export interface SentinelThreatIntelligenceIndicatorExternalReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#description SentinelThreatIntelligenceIndicator#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#hashes SentinelThreatIntelligenceIndicator#hashes}
    */
    readonly hashes?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#source_name SentinelThreatIntelligenceIndicator#source_name}
    */
    readonly sourceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#url SentinelThreatIntelligenceIndicator#url}
    */
    readonly url?: string;
}
export declare function sentinelThreatIntelligenceIndicatorExternalReferenceToTerraform(struct?: SentinelThreatIntelligenceIndicatorExternalReference | cdktf.IResolvable): any;
export declare class SentinelThreatIntelligenceIndicatorExternalReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelThreatIntelligenceIndicatorExternalReference | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelThreatIntelligenceIndicatorExternalReference | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hashes?;
    get hashes(): {
        [key: string]: string;
    };
    set hashes(value: {
        [key: string]: string;
    });
    resetHashes(): void;
    get hashesInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _sourceName?;
    get sourceName(): string;
    set sourceName(value: string);
    resetSourceName(): void;
    get sourceNameInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export declare class SentinelThreatIntelligenceIndicatorExternalReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelThreatIntelligenceIndicatorExternalReference[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelThreatIntelligenceIndicatorExternalReferenceOutputReference;
}
export interface SentinelThreatIntelligenceIndicatorGranularMarking {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#language SentinelThreatIntelligenceIndicator#language}
    */
    readonly language?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#marking_ref SentinelThreatIntelligenceIndicator#marking_ref}
    */
    readonly markingRef?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#selectors SentinelThreatIntelligenceIndicator#selectors}
    */
    readonly selectors?: string[];
}
export declare function sentinelThreatIntelligenceIndicatorGranularMarkingToTerraform(struct?: SentinelThreatIntelligenceIndicatorGranularMarking | cdktf.IResolvable): any;
export declare class SentinelThreatIntelligenceIndicatorGranularMarkingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelThreatIntelligenceIndicatorGranularMarking | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelThreatIntelligenceIndicatorGranularMarking | cdktf.IResolvable | undefined);
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    private _markingRef?;
    get markingRef(): string;
    set markingRef(value: string);
    resetMarkingRef(): void;
    get markingRefInput(): string | undefined;
    private _selectors?;
    get selectors(): string[];
    set selectors(value: string[]);
    resetSelectors(): void;
    get selectorsInput(): string[] | undefined;
}
export declare class SentinelThreatIntelligenceIndicatorGranularMarkingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelThreatIntelligenceIndicatorGranularMarking[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelThreatIntelligenceIndicatorGranularMarkingOutputReference;
}
export interface SentinelThreatIntelligenceIndicatorKillChainPhase {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#name SentinelThreatIntelligenceIndicator#name}
    */
    readonly name?: string;
}
export declare function sentinelThreatIntelligenceIndicatorKillChainPhaseToTerraform(struct?: SentinelThreatIntelligenceIndicatorKillChainPhase | cdktf.IResolvable): any;
export declare class SentinelThreatIntelligenceIndicatorKillChainPhaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelThreatIntelligenceIndicatorKillChainPhase | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelThreatIntelligenceIndicatorKillChainPhase | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class SentinelThreatIntelligenceIndicatorKillChainPhaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelThreatIntelligenceIndicatorKillChainPhase[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelThreatIntelligenceIndicatorKillChainPhaseOutputReference;
}
export interface SentinelThreatIntelligenceIndicatorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#create SentinelThreatIntelligenceIndicator#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#delete SentinelThreatIntelligenceIndicator#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#read SentinelThreatIntelligenceIndicator#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator#update SentinelThreatIntelligenceIndicator#update}
    */
    readonly update?: string;
}
export declare function sentinelThreatIntelligenceIndicatorTimeoutsToTerraform(struct?: SentinelThreatIntelligenceIndicatorTimeouts | cdktf.IResolvable): any;
export declare class SentinelThreatIntelligenceIndicatorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelThreatIntelligenceIndicatorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelThreatIntelligenceIndicatorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator azurerm_sentinel_threat_intelligence_indicator}
*/
export declare class SentinelThreatIntelligenceIndicator extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_threat_intelligence_indicator";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/sentinel_threat_intelligence_indicator azurerm_sentinel_threat_intelligence_indicator} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelThreatIntelligenceIndicatorConfig
    */
    constructor(scope: Construct, id: string, config: SentinelThreatIntelligenceIndicatorConfig);
    private _confidence?;
    get confidence(): number;
    set confidence(value: number);
    resetConfidence(): void;
    get confidenceInput(): number | undefined;
    private _createdBy?;
    get createdBy(): string;
    set createdBy(value: string);
    resetCreatedBy(): void;
    get createdByInput(): string | undefined;
    get createdOn(): string;
    get defanged(): cdktf.IResolvable;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _extension?;
    get extension(): string;
    set extension(value: string);
    resetExtension(): void;
    get extensionInput(): string | undefined;
    get externalId(): string;
    get externalLastUpdatedTimeUtc(): string;
    get guid(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get indicatorType(): string[];
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    get lastUpdatedTimeUtc(): string;
    private _objectMarkingRefs?;
    get objectMarkingRefs(): string[];
    set objectMarkingRefs(value: string[]);
    resetObjectMarkingRefs(): void;
    get objectMarkingRefsInput(): string[] | undefined;
    private _parsedPattern;
    get parsedPattern(): SentinelThreatIntelligenceIndicatorParsedPatternList;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
    private _patternType?;
    get patternType(): string;
    set patternType(value: string);
    get patternTypeInput(): string | undefined;
    private _patternVersion?;
    get patternVersion(): string;
    set patternVersion(value: string);
    resetPatternVersion(): void;
    get patternVersionInput(): string | undefined;
    private _revoked?;
    get revoked(): boolean | cdktf.IResolvable;
    set revoked(value: boolean | cdktf.IResolvable);
    resetRevoked(): void;
    get revokedInput(): boolean | cdktf.IResolvable | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _threatTypes?;
    get threatTypes(): string[];
    set threatTypes(value: string[]);
    resetThreatTypes(): void;
    get threatTypesInput(): string[] | undefined;
    private _validateFromUtc?;
    get validateFromUtc(): string;
    set validateFromUtc(value: string);
    get validateFromUtcInput(): string | undefined;
    private _validateUntilUtc?;
    get validateUntilUtc(): string;
    set validateUntilUtc(value: string);
    resetValidateUntilUtc(): void;
    get validateUntilUtcInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _externalReference;
    get externalReference(): SentinelThreatIntelligenceIndicatorExternalReferenceList;
    putExternalReference(value: SentinelThreatIntelligenceIndicatorExternalReference[] | cdktf.IResolvable): void;
    resetExternalReference(): void;
    get externalReferenceInput(): cdktf.IResolvable | SentinelThreatIntelligenceIndicatorExternalReference[] | undefined;
    private _granularMarking;
    get granularMarking(): SentinelThreatIntelligenceIndicatorGranularMarkingList;
    putGranularMarking(value: SentinelThreatIntelligenceIndicatorGranularMarking[] | cdktf.IResolvable): void;
    resetGranularMarking(): void;
    get granularMarkingInput(): cdktf.IResolvable | SentinelThreatIntelligenceIndicatorGranularMarking[] | undefined;
    private _killChainPhase;
    get killChainPhase(): SentinelThreatIntelligenceIndicatorKillChainPhaseList;
    putKillChainPhase(value: SentinelThreatIntelligenceIndicatorKillChainPhase[] | cdktf.IResolvable): void;
    resetKillChainPhase(): void;
    get killChainPhaseInput(): cdktf.IResolvable | SentinelThreatIntelligenceIndicatorKillChainPhase[] | undefined;
    private _timeouts;
    get timeouts(): SentinelThreatIntelligenceIndicatorTimeoutsOutputReference;
    putTimeouts(value: SentinelThreatIntelligenceIndicatorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelThreatIntelligenceIndicatorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
