/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#addon_json SpringCloudApp#addon_json}
    */
    readonly addonJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#https_only SpringCloudApp#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#id SpringCloudApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#is_public SpringCloudApp#is_public}
    */
    readonly isPublic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#name SpringCloudApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#public_endpoint_enabled SpringCloudApp#public_endpoint_enabled}
    */
    readonly publicEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#resource_group_name SpringCloudApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#service_name SpringCloudApp#service_name}
    */
    readonly serviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#tls_enabled SpringCloudApp#tls_enabled}
    */
    readonly tlsEnabled?: boolean | cdktf.IResolvable;
    /**
    * custom_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#custom_persistent_disk SpringCloudApp#custom_persistent_disk}
    */
    readonly customPersistentDisk?: SpringCloudAppCustomPersistentDisk[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#identity SpringCloudApp#identity}
    */
    readonly identity?: SpringCloudAppIdentity;
    /**
    * ingress_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#ingress_settings SpringCloudApp#ingress_settings}
    */
    readonly ingressSettings?: SpringCloudAppIngressSettings;
    /**
    * persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#persistent_disk SpringCloudApp#persistent_disk}
    */
    readonly persistentDisk?: SpringCloudAppPersistentDisk;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#timeouts SpringCloudApp#timeouts}
    */
    readonly timeouts?: SpringCloudAppTimeouts;
}
export interface SpringCloudAppCustomPersistentDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#mount_options SpringCloudApp#mount_options}
    */
    readonly mountOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#mount_path SpringCloudApp#mount_path}
    */
    readonly mountPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#read_only_enabled SpringCloudApp#read_only_enabled}
    */
    readonly readOnlyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#share_name SpringCloudApp#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#storage_name SpringCloudApp#storage_name}
    */
    readonly storageName: string;
}
export declare function springCloudAppCustomPersistentDiskToTerraform(struct?: SpringCloudAppCustomPersistentDisk | cdktf.IResolvable): any;
export declare class SpringCloudAppCustomPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpringCloudAppCustomPersistentDisk | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudAppCustomPersistentDisk | cdktf.IResolvable | undefined);
    private _mountOptions?;
    get mountOptions(): string[];
    set mountOptions(value: string[]);
    resetMountOptions(): void;
    get mountOptionsInput(): string[] | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _readOnlyEnabled?;
    get readOnlyEnabled(): boolean | cdktf.IResolvable;
    set readOnlyEnabled(value: boolean | cdktf.IResolvable);
    resetReadOnlyEnabled(): void;
    get readOnlyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _storageName?;
    get storageName(): string;
    set storageName(value: string);
    get storageNameInput(): string | undefined;
}
export declare class SpringCloudAppCustomPersistentDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SpringCloudAppCustomPersistentDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpringCloudAppCustomPersistentDiskOutputReference;
}
export interface SpringCloudAppIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#identity_ids SpringCloudApp#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#type SpringCloudApp#type}
    */
    readonly type: string;
}
export declare function springCloudAppIdentityToTerraform(struct?: SpringCloudAppIdentityOutputReference | SpringCloudAppIdentity): any;
export declare class SpringCloudAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudAppIdentity | undefined;
    set internalValue(value: SpringCloudAppIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SpringCloudAppIngressSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#backend_protocol SpringCloudApp#backend_protocol}
    */
    readonly backendProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#read_timeout_in_seconds SpringCloudApp#read_timeout_in_seconds}
    */
    readonly readTimeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#send_timeout_in_seconds SpringCloudApp#send_timeout_in_seconds}
    */
    readonly sendTimeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#session_affinity SpringCloudApp#session_affinity}
    */
    readonly sessionAffinity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#session_cookie_max_age SpringCloudApp#session_cookie_max_age}
    */
    readonly sessionCookieMaxAge?: number;
}
export declare function springCloudAppIngressSettingsToTerraform(struct?: SpringCloudAppIngressSettingsOutputReference | SpringCloudAppIngressSettings): any;
export declare class SpringCloudAppIngressSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudAppIngressSettings | undefined;
    set internalValue(value: SpringCloudAppIngressSettings | undefined);
    private _backendProtocol?;
    get backendProtocol(): string;
    set backendProtocol(value: string);
    resetBackendProtocol(): void;
    get backendProtocolInput(): string | undefined;
    private _readTimeoutInSeconds?;
    get readTimeoutInSeconds(): number;
    set readTimeoutInSeconds(value: number);
    resetReadTimeoutInSeconds(): void;
    get readTimeoutInSecondsInput(): number | undefined;
    private _sendTimeoutInSeconds?;
    get sendTimeoutInSeconds(): number;
    set sendTimeoutInSeconds(value: number);
    resetSendTimeoutInSeconds(): void;
    get sendTimeoutInSecondsInput(): number | undefined;
    private _sessionAffinity?;
    get sessionAffinity(): string;
    set sessionAffinity(value: string);
    resetSessionAffinity(): void;
    get sessionAffinityInput(): string | undefined;
    private _sessionCookieMaxAge?;
    get sessionCookieMaxAge(): number;
    set sessionCookieMaxAge(value: number);
    resetSessionCookieMaxAge(): void;
    get sessionCookieMaxAgeInput(): number | undefined;
}
export interface SpringCloudAppPersistentDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#mount_path SpringCloudApp#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#size_in_gb SpringCloudApp#size_in_gb}
    */
    readonly sizeInGb: number;
}
export declare function springCloudAppPersistentDiskToTerraform(struct?: SpringCloudAppPersistentDiskOutputReference | SpringCloudAppPersistentDisk): any;
export declare class SpringCloudAppPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudAppPersistentDisk | undefined;
    set internalValue(value: SpringCloudAppPersistentDisk | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _sizeInGb?;
    get sizeInGb(): number;
    set sizeInGb(value: number);
    get sizeInGbInput(): number | undefined;
}
export interface SpringCloudAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#create SpringCloudApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#delete SpringCloudApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#read SpringCloudApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app#update SpringCloudApp#update}
    */
    readonly update?: string;
}
export declare function springCloudAppTimeoutsToTerraform(struct?: SpringCloudAppTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app azurerm_spring_cloud_app}
*/
export declare class SpringCloudApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_app";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/spring_cloud_app azurerm_spring_cloud_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudAppConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudAppConfig);
    private _addonJson?;
    get addonJson(): string;
    set addonJson(value: string);
    resetAddonJson(): void;
    get addonJsonInput(): string | undefined;
    get fqdn(): string;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isPublic?;
    get isPublic(): boolean | cdktf.IResolvable;
    set isPublic(value: boolean | cdktf.IResolvable);
    resetIsPublic(): void;
    get isPublicInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicEndpointEnabled?;
    get publicEndpointEnabled(): boolean | cdktf.IResolvable;
    set publicEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetPublicEndpointEnabled(): void;
    get publicEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _tlsEnabled?;
    get tlsEnabled(): boolean | cdktf.IResolvable;
    set tlsEnabled(value: boolean | cdktf.IResolvable);
    resetTlsEnabled(): void;
    get tlsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get url(): string;
    private _customPersistentDisk;
    get customPersistentDisk(): SpringCloudAppCustomPersistentDiskList;
    putCustomPersistentDisk(value: SpringCloudAppCustomPersistentDisk[] | cdktf.IResolvable): void;
    resetCustomPersistentDisk(): void;
    get customPersistentDiskInput(): cdktf.IResolvable | SpringCloudAppCustomPersistentDisk[] | undefined;
    private _identity;
    get identity(): SpringCloudAppIdentityOutputReference;
    putIdentity(value: SpringCloudAppIdentity): void;
    resetIdentity(): void;
    get identityInput(): SpringCloudAppIdentity | undefined;
    private _ingressSettings;
    get ingressSettings(): SpringCloudAppIngressSettingsOutputReference;
    putIngressSettings(value: SpringCloudAppIngressSettings): void;
    resetIngressSettings(): void;
    get ingressSettingsInput(): SpringCloudAppIngressSettings | undefined;
    private _persistentDisk;
    get persistentDisk(): SpringCloudAppPersistentDiskOutputReference;
    putPersistentDisk(value: SpringCloudAppPersistentDisk): void;
    resetPersistentDisk(): void;
    get persistentDiskInput(): SpringCloudAppPersistentDisk | undefined;
    private _timeouts;
    get timeouts(): SpringCloudAppTimeoutsOutputReference;
    putTimeouts(value: SpringCloudAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
