/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StaticSiteCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#domain_name StaticSiteCustomDomain#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#id StaticSiteCustomDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#static_site_id StaticSiteCustomDomain#static_site_id}
    */
    readonly staticSiteId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#validation_type StaticSiteCustomDomain#validation_type}
    */
    readonly validationType?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#timeouts StaticSiteCustomDomain#timeouts}
    */
    readonly timeouts?: StaticSiteCustomDomainTimeouts;
}
export interface StaticSiteCustomDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#create StaticSiteCustomDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#delete StaticSiteCustomDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#read StaticSiteCustomDomain#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain#update StaticSiteCustomDomain#update}
    */
    readonly update?: string;
}
export declare function staticSiteCustomDomainTimeoutsToTerraform(struct?: StaticSiteCustomDomainTimeouts | cdktf.IResolvable): any;
export declare class StaticSiteCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StaticSiteCustomDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StaticSiteCustomDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain azurerm_static_site_custom_domain}
*/
export declare class StaticSiteCustomDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_static_site_custom_domain";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/static_site_custom_domain azurerm_static_site_custom_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StaticSiteCustomDomainConfig
    */
    constructor(scope: Construct, id: string, config: StaticSiteCustomDomainConfig);
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _staticSiteId?;
    get staticSiteId(): string;
    set staticSiteId(value: string);
    get staticSiteIdInput(): string | undefined;
    get validationToken(): string;
    private _validationType?;
    get validationType(): string;
    set validationType(value: string);
    resetValidationType(): void;
    get validationTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): StaticSiteCustomDomainTimeoutsOutputReference;
    putTimeouts(value: StaticSiteCustomDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StaticSiteCustomDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
