/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#id SynapseSqlPoolVulnerabilityAssessmentBaseline#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#name SynapseSqlPoolVulnerabilityAssessmentBaseline#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#rule_name SynapseSqlPoolVulnerabilityAssessmentBaseline#rule_name}
    */
    readonly ruleName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#sql_pool_vulnerability_assessment_id SynapseSqlPoolVulnerabilityAssessmentBaseline#sql_pool_vulnerability_assessment_id}
    */
    readonly sqlPoolVulnerabilityAssessmentId: string;
    /**
    * baseline block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#baseline SynapseSqlPoolVulnerabilityAssessmentBaseline#baseline}
    */
    readonly baseline?: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#timeouts SynapseSqlPoolVulnerabilityAssessmentBaseline#timeouts}
    */
    readonly timeouts?: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts;
}
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#result SynapseSqlPoolVulnerabilityAssessmentBaseline#result}
    */
    readonly result: string[];
}
export declare function synapseSqlPoolVulnerabilityAssessmentBaselineBaselineToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline | cdktf.IResolvable): any;
export declare class SynapseSqlPoolVulnerabilityAssessmentBaselineBaselineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline | cdktf.IResolvable | undefined);
    private _result?;
    get result(): string[];
    set result(value: string[]);
    get resultInput(): string[] | undefined;
}
export declare class SynapseSqlPoolVulnerabilityAssessmentBaselineBaselineList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SynapseSqlPoolVulnerabilityAssessmentBaselineBaselineOutputReference;
}
export interface SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#create SynapseSqlPoolVulnerabilityAssessmentBaseline#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#delete SynapseSqlPoolVulnerabilityAssessmentBaseline#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#read SynapseSqlPoolVulnerabilityAssessmentBaseline#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline#update SynapseSqlPoolVulnerabilityAssessmentBaseline#update}
    */
    readonly update?: string;
}
export declare function synapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | cdktf.IResolvable): any;
export declare class SynapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline azurerm_synapse_sql_pool_vulnerability_assessment_baseline}
*/
export declare class SynapseSqlPoolVulnerabilityAssessmentBaseline extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_sql_pool_vulnerability_assessment_baseline";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment_baseline azurerm_synapse_sql_pool_vulnerability_assessment_baseline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseSqlPoolVulnerabilityAssessmentBaselineConfig
    */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolVulnerabilityAssessmentBaselineConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ruleName?;
    get ruleName(): string;
    set ruleName(value: string);
    get ruleNameInput(): string | undefined;
    private _sqlPoolVulnerabilityAssessmentId?;
    get sqlPoolVulnerabilityAssessmentId(): string;
    set sqlPoolVulnerabilityAssessmentId(value: string);
    get sqlPoolVulnerabilityAssessmentIdInput(): string | undefined;
    private _baseline;
    get baseline(): SynapseSqlPoolVulnerabilityAssessmentBaselineBaselineList;
    putBaseline(value: SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | cdktf.IResolvable): void;
    resetBaseline(): void;
    get baselineInput(): cdktf.IResolvable | SynapseSqlPoolVulnerabilityAssessmentBaselineBaseline[] | undefined;
    private _timeouts;
    get timeouts(): SynapseSqlPoolVulnerabilityAssessmentBaselineTimeoutsOutputReference;
    putTimeouts(value: SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SynapseSqlPoolVulnerabilityAssessmentBaselineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
