/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseSqlPoolVulnerabilityAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#id SynapseSqlPoolVulnerabilityAssessment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#sql_pool_security_alert_policy_id SynapseSqlPoolVulnerabilityAssessment#sql_pool_security_alert_policy_id}
    */
    readonly sqlPoolSecurityAlertPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_account_access_key SynapseSqlPoolVulnerabilityAssessment#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_path SynapseSqlPoolVulnerabilityAssessment#storage_container_path}
    */
    readonly storageContainerPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_sas_key SynapseSqlPoolVulnerabilityAssessment#storage_container_sas_key}
    */
    readonly storageContainerSasKey?: string;
    /**
    * recurring_scans block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#recurring_scans SynapseSqlPoolVulnerabilityAssessment#recurring_scans}
    */
    readonly recurringScans?: SynapseSqlPoolVulnerabilityAssessmentRecurringScans;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#timeouts SynapseSqlPoolVulnerabilityAssessment#timeouts}
    */
    readonly timeouts?: SynapseSqlPoolVulnerabilityAssessmentTimeouts;
}
export interface SynapseSqlPoolVulnerabilityAssessmentRecurringScans {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#email_subscription_admins_enabled SynapseSqlPoolVulnerabilityAssessment#email_subscription_admins_enabled}
    */
    readonly emailSubscriptionAdminsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#emails SynapseSqlPoolVulnerabilityAssessment#emails}
    */
    readonly emails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#enabled SynapseSqlPoolVulnerabilityAssessment#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function synapseSqlPoolVulnerabilityAssessmentRecurringScansToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference | SynapseSqlPoolVulnerabilityAssessmentRecurringScans): any;
export declare class SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSqlPoolVulnerabilityAssessmentRecurringScans | undefined;
    set internalValue(value: SynapseSqlPoolVulnerabilityAssessmentRecurringScans | undefined);
    private _emailSubscriptionAdminsEnabled?;
    get emailSubscriptionAdminsEnabled(): boolean | cdktf.IResolvable;
    set emailSubscriptionAdminsEnabled(value: boolean | cdktf.IResolvable);
    resetEmailSubscriptionAdminsEnabled(): void;
    get emailSubscriptionAdminsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _emails?;
    get emails(): string[];
    set emails(value: string[]);
    resetEmails(): void;
    get emailsInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SynapseSqlPoolVulnerabilityAssessmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#create SynapseSqlPoolVulnerabilityAssessment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#delete SynapseSqlPoolVulnerabilityAssessment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#read SynapseSqlPoolVulnerabilityAssessment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment#update SynapseSqlPoolVulnerabilityAssessment#update}
    */
    readonly update?: string;
}
export declare function synapseSqlPoolVulnerabilityAssessmentTimeoutsToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentTimeouts | cdktf.IResolvable): any;
export declare class SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSqlPoolVulnerabilityAssessmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseSqlPoolVulnerabilityAssessmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment azurerm_synapse_sql_pool_vulnerability_assessment}
*/
export declare class SynapseSqlPoolVulnerabilityAssessment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_sql_pool_vulnerability_assessment";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool_vulnerability_assessment azurerm_synapse_sql_pool_vulnerability_assessment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseSqlPoolVulnerabilityAssessmentConfig
    */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolVulnerabilityAssessmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sqlPoolSecurityAlertPolicyId?;
    get sqlPoolSecurityAlertPolicyId(): string;
    set sqlPoolSecurityAlertPolicyId(value: string);
    get sqlPoolSecurityAlertPolicyIdInput(): string | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageContainerPath?;
    get storageContainerPath(): string;
    set storageContainerPath(value: string);
    get storageContainerPathInput(): string | undefined;
    private _storageContainerSasKey?;
    get storageContainerSasKey(): string;
    set storageContainerSasKey(value: string);
    resetStorageContainerSasKey(): void;
    get storageContainerSasKeyInput(): string | undefined;
    private _recurringScans;
    get recurringScans(): SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference;
    putRecurringScans(value: SynapseSqlPoolVulnerabilityAssessmentRecurringScans): void;
    resetRecurringScans(): void;
    get recurringScansInput(): SynapseSqlPoolVulnerabilityAssessmentRecurringScans | undefined;
    private _timeouts;
    get timeouts(): SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference;
    putTimeouts(value: SynapseSqlPoolVulnerabilityAssessmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SynapseSqlPoolVulnerabilityAssessmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
