/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseSqlPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#collation SynapseSqlPool#collation}
    */
    readonly collation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#create_mode SynapseSqlPool#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#data_encrypted SynapseSqlPool#data_encrypted}
    */
    readonly dataEncrypted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#geo_backup_policy_enabled SynapseSqlPool#geo_backup_policy_enabled}
    */
    readonly geoBackupPolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#id SynapseSqlPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#name SynapseSqlPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#recovery_database_id SynapseSqlPool#recovery_database_id}
    */
    readonly recoveryDatabaseId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#sku_name SynapseSqlPool#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#synapse_workspace_id SynapseSqlPool#synapse_workspace_id}
    */
    readonly synapseWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#tags SynapseSqlPool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * restore block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#restore SynapseSqlPool#restore}
    */
    readonly restore?: SynapseSqlPoolRestore;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#timeouts SynapseSqlPool#timeouts}
    */
    readonly timeouts?: SynapseSqlPoolTimeouts;
}
export interface SynapseSqlPoolRestore {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#point_in_time SynapseSqlPool#point_in_time}
    */
    readonly pointInTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#source_database_id SynapseSqlPool#source_database_id}
    */
    readonly sourceDatabaseId: string;
}
export declare function synapseSqlPoolRestoreToTerraform(struct?: SynapseSqlPoolRestoreOutputReference | SynapseSqlPoolRestore): any;
export declare class SynapseSqlPoolRestoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSqlPoolRestore | undefined;
    set internalValue(value: SynapseSqlPoolRestore | undefined);
    private _pointInTime?;
    get pointInTime(): string;
    set pointInTime(value: string);
    get pointInTimeInput(): string | undefined;
    private _sourceDatabaseId?;
    get sourceDatabaseId(): string;
    set sourceDatabaseId(value: string);
    get sourceDatabaseIdInput(): string | undefined;
}
export interface SynapseSqlPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#create SynapseSqlPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#delete SynapseSqlPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#read SynapseSqlPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool#update SynapseSqlPool#update}
    */
    readonly update?: string;
}
export declare function synapseSqlPoolTimeoutsToTerraform(struct?: SynapseSqlPoolTimeouts | cdktf.IResolvable): any;
export declare class SynapseSqlPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSqlPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SynapseSqlPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool azurerm_synapse_sql_pool}
*/
export declare class SynapseSqlPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_sql_pool";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/synapse_sql_pool azurerm_synapse_sql_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseSqlPoolConfig
    */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolConfig);
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    private _dataEncrypted?;
    get dataEncrypted(): boolean | cdktf.IResolvable;
    set dataEncrypted(value: boolean | cdktf.IResolvable);
    resetDataEncrypted(): void;
    get dataEncryptedInput(): boolean | cdktf.IResolvable | undefined;
    private _geoBackupPolicyEnabled?;
    get geoBackupPolicyEnabled(): boolean | cdktf.IResolvable;
    set geoBackupPolicyEnabled(value: boolean | cdktf.IResolvable);
    resetGeoBackupPolicyEnabled(): void;
    get geoBackupPolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryDatabaseId?;
    get recoveryDatabaseId(): string;
    set recoveryDatabaseId(value: string);
    resetRecoveryDatabaseId(): void;
    get recoveryDatabaseIdInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _synapseWorkspaceId?;
    get synapseWorkspaceId(): string;
    set synapseWorkspaceId(value: string);
    get synapseWorkspaceIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _restore;
    get restore(): SynapseSqlPoolRestoreOutputReference;
    putRestore(value: SynapseSqlPoolRestore): void;
    resetRestore(): void;
    get restoreInput(): SynapseSqlPoolRestore | undefined;
    private _timeouts;
    get timeouts(): SynapseSqlPoolTimeoutsOutputReference;
    putTimeouts(value: SynapseSqlPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SynapseSqlPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
