/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#id VpnGatewayConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#internet_security_enabled VpnGatewayConnection#internet_security_enabled}
    */
    readonly internetSecurityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#name VpnGatewayConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#remote_vpn_site_id VpnGatewayConnection#remote_vpn_site_id}
    */
    readonly remoteVpnSiteId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#vpn_gateway_id VpnGatewayConnection#vpn_gateway_id}
    */
    readonly vpnGatewayId: string;
    /**
    * routing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#routing VpnGatewayConnection#routing}
    */
    readonly routing?: VpnGatewayConnectionRouting;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#timeouts VpnGatewayConnection#timeouts}
    */
    readonly timeouts?: VpnGatewayConnectionTimeouts;
    /**
    * traffic_selector_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#traffic_selector_policy VpnGatewayConnection#traffic_selector_policy}
    */
    readonly trafficSelectorPolicy?: VpnGatewayConnectionTrafficSelectorPolicy[] | cdktf.IResolvable;
    /**
    * vpn_link block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#vpn_link VpnGatewayConnection#vpn_link}
    */
    readonly vpnLink: VpnGatewayConnectionVpnLink[] | cdktf.IResolvable;
}
export interface VpnGatewayConnectionRoutingPropagatedRouteTable {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#labels VpnGatewayConnection#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#route_table_ids VpnGatewayConnection#route_table_ids}
    */
    readonly routeTableIds: string[];
}
export declare function vpnGatewayConnectionRoutingPropagatedRouteTableToTerraform(struct?: VpnGatewayConnectionRoutingPropagatedRouteTableOutputReference | VpnGatewayConnectionRoutingPropagatedRouteTable): any;
export declare class VpnGatewayConnectionRoutingPropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayConnectionRoutingPropagatedRouteTable | undefined;
    set internalValue(value: VpnGatewayConnectionRoutingPropagatedRouteTable | undefined);
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _routeTableIds?;
    get routeTableIds(): string[];
    set routeTableIds(value: string[]);
    get routeTableIdsInput(): string[] | undefined;
}
export interface VpnGatewayConnectionRouting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#associated_route_table VpnGatewayConnection#associated_route_table}
    */
    readonly associatedRouteTable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#inbound_route_map_id VpnGatewayConnection#inbound_route_map_id}
    */
    readonly inboundRouteMapId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#outbound_route_map_id VpnGatewayConnection#outbound_route_map_id}
    */
    readonly outboundRouteMapId?: string;
    /**
    * propagated_route_table block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#propagated_route_table VpnGatewayConnection#propagated_route_table}
    */
    readonly propagatedRouteTable?: VpnGatewayConnectionRoutingPropagatedRouteTable;
}
export declare function vpnGatewayConnectionRoutingToTerraform(struct?: VpnGatewayConnectionRoutingOutputReference | VpnGatewayConnectionRouting): any;
export declare class VpnGatewayConnectionRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayConnectionRouting | undefined;
    set internalValue(value: VpnGatewayConnectionRouting | undefined);
    private _associatedRouteTable?;
    get associatedRouteTable(): string;
    set associatedRouteTable(value: string);
    get associatedRouteTableInput(): string | undefined;
    private _inboundRouteMapId?;
    get inboundRouteMapId(): string;
    set inboundRouteMapId(value: string);
    resetInboundRouteMapId(): void;
    get inboundRouteMapIdInput(): string | undefined;
    private _outboundRouteMapId?;
    get outboundRouteMapId(): string;
    set outboundRouteMapId(value: string);
    resetOutboundRouteMapId(): void;
    get outboundRouteMapIdInput(): string | undefined;
    private _propagatedRouteTable;
    get propagatedRouteTable(): VpnGatewayConnectionRoutingPropagatedRouteTableOutputReference;
    putPropagatedRouteTable(value: VpnGatewayConnectionRoutingPropagatedRouteTable): void;
    resetPropagatedRouteTable(): void;
    get propagatedRouteTableInput(): VpnGatewayConnectionRoutingPropagatedRouteTable | undefined;
}
export interface VpnGatewayConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#create VpnGatewayConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#delete VpnGatewayConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#read VpnGatewayConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#update VpnGatewayConnection#update}
    */
    readonly update?: string;
}
export declare function vpnGatewayConnectionTimeoutsToTerraform(struct?: VpnGatewayConnectionTimeouts | cdktf.IResolvable): any;
export declare class VpnGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnGatewayConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface VpnGatewayConnectionTrafficSelectorPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#local_address_ranges VpnGatewayConnection#local_address_ranges}
    */
    readonly localAddressRanges: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#remote_address_ranges VpnGatewayConnection#remote_address_ranges}
    */
    readonly remoteAddressRanges: string[];
}
export declare function vpnGatewayConnectionTrafficSelectorPolicyToTerraform(struct?: VpnGatewayConnectionTrafficSelectorPolicy | cdktf.IResolvable): any;
export declare class VpnGatewayConnectionTrafficSelectorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnGatewayConnectionTrafficSelectorPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayConnectionTrafficSelectorPolicy | cdktf.IResolvable | undefined);
    private _localAddressRanges?;
    get localAddressRanges(): string[];
    set localAddressRanges(value: string[]);
    get localAddressRangesInput(): string[] | undefined;
    private _remoteAddressRanges?;
    get remoteAddressRanges(): string[];
    set remoteAddressRanges(value: string[]);
    get remoteAddressRangesInput(): string[] | undefined;
}
export declare class VpnGatewayConnectionTrafficSelectorPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnGatewayConnectionTrafficSelectorPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnGatewayConnectionTrafficSelectorPolicyOutputReference;
}
export interface VpnGatewayConnectionVpnLinkCustomBgpAddress {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#ip_address VpnGatewayConnection#ip_address}
    */
    readonly ipAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#ip_configuration_id VpnGatewayConnection#ip_configuration_id}
    */
    readonly ipConfigurationId: string;
}
export declare function vpnGatewayConnectionVpnLinkCustomBgpAddressToTerraform(struct?: VpnGatewayConnectionVpnLinkCustomBgpAddress | cdktf.IResolvable): any;
export declare class VpnGatewayConnectionVpnLinkCustomBgpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnGatewayConnectionVpnLinkCustomBgpAddress | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayConnectionVpnLinkCustomBgpAddress | cdktf.IResolvable | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _ipConfigurationId?;
    get ipConfigurationId(): string;
    set ipConfigurationId(value: string);
    get ipConfigurationIdInput(): string | undefined;
}
export declare class VpnGatewayConnectionVpnLinkCustomBgpAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnGatewayConnectionVpnLinkCustomBgpAddress[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnGatewayConnectionVpnLinkCustomBgpAddressOutputReference;
}
export interface VpnGatewayConnectionVpnLinkIpsecPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#dh_group VpnGatewayConnection#dh_group}
    */
    readonly dhGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#encryption_algorithm VpnGatewayConnection#encryption_algorithm}
    */
    readonly encryptionAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#ike_encryption_algorithm VpnGatewayConnection#ike_encryption_algorithm}
    */
    readonly ikeEncryptionAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#ike_integrity_algorithm VpnGatewayConnection#ike_integrity_algorithm}
    */
    readonly ikeIntegrityAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#integrity_algorithm VpnGatewayConnection#integrity_algorithm}
    */
    readonly integrityAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#pfs_group VpnGatewayConnection#pfs_group}
    */
    readonly pfsGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#sa_data_size_kb VpnGatewayConnection#sa_data_size_kb}
    */
    readonly saDataSizeKb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#sa_lifetime_sec VpnGatewayConnection#sa_lifetime_sec}
    */
    readonly saLifetimeSec: number;
}
export declare function vpnGatewayConnectionVpnLinkIpsecPolicyToTerraform(struct?: VpnGatewayConnectionVpnLinkIpsecPolicy | cdktf.IResolvable): any;
export declare class VpnGatewayConnectionVpnLinkIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnGatewayConnectionVpnLinkIpsecPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayConnectionVpnLinkIpsecPolicy | cdktf.IResolvable | undefined);
    private _dhGroup?;
    get dhGroup(): string;
    set dhGroup(value: string);
    get dhGroupInput(): string | undefined;
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    get encryptionAlgorithmInput(): string | undefined;
    private _ikeEncryptionAlgorithm?;
    get ikeEncryptionAlgorithm(): string;
    set ikeEncryptionAlgorithm(value: string);
    get ikeEncryptionAlgorithmInput(): string | undefined;
    private _ikeIntegrityAlgorithm?;
    get ikeIntegrityAlgorithm(): string;
    set ikeIntegrityAlgorithm(value: string);
    get ikeIntegrityAlgorithmInput(): string | undefined;
    private _integrityAlgorithm?;
    get integrityAlgorithm(): string;
    set integrityAlgorithm(value: string);
    get integrityAlgorithmInput(): string | undefined;
    private _pfsGroup?;
    get pfsGroup(): string;
    set pfsGroup(value: string);
    get pfsGroupInput(): string | undefined;
    private _saDataSizeKb?;
    get saDataSizeKb(): number;
    set saDataSizeKb(value: number);
    get saDataSizeKbInput(): number | undefined;
    private _saLifetimeSec?;
    get saLifetimeSec(): number;
    set saLifetimeSec(value: number);
    get saLifetimeSecInput(): number | undefined;
}
export declare class VpnGatewayConnectionVpnLinkIpsecPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnGatewayConnectionVpnLinkIpsecPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnGatewayConnectionVpnLinkIpsecPolicyOutputReference;
}
export interface VpnGatewayConnectionVpnLink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#bandwidth_mbps VpnGatewayConnection#bandwidth_mbps}
    */
    readonly bandwidthMbps?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#bgp_enabled VpnGatewayConnection#bgp_enabled}
    */
    readonly bgpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#connection_mode VpnGatewayConnection#connection_mode}
    */
    readonly connectionMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#egress_nat_rule_ids VpnGatewayConnection#egress_nat_rule_ids}
    */
    readonly egressNatRuleIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#ingress_nat_rule_ids VpnGatewayConnection#ingress_nat_rule_ids}
    */
    readonly ingressNatRuleIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#local_azure_ip_address_enabled VpnGatewayConnection#local_azure_ip_address_enabled}
    */
    readonly localAzureIpAddressEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#name VpnGatewayConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#policy_based_traffic_selector_enabled VpnGatewayConnection#policy_based_traffic_selector_enabled}
    */
    readonly policyBasedTrafficSelectorEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#protocol VpnGatewayConnection#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#ratelimit_enabled VpnGatewayConnection#ratelimit_enabled}
    */
    readonly ratelimitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#route_weight VpnGatewayConnection#route_weight}
    */
    readonly routeWeight?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#shared_key VpnGatewayConnection#shared_key}
    */
    readonly sharedKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#vpn_site_link_id VpnGatewayConnection#vpn_site_link_id}
    */
    readonly vpnSiteLinkId: string;
    /**
    * custom_bgp_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#custom_bgp_address VpnGatewayConnection#custom_bgp_address}
    */
    readonly customBgpAddress?: VpnGatewayConnectionVpnLinkCustomBgpAddress[] | cdktf.IResolvable;
    /**
    * ipsec_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection#ipsec_policy VpnGatewayConnection#ipsec_policy}
    */
    readonly ipsecPolicy?: VpnGatewayConnectionVpnLinkIpsecPolicy[] | cdktf.IResolvable;
}
export declare function vpnGatewayConnectionVpnLinkToTerraform(struct?: VpnGatewayConnectionVpnLink | cdktf.IResolvable): any;
export declare class VpnGatewayConnectionVpnLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpnGatewayConnectionVpnLink | cdktf.IResolvable | undefined;
    set internalValue(value: VpnGatewayConnectionVpnLink | cdktf.IResolvable | undefined);
    private _bandwidthMbps?;
    get bandwidthMbps(): number;
    set bandwidthMbps(value: number);
    resetBandwidthMbps(): void;
    get bandwidthMbpsInput(): number | undefined;
    private _bgpEnabled?;
    get bgpEnabled(): boolean | cdktf.IResolvable;
    set bgpEnabled(value: boolean | cdktf.IResolvable);
    resetBgpEnabled(): void;
    get bgpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _connectionMode?;
    get connectionMode(): string;
    set connectionMode(value: string);
    resetConnectionMode(): void;
    get connectionModeInput(): string | undefined;
    private _egressNatRuleIds?;
    get egressNatRuleIds(): string[];
    set egressNatRuleIds(value: string[]);
    resetEgressNatRuleIds(): void;
    get egressNatRuleIdsInput(): string[] | undefined;
    private _ingressNatRuleIds?;
    get ingressNatRuleIds(): string[];
    set ingressNatRuleIds(value: string[]);
    resetIngressNatRuleIds(): void;
    get ingressNatRuleIdsInput(): string[] | undefined;
    private _localAzureIpAddressEnabled?;
    get localAzureIpAddressEnabled(): boolean | cdktf.IResolvable;
    set localAzureIpAddressEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAzureIpAddressEnabled(): void;
    get localAzureIpAddressEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyBasedTrafficSelectorEnabled?;
    get policyBasedTrafficSelectorEnabled(): boolean | cdktf.IResolvable;
    set policyBasedTrafficSelectorEnabled(value: boolean | cdktf.IResolvable);
    resetPolicyBasedTrafficSelectorEnabled(): void;
    get policyBasedTrafficSelectorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _ratelimitEnabled?;
    get ratelimitEnabled(): boolean | cdktf.IResolvable;
    set ratelimitEnabled(value: boolean | cdktf.IResolvable);
    resetRatelimitEnabled(): void;
    get ratelimitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _routeWeight?;
    get routeWeight(): number;
    set routeWeight(value: number);
    resetRouteWeight(): void;
    get routeWeightInput(): number | undefined;
    private _sharedKey?;
    get sharedKey(): string;
    set sharedKey(value: string);
    resetSharedKey(): void;
    get sharedKeyInput(): string | undefined;
    private _vpnSiteLinkId?;
    get vpnSiteLinkId(): string;
    set vpnSiteLinkId(value: string);
    get vpnSiteLinkIdInput(): string | undefined;
    private _customBgpAddress;
    get customBgpAddress(): VpnGatewayConnectionVpnLinkCustomBgpAddressList;
    putCustomBgpAddress(value: VpnGatewayConnectionVpnLinkCustomBgpAddress[] | cdktf.IResolvable): void;
    resetCustomBgpAddress(): void;
    get customBgpAddressInput(): cdktf.IResolvable | VpnGatewayConnectionVpnLinkCustomBgpAddress[] | undefined;
    private _ipsecPolicy;
    get ipsecPolicy(): VpnGatewayConnectionVpnLinkIpsecPolicyList;
    putIpsecPolicy(value: VpnGatewayConnectionVpnLinkIpsecPolicy[] | cdktf.IResolvable): void;
    resetIpsecPolicy(): void;
    get ipsecPolicyInput(): cdktf.IResolvable | VpnGatewayConnectionVpnLinkIpsecPolicy[] | undefined;
}
export declare class VpnGatewayConnectionVpnLinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VpnGatewayConnectionVpnLink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpnGatewayConnectionVpnLinkOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection azurerm_vpn_gateway_connection}
*/
export declare class VpnGatewayConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vpn_gateway_connection";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.65.0/docs/resources/vpn_gateway_connection azurerm_vpn_gateway_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnGatewayConnectionConfig
    */
    constructor(scope: Construct, id: string, config: VpnGatewayConnectionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internetSecurityEnabled?;
    get internetSecurityEnabled(): boolean | cdktf.IResolvable;
    set internetSecurityEnabled(value: boolean | cdktf.IResolvable);
    resetInternetSecurityEnabled(): void;
    get internetSecurityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _remoteVpnSiteId?;
    get remoteVpnSiteId(): string;
    set remoteVpnSiteId(value: string);
    get remoteVpnSiteIdInput(): string | undefined;
    private _vpnGatewayId?;
    get vpnGatewayId(): string;
    set vpnGatewayId(value: string);
    get vpnGatewayIdInput(): string | undefined;
    private _routing;
    get routing(): VpnGatewayConnectionRoutingOutputReference;
    putRouting(value: VpnGatewayConnectionRouting): void;
    resetRouting(): void;
    get routingInput(): VpnGatewayConnectionRouting | undefined;
    private _timeouts;
    get timeouts(): VpnGatewayConnectionTimeoutsOutputReference;
    putTimeouts(value: VpnGatewayConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpnGatewayConnectionTimeouts | undefined;
    private _trafficSelectorPolicy;
    get trafficSelectorPolicy(): VpnGatewayConnectionTrafficSelectorPolicyList;
    putTrafficSelectorPolicy(value: VpnGatewayConnectionTrafficSelectorPolicy[] | cdktf.IResolvable): void;
    resetTrafficSelectorPolicy(): void;
    get trafficSelectorPolicyInput(): cdktf.IResolvable | VpnGatewayConnectionTrafficSelectorPolicy[] | undefined;
    private _vpnLink;
    get vpnLink(): VpnGatewayConnectionVpnLinkList;
    putVpnLink(value: VpnGatewayConnectionVpnLink[] | cdktf.IResolvable): void;
    get vpnLinkInput(): cdktf.IResolvable | VpnGatewayConnectionVpnLink[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
