/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import solver.ConfigurationException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0002J\u0006\u0010\u0012\u001a\u00020\u0001J\b\u0010\u0013\u001a\u00020\u0001H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0002J\f\u0010\u001a\u001a\u00020\b*\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lsolver/CLIParser;", "", "input", "", "(Ljava/lang/String;)V", "getInput", "()Ljava/lang/String;", "s", "", "getS", "()Ljava/lang/CharSequence;", "setS", "(Ljava/lang/CharSequence;)V", "consume", "", "e", "msg", "errorMessage", "parse", "parseInner", "parseList", "", "parseMap", "", "parseQuotedString", "parseValue", "dropWhitespace", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Configurable.kt\nsolver/CLIParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,280:1\n1#2:281\n151#3,6:282\n151#3,6:288\n*S KotlinDebug\n*F\n+ 1 Configurable.kt\nsolver/CLIParser\n*L\n50#1:282,6\n65#1:288,6\n*E\n"})
public final class CLIParser {
    @NotNull
    private final String input;
    @NotNull
    private CharSequence s;

    public CLIParser(@NotNull String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.input = input;
        this.s = this.dropWhitespace(this.input);
    }

    @NotNull
    public final String getInput() {
        return this.input;
    }

    @NotNull
    public final CharSequence getS() {
        return this.s;
    }

    public final void setS(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "<set-?>");
        this.s = charSequence;
    }

    private final CharSequence dropWhitespace(CharSequence $this$dropWhitespace) {
        return StringsKt.trimStart($this$dropWhitespace);
    }

    private final void consume(String e, String msg) {
        if (!StringsKt.startsWith$default(this.s, (CharSequence)e, false, 2, null)) {
            CharSequence found = this.s.subSequence(0, Integer.min(this.s.length(), e.length() + 5));
            throw new ConfigurationException("expected \"" + e + "\" but found \"" + found + "\": " + msg);
        }
        this.s = this.dropWhitespace(StringsKt.drop(this.s, e.length()));
    }

    private final String parseQuotedString() {
        int indexOfEndQuote;
        block3: {
            int n;
            char quote = StringsKt.first(this.s);
            if (!StringsKt.contains$default((CharSequence)"'\"", quote, false, 2, null)) {
                boolean $i$a$-check-CLIParser$parseQuotedString$22 = false;
                String $i$a$-check-CLIParser$parseQuotedString$22 = "string quotes should be ' or \"";
                throw new IllegalStateException($i$a$-check-CLIParser$parseQuotedString$22.toString());
            }
            this.consume(String.valueOf(quote), "Start of quoted string");
            CharSequence $this$indexOfFirst$iv = this.s;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it == quote)) continue;
                n = index$iv;
                break block3;
            }
            n = indexOfEndQuote = -1;
        }
        if (indexOfEndQuote == -1) {
            throw new ConfigurationException("unterminated quoted string");
        }
        String res2 = ((Object)this.s.subSequence(0, indexOfEndQuote)).toString();
        this.s = this.dropWhitespace(StringsKt.drop(this.s, indexOfEndQuote + 1));
        return res2;
    }

    private final String parseValue() {
        int id;
        block3: {
            int n;
            if (StringsKt.contains$default((CharSequence)"'\"", StringsKt.first(this.s), false, 2, null)) {
                return this.parseQuotedString();
            }
            CharSequence $this$indexOfFirst$iv = this.s;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!Character.isLetterOrDigit(it) && !StringsKt.contains$default((CharSequence)":_-", it, false, 2, null))) continue;
                n = index$iv;
                break block3;
            }
            n = id = -1;
        }
        if (id == -1) {
            id = this.s.length();
        }
        String res2 = ((Object)this.s.subSequence(0, id)).toString();
        this.s = this.dropWhitespace(StringsKt.drop(this.s, id));
        return res2;
    }

    private final List<Object> parseList() {
        this.consume("[", "Start of a list");
        List res2 = new ArrayList();
        while (this.s.length() > 0 && StringsKt.first(this.s) != ']') {
            res2.add(this.parseInner());
            if (this.s.length() == 0 || StringsKt.first(this.s) == ']') break;
            this.consume(",", "Separation of list entries");
        }
        this.consume("]", "End of a list");
        return res2;
    }

    private final Map<String, Object> parseMap() {
        this.consume("{", "Start of map");
        Map res2 = new LinkedHashMap();
        while (StringsKt.first(this.s) != '}') {
            String k = this.parseValue();
            this.consume("=", "Map assignment");
            Object v = this.parseInner();
            res2.put(k, v);
            if (this.s.length() == 0 || StringsKt.first(this.s) == '}') break;
            this.consume(",", "Separation of map entries");
        }
        this.consume("}", "End of map");
        return res2;
    }

    private final Object parseInner() {
        Object object;
        char c = StringsKt.first(this.s);
        if (c == '[') {
            object = this.parseList();
        } else if (c == '{') {
            object = this.parseMap();
        } else {
            String v = this.parseValue();
            object = this.s.length() > 0 && StringsKt.first(this.s) == '{' ? (Serializable)new Pair<String, Map<String, Object>>(v, this.parseMap()) : (Serializable)((Object)v);
        }
        return object;
    }

    private final String errorMessage() {
        return StringsKt.first(this.s) == ',' ? "Use \"[foo,bar]\" to specify a list of values." : (StringsKt.first(this.s) == '=' ? "Use \"{foo=bar}\" to specify a map or specialize an object." : "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object parse() {
        void var1_1;
        try {
            Object result2 = this.parseInner();
            if (this.s.length() > 0) {
                throw new ConfigurationException(this.errorMessage());
            }
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Failed to parse argument \"" + this.input + "\" at \"" + this.s + "\". " + e.getMessage() + "\nThis error may be caused by incorrect escaping on the command line.");
        }
        return var1_1;
    }
}

