/*
 * Decompiled with CFR 0.152.
 */
package solver;

import datastructures.stdcollections.ListsKt;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import solver.ArithmeticOperations;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001a"}, d2={"Lsolver/SmtInterpolSolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_SMTINTERPOL_COMMAND", "", "alwaysOnOptions", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "versionQuery", "getVersionQuery", "commandForStdInMode", "clOptions", "getOptionForRandomSeed", "randomSeed", "", "getOptionForTimelimit", "timelimit", "Ljava/time/Duration;", "readResolve", "", "supportsLogicFeatures", "", "features", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
public final class SmtInterpolSolverInfo
extends SolverInfo {
    @NotNull
    public static final SmtInterpolSolverInfo INSTANCE = new SmtInterpolSolverInfo();
    @NotNull
    private static final List<String> alwaysOnOptions = ListsKt.listOf("-q");
    @NotNull
    private static final String DEFAULT_SMTINTERPOL_COMMAND = "smtinterpol.sh";

    private SmtInterpolSolverInfo() {
        super("SmtInterpol");
    }

    @Override
    @NotNull
    public String getVersionQuery() {
        return "-version";
    }

    @Override
    @NotNull
    public List<String> getOptionForTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return ListsKt.listOf("-t", String.valueOf(timelimit.toMillis()));
    }

    @Override
    @NotNull
    public List<String> getOptionForRandomSeed(int randomSeed) {
        return ListsKt.listOf("-r", String.valueOf(randomSeed));
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return features.getArithmeticOperations() != ArithmeticOperations.NonLinear && features.getArithmeticOperations() != ArithmeticOperations.BitVector;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@NotNull List<String> clOptions) {
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        return ListsKt.plus((Collection)ListsKt.plus((Collection)ListsKt.listOf(DEFAULT_SMTINTERPOL_COMMAND), (Iterable)alwaysOnOptions), (Iterable)clOptions);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_SMTINTERPOL_COMMAND;
    }

    private final Object readResolve() {
        return INSTANCE;
    }
}

